

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getExportMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getExportMediaList.sp,v $ $Id: getExportMediaList.sp,v 1.11.294.2 2018/03/22 03:14:55 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "getExportMediaList"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS													|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getExportMediaList <<<'

IF EXISTS (select * from sysobjects where name='getExportMediaList')
	drop procedure getExportMediaList
IF EXISTS (select * from GxQscripts where name='getExportMediaList')
	delete from GxQscripts where name = 'getExportMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getExportMediaList')
	delete from GXDBVersions where aliasname = 'getExportMediaList'
GO
print '... Creating Procedure: getExportMediaList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getExportMediaList
  @libId integer,
  @policyId integer,
  @copyId integer,
  @olderThanTime integer,
  @lastReadTime integer,
  @preserveActive integer
AS
  DECLARE @r_mediaId integer;
  DECLARE @r_uniqueId char(255);
  DECLARE @r_barCode char(255);
  DECLARE @r_libraryId integer;
  DECLARE @r_mediaGroupId integer;
  DECLARE @r_exportLocation NVARCHAR(255);
  DECLARE @r_mediaLocation integer;
  DECLARE @r_externalGUID char(255);
  DECLARE @r_mediaFlags integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	CREATE TABLE #tempMediaList (
			mediaId 		INT,
			lastAccessTime	INT
	)
	CREATE TABLE #tmpMedNMedGrpList(
			MediaId			INT,
			MediaGroupId	INT
	)
	INSERT INTO #tmpMedNMedGrpList
	SELECT distinct MM.MediaId, MV.MediaGroupId
	FROM MMS2Media as MM, MMS2Volume as MV
	WHERE MM.IsInMediaGroup > 0
	AND MM.MediaId = MV.MediaId
/****************************************************************************************/
	IF @libId > 0 AND @policyId > 0 AND @copyId > 0
	BEGIN
		IF @lastReadTime > 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MM.MediaId, MM.LastBackupTime
			FROM MMMedia as MM, #tmpMedNMedGrpList as tt
			WHERE MM.MediaId = tt.MediaId AND tt.MediaGroupId IN (SELECT mediaGroupId FROM archStream WHERE archGroupCopyId = @copyId)
				AND (MM.LastRestoreTime > 0 OR MM.LastBackupTime > 0)
				AND (MM.LastRestoreTime < @olderThanTime AND MM.LastBackupTime < @olderThanTime)
				AND MM.MediaTypeId <> 10001
				AND MM.MediaLocation <> 3
		IF @lastReadTime > 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MM.MediaId, lastAccessTime = (case sign(MM.LastRestoreTime-MM.LastBackupTime)
				when -1 then MM.LastBackupTime when 1 then MM.LastRestoreTime else MM.LastRestoreTime end)
			FROM MMS2Media as MM, #tmpMedNMedGrpList as tt
			WHERE MM.MediaId = tt.MediaId AND tt.MediaGroupId IN (SELECT mediaGroupId FROM archStream WHERE archGroupCopyId = @copyId)
				AND (MM.LastBackupTime > 0 OR MM.LastRestoreTime > 0)
				AND MM.MediaTypeId <> 10001
				AND MM.MediaLocation <> 3
			ORDER BY MM.lastAccessTime
		IF @lastReadTime = 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM, #tmpMedNMedGrpList as tt
			WHERE	MM.MediaId = tt.MediaId AND tt.MediaGroupId IN (SELECT mediaGroupId FROM archStream WHERE archGroupCopyId = @copyId)
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND LastBackupTime < @olderThanTime
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
		IF @lastReadTime = 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM, #tmpMedNMedGrpList as tt
			WHERE	MM.MediaId = tt.MediaId AND tt.MediaGroupId IN (SELECT mediaGroupId FROM archStream WHERE archGroupCopyId = @copyId)
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
			ORDER BY LastBackupTime
	END
/****************************************************************************************/
	IF @libId > 0 AND @policyId > 0 AND @copyId = 0
	BEGIN
		IF @lastReadTime > 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM MMMedia as MM, #tmpMedNMedGrpList as tt
			WHERE MM.MediaId = tt.MediaId AND tt.MediaGroupId IN
					(SELECT ST.mediaGroupId
					FROM	archStream ST, MMMediaGroup MG, MMDrivePool HP, MMMasterPool MP
					WHERE ST.archGroupId = @policyId
						AND ST.MediaGroupId = MG.MediaGroupId
						AND MG.DrivePoolId = HP.drivepoolid
						AND HP.MasterPoolId = MP.MasterPoolId
						AND MP.LibraryId = @libId)
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND (LastRestoreTime < @olderThanTime AND LastBackupTime < @olderThanTime)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
		IF @lastReadTime > 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MediaId, lastAccessTime = (case sign(LastRestoreTime-LastBackupTime)
				when -1 then LastBackupTime when 1 then LastRestoreTime ELSE LastRestoreTime end)
			FROM MMMedia as MM, #tmpMedNMedGrpList as tt
			WHERE MM.MediaId = tt.MediaId AND tt.MediaGroupId IN
					(SELECT ST.mediaGroupId
					FROM	archStream ST, MMMediaGroup MG, MMDrivePool HP, MMMasterPool MP
					WHERE ST.archGroupId = @policyId
						AND ST.MediaGroupId = MG.MediaGroupId
						AND MG.DrivePoolId = HP.drivepoolid
						AND HP.MasterPoolId = MP.MasterPoolId
						AND MP.LibraryId = @libId)
				AND (LastBackupTime > 0 OR LastRestoreTime > 0)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
			ORDER BY lastAccessTime
		IF @lastReadTime = 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM, #tmpMedNMedGrpList as tt
			WHERE	MM.MediaId = tt.MediaId AND tt.MediaGroupId IN
					(SELECT ST.mediaGroupId
					FROM	archStream ST, MMMediaGroup MG, MMDrivePool HP, MMMasterPool MP
					WHERE ST.archGroupId = @policyId
						AND ST.MediaGroupId = MG.MediaGroupId
						AND MG.DrivePoolId = HP.drivepoolid
						AND HP.MasterPoolId = MP.MasterPoolId
						AND MP.LibraryId = @libId)
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND LastBackupTime < @olderThanTime
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
		IF @lastReadTime = 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM, #tmpMedNMedGrpList as tt
			WHERE	MM.MediaId = tt.MediaId AND tt.MediaGroupId IN
					(SELECT ST.mediaGroupId
					FROM	archStream ST, MMMediaGroup MG, MMDrivePool HP, MMMasterPool MP
					WHERE ST.archGroupId = @policyId
						AND ST.MediaGroupId = MG.MediaGroupId
						AND MG.DrivePoolId = HP.drivepoolid
						AND HP.MasterPoolId = MP.MasterPoolId
						AND MP.LibraryId = @libId)
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
			ORDER BY LastBackupTime
	END
/****************************************************************************************/
	IF @libId > 0 AND @policyId = 0 AND @copyId = 0
	BEGIN
		IF @lastReadTime > 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastRestoreTime
			FROM MMMedia as MM
			WHERE LibraryId = @libId
				AND IsInMediaGroup = 1
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND (LastRestoreTime < @olderThanTime AND LastBackupTime < @olderThanTime)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
		IF @lastReadTime > 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MediaId, lastAccessTime = (case sign(LastRestoreTime-LastBackupTime)
				when -1 then LastBackupTime when 1 then LastRestoreTime else LastRestoreTime end)
			FROM MMMedia as MM
			WHERE LibraryId = @libId
				AND IsInMediaGroup = 1
				AND (LastBackupTime > 0 OR LastRestoreTime > 0)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
			ORDER BY lastAccessTime
		IF @lastReadTime = 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM
			WHERE	LibraryId = @libId
				AND IsInMediaGroup = 1
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND LastBackupTime < @olderThanTime
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
		IF @lastReadTime = 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM
			WHERE	LibraryId = @libId
				AND IsInMediaGroup = 1
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
			ORDER BY LastBackupTime
	END
/****************************************************************************************/
	IF @libId <= 0 AND @policyId = 0 AND @copyId = 0
	BEGIN
		IF @lastReadTime > 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastRestoreTime
			FROM MMMedia as MM
			WHERE IsInMediaGroup = 1
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND (LastRestoreTime < @olderThanTime AND LastBackupTime < @olderThanTime)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
		IF @lastReadTime > 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MediaId, lastAccessTime = (case sign(LastRestoreTime-LastBackupTime)
				when -1 then LastBackupTime when 1 then LastRestoreTime else LastRestoreTime end)
			FROM MMMedia as MM
			WHERE IsInMediaGroup = 1
				AND (LastBackupTime > 0 OR LastRestoreTime > 0)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
			ORDER BY lastAccessTime
		IF @lastReadTime = 0 AND @olderThanTime > 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM
			WHERE	IsInMediaGroup = 1
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND LastBackupTime < @olderThanTime
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
		IF @lastReadTime = 0 AND @olderThanTime = 0
			INSERT INTO #tempMediaList
			SELECT MediaId, LastBackupTime
			FROM	MMMedia as MM
			WHERE	IsInMediaGroup = 1
				AND (LastRestoreTime > 0 OR LastBackupTime > 0)
				AND MediaTypeId <> 10001
				AND MediaLocation <> 3
			ORDER BY LastBackupTime
	END
/****************************************************************************************/
	IF @preserveActive > 0
	BEGIN
		DELETE #tempMediaList
		FROM   #tempMediaList T, MMVolume MV
		WHERE T.mediaId = MV.MediaId AND MV.volumeFlags = 1
	END
--  	FOREACH								-- MORE THAN (1) ROW RETURNED	--skip for mssql7--
	SELECT T.MediaId, M.UniqueId, M.BarCode, M.LibraryId, M.MediaGroupId, E.ExportLocation,
		 M.MediaLocation, M.ExternalGUID, M.MediaFlags
--  	:INTO r_mediaId,r_uniqueId,r_barCode,r_libraryId,r_mediaGroupId,r_exportLocation,r_mediaLocation,r_externalGUID,r_mediaFlags	--skip for mssql7--
      FROM #tempMediaList T, MMMedia M, MMExportLocation E
	WHERE	T.mediaId = M.MediaId AND M.ExportLocationId = E.ExportLocationId
	ORDER BY T.lastAccessTime
--  	  return  r_mediaId,r_uniqueId,r_barCode,r_libraryId,r_mediaGroupId,r_exportLocation,r_mediaLocation,r_externalGUID,r_mediaFlags	--skip for mssql7--
--  			WITH RESUME;				-- MORE THAN (1) ROW RETURNED	--skip for mssql7--
--  	END FOREACH;	--skip for mssql7--
DROP TABLE 	#tempMediaList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getExportMediaList')
	delete from GxQscripts where name = 'getExportMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getExportMediaList')
	delete from GXDBVersions where aliasname = 'getExportMediaList'
GO

insert into GXDBVersions values(2, 'getExportMediaList',  '00010011029400020000', 'getExportMediaList', '00010011029400020000')
GO

