

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getEvents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getEvents.sp,v $ $Id: getEvents.sp,v 1.1.2.2 2020/06/30 10:46:15 vmishra Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "getEvents"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getEvents')
BEGIN
	print '>>> Drop Stored Procedure: getEvents <<<'
	drop procedure getEvents
END
IF EXISTS (select * from GxQscripts where name='getEvents')
	delete from GxQscripts where name = 'getEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getEvents')
	delete from GXDBVersions where aliasname = 'getEvents'
GO
print '... Creating Procedure: getEvents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure getEvents
-- The following lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @inUserId integer,
  @inBUnrestrictedUser integer,
  @whereClause varchar(MAX)
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userPrefs XML =(select CONVERT(XML,SUBSTRING(value,LEN('<?xml version=''1.0'' encoding=''UTF-8''?>')+1,LEN(value)),2) FROM UMUserPrefs where userId = @inUserId)
DECLARE @useGlobalSettings INT = ISNULL((select @userPrefs.value('./userprefs_UserPreferences[1]/@useGlobalSettings','int') ),1)
DECLARE @inBufferSize INT
DECLARE @inNumberOfDays INT
IF @useGlobalSettings = 1 -- If Key is set then override from globalSetting
BEGIN
	SELECT @inBufferSize = ISNULL((SELECT CONVERT(INT, CONVERT(VARCHAR(12), value)) FROM APP_AdvanceSettings WITH (NOLOCK)
		WHERE keyName = 'MaximumNumberOfEvents' AND enabled = 1 AND deleted = 0 AND relativePath = 'CommServDB.Console'),200)
	SELECT @inNumberOfDays = ISNULL((SELECT CONVERT(INT, CONVERT(VARCHAR(12), value)) FROM APP_AdvanceSettings WITH (NOLOCK)
		WHERE keyName = 'MaxNumberOfDaysForEvents' AND enabled = 1 AND deleted = 0 AND relativePath = 'CommServDB.Console'),2)
END
ELSE
BEGIN
	SELECT @inBufferSize = ISNULL((select @userPrefs.value('./userprefs_UserPreferences[1]/@eventBufferSize','int') ),200)
	SELECT @inNumberOfDays = ISNULL((select @userPrefs.value('./userprefs_UserPreferences[1]/@dayBufferSize','int') ),2)
END
--if @inUserId is not zero, then check vis in cursor (if zero, then unrestricted so no need to check)
IF @inBUnrestrictedUser = 1
	SET @inUserId = 0
DECLARE @eventLookupTime INT = (dbo.GetUnixTime(GETUTCDATE()) - (@inNumberOfDays * 24 * 60 * 60 ) )-- ( this is the number of seconds in given days )
DECLARE @sql nvarchar(max)= 'SELECT id, timeSource, severity, ack, type, jobId_h, jobId_l, messageId, clientID, commCellID, userID,
    subsystemID, Client, CommCell, userName, subsystem, msgEnglish, displayName FROM
    (SELECT TOP ('+ CAST(@inBufferSize AS varchar(5)) +') EM.id, timeSource, severity, ack, type, jobId_h, jobId_l, messageId, EM.clientID, commCellID, userID,
    subsystemID, Client, CommCell, userName, subsystem, msgEnglish, CL.displayName
    FROM evMsg EM
    INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.Id = EM.clientID
	WHERE ('+ @whereClause +' and timeSource > '+ CAST(@eventLookupTime AS varchar(15)) +' and type <> 2 and (dbo.isClientVisibleEvents('+ CAST(@inUserId AS varchar(15)) +', jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0))
	ORDER BY timeSource DESC) A
ORDER BY timeSource ASC'
EXEC(@sql)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getEvents')
	delete from GxQscripts where name = 'getEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getEvents')
	delete from GXDBVersions where aliasname = 'getEvents'
GO

insert into GXDBVersions values(2, 'getEvents',  '00010001000200020000', 'getEvents', '00010001000200020000')
GO

