

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getEntitiesIds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getEntitiesIds.sp,v $ $Id: getEntitiesIds.sp,v 1.8.208.1 2018/03/20 00:32:50 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: getEntitiesIds()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Muath Ali  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getEntitiesIds <<<'

IF EXISTS (select * from sysobjects where name='getEntitiesIds')
	drop procedure getEntitiesIds
IF EXISTS (select * from GxQscripts where name='getEntitiesIds')
	delete from GxQscripts where name = 'getEntitiesIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getEntitiesIds')
	delete from GXDBVersions where aliasname = 'getEntitiesIds'
GO
print '... Creating Procedure: getEntitiesIds'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getEntitiesIds
  @i_apptypeId INTEGER,
  @i_clientName VARCHAR(128),
  @i_instName VARCHAR(128),
  @i_bkpSetName VARCHAR(128),
  @i_subClntName VARCHAR(128)
AS
  DECLARE @r_clientId INTEGER;
  DECLARE @r_instId INTEGER;
  DECLARE @r_bkpSetId INTEGER;
  DECLARE @r_subClntId INTEGER;
  DECLARE @r_errorString VARCHAR(1024);
SET NOCOUNT ON
   DECLARE @rowCount  integer
   SET @r_clientId = 0
   SET @r_instId = 0
   SET @r_bkpSetId = 0
   SET @r_subClntId = 0
   SET @r_errorString = ''
   SELECT @r_clientId = id
   FROM APP_Client
   WHERE name = @i_clientName
   IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
   BEGIN
      SET @r_errorString = 'Invalid Client Name'
      GOTO EXIT_POINT
   END
   IF @i_instName = ''
      GOTO EXIT_POINT
   SELECT DISTINCT @r_instId = instance
   FROM   APP_Application, APP_InstanceName
   WHERE  clientid = @r_clientId
   AND    appTypeId = @i_apptypeId
   AND    APP_InstanceName.name = @i_instName
   AND    APP_Application.instance = APP_InstanceName.id
   IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
   BEGIN
      SET @r_errorString = 'Invalid Instance Name'
      GOTO EXIT_POINT
   END
   IF @i_bkpSetName = ''
      GOTO EXIT_POINT
   SELECT DISTINCT @r_bkpSetId = backupset
   FROM            APP_Application, APP_BackupSetName
   WHERE           clientid = @r_clientId
   AND             appTypeId = @i_apptypeId
   AND             instance = @r_instId
   AND             APP_BackupSetName.name = @i_bkpSetName
   AND             APP_Application.backupset = APP_BackupSetName.id
   IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
   BEGIN
      SET @r_errorString = 'Invalid BackupSet Name'
      GOTO EXIT_POINT
   END
   IF @i_subClntName = ''
      GOTO EXIT_POINT
   SELECT @r_subClntId = id
   FROM   APP_Application
   WHERE  clientid = @r_clientId
   AND    appTypeId = @i_apptypeId
   AND    instance = @r_instId
   AND    backupSet = @r_bkpSetId
   AND    subClientName = @i_subClntName
   IF @@ERROR <> 0 OR @@ROWCOUNT <> 1
   BEGIN
      SET @r_errorString = 'Invalid SubClient Name'
      GOTO EXIT_POINT
   END
EXIT_POINT:
   SELECT @r_clientId, @r_instId, @r_bkpSetId, @r_subClntId, @r_errorString
   RETURN
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'getEntitiesIds')
	delete from GxQscripts where name = 'getEntitiesIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getEntitiesIds')
	delete from GXDBVersions where aliasname = 'getEntitiesIds'
GO

insert into GXDBVersions values(2, 'getEntitiesIds',  '00010008020800010000', 'getEntitiesIds', '00010008020800010000')
GO

