

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getDaysOnlyRetentionSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getDaysOnlyRetentionSubclient.sp,v $ $Id: getDaysOnlyRetentionSubclient.sp,v 1.3.40.4 2019/12/20 01:14:03 chandru Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE: "getDaysOnlyRetentionSubclient"             |
--  |                                   |
--  | Execute the System stored procedure to fetch the physical files   |
--  | .. for the (current) database.                    |
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getDaysOnlyRetentionSubclient')
BEGIN
	print '>>> Drop Stored Procedure: getDaysOnlyRetentionSubclient <<<'
	drop procedure getDaysOnlyRetentionSubclient
END
IF EXISTS (select * from GxQscripts where name='getDaysOnlyRetentionSubclient')
	delete from GxQscripts where name = 'getDaysOnlyRetentionSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getDaysOnlyRetentionSubclient')
	delete from GXDBVersions where aliasname = 'getDaysOnlyRetentionSubclient'
GO
print '... Creating Procedure: getDaysOnlyRetentionSubclient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getDaysOnlyRetentionSubclient
AS
SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#subclientRetention') IS NOT NULL
    DROP TABLE #subclientRetention
    CREATE TABLE #subclientRetention (
                            appId INT PRIMARY KEY,
                            enableOnePass INT NULL,
                            archiveMode INT NULL,
                            backupMode INT NULL,
                            associatedSCP INT NULL,
							indexV2 INT
    )
	IF OBJECT_ID('tempdb.dbo.#subclientDaysRetention') IS NOT NULL
	BEGIN
		INSERT #subclientRetention(appId)
		SELECT DISTINCT subclient.id FROM #subclientDaysRetention S
		INNER JOIN APP_Application subclient WITH (NOLOCK) ON S.appId = subclient.id
		INNER JOIN APP_AppTypeGroupAssoc appType WITH (NOLOCK) ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22,34) AND appType.typeOfGroup = 0 --22:WinFS and 34:UnixFS
		WHERE subclient.subclientStatus & 0x04 != 0x04
	END
	ELSE
	BEGIN
		INSERT #subclientRetention(appId)
		SELECT DISTINCT subclient.id FROM APP_Application subclient WITH (NOLOCK)
		INNER JOIN APP_AppTypeGroupAssoc appType WITH (NOLOCK) ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22,34) AND appType.typeOfGroup = 0 --22:WinFS and 34:UnixFS
		WHERE subclient.subclientStatus & 0x04 != 0x04
	END
	UPDATE T
        SET T.enableOnePass = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
    FROM #subclientRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Is Turbo Subclient' AND prop.modified = 0
	UPDATE T
        SET T.archiveMode = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
    FROM #subclientRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Is Archive Retention Mode Enabled' AND prop.modified = 0
	UPDATE T
        SET T.backupMode = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
    FROM #subclientRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Is Backup Retention Mode Enabled' AND prop.modified = 0
	UPDATE T
        SET T.associatedSCP = CAST(attrVal AS INT)
    FROM #subclientRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Associated subclient Policy' AND prop.modified = 0
	UPDATE T
        SET T.indexV2 = CAST(cp.attrVal AS INT)
    FROM #subclientRetention T
	INNER JOIN APP_Application subclient WITH (NOLOCK) on subclient.id = T.appId
	INNER JOIN APP_ClientProp cp WITH (NOLOCK) ON cp.componentNameId = subclient.clientId
    WHERE cp.attrName = N'IndexingV2' AND cp.modified = 0
	--select * from #subclientRetention
	IF OBJECT_ID('tempdb.dbo.#policyRetention') IS NOT NULL
    DROP TABLE #policyRetention
    CREATE TABLE #policyRetention (
                            appId INT PRIMARY KEY,
							policyHasRetention INT NULL,
                            enableOnePass INT NULL,
                            archiveMode INT NULL,
                            backupMode INT NULL
	)
	IF OBJECT_ID('tempdb.dbo.#subclientDaysRetention') IS NOT NULL
	BEGIN
		INSERT #policyRetention(appId)
		SELECT id FROM #subclientDaysRetention S
						INNER JOIN APP_Application subclient WITH (NOLOCK) ON S.appId = subclient.id
		WHERE appTypeId = 1030
	END
	ELSE
	BEGIN
		INSERT #policyRetention(appId)
		SELECT id FROM APP_Application WITH (NOLOCK) WHERE appTypeId = 1030
	END
	UPDATE T
        SET T.policyHasRetention = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
    FROM #policyRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Subclient Policy Has Retention' AND prop.modified = 0
	UPDATE T
        SET T.enableOnePass = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
    FROM #policyRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Is Turbo Subclient' AND prop.modified = 0
	UPDATE T
        SET T.archiveMode = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
    FROM #policyRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Is Archive Retention Mode Enabled' AND prop.modified = 0
	UPDATE T
        SET T.backupMode = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)
    FROM #policyRetention T
    INNER JOIN APP_SubClientProp prop WITH (NOLOCK) on prop.componentNameId = T.appId
    WHERE prop.attrName = N'Is Backup Retention Mode Enabled' AND prop.modified = 0
	--SELECT * FROM #policyRetention
	IF OBJECT_ID('tempdb.dbo.#subclientDaysRetention') IS NOT NULL
	BEGIN
		UPDATE	S
		SET		S.daysOnlyRetention = 1
		FROM	#subclientDaysRetention S,
				(SELECT DISTINCT subclientProp.appId FROM #subclientRetention subclientProp
				INNER JOIN #policyRetention policyProp ON subclientProp.associatedSCP = policyProp.appId
				WHERE subclientProp.indexV2 = 1
				AND policyProp.policyHasRetention = 1
				AND policyProp.enableOnePass = 1
				AND policyProp.archiveMode = 1
				AND (policyProp.backupMode IS NULL OR policyProp.backupMode = 0)
				UNION
				SELECT DISTINCT subclientProp.appId FROM #subclientRetention subclientProp
				INNER JOIN #policyRetention policyProp ON subclientProp.associatedSCP = policyProp.appId
				WHERE subclientProp.indexV2 = 1
				AND (policyProp.policyHasRetention IS NULL OR policyProp.policyHasRetention = 0)
				AND subclientProp.enableOnePass = 1
				AND subclientProp.archiveMode = 1
				AND (subclientProp.backupMode IS NULL OR subclientProp.backupMode = 0)
				UNION
				SELECT DISTINCT subclientProp.appId FROM #subclientRetention subclientProp
				WHERE subclientProp.indexV2 = 1
				AND (subclientProp.associatedSCP IS NULL OR subclientProp.associatedSCP = 0)
				AND subclientProp.enableOnePass = 1
				AND subclientProp.archiveMode = 1
				AND (subclientProp.backupMode IS NULL OR subclientProp.backupMode = 0)
				UNION
				--Returns list of subclients that are associated to subclient policy having the properties
				SELECT DISTINCT PROP1.componentNameId AS SubclientId
				FROM	#subclientDaysRetention ST
						INNER JOIN APP_SubClientProp PROP1 WITH (NOLOCK) ON ST.appId = PROP1.componentNameId,
						APP_Application APP WITH (NOLOCK), APP_SubClientProp PROP2 WITH (NOLOCK)
				WHERE	PROP1.attrName = 'Associated subclient Policy'
				AND 	PROP1.modified = 0
				AND 	CAST(PROP1.attrVal AS INT) = APP.Id
				AND 	APP.appTypeId = 1030
				AND		APP.Id = PROP2.componentNameId
				AND 	PROP2.attrName = 'Use SP Based Days Retention'
				AND 	PROP2.attrVal = '1'
				AND 	PROP2.modified = 0
				UNION
				--Returns list of subclients having the required properties
				SELECT DISTINCT APP.Id AS SubclientId
				FROM 	#subclientDaysRetention ST
						INNER JOIN APP_Application APP WITH (NOLOCK) ON ST.appId = APP.id
						INNER JOIN APP_SubClientProp PROP WITH (NOLOCK)
				ON		APP.Id = PROP.componentNameId
				AND 	APP.appTypeId != 1030
				AND 	PROP.attrName = 'Use SP Based Days Retention'
				AND 	PROP.attrVal = '1'
				AND 	PROP.modified = 0) T
		WHERE S.appId = T.appId
	END
	ELSE
	BEGIN
		SELECT DISTINCT subclientProp.appId FROM #subclientRetention subclientProp
		INNER JOIN #policyRetention policyProp ON subclientProp.associatedSCP = policyProp.appId
		WHERE subclientProp.indexV2 = 1
		AND policyProp.policyHasRetention = 1
		AND policyProp.enableOnePass = 1
		AND policyProp.archiveMode = 1
		AND (policyProp.backupMode IS NULL OR policyProp.backupMode = 0)
		UNION
		SELECT DISTINCT subclientProp.appId FROM #subclientRetention subclientProp
		INNER JOIN #policyRetention policyProp ON subclientProp.associatedSCP = policyProp.appId
		WHERE subclientProp.indexV2 = 1
		AND (policyProp.policyHasRetention IS NULL OR policyProp.policyHasRetention = 0)
		AND subclientProp.enableOnePass = 1
		AND subclientProp.archiveMode = 1
		AND (subclientProp.backupMode IS NULL OR subclientProp.backupMode = 0)
		UNION
		SELECT DISTINCT subclientProp.appId FROM #subclientRetention subclientProp
		WHERE subclientProp.indexV2 = 1
		AND (subclientProp.associatedSCP IS NULL OR subclientProp.associatedSCP = 0)
		AND subclientProp.enableOnePass = 1
		AND subclientProp.archiveMode = 1
		AND (subclientProp.backupMode IS NULL OR subclientProp.backupMode = 0)
		UNION
		--Returns list of subclients that are associated to subclient policy having the properties
		SELECT DISTINCT PROP1.componentNameId AS SubclientId
		FROM APP_SubClientProp PROP1 WITH (NOLOCK), APP_Application APP WITH (NOLOCK), APP_SubClientProp PROP2 WITH (NOLOCK)
		WHERE	PROP1.attrName = 'Associated subclient Policy'
		AND 	PROP1.modified = 0
		AND 	CAST(PROP1.attrVal AS INT) = APP.Id
		AND 	APP.appTypeId = 1030
		AND		APP.Id = PROP2.componentNameId
		AND 	PROP2.attrName = 'Use SP Based Days Retention'
		AND 	PROP2.attrVal = '1'
		AND 	PROP2.modified = 0
		UNION
		--Returns list of subclients having the required properties
		SELECT DISTINCT APP.Id AS SubclientId
		FROM 	APP_Application APP WITH (NOLOCK) INNER JOIN APP_SubClientProp PROP WITH (NOLOCK)
		ON		APP.Id = PROP.componentNameId
		AND 	APP.appTypeId != 1030
		AND 	PROP.attrName = 'Use SP Based Days Retention'
		AND 	PROP.attrVal = '1'
		AND 	PROP.modified = 0
	END
GO

IF EXISTS (select * from GxQscripts where name = 'getDaysOnlyRetentionSubclient')
	delete from GxQscripts where name = 'getDaysOnlyRetentionSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getDaysOnlyRetentionSubclient')
	delete from GXDBVersions where aliasname = 'getDaysOnlyRetentionSubclient'
GO

insert into GXDBVersions values(2, 'getDaysOnlyRetentionSubclient',  '00010003004000040000', 'getDaysOnlyRetentionSubclient', '00010003004000040000')
GO

