

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getCompatAppClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getCompatAppClient.sp,v $ $Id: getCompatAppClient.sp,v 1.81.12.34 2020/09/28 14:15:06 duncan Exp $";
--
--  +========================================================================+
--  |   Procedure:  getCompatAppClient()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        skatz    Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getCompatAppClient')
BEGIN
	print '>>> Drop Stored Procedure: getCompatAppClient <<<'
	drop procedure getCompatAppClient
END
IF EXISTS (select * from GxQscripts where name='getCompatAppClient')
	delete from GxQscripts where name = 'getCompatAppClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getCompatAppClient')
	delete from GXDBVersions where aliasname = 'getCompatAppClient'
GO
print '... Creating Procedure: getCompatAppClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure getCompatAppClient
  @userIdParam integer,
  @apptypeParam integer,
  @clientIdParam integer,
  @InstanceNameParam char(255),
  @restoreFlag integer,
  @instanceIdParam integer
-- Following are the "columns" returned, in the order in which they are returned
--		clientId	  	integer
--		clientName 	  	char(MAX_VARCHAR_SIZE)
--		destAppType	  	integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName char(255)
  DECLARE @o_destAppType integer
  DECLARE @o_instanceId integer
  DECLARE @o_instanceName NVARCHAR(255)
  DECLARE @o_clientDisplayName NVARCHAR(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF object_id('tempdb.dbo.#GCAC_TMP') IS NOT Null DROP TABLE #GCAC_TMP
	CREATE TABLE #GCAC_TMP (srcAppType int, destAppType int, clientId int, clientName nvarchar(255), instance int, checkName nvarchar(512), osID INT, bUseAppMgrTbl INT, clientDisplayName nvarchar(255))
	CREATE CLUSTERED INDEX #GCAC_TMP_ClientId_Idx ON #GCAC_TMP (clientId)
	CREATE NONCLUSTERED INDEX #GCAC_TMP_ClientId_srcAppType_destAppType_Idx ON #GCAC_TMP (clientId, srcAppType, destAppType) INCLUDE (checkName)
IF (@appTypeParam = 124)	--CV_APPTYPE_CONTENT_STORE_
	BEGIN
SET @apptypeParam = 29		--CV_APPTYPE_LINUX_FS_
	END
IF (@appTypeParam = 1033)		-- 'CV_APPTYPE_1_TOUCH_SERVER_UNIX'
	BEGIN
		INSERT INTO #GCAC_TMP
		SELECT	DISTINCT 0, @appTypeParam, clientId = C.ID, clientName = C.name, 0, '', simOperatingSystemId, 0, C.displayName
		FROM	simInstalledPackages as S, APP_Client as C
WHERE	C.id = S.clientId AND simPackageID = 1119
	END
ELSE IF (@appTypeParam = 1040)
	BEGIN
		INSERT INTO #GCAC_TMP
		SELECT	DISTINCT 0, @appTypeParam, clientId = C.ID, clientName = C.name, 0, '', simOperatingSystemId, 0, C.displayName
		FROM	simInstalledPackages as S, APP_Client as C
WHERE	C.id = S.clientId AND simPackageID = 554
	END
ELSE IF (@appTypeParam = 13)
	BEGIN
		DECLARE @srcNdmpOsType     INT = 0
		DECLARE @srcSimOsType      INT = 0
		IF @clientIdParam > 0
		BEGIN
			SET @srcNdmpOsType = ISNULL((select OSType from MMNDMPHostInfo where clientId = @clientIdParam), 0)
			SET @srcSimOsType  = ISNULL((select simOperatingSystemId from APP_Client where id = @clientIdParam), 0)
		END
		-- SELECT NAS clients of same NDMP OS TYPE
		-- 10.0 if the client had no NDMP row it would get all NDMP rows. Would miss compatible clients which also have no NDMP row.
		-- 11.0 Only get matching NDMP rows. Then get matching clients which have the same simOperatingSystemId
		IF @srcNdmpOsType != 0
		BEGIN
			-- Get all clients with matching NDMP OS type
			INSERT INTO #GCAC_TMP
			SELECT DISTINCT 0, I.appTypeId, clientId = C.ID, clientName = C.name, 0, '', simOperatingSystemId, 0, C.displayName
			FROM   APP_Client C, MMNDMPHostInfo M, APP_iDAName I
WHERE  C.id = M.clientId AND M.clientId = I.clientId AND M.NDMPHostId > 0 AND I.appTypeId = 13
			AND ((@srcNdmpOsType = M.osType)
				OR
(@srcNdmpOsType = 1 AND M.osType IN ( 33, 35 ))
				OR
(@srcNdmpOsType = 33 AND M.osType IN ( 1, 35 ))
				OR
(@srcNdmpOsType = 35 AND M.osType IN ( 33 )))
			-- Get all clients with matching simOperatingSystemId ...but which have no NDMP row
			-- This may get clients which do not match ... but will work best for NetApp and Isilon and other
			-- vendors which may have snap clients with no NDMP row
			INSERT INTO #GCAC_TMP
			SELECT DISTINCT 0, I.appTypeId, clientId = C.ID, clientName = C.name, 0, '', simOperatingSystemId, 0, C.displayName
			FROM   APP_Client C
				INNER JOIN APP_iDAName I
ON C.id = I.clientId AND I.appTypeId = 13 AND C.simOperatingSystemId = @srcSimOsType
				LEFT OUTER JOIN MMNDMPHostInfo MM
					ON MM.clientId = C.id
			WHERE	MM.clientId is NULL
		END
		-- If the client has no NDMP row then get all clients with a matching simOperatingSystemId. This query may
		-- get too many clients, but that is the best we can do if we don't know the NDMP OS type.
		ELSE  -- @srcNdmpOsType == 0
		BEGIN
			INSERT INTO #GCAC_TMP
			SELECT DISTINCT 0, I.appTypeId, clientId = C.ID, clientName = C.name, 0, '', simOperatingSystemId, 0, C.displayName
			FROM   APP_Client C, APP_iDAName I
WHERE  C.id = I.clientId AND I.appTypeId = 13 AND C.simOperatingSystemId = @srcSimOsType
		END
		-- SELECT clients which has the property and package installed with the CVNRDS.exe binary on win and linux.
		-- NDMP OS TYPE 1, 2, 9, 18, 33 is Celerra, NetApp, Hitachi NAS (BlueArc), Isilon, Unity - see MMS2NDMPTypes.h
		-- For restore from snap we would do an NDMP copy - so we would require NDMP credentials for the source client
		-- For restore from NDMP backup we would also need NDMP credentials on the source, so we would have a non-0 @srcNdmpOsType
		-- Duncan 1/29/2015: Added 0 to the NDMP OS type. So if there is no NDMP row we will include the FS iDA clients
		-- * Only NetApp and Isilon will have no NDMP row - and both support restore to Windows/UNIX FS iDA
		-- * When NetApp tunneling is in place the NDMP credentials will come from the physical file server - restore to FS iDA will succeed
		-- * When NetApp or Isilon is added through array management, there is no NDMP rows - if tunneling is not setup then
		--   restore to FS iDA will fail with a nice JPR indicating NDMP credentials are required. But to get to this point where
		--   there is information delivered to the user to add NDMP, we need to have the FS iDA clients list.
IF @srcNdmpOsType IN (0, 1, 2, 9, 18, 33, 35)
		BEGIN
			INSERT INTO #GCAC_TMP
			SELECT DISTINCT 0, I.appTypeId, clientId = C.ID, clientName = C.name, 0, '', simOperatingSystemId, 0, C.displayName
			FROM   APP_Client C
				INNER JOIN APP_ClientProp P ON C.id = P.componentNameId
AND (C.releaseId > 14 OR P.attrName = 'NDMP Restore Enabler' AND P.attrVal = '1')
				INNER JOIN APP_iDAName I ON C.id = I.clientId
				INNER JOIN simInstalledPackages S ON S.clientId = C.id AND S.simPackageID in (702, 1101)
		END
	END  -- END CV_APPTYPE_NAS_FS
	ELSE
	BEGIN
		DECLARE @srcRelId INTEGER
		SELECT @srcRelId = releaseId FROM APP_client WHERE id=@clientIdParam
		--			FETCH ALL THE ROWS OF COMPATIBLE APPTYPES
		--			-----------------------------------------
		INSERT INTO #GCAC_TMP
		SELECT	distinct AC.srcAppType, AC.destAppType, AP.clientId,
				clientName = C.name, AP.instance,
				checkName = I.name, C.simOperatingSystemId, 0,
				clientDisplayName = C.displayName
		FROM	APP_Application  as AP
			INNER JOIN APP_AppCompat as AC
				ON AP.apptypeId = AC.destAppType AND AC.srcAppType = @appTypeParam
			LEFT OUTER JOIN APP_Client C ON AP.clientId = C.id
			LEFT OUTER JOIN APP_InstanceName I ON AP.instance = I.id
		IF(@apptypeParam IN(22,37,62)) --Oracle and DB2, MR:81569
		BEGIN
			DECLARE @documentumDbType NVARCHAR(12)
			IF(@apptypeParam = 22)
				SET @documentumDbType = '0'
			ELSE
				SET @documentumDbType = '1'
			DELETE	T
			FROM	#GCAC_TMP T
				LEFT OUTER JOIN APP_InstanceProp INST
					ON T.instance = INST.componentNameId AND INST.attrName = 'DOCUMENTUM DbType' AND INST.attrVal = @documentumDbType
			WHERE destAppType = 128 AND INST.id IS NULL
		END
		--			FETCH ALL THE ROWS OF THE SAME APPTYPE
		--			---------------------------------------
		INSERT INTO #GCAC_TMP
		SELECT	distinct apptypeId, apptypeId, clientId,
				clientName = C.name,
				instance,checkName = I.name, C.simOperatingSystemId, 0, C.displayName
		FROM  APP_Application A
			LEFT OUTER JOIN APP_Client C
				ON A.clientId = C.id
			LEFT OUTER JOIN APP_InstanceName I
				ON A.instance = I.id
		WHERE appTypeId = @appTypeParam
		-- For restore only clients
		INSERT INTO #GCAC_TMP
		SELECT	distinct apptypeId, apptypeId, clientId, C.name, 0, '', C.simOperatingSystemId, 0, C.displayName
		FROM	APP_iDAName A
			INNER JOIN APP_Client C
				ON A.clientId = C.id AND A.appTypeId = @appTypeParam AND (C.status & 2) > 0
		-- For restore only clients with FS agent not configured
		INSERT INTO #GCAC_TMP
		SELECT	@appTypeParam, T.destAppType, id, name, 0, '', simOperatingSystemId, 0, displayName
		FROM	APP_Client NOLOCK JOIN
			(SELECT	P.clientID, destAppType=MAX(AC.destAppType)
			FROM	SimInstalledPackages P JOIN SimPackageMap M ON P.simpackageID = M.simPackageID AND P.SimPackageID IN (1, 1002)
				JOIN APP_AppCompat as AC ON AC.destAppType = appType AND AC.srcAppType = @appTypeParam
			WHERE	clientID NOT IN (select clientID from #GCAC_TMP)
			GROUP BY P.clientID) T ON id = T.clientID
		-- Restore destination clients with Merged Exchange Package
		IF (@appTypeParam IN (54,35,82,67))
		BEGIN
		INSERT INTO #GCAC_TMP SELECT   distinct @apptypeParam, @appTypeParam, C.id, C.name, 0, '', C.simOperatingSystemId, 0, C.displayName
		FROM  APP_Client C, simInstalledPackages sim, PatchSPVersion psp
		WHERE sim.simPackageID = 151 AND sim.ClientId = C.id AND sim.SPVersionID = psp.id AND psp.Release >= 16 AND psp.SPMajor >= 12
		END
		--			FETCH ALL THE ROWS FOR DATA BASE NAME
		--			---------------------------------------
IF ((@restoreFlag & 0x10) > 0 OR @appTypeParam = 80)
		BEGIN
			INSERT INTO #GCAC_TMP
				SELECT distinct A.appTypeId, A.appTypeId, A.clientId, C.name, A.instance, I.name, C.simOperatingSystemId, 0, C.displayName
				FROM	APP_Application A
					INNER JOIN APP_Client C
						ON A.clientId = C.id
					INNER JOIN APP_InstanceName I
						ON A.instance = I.id
					INNER JOIN APP_InstanceProp IP
						ON A.instance = IP.componentNameId AND IP.attrName = 'Oracle DB Name' AND IP.modified = 0 AND IP.attrVal = @InstanceNameParam
WHERE	A.appTypeId IN (80, 22)
			UNION
				SELECT distinct A.appTypeId, A.appTypeId, A.clientId, C.name, A.instance, IP.attrVal, 0, 0, C.displayName
				FROM	APP_Application A
						INNER JOIN APP_Client C
							ON A.clientId = C.id
						INNER JOIN APP_InstanceName I
							ON A.instance = I.id
						INNER JOIN APP_InstanceProp IP
							ON A.instance = IP.componentNameId AND IP.attrName = 'Oracle DB Name' AND IP.modified = 0 AND IP.attrVal = @InstanceNameParam
WHERE	A.appTypeId IN (80, 22)
		END
	END
	--security check
	IF @userIdParam > 0
	BEGIN
		DECLARE @CapCanOutOfPlaceRestore	INT
		DECLARE @CapCanInPlaceRestore		INT
		SET @CapCanOutOfPlaceRestore = 0
SET @CapCanOutOfPlaceRestore = @CapCanOutOfPlaceRestore | POWER(2, 1 -1)
SET @CapCanOutOfPlaceRestore = @CapCanOutOfPlaceRestore | POWER(2, 22 -1)
		SET @CapCanInPlaceRestore = 0
SET @CapCanInPlaceRestore = @CapCanInPlaceRestore | POWER(2, 1 -1)
SET @CapCanInPlaceRestore = @CapCanInPlaceRestore | POWER(2, 20 -1)
		--Get clients where user has end user access
		IF EXISTS(select 1 from GXGlobalParam where name = 'EnforceUnixUserPermissionsOnRestore' and value = 1)
		BEGIN
			IF @apptypeParam IN (SElECT A.appTypeId from APP_AppTypeGroup G,APP_AppTypeGroupAssoc A where G.groupName = 'APPGRP_UnixFileSystem'
													and A.appGroupId=G.appTypeGroupId)
SET @CapCanInPlaceRestore = @CapCanInPlaceRestore | POWER(2, 24   -1)
		END
		IF object_id('tempdb.dbo.#tempUserObjects') IS NOT Null DROP TABLE #tempUserObjects
create table  #tempUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		CREATE CLUSTERED INDEX #tempUserObjects_Idx1 ON #tempUserObjects (clientId)
		CREATE NONCLUSTERED INDEX #tempUserObjects_Idx2 ON #tempUserObjects (clientId, clientGroupId, mediaAgentId, libraryID, archGroupID, vtContainerId, vtPolicyId,vtShelfId,reviewSetId,querySetId,downloadSetId,ermId,legalHoldId,tagId)
		include(cdPolicyId, complianceReportId, taskId, workflowId, logMonitoringPolicyId, arrayId, cloudId, userGroupId, providerId, entityId1, entityId2, entityId3, entityId4, entityId5, entityId6, entityId7, entityId8, entityId9)
EXEC sec_getUserObjects @userIdParam, 2013 , 0, '#tempUserObjects'
		IF object_id('tempdb.dbo.#tempUserRestoreClients') IS NOT Null DROP TABLE #tempUserRestoreClients
		SELECT DISTINCT U.capabilities, T.clientId
		INTO #tempUserRestoreClients
		FROM	#GCAC_TMP T, #tempUserObjects U
		WHERE	U.clientId In (0, T.clientId) AND U.clientGroupId = 0 AND U.mediaAgentId = 0 AND U.libraryID = 0 AND U.archGroupID = 0
						AND U.vtContainerId=0 AND U.vtPolicyId=0 AND U.vtShelfId=0 AND U.reviewSetId=0 AND U.querySetId=0 AND U.downloadSetId=0 AND U.ermId=0 AND U.legalHoldId=0 AND U.tagId=0 AND U.cdPolicyId=0 AND U.complianceReportId=0 AND U.taskId=0 AND U.workflowId=0 AND U.logMonitoringPolicyId=0 AND U.arrayId=0 AND U.cloudId=0 AND U.userGroupId=0 AND U.providerId=0 AND U.entityId1=0 AND U.entityId2=0 AND U.entityId3=0 AND U.entityId4=0 AND U.entityId5=0	   AND U.entityId6=0 AND U.entityId7=0 AND U.entityId8=0 AND U.entityId9=0								AND U.entityId6=0 AND U.entityId7=0 AND U.entityId8=0 AND U.entityId9=0
		DELETE T
		FROM #GCAC_TMP T
		LEFT OUTER JOIN #tempUserRestoreClients U
			ON T.clientId = U.clientId AND ((U.capabilities & @CapCanInPlaceRestore) > 0 )
		WHERE U.clientId IS NULL
		DROP TABLE #tempUserObjects
		DROP TABLE #tempUserRestoreClients
	END
	--			NDS AppType: treeNames must be the same!
	--			----------------------------------------
if (@appTypeParam = 10)				--'CV_APPTYPE_NDS'
	BEGIN
		UPDATE #GCAC_TMP
			SET  checkname=(select TOP 1 attrVal from APP_IDAProp
				where attrName = N'treename' AND modified=0 AND componentNameId In
				(select id from APP_IDAName where APP_IDAName.clientId = #GCAC_TMP.clientId and apptypeId=10))
WHERE srcAppType = 10			--'CV_APPTYPE_NDS'
		SET @instanceNameParam = (select TOP 1 attrVal from APP_IDAProp
				where attrName = N'treename' AND modified=0 AND componentNameId In
				(select id from APP_IDAName where APP_IDAName.clientId = @clientIdParam and apptypeId=10))
		Delete from #GCAC_TMP where checkname <> @instanceNameParam
	END
	--			AD AppType: Disallow cross machine AD restore from 6.0 client to 5.0 client
	--			------------------------------------------------------------------------
if (@appTypeParam = 41)		--'CV_APPTYPE_GRANULAR_AD'
	BEGIN
		IF @srcRelId > 9
			Delete	#GCAC_TMP
			WHERE	#GCAC_TMP.clientId <> @clientIdParam AND
				9 >= (SELECT releaseId FROM APP_client C WHERE C.id = #GCAC_TMP.clientId)
	END
	/*
IF @appTypeParam in (58, 73, 1081)
	BEGIN
		DECLARE @instTypeId	INT
		DECLARE @DMAppTypeId	INT
		DECLARE @destClinstTbl	TABLE (t_clientId int, t_appTypeId int, t_instId int, t_instType int, t_mapToAppType int)
		IF @instanceIdParam > 0 and @srcRelId >= 13 -- for 8.0 & beyond
		BEGIN
			SET @instTypeId = ISNULL((	select cast(attrVal as int) from APP_instanceProp
							where componentNameid = @instanceIdParam and attrName = 'FSDM Instance Type' and modified = 0), 0)
			-- 1 = APP_FSDM_LOCAL_MIGRATION
			-- 2 = APP_FSDM_CELERRA
			-- 3 = APP_FSDM_NETWORK_SHARE
SET @DMAppTypeId = (case @instTypeId	when 2 then 1081
when 3 then 73
else 58 end)
		END
		ELSE
			SET @DMAppTypeId = @appTypeParam
		INSERT INTO @destClinstTbl
		SELECT	clientId, destAppType, instance,
			ISNULL((select cast (attrVal as int) from APP_instanceProp
				where componentNameid=instance and attrName = 'FSDM Instance Type' and modified = 0), 0), 0
		FROM	#GCAC_TMP
		UPDATE	@destClinstTbl
SET	t_mapToAppType = (case t_instType	when 2 then 1081
when 3 then 73
else 58 end)
		delete	#GCAC_TMP
		from	#GCAC_TMP G, (select t_clientId, t_appTypeId, t_instId from @destClinstTbl where t_mapToAppType <> @DMAppTypeId) T
		where	G.clientId = T.t_clientId and G.destAppType = T.t_appTypeId and G.instance = T.t_instId
	END
	*/
	-- For MySQL and PostGreSQL apptypes, clone is supported only to the clients which have MediaAgent installed.
	-- Delete all clients which do not have MediaAgent Package installed on them.
IF @appTypeParam IN (104, 125)
	BEGIN
IF (@restoreFlag & 0x200) <> 0
		BEGIN
			DELETE	#GCAC_TMP
			FROM	#GCAC_TMP C
				LEFT OUTER JOIN simInstalledPackages P
					ON C.clientId = P.ClientId AND P.OpType IN ('Install', 'Reinstall', 'Release Upgrade', 'Package Sync') AND P.simPackageID IN (51, 1301)
			WHERE	P.simPackageID IS NULL
		END
		-- Remove all standby pairs
IF (@appTypeParam = 125) AND ((@restoreFlag & 0x4000) <> 0)
		BEGIN
			DECLARE @standbyInstance NVARCHAR(16) = ISNULL((SELECT attrVal
														FROM App_InstanceProp
														WHERE attrName = 'PostgreSQL Standby Instance' AND
																componentNameId = @instanceIdParam AND
																modified = 0), '0')
			DELETE	#GCAC_TMP
			FROM	#GCAC_TMP C
					LEFT OUTER JOIN App_InstanceProp ip
					ON C.instance = ip.componentNameId AND ip.attrName IN ('PostgreSQL is Standby Instance', 'PostgreSQL Enable Standby Backup') AND ip.modified = 0
			WHERE	ip.attrVal IS NOT NULL AND ip.attrVal <> '0' AND CAST(C.instance AS NVARCHAR(16)) <> @standbyInstance
			-- return client of same os type
			DECLARE @clientOsType NVARCHAR(124) = (SELECT os.Type
													FROM APP_Client client
														LEFT JOIN simOperatingSystem os ON os.id = client.simOperatingSystemId
													WHERE client.id = @clientIdParam)
			DELETE	#GCAC_TMP
			FROM	#GCAC_TMP C
					LEFT JOIN simOperatingSystem os ON os.id = C.osID
			WHERE os.Type <> @clientOsType
		END
	END
	--	FOR THE ORACLE APPTYPES, CAN ONLY RESTORE TO THE SAME INSTANCE NAME
	--  THERE ARE MORE SEVERE RESTRICTIONS THAN THIS, BUT FOR NOW KEEP IT SIMPLE
	--  ------------------------------------------------------------------------
	-- Sunil - Delete such entries whose instance/database name doesn't match when
	--			1) Client is v10 or below, and
	--			2) Request is not for Duplicate restore
IF (@appTypeParam  in (2, 22, 23, 80) AND @instanceNameParam != '') -- 'UNUSED_CV_APPTYPE_2, CV_APPTYPE_ORACLE8, UNUSED_CV_APPTYPE_23'
			delete #GCAC_TMP
			FROM	#GCAC_TMP T
			INNER JOIN APP_Client C
			ON	T.clientId = C.id
where	(checkName != @instanceNameParam AND C.releaseId < 16) AND (@restoreFlag & 0x10) = 0
	--For oracle apptypes, exclude ASM and MGMTDB instances irrespective of flags
IF @appTypeParam  in (22, 80)
		DELETE	#GCAC_TMP
		WHERE	(checkName LIKE '+ASM%' OR checkName = '-MGMTDB')
	--  -- ORACLE_RAC is a "Pseudo AppType". Per Kumar, it should not be allow to restore to itself, or cause it's client
	--  -- to show up when creating new instances of Oracle_rac
	--  ------------------------------------------------------------------------
	-- For duplicate restore: Get only physical clients with matching DB name
IF (@restoreFlag & 0x10) > 0
delete #GCAC_TMP where destAppType = 80				  	--'CV_APPTYPE_ORACLE_RAC'
	--according to Arun, We should check the SharePoint versions only for SharePoint DB iDA's and not Doc iDA's.
IF @appTypeParam in (53, 69, 89) AND @clientIdParam > 0
	BEGIN
		DECLARE	@iDAVersion	integer
		SET	@iDAVersion	=ISNULL((	select	CAST(P.attrVal AS int)
							from	APP_IDAName N, APP_IDAProp P
							where	N.clientId = @clientIdParam and N.appTypeId = @apptypeParam and
								N.id = P.componentNameId and P.attrName = 'iDA version' and P.modified = 0	), 0)
		IF @iDAVersion = 0
			delete	#GCAC_TMP
			from	#GCAC_TMP T
			where	EXISTS (	select	*
						from	APP_IDAName N, APP_IDAProp P
						where	N.clientId = T.clientId and N.appTypeId = destAppType and
							N.id = P.componentNameId and P.attrName = 'iDA version' and P.modified = 0	)
ELSE IF @appTypeParam = 53
		BEGIN
			--confirmed with Jun A., only allow iDA version 14 for DAG source
			IF @iDAVersion = 1000
			BEGIN
				DECLARE @dataMemberIdaVersion INTEGER=0
				--As per Gallean, all the  memeber server must have same idaVersion , so selecting top 1 for comparion
				SET @dataMemberIdaVersion =ISNULL((SELECT top 1 attrVal
		   							FROM APP_IDAName N ,APP_IDAProp  P
					  				WHERE N.clientId in  (SELECT C.id
												FROM APP_Client C JOIN APP_ClientProp CP on C.net_hostname=CP.attrName
													WHERE CP.componentNameId=@clientIdParam
											and attrType=125 and CP.modified=0   ) --PROPERTY_DAG_MEMBERSERVER
and appTypeId=53
									and N.id = P.componentNameId and  P.attrname = 'iDA version' and P.modified=0),-1)
				---Return all restore clients(2013,2010) if memberserver list is empty
				delete	#GCAC_TMP
				from	#GCAC_TMP T
				where	NOT EXISTS   (select  1
							from    APP_IDAName N, APP_IDAProp P
							WHERE	N.clientId = T.clientId and N.appTypeId = destAppType
								AND	N.id = P.componentNameId and P.attrname = 'iDA version'
								AND	(P.attrVal = CAST(@dataMemberIdaVersion AS NVARCHAR(12)) OR ( @dataMemberIdaVersion =-1 AND (LEN(P.attrVal) <= 10 AND ISNUMERIC(P.attrVal) = 1 AND CAST(P.attrVal AS INT) >= 14) )) and P.modified = 0 )
			END
ELSE IF (@restoreFlag & 0x1000 ) > 0
			BEGIN
				DELETE	#GCAC_TMP
				FROM	#GCAC_TMP T
					INNER JOIN APP_IDAName N
						ON N.appTypeId = T.destAppType AND N.client = T.clientID
					LEFT OUTER JOIN APP_IDAProp P
						ON N.id = P.componentNameId AND P.attrName = 'iDA version' AND P.modified = 0
				WHERE	P.attrVal IS NULL OR (LEN(P.attrVal) <= 10 AND ISNUMERIC(P.attrVal) = 1 AND @iDAVersion >= CAST(P.attrVal AS int))
			END
			ELSE
			BEGIN
				DELETE	#GCAC_TMP
				FROM	#GCAC_TMP T
					INNER JOIN APP_IDAName N
						ON N.clientId = T.clientId AND N.appTypeId = T.destAppType
					LEFT OUTER JOIN APP_IDAProp P
						ON N.id = P.componentNameId AND P.attrName = 'iDA version' AND P.modified = 0
				WHERE	(LEN(P.attrVal) <= 10 AND ISNUMERIC(P.attrVal) = 1 AND @iDAVersion <> CAST(P.attrVal AS int))
			END
		END
		ELSE
		BEGIN
			DELETE	#GCAC_TMP
			FROM	#GCAC_TMP T
				INNER JOIN APP_IDAName N
					ON N.clientId = T.clientId AND N.appTypeId = T.destAppType
				LEFT OUTER JOIN APP_IDAProp P
					ON N.id = P.componentNameId AND P.attrName = 'iDA version' AND P.modified = 0
			WHERE	(LEN(P.attrVal) <= 10 AND ISNUMERIC(P.attrVal) = 1 AND @iDAVersion > CAST(P.attrVal AS int))
		END
	END
	--  Instead of license we should check for package for that agent. As long as the package is installed we can use that client as a restore target.
	--	We still use appMgr table for virtual clients, pseudo clients, and any agents/clients without install packages
	--------------------
	UPDATE G
	SET G.bUseAppMgrTbl = (CASE WHEN C.id IS NULL THEN 0 ELSE 1 END)
	FROM #GCAC_TMP G
		LEFT OUTER JOIN APP_ClientProp C
			ON C.componentNameId = G.clientId AND C.attrName = 'Virtual Client' AND C.attrVal = '1' and C.modified = 0
	UPDATE #GCAC_TMP SET bUseAppMgrTbl = 1
WHERE destAppType in (103,38, 54,35,82,67,125,104,22,134)
	Delete #GCAC_TMP from #GCAC_TMP T, APP_ClientProp
	WHERE bUseAppMgrTbl>0 AND componentNameId=clientId AND modified=0 AND attrVal='1' AND attrName='platformdeleted 4'
		AND NOT EXISTS (select 1 from APP_Platform P where P.clientId = T.clientId AND platformType = 4)
	Delete #GCAC_TMP from #GCAC_TMP T, APP_IDAName I
	WHERE T.bUseAppMgrTbl>0 AND I.clientId=T.clientId and I.appTypeId=T.destappType and (Status & 4) > 0
IF (@appTypeParam <> 13 AND @appTypeParam <> 80)
		DELETE	T
		FROM	#GCAC_TMP T
		LEFT OUTER JOIN simInstalledPackages S
			ON T.clientId=S.clientId AND S.simPackageID=dbo.getPackageID(T.destAppType, T.osID)
		WHERE T.bUseAppMgrTbl=0 AND S.id IS NULL
IF (@restoreFlag & 0x1) > 0
		Delete	#GCAC_TMP
		WHERE	10 > (SELECT releaseId FROM APP_client C WHERE C.id = #GCAC_TMP.clientId)
IF (@restoreFlag & 0x2) > 0
		Delete	#GCAC_TMP
		WHERE	destAppType <> @appTypeParam OR
			--TR: 090911-000384: State Compensation Insurance Fund - Destination client is not compatible with source client for system state restore
			--According to Rahul & Reinaldo, it's OK to remove Glaxy release check
			--@srcRelId <> (SELECT releaseId FROM app_client WHERE id = #GCAC_TMP.clientId) OR
			0 < ISNULL((select cast(attrVal as int) from APP_ClientProp where componentNameId=#GCAC_TMP.clientId and attrName='Virtual Client' and modified =0),0)
	--TR: 090911-000384: State Compensation Insurance Fund - Destination client is not compatible with source client for system state restore
	--According to Rahul & Reinaldo, it's OK to remove Glaxy release check
		-- @srcRelId <> (SELECT releaseId FROM app_client WHERE id = #GCAC_TMP.clientId) OR
IF (@restoreFlag & 0x2) > 0
		DELETE	#GCAC_TMP
		FROM	#GCAC_TMP G
			LEFT OUTER JOIN APP_ClientProp CP
				ON CP.componentNameId = G.clientId AND CP.attrName = 'Virtual Client' AND CP.modified = 0
		WHERE	G.destAppType <> @appTypeParam
			OR	(CP.attrVal IS NOT NULL AND CP.attrVal <> '0')
IF (@restoreFlag & 0x4) > 0
		Delete	#GCAC_TMP
		WHERE	12 > (SELECT releaseId FROM APP_client C WHERE C.id = #GCAC_TMP.clientId)
	-- cross OS check
	DECLARE	@clOSList	TABLE (clId int, osType varchar(255))
	DECLARE @srcOS varchar(255)
	SET	@srcOS = (select S.Type from simOperatingSystem S, APP_client C where C.id=@clientIdParam and C.simOperatingSystemId=S.id)
	-- MR 84298: Unix CDR GUI should filter out Windows host as destination
	-- MR 74324: not allow cross machine restore for DMNWFS
	-- MR 90945: Unix - Cross operating system restore should be restricted in the gui
	-- MR 17148: DMNAS:Unix file system ida should not be in list of destination machines for restore
IF	@appTypeParam in (84, 107)
		OR
@appTypeParam in (51, 77, 90)
		OR
@appTypeParam = 58
	BEGIN
		INSERT INTO @clOSList
		SELECT	T.clientId, S.Type
		FROM	#GCAC_TMP T, simOperatingSystem S, APP_client C
		WHERE	T.clientId = C.id and C.simOperatingSystemId = S.id
IF @appTypeParam = 58
		BEGIN
			DECLARE @instTypeId	INT
			IF @instanceIdParam > 0 and @srcRelId >= 13 -- for 8.0 & beyond
				SET @instTypeId = ISNULL((select cast(attrVal as int) from APP_instanceProp
								where componentNameid = @instanceIdParam and attrName like 'FSDM Instance Type' and modified = 0), 0)
			-- 1 = APP_FSDM_LOCAL_MIGRATION
			-- 2 = APP_FSDM_CELERRA
			-- 3 = APP_FSDM_NETWORK_SHARE
			IF @instTypeId in (2, 3)
				delete	#GCAC_TMP
				from	#GCAC_TMP T, @clOSList O
				where	T.clientId = O.clId AND @srcOS <> O.osType
		END
ELSE IF (@restoreFlag & 0x100 ) > 0
		BEGIN
			delete	#GCAC_TMP
			FROM	#GCAC_TMP T, @clOSList O
			where	T.clientId = O.clId AND
				(
@appTypeParam not in (51, 77) AND
				((@srcOS = 'Windows' AND O.osType <> 'Windows') OR (@srcOS <> 'Windows' AND O.osType = 'Unix')))
		END
		ELSE
		delete	#GCAC_TMP
		FROM	#GCAC_TMP T, @clOSList O
		where	T.clientId = O.clId AND
			(
			-- MR 90945: OS has to be matched for LNDB
(@appTypeParam in (51, 77, 90) AND @srcOS <> O.osType)
			OR
(@appTypeParam not in (51, 77) AND
			((@srcOS = 'Windows' AND O.osType <> 'Windows') OR (@srcOS <> 'Windows' AND O.osType = 'Windows'))))
	END
	--MR39314: Exchange DB restore dialog should filter out DAG restore targets if this is a restore from a DAG client
IF	@appTypeParam = 53
	BEGIN
		DECLARE @isSrcDAGClient int
SET @isSrcDAGClient = ISNULL((select (status & 0x200000) from APP_client where id = @clientIdParam), 0)
		IF @isSrcDAGClient > 0
			Delete #GCAC_TMP
WHERE EXISTS (select 1 from APP_client where id = clientId AND (status & 0x200000) > 0)
	END
	-- for oracle replication , we do not want to show cross platform clients.
IF (@restoreFlag & 0x8000) <> 0 AND @appTypeParam in (22, 80)
	BEGIN
		DECLARE @srcOSSubType nvarchar(max) = (SELECT S.SubType FROM simOperatingSystem S, APP_client C WHERE C.id=@clientIdParam AND C.simOperatingSystemId=S.id)
		delete	#GCAC_TMP
		FROM	#GCAC_TMP T, simOperatingSystem S, APP_client C
		WHERE	T.clientId = C.id and C.simOperatingSystemId = S.id AND S.SubType <> @srcOSSubType
	END
	--MR38818: NetWare data is restorable to 9.0 Windows filesystem clients
	IF	@srcOS = 'Netware'
		delete	#GCAC_TMP
		FROM	simOperatingSystem S, APP_client C
		WHERE	clientId = C.id and C.simOperatingSystemId = S.id and S.type = 'UNIX' AND S.subType <> 'Linux'
IF	@appTypeParam = 12
	BEGIN
		Delete #GCAC_TMP
		WHERE 14 > (	SELECT	C.releaseId FROM APP_client C
				WHERE 	C.id = clientId and
destAppType in (	1,
11,
33,
34,
42,
43,
58	)	)
	END
IF(@apptypeParam = 38 )
	BEGIN
		--verify if source  simOperating System id is iSeries/OpenVMS
		DECLARE @srcOsName nvarchar(MAX)
		SET @srcOsName= dbo.scgGetClientOSVersion(@clientIdParam)
		IF (@srcOsName= 'iSeries' OR @srcOsName ='Open VMS')
		BEGIN
			delete	#GCAC_TMP
			FROM	simOperatingSystem S, APP_client C
			WHERE	clientId = C.id and C.simOperatingSystemId = S.id and S.type = 'Windows'
		END
	END
IF(@restoreFlag & 0x10000 = 0x10000) -- git app clients can't be mixed with other clients.
	BEGIN
DELETE FROM #GCAC_TMP WHERE destAppType = 134 AND instance NOT IN (SELECT componentNameId FROM APP_InstanceProp NOLOCK WHERE attrName = 'Cloud Apps Instance Type' AND attrVal IN ('33','34') AND modified = 0)
	END
	-- onedrive client check
DELETE FROM #GCAC_TMP WHERE destAppType = 134 AND instance NOT IN (SELECT componentNameId FROM APP_InstanceProp NOLOCK WHERE attrName = 'Cloud Apps Instance Type' AND attrVal IN ('7', '5', '6', '20', '21', '24', '25','33','34') AND modified = 0)
 	SELECT DISTINCT clientId, clientName = convert(varchar(256), clientName), destappType, instance,
 	ISNULL((SELECT name FROM APP_InstanceName WHERE id = instance AND status in (0, 2)), '') as instanceName, clientDisplayName
 	FROM  #GCAC_TMP
	DROP TABLE #GCAC_TMP
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getCompatAppClient')
	delete from GxQscripts where name = 'getCompatAppClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getCompatAppClient')
	delete from GXDBVersions where aliasname = 'getCompatAppClient'
GO

insert into GXDBVersions values(2, 'getCompatAppClient',  '00010081001200340000', 'getCompatAppClient', '00010081001200340000')
GO

