

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getClientNameList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getClientNameList')
BEGIN
	print '>>> Drop Stored Procedure: getClientNameList <<<'
	drop procedure getClientNameList
END
IF EXISTS (select * from GxQscripts where name='getClientNameList')
	delete from GxQscripts where name = 'getClientNameList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getClientNameList')
	delete from GXDBVersions where aliasname = 'getClientNameList'
GO
print '... Creating Procedure: getClientNameList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getClientNameList
  @userIdParam integer,
  @commCellId integer,
  @clientGroupId integer,
  @capOpType1 bigint,
  @capOpType2 bigint,
  @i_includeHiddenClients integer,
  @applicationId integer,
  @i_installTypeFilter INT = 0,
  @i_filterFlags INT = 0
-- Following are the "columns" returned, in the order in which they are returned
--		clientId	  	integer
--		clientName 	  	char(MAX_VARCHAR_SIZE)
--		deleted			integer
AS
  DECLARE @r_clientId integer
  DECLARE @r_clientName nvarchar(255)
  DECLARE @r_deleted integer
  DECLARE @r_rights integer
  DECLARE @r_cvdPort integer
  DECLARE @r_evmgrcPort integer
  DECLARE @r_clientGuid varchar(40)
  DECLARE @r_clientHostName nvarchar(255)
  DECLARE @r_clusterType integer
  DECLARE @r_clientDisplayName nvarchar(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#IDX_CLS_TMP') IS NOT Null DROP INDEX #IDX_CLS_TMP ON #CLIST_TMP
IF object_id('tempdb.dbo.#CLIST_TMP') IS NOT Null DROP TABLE #CLIST_TMP
CREATE TABLE #CLIST_TMP
(
	tr_clientId int,
	tr_clientName nvarchar(255),
	tr_deleted int,
	tr_rights int,
	tr_cvdPort int,
	tr_evmgrcPort int,
	tr_enableAccessControl int,
	tr_clientGuid varchar(40),
	tr_clientHostName NVARCHAR(255),
	tr_clusterType int,
tr_clientDisplayName nvarchar(255)
)
CREATE INDEX IDX_CLS_TMP ON #CLIST_TMP (tr_clientId )
IF object_id('tempdb.dbo.#ClientCap') IS NOT Null DROP TABLE #ClientCap
create table  #ClientCap ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
--enum CapaOperationType
--{
--CAP_SCHEDULE = 1,
--CAP_ALERT,
--CAP_CLIENT_GROUP,
--CAP_SUBCLIENT_POLICY,
--CAP_PSUEDOCLIENT_CREATE,
--CAP_ADMIN
--CAP_LOG_MONITORNIG
--};
DECLARE @getPhysicalClients INT = (@i_filterFlags & 1)
DECLARE @getProxyForADServer INT = ISNULL((SELECT 1 WHERE (@i_filterFlags & 2 = 2)), 0)
DECLARE @permission1 VARCHAR(10) = '0'
DECLARE @permission2 VARCHAR(10) = '0'
DECLARE @permission3 VARCHAR(10) = '0'
SET @permission1 =
	CASE @capOpType1
WHEN 6 THEN '1'
WHEN 2 THEN '18'
WHEN 3 THEN '2'
WHEN 4 THEN '2 '
WHEN 5 THEN '2 '
WHEN 1 THEN '3,12'
		ELSE '0'
	END
SET @permission2 =
	CASE @capOpType2
WHEN 1 THEN '1'
WHEN 2 THEN '1'
WHEN 6 THEN '1'
WHEN 55 THEN '1'
WHEN 29 THEN '1'
WHEN 5  THEN '1'
WHEN 22 THEN '1'
WHEN 19 THEN '1'
WHEN 20 THEN '1'
WHEN 12 THEN '1'
WHEN 3 THEN '12'
WHEN 7 THEN '8'
WHEN 9 THEN '8'
WHEN 21 THEN '8'
WHEN 17 THEN '8'
WHEN 18 THEN '8'
WHEN 16 THEN '8'
WHEN 10 THEN '2'
WHEN 13 THEN '10'
WHEN 14 THEN '3'
WHEN 15 THEN '4'
		ELSE '0'
	END
IF @capOpType2 = 4
BEGIN
SET @permission2 = '20'
SET @permission3 = '22'
END
IF(@capOpType1=7)
BEGIN
SET @permission2 = '2'
SET @permission3 = '1'
END
-- SEC_NO_CAPABILITIES = 0
-- SEC_FULL_CAPABILIES = 1
-- SEC_PARTIAL_CAPABILIES = 2
BEGIN
	-- Get all the client List for view using xml protocol.
	IF @clientGroupId <> 0
	BEGIN
			INSERT INTO #CLIST_TMP(tr_clientId, tr_clientName, tr_deleted, tr_rights, tr_cvdPort, tr_evmgrcPort, tr_clientGuid, tr_clientHostName, tr_clientDisplayName)
			SELECT id, name, 0, 0, cvdPort, evmgrcPort, c.guid, c.net_hostname, c.displayName
			FROM APP_Client C
			JOIN APP_ClientGroupAssoc CGA ON CGA.clientId = C.id AND CGA.clientGroupId = @clientGroupId
			INNER JOIN App_Platform P ON
			C.id = P.clientId AND P.platformType = 4
			WHERE @i_includeHiddenClients > 0 OR (C.specialClientFlags & 0x1 <> 0x1)
	END
	ELSE IF @applicationId <> 0
	BEGIN
			INSERT INTO #CLIST_TMP(tr_clientId, tr_clientName, tr_deleted, tr_rights, tr_cvdPort, tr_evmgrcPort, tr_clientGuid,tr_clientDisplayName)
			SELECT C.id, C.name, 0, 0, cvdPort, evmgrcPort, c.guid, c.displayName
			FROM APP_Client C
			INNER JOIN App_Platform P ON
			C.id = P.clientId AND P.platformType = 4
			INNER JOIN APP_IDAName AGENT ON AGENT.clientId = C.id AND AGENT.appTypeId = @applicationId
			WHERE @i_includeHiddenClients > 0 OR (C.specialClientFlags & 0x1 <> 0x1)
	END
	ELSE
	BEGIN
		INSERT INTO #CLIST_TMP(tr_clientId, tr_clientName, tr_deleted, tr_rights, tr_cvdPort, tr_evmgrcPort, tr_clientGuid, tr_clientHostName, tr_clientDisplayName)
		SELECT id, name, 0, 0, cvdPort, evmgrcPort , c.guid, c.net_hostname, c.displayName
		FROM	APP_Client C INNER JOIN App_Platform P ON
			C.id = P.clientId AND P.platformType = 4
		WHERE @i_includeHiddenClients > 0 OR (C.specialClientFlags & 0x1 <> 0x1)
	END
END
	IF @i_installTypeFilter <> 0
	BEGIN
		-- InstallType: 1. Install, 2. Uninstall and 3. Upgrade
		DECLARE @csClientId INT = ISNULL((SELECT clientId FROM APP_Platform  WHERE platformType = 1), 2) -- Default 2
		DECLARE @csReleaseId INT = (SELECT releaseId FROM APP_Client WHERE id = @csClientId)
		DELETE CList
			FROM #CLIST_TMP CList
				INNER JOIN APP_Client Client
					ON Client.id = CList.tr_clientId
				INNER JOIN simOperatingSystem OS
					ON Client.simOperatingSystemId = OS.id
				LEFT OUTER JOIN APP_ClientProp Virtual
					ON Virtual.componentNameId = Client.id
						AND Virtual.attrName = N'Virtual client'
						AND Virtual.modified = 0
				LEFT OUTER JOIN APP_ClientProp DELETED
					ON DELETED.componentNameId = Client.id
						AND DELETED.attrName = N'PlatformDeleted 4'
						AND DELETED.modified = 0
				LEFT OUTER JOIN APP_ClientProp ADDIN
					ON ADDIN.componentNameId = Client.id
						AND ADDIN.attrName = N'Outlook Addin Client'
						AND ADDIN.modified = 0
				LEFT OUTER JOIN APP_Platform MA
					ON Client.id = MA.clientId AND MA.platformType = 2
				WHERE releaseId <= 9
					OR (@i_installTypeFilter IN (2,3)
						AND Client.id = @csClientId )
					OR (@i_installTypeFilter = 3
						AND Client.releaseId >= @csReleaseId)
OR Client.status & (CONVERT(INT,0x200000) | CONVERT(INT,0x0040) | CONVERT(INT,0x0200) | CONVERT(INT,0x0400) ) <> 0
OR Client.specialClientFlags & (CONVERT(INT,0x2) | CONVERT(INT,0x20)) <> 0
OR Client.simOperatingSystemId = 49
					OR (Client.id <> @csClientId
						AND Virtual.attrVal IS NOT NULL
						AND CAST(Virtual.attrVal AS BIGINT) & 2 = 2)
					OR (DELETED.attrVal IS NOT NULL
						AND DELETED.attrVal = N'1'
AND Client.specialClientFlags & CONVERT(INT,0x2) <> 0
						AND Client.id <> @csClientId
						AND MA.clientId IS NULL)
					OR (ADDIN.attrVal IS NOT NULL
						AND ADDIN.attrVal = N'1')
					OR (OS.Name = N'NetWare' AND Client.releaseId < 11)
	END
	IF @getPhysicalClients = 1
	BEGIN
		DELETE CList
			FROM #CLIST_TMP CList
			INNER JOIN App_Client Client
				ON Client.id = CList.tr_clientId
			LEFT JOIN App_Application App
				ON Client.id = App.clientId
			WHERE Client.specialClientFlags <> 0 OR App.id IS NULL
	END
	-- Proxy Clients for AD Server
	IF @getProxyForADServer = 1
	BEGIN
		DELETE CList
			FROM #CLIST_TMP CList
			INNER JOIN App_Client Client
				ON Client.id = CList.tr_clientId
			LEFT OUTER JOIN APP_ClientProp DELETED                -- remove clients Marked Deleted
                ON DELETED.componentNameId = Client.id
                    AND DELETED.attrName = N'PlatformDeleted 4'
                    AND DELETED.modified = 0
			LEFT OUTER JOIN APP_ClientProp ADDIN                  -- remove ADD IN
				ON ADDIN.componentNameId = Client.id
					AND ADDIN.attrName = N'Outlook Addin Client'
					AND	ADDIN.modified = 0
			LEFT OUTER JOIN
			(
				SELECT l.cid AS clientId, SUM(CASE WHEN l.appType < 1000 THEN 1 ELSE 0 END) AS agents FROM LicUsage l WHERE
                l.optype = 'Install'                                        -- remove if all IDAs are invalid.  (NO_VALID_IDAS_PRESENT_ITEM)
                AND l.InstallFlag = 0
				GROUP BY l.Cid
			)lic
				ON lic.clientId = Client.id
			-- remove clients which are psuedo DAG, pseudo SRM, pseudo DPF, pseudo RAC, commcell package absent, NAS OS , releaseId<=14
			WHERE Client.releaseId <= 14
OR Client.status & ( CONVERT(INT, 0x0400) |  CONVERT(INT, 0x200000) |  CONVERT(INT, 0x0200)) <> 0
OR Client.specialClientFlags & (CONVERT(INT,0x2) ) <> 0
OR Client.simOperatingSystemId IN (16, 17, 18, 19, 29, 45, 55)
				  OR lic.agents = 0
				  OR (DELETED.attrVal IS NOT NULL
                     AND DELETED.attrVal = N'1')
				  OR (ADDIN.attrVal IS NOT NULL
                     AND ADDIN.attrVal = N'1')
	END
-- Return "deleted" clients, but set the "isDeleted" column (below)
UPDATE #CLIST_TMP
SET tr_deleted  = 1
WHERE EXISTS	(
				SELECT attrVal FROM APP_ClientProp
				WHERE componentNameId = tr_clientId
				AND attrName='platformdeleted 4'
				AND modified =0 AND attrVal = '1'
				)
-- Delete the physical machines on the cluster CS
delete from #CLIST_TMP where tr_clientId IN (select APP_VMToPMMap.PMClientId from APP_VMToPMMap where APP_VMToPMMap.VMClientId = 2)
DECLARE @permissionId VARCHAR(1024) = ''
DECLARE @isAndOperation INT = 0
IF @permission1 = '0' AND @permission2 = '0' AND @permission3 = '0'
	SET @permissionId = ''
ELSE
BEGIN
	IF @permission1 <> '0'
		SET @permissionId = @permission1
	IF @permission2 <> '0'
		SET @permissionId = CASE WHEN @permissionId = '' THEN @permission2 ELSE @permissionId + ',' + @permission2 END
	IF @permission3 <> '0'
		SET @permissionId = CASE WHEN @permissionId = '' THEN @permission3 ELSE @permissionId + ',' + @permission3 END
END
IF @capOpType1 = 1				-- Ideally we need client list with any of permission1, permission2 or permission3 set. But for capOpType1=1 we need clients with both permissions.
	SET @isAndOperation = 1		-- In that case, capOpType2=0 so we dont need to bother about permission2 and permission3.
IF OBJECT_ID('tempdb.dbo.#sec_getClientList') IS NOT NULL
	DROP TABLE #sec_getClientList
CREATE TABLE #sec_getClientList (clientID INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
EXEC sec_getIdaObjectsForUser @userIdParam,								-- userId
3,						-- entityType
							  0,										-- permissionId (let us pass a string)
							  1,										-- inherit from children (appType, instance, backupset, subclient)
							  '#sec_getClientList',						-- output #table
							  0,										-- returnCursor
							  @permissionId,							-- permissionIdString
							  @isAndOperation							-- And/Or of permissionIdString
UPDATE Client
SET tr_rights = 2								-- If association is on apptype, instance, backupset or subclient we need to set tr_rights as 2 (partial)
FROM #CLIST_TMP Client							-- That same user might have association on client also. He will be set tr_rights as 1 (full) in the next query
	INNER JOIN #sec_getClientList Sec
		ON Client.tr_clientId = Sec.clientID
UPDATE Client
SET tr_rights = 1
FROM #CLIST_TMP Client
	INNER JOIN #sec_getClientList Sec
		ON Client.tr_clientId = Sec.clientID
			AND Sec.appTypeId = 0			-- If apptypeId is 0, then he has full access on client itself. Set tr_rights to 1 (full).
-- Delete cleints with no rights
delete #CLIST_TMP WHERE tr_rights = 0
-- set cluster type for index server clients
UPDATE client
SET tr_clusterType  = ISNULL(CAST (attrVal as INT),0)
FROM #CLIST_TMP client
JOIN APP_ClientProp cp (NOLOCK) ON componentNameId = tr_clientId
				AND attrName='index server Type'
				AND modified =0
EXIT_OUT:
SELECT DISTINCT tr_clientId, tr_clientName, tr_deleted, tr_rights, tr_cvdport, tr_evmgrcPort, tr_clientGuid, tr_clientHostName, tr_clusterType, tr_clientDisplayName  FROM  #CLIST_TMP
GO

IF EXISTS (select * from GxQscripts where name = 'getClientNameList')
	delete from GxQscripts where name = 'getClientNameList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getClientNameList')
	delete from GXDBVersions where aliasname = 'getClientNameList'
GO

insert into GXDBVersions values(2, 'getClientNameList',  '00000000000000000000', 'getClientNameList', '00000000000000000000')
GO

