

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getClientListIdBlocks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getclientlistIdBlocks.sp,v $ $Id: getclientlistIdBlocks.sp,v 1.1.2.6 2018/03/27 08:18:10 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getClientListIdBlocks')
BEGIN
	print '>>> Drop Stored Procedure: getClientListIdBlocks <<<'
	drop procedure getClientListIdBlocks
END
IF EXISTS (select * from GxQscripts where name='getClientListIdBlocks')
	delete from GxQscripts where name = 'getClientListIdBlocks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getClientListIdBlocks')
	delete from GXDBVersions where aliasname = 'getClientListIdBlocks'
GO
print '... Creating Procedure: getClientListIdBlocks'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure getClientListIdBlocks
  @i_userId integer,
  @i_getCommNetClients integer = 0,
  @i_includeHiddenClients integer = 0,
  @i_clientGroupId integer = 0,
  @i_clientId integer = 0,
  @i_hideEnabled integer = 1
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :OUT LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
AS
  DECLARE @r_rowNumber integer
  DECLARE @r_clientId integer
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#visibleClientList') IS NOT NULL
		DROP TABLE #visibleClientList
	CREATE TABLE #visibleClientList (clientId INT, apptypeId INT, instanceId INT, backupsetId INT, subclientId INT)
	--NOTE: XML Parsing inputted XML Security document more costly than performing the security calls below.
	if (@i_userId <> 0)
	BEGIN
EXEC sec_getIdaObjectsForUser @i_userId, 3, 0, 1, '#visibleClientList'
	END
	IF object_id('tempdb.dbo.#ClientList') is not null DROP TABLE #ClientList
	CREATE TABLE #ClientList (
		clientId		INT PRIMARY KEY
	)
	DECLARE @clientRowCount INT = 0
	-- Get requested clients
	IF (@i_clientGroupId <> 0)
	BEGIN
		INSERT INTO #ClientList(clientId)
			SELECT
				c.id
			FROM
				APP_Client c
				INNER JOIN APP_ClientGroupAssoc CG ON
					id = CG.clientId
					AND CG.clientGroupId = @i_clientGroupId
		SET  @clientRowCount = @@ROWCOUNT
	END
	ELSE IF  (@i_clientId <> 0)
	BEGIN
		INSERT INTO #ClientList(clientId)
			SELECT
				c.id
			FROM
				APP_Client c
			WHERE
				c.id = @i_clientId
		SET  @clientRowCount = @@ROWCOUNT
	END
	ELSE IF (@i_getCommNetClients <> 0)
	BEGIN
		INSERT INTO #ClientList(clientId)
			SELECT
				c.id
			FROM APP_Client c
			WHERE
				@i_includeHiddenClients > 0
				OR id IN (SELECT clientId FROM APP_IDAName where appTypeId = 121) -- 121 IS COMMNET SERVER
		SET  @clientRowCount = @@ROWCOUNT
	END
	ELSE	-- all clients
	BEGIN
		INSERT INTO #ClientList(clientId)
			SELECT
				c.id
			FROM
				APP_Client c
			WHERE
				(
					@i_includeHiddenClients > 0
					OR (c.specialClientFlags & 0x1 <> 0x1)
				)
		SET  @clientRowCount = @@ROWCOUNT
	END
	-- determine visibility
	IF (@i_userId <> 0)
	BEGIN
		IF (@i_hideEnabled <> 0)
		BEGIN
			DELETE cl
			FROM #ClientList cl
			WHERE NOT EXISTS (SELECT 1 FROM #visibleClientList t WHERE t.clientId = cl.clientId)
			SET @clientRowCount = @clientRowCount - @@ROWCOUNT
		END
	END
	DECLARE @ClientIdBlockSize INT = 1000		-- ACPTP_MIN_BLOCKSIZE
	SELECT @ClientIdBlockSize = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'GetClientListIdBlocksSPSize'		-- if null default set above
	IF (@ClientIdBlockSize < 1000 OR @ClientIdBlockSize > 5000)		-- ACPTP_MIN_BLOCKSIZE OR ACPTP_MAX_BLOCKSIZE
	BEGIN
		PRINT 'getClientListIdBlocks: Warning block size range is out-of-range 1000 to 5000, read [' + CAST(@ClientIdBlockSize AS VARCHAR(12)) + ']'
		-- Safety check for size out of range
		SET @ClientIdBlockSize = 1000			-- ACPTP_MIN_BLOCKSIZE
	END
	IF object_id('tempdb.dbo.#ClientList2') is not null DROP TABLE #ClientList2
	CREATE TABLE #ClientList2 (
		rowNumber		INT PRIMARY KEY,
		clientId		INT
	)
	INSERT INTO #ClientList2(rowNumber, clientId)
		SELECT
			ROW_NUMBER() OVER(ORDER BY c.clientId ASC) rowNumber,
			c.clientId
		FROM #ClientList c
	DECLARE @clientBlockCount INT = 0
	SELECT	@clientBlockCount = COUNT(clientId)
	FROM #ClientList2
	WHERE
		(rowNumber % @ClientIdBlockSize) = 0
	-- Return Output rows
	--SELECT -1 rowNumber, @clientBlockCount			-- estimated total count of client blocks
	--UNION ALL
	SELECT 0 rowNumber, @clientRowCount			-- estimated total count of client rows
	UNION ALL
	SELECT	-- return every Nth, @ClientIdBlockSize, row clientId
		rowNumber,
		clientId
	FROM #ClientList2
	WHERE
		(rowNumber % @ClientIdBlockSize) = 0
	UNION ALL
	SELECT ((@clientBlockCount + 1) * @ClientIdBlockSize), -1			-- max client Id
	ORDER BY rowNumber
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'getClientListIdBlocks')
	delete from GxQscripts where name = 'getClientListIdBlocks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getClientListIdBlocks')
	delete from GXDBVersions where aliasname = 'getClientListIdBlocks'
GO

insert into GXDBVersions values(2, 'getClientListIdBlocks',  '00010001000200060000', 'getClientListIdBlocks', '00010001000200060000')
GO

