

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getClientCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getClientCount <<<'

IF EXISTS (select * from sysobjects where name='getClientCount')
	drop procedure getClientCount
IF EXISTS (select * from GxQscripts where name='getClientCount')
	delete from GxQscripts where name = 'getClientCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getClientCount')
	delete from GXDBVersions where aliasname = 'getClientCount'
GO
print '... Creating Procedure: getClientCount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getClientCount
  @userIdParam integer,
  @commCellId integer,
  @i_includeHiddenClients integer,
  @clientCount integer output
-- Following are the "columns" returned, in the order in which they are returned
--		clientId	  	integer
--		clientName 	  	char(MAX_VARCHAR_SIZE)
--		deleted			integer
AS
  DECLARE @r_clientId integer
  DECLARE @r_deleted integer
  DECLARE @commcellLevelCaps bigint
SET NOCOUNT ON
IF object_id('tempdb.dbo.#IDX_CLS_TMP') IS NOT Null DROP INDEX #IDX_CLS_TMP ON #CLIST_TMP
IF object_id('tempdb.dbo.#CLIST_TMP') IS NOT Null DROP TABLE #CLIST_TMP
CREATE TABLE #CLIST_TMP
(
	tr_clientId int,
	tr_clientName nvarchar(255),
	tr_rights int
)
CREATE INDEX IDX_CLS_TMP ON #CLIST_TMP (tr_clientId )
IF object_id('tempdb.dbo.#ClientCap') IS NOT Null DROP TABLE #ClientCap
create table  #ClientCap ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
--enum CapaOperationType
--{
--CAP_SCHEDULE = 1,
--CAP_ALERT,
--CAP_CLIENT_GROUP,
--CAP_SUBCLIENT_POLICY,
--CAP_PSUEDOCLIENT_CREATE,
--CAP_ADMIN
--CAP_LOG_MONITORNIG
--};
BEGIN
		INSERT INTO #CLIST_TMP(tr_clientId, tr_rights)
		SELECT id, 0
		FROM	APP_Client C INNER JOIN App_Platform P ON
			C.id = P.clientId AND P.platformType = 4
		WHERE @i_includeHiddenClients > 0 OR (C.specialClientFlags & 0x1 <> 0x1)
END
-- Delete the physical machines on the cluster CS
delete from #CLIST_TMP where tr_clientId IN (select APP_VMToPMMap.PMClientId from APP_VMToPMMap where APP_VMToPMMap.VMClientId = 2)
EXEC sec_getUserObjects @userIdParam, 0, 0, '#ClientCap'
delete #ClientCap
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
		  OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0  OR taskId <> 0
		  OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
		  OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
		  OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
		  OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
SET @commcellLevelCaps = ISNULL( (SELECT capabilities FROM #ClientCap WHERE #ClientCap.commCellId=2 AND #ClientCap.clientGroupId=0 AND #ClientCap.clientId=0 AND #ClientCap.appTypeId=0 AND #ClientCap.instanceId=0 AND #ClientCap.backupsetId=0 AND #ClientCap.subClientId=0 AND #ClientCap.mediaAgentId=0 AND #ClientCap.libraryId=0 AND #ClientCap.archGroupId=0 AND #ClientCap.vtContainerId=0 AND #ClientCap.vtPolicyId=0 AND #ClientCap.vtShelfId=0 AND #ClientCap.reviewSetId=0 AND #ClientCap.querySetId=0 AND #ClientCap.downloadSetId=0 AND #ClientCap.ermId=0 AND #ClientCap.legalHoldId=0 AND #ClientCap.tagId=0 AND #ClientCap.cdPolicyId=0 AND #ClientCap.complianceReportId=0 AND #ClientCap.taskId=0 AND #ClientCap.workflowId=0 AND #ClientCap.logMonitoringPolicyId=0 AND #ClientCap.arrayId=0 AND #ClientCap.cloudId=0 AND #ClientCap.userGroupId=0 AND #ClientCap.providerId=0 AND #ClientCap.entityId1=0 AND #ClientCap.entityId2=0 AND #ClientCap.entityId3=0 AND #ClientCap.entityId4=0 AND #ClientCap.entityId5=0 AND #ClientCap.entityId6=0 AND #ClientCap.entityId7=0 AND #ClientCap.entityId8=0 AND #ClientCap.entityId9=0), 0)
IF (@commcellLevelCaps > 0)
BEGIN
	UPDATE #CLIST_TMP SET tr_rights = 1
END
ELSE
BEGIN
	UPDATE #CLIST_TMP SET tr_rights = 1
	FROM (SELECT dbo.BitwiseOR(capabilities) AS capabilities, clientId
	FROM #ClientCap WHERE appTypeId = 0	AND instanceId  = 0  AND backupSetId = 0  AND subClientId = 0
	GROUP BY clientId
	) T
	WHERE tr_clientId = T.clientId
END
-- Delete cleints with no rights
delete #CLIST_TMP WHERE tr_rights = 0
EXIT_OUT:
SET @clientCount=(SELECT count(DISTINCT tr_clientId) FROM  #CLIST_TMP)
GO

IF EXISTS (select * from GxQscripts where name = 'getClientCount')
	delete from GxQscripts where name = 'getClientCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getClientCount')
	delete from GXDBVersions where aliasname = 'getClientCount'
GO

insert into GXDBVersions values(2, 'getClientCount',  '00000000000000000000', 'getClientCount', '00000000000000000000')
GO

