

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getAlertTypeCompatClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getAlertTypeCompatClient.sp,v $ $Id: getAlertTypeCompatClient.sp,v 1.16.210.2 2018/03/27 07:59:03 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  getAlertTypeCompatClient()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--	|
--  |      Output:  Returns rows that match input criteria
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        skatz    Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getAlertTypeCompatClient <<<'

IF EXISTS (select * from sysobjects where name='getAlertTypeCompatClient')
	drop procedure getAlertTypeCompatClient
IF EXISTS (select * from GxQscripts where name='getAlertTypeCompatClient')
	delete from GxQscripts where name = 'getAlertTypeCompatClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getAlertTypeCompatClient')
	delete from GXDBVersions where aliasname = 'getAlertTypeCompatClient'
GO
print '... Creating Procedure: getAlertTypeCompatClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getAlertTypeCompatClient
  @userIdParam integer,
  @alertTypeParam integer
-- Following are the "columns" returned, in the order in which they are returned
--		clientId	  	integer
--		clientName 	  	char(MAX_VARCHAR_SIZE)
--		AppType	  	    integer
AS
  DECLARE @r_clientId integer
  DECLARE @r_clientName nvarchar(255)
  DECLARE @r_appType integer
  DECLARE @r_deleted integer
 SET NOCOUNT ON
 set transaction isolation level read uncommitted
 DECLARE @apptypeParam integer
 DECLARE @appTypeCeiling integer
set @appTypeCeiling = 1000						-- 'CV_APPTYPE_COMMSRVMGMT'
IF (@alertTypeParam = 20                     -- 'NT_ALERTTYPE_CLIENT_DIST'
OR @alertTypeParam = 26)               -- 'NT_ALERTTYPE_UPGR_UPDATES'
SET @appTypeCeiling = 1000 +1
-- FOR NOW, GET Apptype from alertType using simple conditional stmt here.  Eventually, we will need to make
-- this part of one of the alert tables, but it seems kind of silly to do it for this one case now
SET @appTypeParam = 0								-- "CV_APPTYPE_NOT_DEFINED  0"
IF @alertTypeParam = 23  						-- "NT_ALERTTYPE_APP_EXCHANGE  23"
SET @appTypeParam = 68					--"UNUSED_CV_APPTYPE_68"
ELSE IF @alertTypeParam = 25  						-- File levele replication ida
SET @appTypeParam = 84
ELSE IF @alertTypeParam = 27  						-- File levele replication ida
SET @appTypeParam = 85
ELSE IF  @alertTypeParam = 30						--NT_ALERTTYPE_APP_SHAREPOINT 30
SET @appTypeParam = 78						--CV_APPTYPE_MS_SHAREPOINTV2_DOC 78
IF object_id('tempdb.dbo.#GATCC_TMP') IS NOT Null DROP TABLE #GATCC_TMP
CREATE TABLE #GATCC_TMP
    (r_srcAppType int,
     tr_appType int,
     tr_clientId int,
     tr_clientName nvarchar(255),
     r_instance int,
     tr_deleted int,
     checkName nvarchar(512)
     )
IF @appTypeParam <> 0
BEGIN
IF (@appTypeParam = 1033)		-- 'CV_APPTYPE_1_TOUCH_SERVER_UNIX'
	BEGIN
		INSERT INTO #GATCC_TMP
		SELECT	DISTINCT 0, 0, tr_clientId = CP.componentnameId, clientName = C.name, 0, 0,''
		FROM	APP_ClientProp as CP, APP_Client as C
		WHERE	C.id = CP.componentnameId
AND  attrName = 'System Recovery Boot Server' AND attrVal = N'1'AND CP.modified=0
	END
	ELSE
	BEGIN
	DECLARE @AppGroupName nvarchar(256)
	SET @AppGroupName = (select case @appTypeParam
WHEN(68) THEN 'Exchange'
WHEN(84) THEN 'CDR'
WHEN (78) THEN 'SharePoint'
										ELSE NULL
										END)
--			FETCH ALL THE ROWS OF COMPATIBLE APPTYPES
--			-----------------------------------------
    INSERT INTO #GATCC_TMP
       SELECT  distinct AC.srcAppType,
               AC.destAppType, AP.clientId,
               clientName = (select name from APP_Client where id = AP.clientId),
               AP.instance,
               0,
               checkName = (select name from APP_InstanceName where id = instance)
                from  APP_Application  as AP, APP_AppCompat as AC
   WHERE AC.srcAppType = @appTypeParam AND AP.apptypeId = AC.destAppType
--			FETCH ALL THE ROWS OF THE SAME APPTYPE
--			---------------------------------------
   IF @AppGroupName = null
	BEGIN
        	INSERT INTO #GATCC_TMP SELECT   distinct apptypeId, apptypeId, clientId,
        		clientName = (select name from APP_Client where id = clientId),
        	    instance,
    	    0,
          checkName = (select name from APP_InstanceName where id = instance)
    	FROM  APP_Application
    	WHERE appTypeId = @appTypeParam
	END
	ELSE
	BEGIN
        	INSERT INTO #GATCC_TMP SELECT   distinct apptypeId, apptypeId, clientId,
        		clientName = (select name from APP_Client where id = clientId),
        	    instance,
    	    0,
          checkName = (select name from APP_InstanceName where id = instance)
    	FROM  APP_Application
    	WHERE appTypeId in (select appTypeId from App_AppTypeGroups where appGroup = @AppGroupName)
	END
	END
END
ELSE
--		NO ALERTTYPE SPECIFIC FILTERING TO BE DONE, RETURN ALL CLIENTS (SUBJ TO VISIBILITY)
BEGIN
	INSERT INTO #GATCC_TMP SELECT   distinct apptypeId, apptypeId, clientId,
		clientName = (select name from APP_Client where id = clientId),
	    instance,
	    0,
      checkName = (select name from APP_InstanceName where id = instance)
	FROM  APP_Application
	WHERE appTypeId < @appTypeCeiling		-- Usually 'CV_APPTYPE_COMMSRVMGMT 1000'
END
--  Return "deleted" clients, but set the "isDeleted" column (below)
--	Delete #GATCC_TMP from #GATCC_TMP, APP_ClientProp WHERE componentNameId=tr_clientId AND modified=0 AND attrVal='1' AND
--			attrName='platformdeleted 4'
UPDATE #GATCC_TMP
  SET tr_deleted  = 1
  WHERE EXISTS (select attrVal from APP_ClientProp where componentNameId=tr_clientid and attrName='platformdeleted 4' and modified =0 AND attrVal = '1')
	Delete #GATCC_TMP from #GATCC_TMP T, APP_IDAName I WHERE I.clientId=T.tr_clientId and I.appTypeId=T.tr_appType and
			((Status & 2) > 0 or (Status & 4) > 0)
--security check
IF @userIdParam > 0
BEGIN
	IF object_id('tempdb.dbo.#tempUserObjects') IS NOT Null DROP TABLE #tempUserObjects
create table  #tempUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userIdParam, 2009, 0, '#tempUserObjects'
	Delete #GATCC_TMP
	FROM #GATCC_TMP T
	WHERE 0 = (select count(*) from #tempUserObjects U where U.clientId In (0, T.tr_clientId) AND
			U.clientGroupId = 0 AND U.mediaAgentId = 0 AND U.libraryID = 0 AND U.archGroupID = 0)
	DROP TABLE #tempUserObjects
END
 	SELECT DISTINCT tr_clientId, tr_clientName, tr_appType, tr_deleted FROM  #GATCC_TMP
        drop table #GATCC_TMP
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getAlertTypeCompatClient')
	delete from GxQscripts where name = 'getAlertTypeCompatClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getAlertTypeCompatClient')
	delete from GXDBVersions where aliasname = 'getAlertTypeCompatClient'
GO

insert into GXDBVersions values(2, 'getAlertTypeCompatClient',  '00010016021000020000', 'getAlertTypeCompatClient', '00010016021000020000')
GO

