

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/deleteMultipleBackupByJobCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/deleteMultipleBackupByJobCopy.sp,v $ $Id: deleteMultipleBackupByJobCopy.sp,v 1.24.2.17 2020/12/22 07:13:05 hkapadia Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='deleteMultipleBackupByJobCopy')
BEGIN
	print '>>> Drop Stored Procedure: deleteMultipleBackupByJobCopy <<<'
	drop procedure deleteMultipleBackupByJobCopy
END
IF EXISTS (select * from GxQscripts where name='deleteMultipleBackupByJobCopy')
	delete from GxQscripts where name = 'deleteMultipleBackupByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteMultipleBackupByJobCopy')
	delete from GXDBVersions where aliasname = 'deleteMultipleBackupByJobCopy'
GO
print '... Creating Procedure: deleteMultipleBackupByJobCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure deleteMultipleBackupByJobCopy
  @i_userId INTEGER,
  @i_xml XML
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
  DECLARE @skippedCode INTEGER;
  DECLARE @prunedJobIdList VARCHAR(MAX);
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	-- These below defines are used in GUI for sending skipped message to user.
	-- MANUALLY_RETAINED_JOB				1
	-- MANUAL_PRUNING_FROM_WORM_STORAGE		2
	-- SILO_TAPE_COPY_JOB					4
	-- DDB_BACKUP_JOB						8
	-- MIRROR_COPY_JOB						16
	-- AUXCOPY_ARCHCHECK_DV_MR_CI_RUNNING	32
	-- SNAPTOTAPE_RUNNING					64
    -- LAST_CYCLE_RUNNING_JOBS			    128
	-- Declare temp variables for Gui Audit
	DECLARE @opMsgId 			INTEGER
	DECLARE @opEvMsgId 		INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId 	INTEGER
	DECLARE @JobList 			VARCHAR(MAX)
	DECLARE	@l_now 		INT
	SET 		@l_now 		= dbo.GetUnixTime(GETUTCDATE())
	DECLARE @rowCnt		INTEGER
	DECLARE	@errCode	INTEGER
	DECLARE @GUIAuditId INT
	SET			@GUIAuditId	= 0
	DECLARE @GUIAuditUserId INT
	SELECT	@GUIAuditUserId = ISNULL(@i_userId, 1)
	DECLARE @GUISPName NVARCHAR(256)
	SET			@GUISPName = ''
	DECLARE @GUICopyName NVARCHAR(256)
	SET			@GUICopyName = ''
	DECLARE @SpCopyListCursorFlag INT
	SET 		@SpCopyListCursorFlag = 0
	DECLARE	@curArchGrpId			INT
	DECLARE	@curArchGrpCopyId	INT
	DECLARE	@RetainDDBBkpsOfSealedStores	INTEGER
	SET			@RetainDDBBkpsOfSealedStores	= 0
	DECLARE	@GUIDescription	NVARCHAR(256)
	SET			@GUIDescription = ''
	DECLARE @checkSumIsTurboSC INTEGER
	SET 		@checkSumIsTurboSC = CHECKSUM(N'Is Turbo Subclient')
	DECLARE @tblRetVal TABLE (errorCode int)
	DECLARE @tblCopy TABLE (
		archGroupId 	INT,
		archCopyId		INT,
		primaryCopyId INT,
		sourceCopyId	INT,
		isSnapCopy		INT,
		isMirrorCopy	INT
	)
	DECLARE @tblMatSrcCopy TABLE (
		archGroupId 	INT,
		sourceCopyId 	INT
	)
	if object_id('tempdb.dbo.#ReqDDBBackupJobs') is not null DROP TABLE #ReqDDBBackupJobs
	CREATE	TABLE #ReqDDBBackupJobs (
			SIDBStoreId			INTEGER,
			SubStoreId			INTEGER,
			commCellId			INTEGER,
			JobId						INTEGER,
			JobCommCellId		INTEGER,
			)
	CREATE INDEX Idx_ReqDDBBackupJobs_1 ON #ReqDDBBackupJobs (SIDBStoreId, SubStoreId, CommCellId)
	CREATE INDEX Idx_ReqDDBBackupJobs_2 ON #ReqDDBBackupJobs (JobId, JobCommCellId)
	if object_id('tempdb.dbo.#JobsToPrune') is not null DROP TABLE #JobsToPrune
	IF OBJECT_ID('tempdb.dbo.#JobsSelectedForCopyByAuxCopyJob') IS NOT NULL DROP TABLE  #JobsSelectedForCopyByAuxCopyJob
	CREATE TABLE #JobsSelectedForCopyByAuxCopyJob(JobId INTEGER, commCellId INTEGER, SrcCopyId INTEGER, DestCopyId INTEGER)
	CREATE INDEX Idx_jobId_CommcellId ON #JobsSelectedForCopyByAuxCopyJob (JobId, commCellId, SrcCopyId, DestCopyId)
	SET @errorString = ''
	SET @skippedCode = 0
	BEGIN TRANSACTION DELJOBCOPYTRAN
	-- This temp table must be created and populated before calling stored procedure archSetJobsAgedViaTable
	DECLARE @tblBCDIndexAF TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	DECLARE @tblJobsWithBCDIndex TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	CREATE TABLE #ToBeAgedJob (
		jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
		PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
	-- This temp table must be created and populated before calling stored procedure archDisallowMultipleJobForCopy
	CREATE TABLE #ToBeDisabledJob (
		jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
		PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
	SELECT @RetainDDBBkpsOfSealedStores = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETAIN_DDB_BACKUPS_OF_SEALED_STORES'
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
DECLARE @DDBBkpsToRetain INT = 0
DECLARE @prevDDBBkpsRetained INT = 0
DECLARE @err INT = 0
SET @DDBBkpsToRetain = (SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_RETAIN_NO_OF_DDB_BACKUPS')
IF @DDBBkpsToRetain > 1
BEGIN
    -- T.rn >= @DDBBkpsToRetain because we maintain old backup info in IdxSIDBSubStoreBackupInfo and latest in IdxSIDBSubStore table
    -- Delete the old DDB Backups
    DELETE I
    FROM IdxSIDBSubStoreBackupInfo I,
		(SELECT SIDBStoreId, SubStoreId, LastSnapJobId, ROW_NUMBER() OVER(PARTITION BY SIDBStoreId, SubStoreId ORDER BY LastSnapTime DESC) AS rn
		FROM IdxSIDBSubStoreBackupInfo WITH (READUNCOMMITTED)
		) T
    WHERE I.SIDBStoreId = T.SIDBStoreId
	AND I.SubStoreId = T.SubStoreId
	AND I.LastSnapJobId = T.LastSnapJobId
	AND T.rn >= @DDBBkpsToRetain
    SET	@err	=	@@ERROR
END
ELSE
BEGIN
    DELETE FROM IdxSIDBSubStoreBackupInfo
END
	SET @retVal = @err
	IF	@retVal != 0 GOTO CX_EXIT
	--Get all DDB Backup jobs
	INSERT INTO #ReqDDBBackupJobs
	SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, CASE WHEN C.id IS NULL THEN SS.commCellId ELSE C.id END
	FROM IdxSIDBSubStore SS WITH (NOLOCK)
	INNER JOIN IdxSIDBStore S WITH (NOLOCK)
		ON 	SS.SIDBStoreId = S.SIDBStoreId
		AND	SS.commCellId = S.commCellId
	LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK)
	ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
	WHERE	SS.LastSnapJobId > 0
AND	(S.flags & 256) = 0
	AND		(	(@RetainDDBBkpsOfSealedStores = 1)
					OR
					(@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0)
				)
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	--Get old DDB backup jobs also. Need to retain them from pruning.
	INSERT INTO #ReqDDBBackupJobs
	SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, CASE WHEN C.id IS NULL THEN SS.commCellId ELSE C.id END
	FROM IdxSIDBSubStoreBackupInfo SS WITH (NOLOCK)
	INNER JOIN IdxSIDBStore S WITH (NOLOCK)
		ON 	SS.SIDBStoreId = S.SIDBStoreId
		AND	SS.commCellId = S.commCellId
	LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK)
	ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
	WHERE	SS.LastSnapJobId > 0
AND	(S.flags & 256) = 0
	AND		(	(@RetainDDBBkpsOfSealedStores = 1)
					OR
					(@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0)
				)
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	SELECT	DISTINCT T.item.value('@JobId', 'INTEGER') AS JobId,
					T.item.value('@commCellId', 'INTEGER') AS commCellId,
					T.item.value('@fileType', 'INTEGER') AS fileType,
					T.item.value('@archGrpId', 'INTEGER') AS archGrpId,
					T.item.value('@archGrpCopyId', 'INTEGER') AS archGrpCopyId,
					ISNULL(T.item.value('@ignoreCheckFlags', 'INTEGER'), 0) AS ignoreCheckFlags
	INTO 	#JobsToPrune
	FROM	@i_xml.nodes('/GalaxyOperations_PruneJobs/JobInfo') T(item)
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	INSERT INTO #JobsToPrune
	SELECT	DISTINCT JDS.JobId , JDS.commCellId , JTP.fileType , JDS.archGrpId , JDS.archGrpCopyId, JTP.ignoreCheckFlags
	FROM	#JobsToPrune JTP INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
	ON		JTP.jobId = JDS.jobId AND JTP.commCellId = JDS.commCellId AND (JTP.fileType = 0 OR JTP.fileType = JDS.dataType )
			AND (JTP.archGrpId = -1 OR JTP.archGrpId = JDS.archGrpId) AND JTP.archGrpCopyId = -1
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	DELETE 	FROM #JobsToPrune
	WHERE 	archGrpCopyId = -1
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	INSERT INTO @tblMatSrcCopy
	SELECT DISTINCT a.id, (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	FROM	#JobsToPrune T, archGroup a WITH (NOLOCK), archMaterializeSnapshotProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
	WHERE	T.archGrpId = a.id
	AND		a.id = b.archGroupId
	AND		b.archGroupId = c.archGroupId
	AND		c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	AND		c.isSnapCopy > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- Set Materialization Source Copy as source of Mirror copy, if materialization Source Copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblMatSrcCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE @tblMatSrcCopy
		SET sourceCopyId = (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
		FROM	@tblMatSrcCopy T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		T.archGroupId = AGC.archGroupId
		AND		AGC.archGroupId = AG.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SET	@retVal	=	@@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
	END
	DECLARE	SpCopyListCursor CURSOR STATIC FOR
			SELECT	DISTINCT archGrpId, archGrpCopyId
			FROM	#JobsToPrune
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- DO NOT PRUNE any jobs on WORM copy
	DELETE 	#JobsToPrune
	FROM 		#JobsToPrune JP, archGroupCopy AGC WITH (NOLOCK)
	WHERE 	JP.archGrpCopyId = AGC.id
AND 		(AGC.flags & 16777216) > 0
	AND			JP.ignoreCheckFlags & 2 = 0
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped jobs on WORM Copy. ' + char(10)
		SET @skippedCode = @skippedCode | 2 --MANUAL_PRUNING_FROM_WORM_STORAGE
	END
	IF	@retVal != 0 GOTO CX_EXIT
	-- Do Not Prune Manually Retained Jobs
	DELETE 	#JobsToPrune
	FROM 		#JobsToPrune JP,JMJobDataStats JDS WITH (NOLOCK)
	WHERE 	JP.JobId = JDS.JobId
	AND 		JP.archGrpId = JDS.archGrpId
	AND			JP.archGrpCopyId = JDS.archGrpCopyId
	AND 		JP.commCellId = JDS.commCellId
AND 		(JDS.disabled & 2) = 2
	AND			JP.ignoreCheckFlags & 1 = 0
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped manually retained jobs. ' + char(10)
		SET @skippedCode = @skippedCode | 1  --MANUALLY_RETAINED_JOB
	END
	IF	@retVal != 0 GOTO CX_EXIT
	-- DO NOT PRUNE any jobs for SILO AppId
	DELETE 	#JobsToPrune
	FROM 		#JobsToPrune JP,JMJobDataStats JDS WITH (NOLOCK)
	WHERE 	JP.JobId = JDS.JobId
	AND 		JP.archGrpId = JDS.archGrpId
	AND			JP.archGrpCopyId = JDS.archGrpCopyId
	AND 		JP.commCellId = JDS.commCellId
	AND 		JDS.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
	AND			JP.ignoreCheckFlags & 4 = 0
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped SILO Tape Copy jobs. ' + char(10)
		SET @skippedCode = @skippedCode | 4 --SILO_TAPE_COPY_JOB
	END
	IF	@retVal != 0 GOTO CX_EXIT
	-- Do Not Prune DDB Backup Jobs
	DELETE 	#JobsToPrune
	FROM 		#JobsToPrune JP,#ReqDDBBackupJobs T
	WHERE 	JP.JobId = T.JobId
	AND 		JP.commCellId = T.JobCommCellId
	AND			JP.ignoreCheckFlags & 8 = 0
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped DDB Backup Jobs. ' + char(10)
		SET @skippedCode = @skippedCode | 8 --DDB_BACKUP_JOB
	END
	IF	@retVal != 0 GOTO CX_EXIT
	-- DO NOT PRUNE any jobs on MIRROR Copy
	DELETE #JobsToPrune
	FROM	#JobsToPrune T, archGroupCopy AGC WITH (NOLOCK)
	WHERE	T.archGrpCopyId = AGC.id
	AND 	AGC.isSnapCopy > 0
	AND 	AGC.isMirrorCopy > 0
	AND		T.ignoreCheckFlags & 16 = 0
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped Mirror Copy jobs. ' + char(10)
		SET @skippedCode = @skippedCode | 16 --MIRROR_COPY_JOB
	END
	IF	@retVal != 0 GOTO CX_EXIT
	-- DO NOT PRUNE jobs if Online/Offline Content Indexing job is running for SP/Copy
	DELETE #JobsToPrune
	FROM	#JobsToPrune T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archContentIndexingRules IR WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE	T.archGrpId = AG.id
	AND		AG.id = IR.archGroupId
	AND 	T.archGrpCopyId = (CASE WHEN IR.sourceCopyId = 0 THEN AG.defaultCopy ELSE IR.sourceCopyId END)
	AND		T.jobId = AF.jobId
	AND 	T.commCellId = AF.commCellId
	AND		AF.id = AFC.archFileId
	AND		AF.commCellId = AFC.commCellId
	AND 	T.archGrpCopyId = AFC.archCopyId
AND 	(AFC.flags & 256) = 0
AND 	(AF.flags & (16 | 32)) <> 0
	AND		T.ignoreCheckFlags & 32 = 0
	AND 	EXISTS
				(
					SELECT B.JobId
					FROM	JMAdminJobInfoTable B WITH (NOLOCK)
					WHERE	B.opType IN (53, 57)
					AND 	EXISTS
							(
								SELECT 	A.optionId
								FROM 		dbo.GetAllJobOptions(B.JobId) A
WHERE 	A.optionId = 140008 AND A.value = CAST(T.archGrpId AS CHAR(10))
								  			OR
A.optionId = 140009 AND A.value = CAST(T.archGrpCopyId AS CHAR(10))
					  	)
				)
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped jobs as Online/Offline Content Indexing job is running. ' + char(10)
		SET @skippedCode = @skippedCode | 32 --AUXCOPY_ARCHCHECK_DV_MR_CI_RUNNING
	END
	IF	@retVal != 0 GOTO CX_EXIT
	-- DO NOT PRUNE jobs if Media Refresh job is running for SP/Copy
	DELETE #JobsToPrune
	FROM	#JobsToPrune T, JMJobDataStats JDS WITH (NOLOCK)
	WHERE	T.jobId = JDS.jobId
	AND 	T.commCellId = JDS.commCellId
	AND 	T.archGrpCopyId = JDS.archGrpCopyId
AND 	(JDS.disabled & 256) = 0
	AND		T.ignoreCheckFlags & 32 = 0
	AND 	EXISTS
				(
					SELECT B.JobId
					FROM	JMAdminJobInfoTable B WITH (NOLOCK)
					WHERE	B.opType = 74
					AND 	EXISTS
							(
								SELECT 	A.optionId
								FROM 		dbo.GetAllJobOptions(B.JobId) A
WHERE 	A.optionId = 140008 AND A.value = CAST(T.archGrpId AS CHAR(10))
								  			OR
A.optionId = 140009 AND A.value = CAST(T.archGrpCopyId AS CHAR(10))
					  	)
				)
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped jobs as Media Refresh job is running. ' + char(10)
		SET @skippedCode = @skippedCode | 32 --AUXCOPY_ARCHCHECK_DV_MR_CI_RUNNING
	END
	IF	@retVal != 0 GOTO CX_EXIT
	-- DO NOT PRUNE jobs if Snap To Tape or deferred catalog job is running for SP/Copy
	DELETE #JobsToPrune
	FROM	#JobsToPrune T, JMJobDataStats JDS WITH (NOLOCK), JMJobWF JW WITH (NOLOCK), JMJobInfo JI WITH (NOLOCK)
	WHERE	T.jobId = JW.processedJobId
	AND 	T.commCellId = JW.processedCommcellId
	AND 	JW.childJobId = JI.jobId
	AND 	JW.commcellId = JI.commCellId
	AND		T.jobId = JDS.jobId
	AND 	T.commCellId = JDS.commCellId
	AND 	T.archGrpCopyId = JDS.archGrpCopyId
	AND 	T.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
AND 	(JDS.disabled & 256) = 0
	AND		T.ignoreCheckFlags & 64 = 0
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped jobs as Snap To Tape or Deferred Catalog job is running. ' + char(10)
		SET @skippedCode = @skippedCode | 64 --SNAPTOTAPE_RUNNING
	END
	IF	@retVal != 0 GOTO CX_EXIT
    --Do not prune jobs of latest cycle on primary copy if there are running jobs for the subclient
    DECLARE @appCycleNum table(appId int, fullCycleNum int)
    --Getting subclients whose jobs in primary copy are deleted
    INSERT INTO @appCycleNum
    SELECT JBKP.appId, MAX(JBKP.fullCycleNum)
    FROM #JobsToPrune JOBS INNER JOIN JMBkpStats JBKP WITH(NOLOCK)
    ON JOBS.jobId = JBKP.jobId AND JOBS.commcellId = JBKP.commcellId AND JBKP.status IN(1, 3, 14)
    INNER JOIN archGroup AG WITH(NOLOCK) ON AG.id = JOBS.archGrpId AND (JOBS.archGrpCopyId = AG.defaultCopy OR JOBS.archGrpCopyId = AG.defaultSnapCopy)
    GROUP BY JBKP.appId
    --Filter out only those whose jobs in latest cycle are deleted
    /*
    DELETE @appCycleNum
    FROM @appCycleNum APP INNER JOIN JMBkpStats JBKP WITH(NOLOCK)
    ON APP.appId = JBKP.appId AND JBKP.fullCycleNum > APP.fullCycleNum AND JBKP.status IN (1, 3, 14)
    */
    DELETE @appCycleNum
    FROM @appCycleNum APP INNER JOIN App_SubclientProp SCProp WITH(NOLOCK) ON App.appId = SCProp.componentNameId
    WHERE SCProp.attrName = 'sys:full cycle num' AND APP.fullCycleNum < CAST(SCProp.attrVal AS BIGINT)
    --Filter out such jobs from the job list to delete if there are running jobs for the subclient
    DELETE #JobsToPrune
    FROM #JobsToPrune JOBS INNER JOIN JMBkpStats JBKP WITH(NOLOCK)
    ON JOBS.jobId = JBKP.jobId AND JOBS.commcellId = JBKP.commcellId
    INNER JOIN @appCycleNum APP ON JBKP.appId = APP.appID AND JBKP.fullCycleNum = APP.fullCycleNum
    INNER JOIN JMBkpJobInfo RJ WITH(NOLOCK) ON RJ.applicationId = JBKP.appId
		WHERE JOBS.ignoreCheckFlags & 128 = 0
	SELECT	@retVal	=	@@ERROR, @rowCnt = @@ROWCOUNT
	IF @rowCnt > 0
	BEGIN
		SET @errorString = @errorString + 'Skipped jobs as active jobs are running for subclient ' + char(10)
		SET @skippedCode = @skippedCode | 128 --LAST_CYCLE_RUNNING_JOBS
	END
	IF	@retVal != 0 GOTO CX_EXIT
	INSERT INTO @tblCopy
	SELECT DISTINCT AG.id, AGC.id, (CASE AGC.isSnapCopy WHEN 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END), AGC.sourceCopyId, AGC.isSnapCopy, AGC.isMirrorCopy
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), #JobsToPrune JP
	WHERE	AG.id = JP.archGrpId
	AND		AG.id = AGC.archGroupId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- The source copy will be source of Mirror copy if source copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopy
		SET 	sourceCopyId = AGC.sourceCopyId
		FROM	@tblCopy T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
	END
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- The source copy will be primary copy if source copy is not defined
	UPDATE	@tblCopy
	SET 	sourceCopyId = primaryCopyId
	WHERE	sourceCopyId = 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- PRUNE jobs on Mirror Copy if the copy is source of Mirror Snap Copy
	INSERT	INTO #JobsToPrune
	SELECT	DISTINCT JDS.jobId, JDS.commCellId, T.fileType, JDS.archGrpId, JDS.archGrpCopyId, T.ignoreCheckFlags
	FROM	JMJobDataStats JDS WITH (NOLOCK), #JobsToPrune T, @tblCopy C
	WHERE	JDS.jobId = T.JobId
	AND 	JDS.commCellId = T.commCellId
	AND 	JDS.archGrpCopyId = C.archCopyId
	AND 	C.sourceCopyId = T.archGrpCopyId
	AND 	C.isSnapCopy > 0
	AND 	C.isMirrorCopy > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	INSERT	INTO #ToBeAgedJob
	SELECT 	DISTINCT JM.JobId, JM.archGrpId, JM.archGrpCopyId, JM.dataType, JM.commCellId
	FROM 		JMJobDataStats JM WITH (NOLOCK), #JobsToPrune JP
	WHERE  	JM.JobId = JP.JobId
	AND 		JM.commCellId = JP.commCellId
	AND 		JM.archGrpId = JP.archGrpId
	AND			JM.archGrpCopyId = JP.archGrpCopyId
AND 		((JP.fileType = 0) OR (JP.fileType = 1 AND JM.dataType NOT IN (4, 6)) OR (JP.fileType = 4 AND JM.dataType = 4))
	UNION
	SELECT 	DISTINCT AF.jobId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.commCellId
	FROM 		archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), #JobsToPrune JP
	WHERE 	AF.JobId = JP.JobId
	AND			AF.commCellId = JP.commCellId
	AND			AF.archGroupId = JP.archGrpId
	AND			AF.id = AFC.archFileId
	AND			AF.commCellId = AFC.commCellId
	AND			AFC.archCopyId = JP.archGrpCopyId
AND 		((JP.fileType = 0) OR (JP.fileType = 1 AND AF.fileType NOT IN (4, 6)) OR (JP.fileType = 4 AND AF.fileType = 4))
	INSERT INTO @tblBCDIndexAF
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), #JobsToPrune JP
	WHERE		JDS.jobId = JP.jobId
	AND			JDS.commCellId = JP.commCellId
	AND 		JDS.archGrpId = JP.archGrpId
AND 		JDS.dataType IN (6)
	AND			JP.fileType <> 0
	AND			JDS.archGrpCopyId = JP.archGrpCopyId
	UNION
	SELECT 	DISTINCT AF.jobId, AF.commCellId, AF.fileType, AFC.archCopyId, 0
	FROM 		archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), #JobsToPrune JP
	WHERE 	AF.JobId = JP.JobId
	AND			AF.commCellId = JP.commCellId
	AND			AF.archGroupId = JP.archGrpId
AND			AF.fileType IN (6)
	AND			JP.fileType <> 0
	AND			AF.id = AFC.archFileId
	AND			AF.commCellId = AFC.commCellId
	AND			AFC.archCopyId = JP.archGrpCopyId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- Regular Index Archive Files after movement to media
	INSERT INTO @tblBCDIndexAF
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), #JobsToPrune JP, archFile AF WITH (NOLOCK)
	WHERE		JDS.jobId = JP.jobId
	AND			JDS.commCellId = JP.commCellId
	AND 		JDS.archGrpId = JP.archGrpId
	AND			JDS.archGrpCopyId = JP.archGrpCopyId
	AND			JDS.jobId = AF.jobId
	AND			JDS.commCellId = AF.commCellId
	AND			JDS.dataType = AF.fileType
AND 		AF.fileType IN (2)
AND			(AF.flags & (4 | 4096)) > 0
	AND			JP.fileType <> 0
	UNION
	SELECT 	DISTINCT AF.jobId, AF.commCellId, AF.fileType, AFC.archCopyId, 0
	FROM 		archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), #JobsToPrune JP
	WHERE 	AF.JobId = JP.JobId
	AND			AF.commCellId = JP.commCellId
	AND			AF.archGroupId = JP.archGrpId
AND 		AF.fileType IN (2)
AND			(AF.flags & (4 | 4096)) > 0
	AND			JP.fileType <> 0
	AND			AF.id = AFC.archFileId
	AND			AF.commCellId = AFC.commCellId
	AND			AFC.archCopyId = JP.archGrpCopyId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- DO NOT Prune Regular Index Archive File created after Snap movement to media, if either Data or Log is NOT Aged
	DELETE #ToBeAgedJob
	FROM #ToBeAgedJob TT, @tblBCDIndexAF BCD
	WHERE TT.jobId = BCD.jobId
	AND TT.commCellId = BCD.commCellId
	AND TT.dataType = BCD.fileType
	AND TT.archGrpCopyId = BCD.copyId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	INSERT INTO @tblJobsWithBCDIndex
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.disabled & 256
	FROM 		JMJobDataStats JDS WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE		JDS.jobId = TT.jobId
	AND			JDS.commCellId = TT.commCellId
AND 		JDS.dataType IN (1, 4)
	AND			JDS.archGrpCopyId = TT.copyId
	UNION
	SELECT 	DISTINCT AF.jobId, AF.commCellId, AF.fileType, AFC.archCopyId, AFC.flags & 256
	FROM 		archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE 	AF.JobId = TT.jobId
	AND			AF.commCellId = TT.commCellId
AND 		AF.fileType IN (1, 4)
	AND			AF.id = AFC.archFileId
	AND			AF.commCellId = AFC.commCellId
	AND			AFC.archCopyId = TT.copyId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	UPDATE  @tblJobsWithBCDIndex
	SET 		flags = 256
	FROM 		@tblJobsWithBCDIndex TT, #ToBeAgedJob b
	WHERE		TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
	AND 		TT.fileType = b.dataType
	AND			TT.copyId = b.archGrpCopyId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	UPDATE  @tblBCDIndexAF
	SET 		flags = ISNULL(b.flags, 256)
	FROM 		@tblBCDIndexAF TT LEFT OUTER JOIN (SELECT jobId, commCellId, copyId, MIN(flags & 256) AS flags
															FROM @tblJobsWithBCDIndex
															GROUP BY jobId, commCellId, copyId) b
	ON			TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
	AND			TT.copyId = b.copyId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	-- Prune the prunable BCD Index AFs also
	INSERT	INTO #ToBeAgedJob
	SELECT 	DISTINCT JM.JobId, JM.archGrpId, JM.archGrpCopyId, JM.dataType, JM.commCellId
	FROM 		JMJobDataStats JM WITH (NOLOCK), @tblBCDIndexAF T
	WHERE  	JM.JobId = T.JobId
	AND 		JM.commCellId = T.commCellId
	AND			JM.archGrpCopyId = T.copyId
	AND 		JM.dataType = T.fileType
	AND			T.flags & 256 = 256
	UNION
	SELECT 	DISTINCT AF.jobId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.commCellId
	FROM 		archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), @tblBCDIndexAF T
	WHERE 	AF.JobId = T.JobId
	AND			AF.commCellId = T.commCellId
	AND			AF.id = AFC.archFileId
	AND			AF.commCellId = AFC.commCellId
	AND			AFC.archCopyId = T.copyId
	AND 		AF.fileType = T.fileType
	AND			T.flags & 256 = 256
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	INSERT 	INTO #ToBeDisabledJob
	SELECT 	T.JobId, T.archGrpId, T.archGrpCopyId, T.dataType, T.commCellId
	FROM 		#ToBeAgedJob T
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	IF	EXISTS (SELECT * FROM #ToBeAgedJob)
	BEGIN
		INSERT INTO @tblRetVal
EXEC archSetJobsAgedViaTable 1024, @l_now
		SET	@retVal = @@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		SELECT @retVal = ISNULL(errorCode, -1) FROM @tblRetVal
		IF	@retVal != 0 GOTO CX_EXIT
		EXEC @errCode = archDisallowMultipleJobForCopy @l_now
		SET	@retVal = @@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		SET @retVal = @errCode
		IF	@retVal != 0 GOTO CX_EXIT
		--Check if deleted job is in last cycle. If yes - convert next job to full or diff
		DECLARE @tblAppIdListToConvert table(appId int, fullCycleNum int, maxServStartDate int)
		INSERT INTO @tblAppIdListToConvert
		SELECT JBKP.appId, MAX(JBKP.fullCycleNum), MAX(JBKP.servStartDate)
		FROM #ToBeAgedJob J INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.commcellId = JBKP.commcellId AND JBKP.status IN (1, 3, 14)
		INNER JOIN ArchGroup AG WITH(NOLOCK) ON AG.id = J.archGrpId AND (AG.defaultCopy = J.archGrpCopyId OR AG.defaultSnapCopy = J.archGrpCopyId)
		LEFT OUTER JOIN #JobsToPrune J1 ON J.jobId = J1.jobId AND J.commcellId = J1.commcellId
		WHERE ISNULL(J1.ignoreCheckFlags, 0) & 128 = 0 /*For callers that chose to clean up latest cycle jobs intentionally do not force next backup to full*/
		GROUP BY JBKP.appId
		SET	@retVal = @@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		--Filter out and get only subclients whose latest cycle jobs were deleted
		/*
		DELETE @tblAppIdListToConvert
		FROM @tblAppIdListToConvert APP INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON APP.appId = JBKP.appId
		WHERE JBKP.fullCycleNum > APP.fullCycleNum
		*/
		DELETE @tblAppIdListToConvert
    	FROM @tblAppIdListToConvert APP INNER JOIN App_SubclientProp SCProp WITH(NOLOCK) ON App.appId = SCProp.componentNameId
    	WHERE SCProp.attrName = 'sys:full cycle num' AND APP.fullCycleNum < CAST(SCProp.attrVal AS BIGINT)
		SET	@retVal = @@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		DECLARE @configForceDiff INT = 0
		SELECT @configForceDiff = ISNULL(value, 0) FROM MMConfigs WITH(NOLOCK) WHERE name = 'MMCONFIGS_DEL_INCR_DIFF_NOT_FORCE_FULL_ON_NEXT_BACKUP'
		SET	@retVal = @@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		--Subclients that I am left with must need job conversion
		DECLARE @tblAppIdsToForceFull table(appId int)
		IF(@configForceDiff > 0)
			INSERT INTO @tblAppIdsToForceFull
			SELECT distinct APP.appId
			FROM @tblAppIdListToConvert APP INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON APP.appId = JBKP.appId AND APP.fullCycleNum = JBKP.fullCycleNum
			INNER JOIN #TobeAgedJob J ON JBKP.jobId = J.jobId AND JBKP.commcellId = J.commcellId
			WHERE JBKP.bkpLevel NOT IN(2, 4) AND JBKP.status IN (1, 3, 14)
		ELSE
			INSERT INTO @tblAppIdsToForceFull
			SELECt appId FROM @tblAppIdListToConvert
		SET	@retVal = @@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		/*
		typedef enum CVBkpLevel
		{
		    UNKNOWN_BKP_LEVEL = 0x0,
		    FULL = 0x1,
		    INCR = 0x2,
		    DIFFERENTIAL = 0x4,
		*/
		IF EXISTS(SELECT 1 FROM @tblAppIdsToForceFull)
		BEGIN
			DECLARE @appIdListXmlFull xml
			SET @appIdListXmlFull = (SELECT appId FROM @tblAppIdsToForceFull FOR XML RAW, ROOT('AppIdList'))
			SET	@retVal = @@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
			DECLARE @tblTempResultFull table (retVal int)
			INSERT @tblTempResultFull
			EXEC AppForceNextBackpAsFullOrDiff 1, @appIdListXmlFull, '8' --CV_CLEAR_ARCHIVE_AUXCOPY_JOBCOPY
			SET @retVal = @@ERROR
			IF @retVal = 0
				SELECT @retVal = retVal FROM @tblTempResultFull
			IF @retVal != 0 GOTO CX_EXIT
		END
		DELETE @tblAppIdListToConvert WHERE appId IN (SELECT appId FROM @tblAppIdsToForceFull)
		IF EXISTS(SELECT 1 FROM @tblAppIdListToConvert)
		BEGIN
            -- At this point all appIds in @tblAppIdListToConvert will have only appids whose incr and differential jobs are deleted. If these deleted jobs before last diff conversion is not required
            DELETE @tblAppIdListToConvert
            FROM @tblAppIdListToConvert APP INNER JOIN JMBkpStats JBKP WITH(NOLOCK)
            ON APP.appId = JBKP.appId AND APP.fullCycleNum = JBKP.fullCycleNum AND JBKP.bkpLevel = 4
            AND JBKP.servStartDate > APP.maxServStartDate AND JBKP.status IN (1, 3, 14)
			IF EXISTS(SELECT 1 FROM @tblAppIdListToConvert)
			BEGIN
				DECLARE @appIdListXmlDiff xml
				SET @appIdListXmlDiff = (SELECT appId FROM @tblAppIdListToConvert FOR XML RAW, ROOT('AppIdList'))
				SET	@retVal = @@ERROR
				IF	@retVal != 0 GOTO CX_EXIT
				DECLARE @tblTempResultDiff table(retVal int)
				INSERT @tblTempResultDiff
				EXEC AppForceNextBackpAsFullOrDiff 2, @appIdListXmlDiff, '8' --CV_CLEAR_ARCHIVE_AUXCOPY_JOBCOPY
				SET @retVal = @@ERROR
				IF @retVal = 0
					SELECT @retVal = retVal FROM @tblTempResultDiff
				IF @retVal != 0 GOTO CX_EXIT
			END
		END
		---------------------------------
		--CREATE GUI AUDIT TRAIL ENTRIES
		---------------------------------
		SET		@SpCopyListCursorFlag = 1
		OPEN	SpCopyListCursor
		SET	@retVal	=	@@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM SpCopyListCursor
		INTO	@curArchGrpId, @curArchGrpCopyId
		SET	@retVal	=	@@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			IF EXISTS (SELECT * FROM #ToBeAgedJob WHERE archGrpCopyId = @curArchGrpCopyId)
			BEGIN
				-- Set Gui Audit Operation
SET @opMsgId = (19 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17, @curArchGrpId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- Set Gui Audit Parameter - Storage Policy Name
				SELECT @GUISPName = name FROM archGroup WITH (NOLOCK) WHERE Id = @curArchGrpId
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @GUISPName, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				-- Set Gui Audit Parameter - Copy Name
				SELECT @GUICopyName = name FROM archGroupCopy WITH (NOLOCK) WHERE Id = @curArchGrpCopyId
SET @paramMsgId = (27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @GUICopyName, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				-- Set Gui Audit Parameter - Job List
				SET @JobList = null
				SELECT @JobList = COALESCE(@JobList + ',', '') + CONVERT(VARCHAR(36), T.JobId)
				FROM 		#JobsToPrune T
				WHERE 	T.archGrpCopyId = @curArchGrpCopyId
SET @paramMsgId = (3 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @JobList, 1
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				SELECT @GUIDescription = ISNULL(T.item.value('@description', 'NVARCHAR(256)'), '') FROM	@i_xml.nodes('/GalaxyOperations_PruneJobs') T(item)
SET @paramMsgId = (1622 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @GUIDescription, 1
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				SET	@retVal	=	@@ERROR
				IF	@retVal != 0 GOTO CX_EXIT
				IF DATALENGTH( @prunedJobIdList) > 0
					SET @prunedJobIdList = CONCAT ( @prunedJobIdList , ', ')
			        SET @prunedJobIdList = CONCAT ( @prunedJobIdList,'JobIdList [', @JobList , '] Storage Policy Name - [',@GUISPName,'] Copy Name [',@GUICopyName,'(',@curArchGrpCopyId,')] ' )
				-- Set Archiver jobs deleted audit
				IF EXISTS
				(
					SELECT 1
					FROM #JobsToPrune t INNER JOIN JMBkpStats JS WITH (READUNCOMMITTED)
						ON t.jobId = JS.jobId AND t.commCellId = JS.commCellId
						INNER JOIN APP_IDATypeHandlingInfo IDT WITH (READUNCOMMITTED)
						ON IDT.AppTypeId = JS.AppType
					WHERE IDT.isDMAppType = 1 AND T.archGrpCopyId = @curArchGrpCopyId
				)
				OR EXISTS
				(
					SELECT 1
					FROM #JobsToPrune t INNER JOIN JMJobDataStats JS WITH (READUNCOMMITTED)
						ON t.jobId = JS.jobId AND t.commCellId = JS.commCellId AND  t.archGrpCopyId= JS.archGrpCopyId
						INNER JOIN App_SubClientProp SCP WITH (READUNCOMMITTED) ON JS.appId = SCP.ComponentNameId
						INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON JS.archGrpCopyId = AGC.id
						--ArchGroup AG WITH (READUNCOMMITTED)
						WHERE SCP.attrName = N'Is Turbo SubClient'
						AND	SCP.cs_attrName = @checkSumIsTurboSC
						AND SCP.attrVal = 1
						AND SCP.created < JS.copiedTime
						AND AGC.isSnapCopy = 0 AND T.archGrpCopyId = @curArchGrpCopyId
						--AND (JS.copyId = AG.defaultCopy OR JS.copyId = AG.defaultSnapCopy)
				)
				BEGIN
					--SET @l_HasArchiverJob = 1
SET @paramMsgId = (1589 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				END
			END
			FETCH	NEXT
			FROM SpCopyListCursor
			INTO	@curArchGrpId, @curArchGrpCopyId
			SET	@retVal	=	@@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
		END
		SET @errorString = @errorString + 'Jobs [' + @prunedJobIdList + '] pruned successfully. ' + char(10)
	END
	ELSE
	BEGIN
		SET @errorString = @errorString + 'No Jobs to prune. ' + char(10)
	END
CX_EXIT:
	IF @retVal = 0
	BEGIN
		--SET @errorString = @errorString + 'Jobs pruned successfully. ' + char(10)
		COMMIT TRANSACTION DELJOBCOPYTRAN
	END
	IF @retVal <> 0
	BEGIN
		SET @errorString = @errorString + 'Failed to prune the Jobs. ' + char(10)
		ROLLBACK TRANSACTION DELJOBCOPYTRAN
	END
	if object_id('tempdb.dbo.#JobsToPrune') is not null DROP TABLE #JobsToPrune
	if object_id('tempdb.dbo.#ToBeAgedJob') is not null DROP TABLE #ToBeAgedJob
	IF OBJECT_ID('tempdb.dbo.#JobsSelectedForCopyByAuxCopyJob') IS NOT NULL DROP TABLE  #JobsSelectedForCopyByAuxCopyJob
	IF @SpCopyListCursorFlag = 1
	BEGIN
		CLOSE				SpCopyListCursor
		DEALLOCATE	SpCopyListCursor
	END
	if object_id('tempdb.dbo.#tmpRetVal') is not null
	BEGIN
		INSERT INTO #tmpRetVal
		SELECT @retVal, @errorString, @skippedCode, @prunedJobIdList
	END
	ELSE
	BEGIN
		SELECT @retVal, @errorString, @skippedCode, @prunedJobIdList
	END
	RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'deleteMultipleBackupByJobCopy')
	delete from GxQscripts where name = 'deleteMultipleBackupByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteMultipleBackupByJobCopy')
	delete from GXDBVersions where aliasname = 'deleteMultipleBackupByJobCopy'
GO

insert into GXDBVersions values(2, 'deleteMultipleBackupByJobCopy',  '00010024000200170000', 'deleteMultipleBackupByJobCopy', '00010024000200170000')
GO

