

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/deleteBackupByJobsOnAllCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/deleteBackupByJobsOnAllCopy.sp,v $ $Id: deleteBackupByJobsOnAllCopy.sp,v 1.11.2.3 2019/12/21 21:47:02 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='deleteBackupByJobsOnAllCopy')
BEGIN
	print '>>> Drop Stored Procedure: deleteBackupByJobsOnAllCopy <<<'
	drop procedure deleteBackupByJobsOnAllCopy
END
IF EXISTS (select * from GxQscripts where name='deleteBackupByJobsOnAllCopy')
	delete from GxQscripts where name = 'deleteBackupByJobsOnAllCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteBackupByJobsOnAllCopy')
	delete from GXDBVersions where aliasname = 'deleteBackupByJobsOnAllCopy'
GO
print '... Creating Procedure: deleteBackupByJobsOnAllCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure deleteBackupByJobsOnAllCopy
  @i_jobList xml
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE		@retCode 	INT
DECLARE		@l_now 		INT
SET 			@l_now 		= dbo.GetUnixTime(GETUTCDATE())
-- This temp table will hold the jobs to be pruned
if object_id('tempdb.dbo.#pruneJobs') is not null DROP TABLE #pruneJobs
if object_id('tempdb.dbo.#ToBeAgedJob') is not null DROP TABLE #ToBeAgedJob
CREATE TABLE #pruneJobs
(
	jobId int,
	commCellId int,
	archGroupId int
)
-- This temp table must be created and populated before calling stored procedure archSetJobsAgedViaTable
CREATE TABLE #ToBeAgedJob
(
	jobId INT,
	archGrpId INT,
	archGrpCopyId INT,
	dataType INT,
	commCellId INT,
	status INT,
	disabled INT,
	archCheckStatus INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId)
)
INSERT 	INTO #pruneJobs
SELECT 	T.jobs.value('@jobId','int'),
	   		T.jobs.value('@commCellId','int'),
	   		T.jobs.value('@archGroupId','int')
FROM   	@i_jobList.nodes('/Job') T(jobs)
SET @retCode = 	@@ERROR
IF 	@retCode !=	0 GOTO CX_EXIT
-- Get the jobs on all copies
INSERT	INTO #ToBeAgedJob
SELECT	JDS.jobId, JDS.archGrpId, JDS.archGrpCopyId, JDS.dataType, JDS.commCellId, JDS.status, JDS.disabled, JDS.archCheckStatus
FROM		JMJobDataStats JDS, #pruneJobs TEMP
WHERE		JDS.jobId = TEMP.jobId
AND 		JDS.commCellId = TEMP.commCellId
AND 		JDS.archGrpId = TEMP.archGroupId
SET @retCode = 	@@ERROR
IF 	@retCode !=	0 GOTO CX_EXIT
--Do not prune the manually retained jobs
DELETE #ToBeAgedJob
WHERE disabled & 2 <> 0
SET @retCode = 	@@ERROR
IF 	@retCode !=	0 GOTO CX_EXIT
IF	EXISTS (SELECT id FROM archGroupCopy WITH (NOLOCK)
WHERE  id IN (SELECT DISTINCT archGrpCopyId FROM #ToBeAgedJob) AND (flags & 16777216) <> 0)
BEGIN
SET	@retCode = 92
	GOTO CX_EXIT
END
-- DO NOT PRUNE any to be copied jobs when offline content indexing or media refresh jobs are running for the storage policy or copy.
-- 57-ONLINECONTENTINDEX, 74-MEDIAREFRESHING
DECLARE	@tblOpType TABLE (opType INT)
INSERT	INTO @tblOpType
SELECT	opType
FROM	TM_JobOptions A WITH (NOLOCK), JMAdminJobInfoTable B WITH (NOLOCK),
		(SELECT DISTINCT archGroupId FROM #pruneJobs) C
WHERE	A.jobId = B.jobId
		AND B.opType IN (53, 57, 74)
AND A.optionId = 140008 AND A.value = CAST(C.archGroupId AS CHAR(10))
IF	EXISTS (SELECT * FROM archContentIndexingRules WITH (NOLOCK)
				WHERE	archGroupId IN (SELECT DISTINCT archGroupId FROM #pruneJobs))
	AND	EXISTS (SELECT * FROM archFile AF WITH (NOLOCK), #pruneJobs T
				WHERE	AF.jobId = T.jobId AND AF.commCellId = T.commCellId
AND (AF.flags & (16|32)) <> 0)
OR	EXISTS (SELECT * FROM @tblOpType WHERE opType = 74)
BEGIN
SET	@retCode = 92
	GOTO CX_EXIT
END
IF	EXISTS (SELECT * FROM #ToBeAgedJob)
BEGIN
EXEC @retCode = archSetJobsAgedViaTable 1024, @l_now
END
CX_EXIT:
	if object_id('tempdb.dbo.#pruneJobs') is not null DROP TABLE #pruneJobs
	if object_id('tempdb.dbo.#ToBeAgedJob') is not null DROP TABLE #ToBeAgedJob
	SET	@retVal = @retCode
	SELECT	@retVal
	RETURN	@retVal
GO

IF EXISTS (select * from GxQscripts where name = 'deleteBackupByJobsOnAllCopy')
	delete from GxQscripts where name = 'deleteBackupByJobsOnAllCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteBackupByJobsOnAllCopy')
	delete from GXDBVersions where aliasname = 'deleteBackupByJobsOnAllCopy'
GO

insert into GXDBVersions values(2, 'deleteBackupByJobsOnAllCopy',  '00010011000200030000', 'deleteBackupByJobsOnAllCopy', '00010011000200030000')
GO

