

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/deleteBackupByJobCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/deleteBackupByJobCopy.sp,v $ $Id: deleteBackupByJobCopy.sp,v 1.92.2.5 2019/12/21 21:47:11 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='deleteBackupByJobCopy')
BEGIN
	print '>>> Drop Stored Procedure: deleteBackupByJobCopy <<<'
	drop procedure deleteBackupByJobCopy
END
IF EXISTS (select * from GxQscripts where name='deleteBackupByJobCopy')
	delete from GxQscripts where name = 'deleteBackupByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteBackupByJobCopy')
	delete from GXDBVersions where aliasname = 'deleteBackupByJobCopy'
GO
print '... Creating Procedure: deleteBackupByJobCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure deleteBackupByJobCopy
  @i_jobId INTEGER,
  @i_commCellId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@retVal = 0
DECLARE	@RetainDDBBkpsOfSealedStores	INTEGER
SET			@RetainDDBBkpsOfSealedStores	= 0
DECLARE @tblCopy TABLE (
	archGroupId 	INT,
	archCopyId		INT,
	primaryCopyId INT,
	sourceCopyId	INT,
	isSnapCopy		INT,
	isMirrorCopy	INT
)
if object_id('tempdb.dbo.#ReqDDBBackupJobs') is not null DROP TABLE #ReqDDBBackupJobs
CREATE	TABLE #ReqDDBBackupJobs (
		SIDBStoreId			INTEGER,
		SubStoreId			INTEGER,
		commCellId			INTEGER,
		JobId						INTEGER,
		JobCommCellId		INTEGER,
		)
CREATE INDEX Idx_ReqDDBBackupJobs_1 ON #ReqDDBBackupJobs (SIDBStoreId, SubStoreId, CommCellId)
CREATE INDEX Idx_ReqDDBBackupJobs_2 ON #ReqDDBBackupJobs (JobId, JobCommCellId)
DECLARE	@l_archGroupId	INT = 0
DECLARE	@l_copyFlags	INT = 0
DECLARE	@MatSrcCopyId INT
DECLARE	@defaultCopyId INT
SELECT	@l_archGroupId = archGroupId, @l_copyFlags = flags
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
SELECT @defaultCopyId = defaultCopy
FROM	archGroup WITH (NOLOCK)
WHERE	id = @l_archGroupId
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
SELECT @MatSrcCopyId = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
FROM	archGroup a WITH (NOLOCK), archMaterializeSnapshotProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
WHERE	a.id = @l_archGroupId
AND		a.id = b.archGroupId
AND		b.archGroupId = c.archGroupId
AND		c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
AND		c.isSnapCopy > 0
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
-- Set Materialization Source Copy as source of Mirror copy, if materialization Source Copy is Mirror Copy
WHILE EXISTS(SELECT AGC.id FROM archGroupCopy AGC WITH (NOLOCK) WHERE AGC.id = @MatSrcCopyId AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
BEGIN
	SELECT @MatSrcCopyId = (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AGC.id = @MatSrcCopyId
	AND		AGC.archGroupId = AG.id
	AND		AGC.isSnapCopy > 0
	AND		AGC.isMirrorCopy > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
END
IF	(@l_copyFlags & 16777216) <> 0
BEGIN
SET @retVal = 92
	GOTO CX_EXIT
END
SELECT @RetainDDBBkpsOfSealedStores = isnull(value, 0)
FROM mmconfigs
WHERE name = 'DA_CONFIG_RETAIN_DDB_BACKUPS_OF_SEALED_STORES'
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
DECLARE @DDBBkpsToRetain INT = 0
DECLARE @prevDDBBkpsRetained INT = 0
DECLARE @err INT = 0
SET @DDBBkpsToRetain = (SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_RETAIN_NO_OF_DDB_BACKUPS')
IF @DDBBkpsToRetain > 1
BEGIN
    -- T.rn >= @DDBBkpsToRetain because we maintain old backup info in IdxSIDBSubStoreBackupInfo and latest in IdxSIDBSubStore table
    -- Delete the old DDB Backups
    DELETE I
    FROM IdxSIDBSubStoreBackupInfo I,
		(SELECT SIDBStoreId, SubStoreId, LastSnapJobId, ROW_NUMBER() OVER(PARTITION BY SIDBStoreId, SubStoreId ORDER BY LastSnapTime DESC) AS rn
		FROM IdxSIDBSubStoreBackupInfo WITH (READUNCOMMITTED)
		) T
    WHERE I.SIDBStoreId = T.SIDBStoreId
	AND I.SubStoreId = T.SubStoreId
	AND I.LastSnapJobId = T.LastSnapJobId
	AND T.rn >= @DDBBkpsToRetain
    SET	@err	=	@@ERROR
END
ELSE
BEGIN
    DELETE FROM IdxSIDBSubStoreBackupInfo
END
SET @retVal = @err
IF	@retVal != 0 GOTO CX_EXIT
--DO NOT Prune DDB Backup jobs
INSERT INTO #ReqDDBBackupJobs
SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, CASE WHEN C.id IS NULL THEN SS.commCellId ELSE C.id END
FROM IdxSIDBSubStore SS WITH (NOLOCK)
INNER JOIN IdxSIDBStore S WITH (NOLOCK)
	ON 	SS.SIDBStoreId = S.SIDBStoreId
	AND	SS.commCellId = S.commCellId
LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK)
ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
WHERE	SS.LastSnapJobId > 0
AND	(S.flags & 256) = 0
AND		SS.LastSnapJobId = @i_jobId
AND 	(CASE WHEN C.id IS NULL THEN SS.commCellId ELSE C.id END) = @i_commCellId
AND		(	(@RetainDDBBkpsOfSealedStores = 1)
				OR
				(@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0)
			)
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
INSERT INTO #ReqDDBBackupJobs
SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, CASE WHEN C.id IS NULL THEN SS.commCellId ELSE C.id END
FROM IdxSIDBSubStoreBackupInfo SS WITH (NOLOCK)
INNER JOIN IdxSIDBStore S WITH (NOLOCK)
	ON 	SS.SIDBStoreId = S.SIDBStoreId
	AND	SS.commCellId = S.commCellId
LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK)
ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
WHERE	SS.LastSnapJobId > 0
AND	(S.flags & 256) = 0
AND		SS.LastSnapJobId = @i_jobId
AND 	(CASE WHEN C.id IS NULL THEN SS.commCellId ELSE C.id END) = @i_commCellId
AND		(	(@RetainDDBBkpsOfSealedStores = 1)
				OR
				(@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0)
			)
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
IF EXISTS (SELECT JobId, JobCommCellId FROM #ReqDDBBackupJobs WHERE JobId = @i_jobId AND JobCommCellId = @i_commCellId)
BEGIN
SET @retVal = 110
	GOTO CX_EXIT
END
INSERT INTO @tblCopy
SELECT AG.id, AGC.id, (CASE AGC.isSnapCopy WHEN 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END), AGC.sourceCopyId, AGC.isSnapCopy, AGC.isMirrorCopy
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = @l_archGroupId
AND		AG.id = AGC.archGroupId
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
-- The source copy will be source of Mirror copy if source copy is Mirror Copy
WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
BEGIN
	UPDATE	@tblCopy
	SET 	sourceCopyId = AGC.sourceCopyId
	FROM	@tblCopy T, archGroupCopy AGC WITH (NOLOCK)
	WHERE	T.sourceCopyId = AGC.id
	AND		AGC.isSnapCopy > 0
	AND		AGC.isMirrorCopy > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
END
-- The source copy will be primary copy if source copy is not defined
UPDATE	@tblCopy
SET 	sourceCopyId = primaryCopyId
WHERE	sourceCopyId = 0
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
-- DO NOT PRUNE any to be copied jobs when offline content indexing or media refresh jobs are running for the storage policy or copy.
-- 53-OFFLINECONTENTINDEX, 57-ONLINECONTENTINDEX, 74-MEDIAREFRESHING, 60-SNAPTOTAPE
DECLARE	@tblOpType TABLE (opType INT)
INSERT	INTO @tblOpType
SELECT	DISTINCT B.opType
FROM	JMAdminJobInfoTable B WITH (NOLOCK)
WHERE	B.opType IN (53, 57, 74)
AND 	B.commCellId = @i_commCellId
AND 	EXISTS
			(
				SELECT 	A.optionId
				FROM 		dbo.GetAllJobOptions(B.JobId) A
WHERE 	A.optionId = 140008 AND A.value = CAST(@l_archGroupId AS CHAR(10))
				  			OR
A.optionId = 140008 AND B.opType = 74 AND A.value = (SELECT CAST(AG.id AS CHAR(10)) FROM archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK) WHERE AGC.id = @i_copyId AND AG.defaultCopy = AGC.destMediaCopyId AND AGC.destMediaCopyId > 0)
	  						OR
A.optionId = 140009 AND A.value = CAST(@i_copyId AS CHAR(10))
                OR
A.optionId = 140009 AND B.opType = 74 AND A.value = (SELECT CAST(destMediaCopyId AS CHAR(10)) FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId AND destMediaCopyId > 0)
	  						OR
(A.optionId = 229570007 AND A.value IN (SELECT CAST(SIDBStoreId AS CHAR(12)) FROM archCopySIDBStore WHERE CopyId = @i_copyId))
	  	)
IF	EXISTS (SELECT * FROM @tblOpType WHERE opType IN (53, 57))
		AND EXISTS (SELECT * FROM archContentIndexingRules WITH (NOLOCK)
									WHERE	archGroupId = @l_archGroupId
									AND 	(CASE WHEN sourceCopyId = 0 THEN @defaultCopyId ELSE sourceCopyId END) = @i_copyId
								)
		AND	EXISTS (SELECT * FROM archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
									WHERE	AF.jobId = @i_jobId
									AND 	AF.commCellId = @i_commCellId
									AND		AF.id = AFC.archFileId
									AND		AF.commCellId = AFC.commCellId
									AND 	AFC.archCopyId = @i_copyId
AND 	(AFC.flags & 256) = 0
AND 	(AF.flags & (16|32)) <> 0)
		OR	EXISTS (SELECT * FROM @tblOpType WHERE opType = 74)
		AND	EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
									WHERE	jobId = @i_jobId
									AND 	commCellId = @i_commCellId
									AND 	archGrpCopyId = @i_copyId
AND 	(disabled & 256) = 0
								)
BEGIN
SET @retVal = 98
	GOTO CX_EXIT
END
-- Do Not delete job if snap-to-tape or deferred cataloging job is running for that job.
IF		EXISTS (SELECT	*
				FROM	JMJobWF JW WITH (NOLOCK), JMJobInfo JI WITH (NOLOCK)
				WHERE	JW.processedJobId = @i_jobId
						AND JW.processedCommcellId = @i_commCellId
						AND @i_copyId = @MatSrcCopyId
						AND JW.childJobId = JI.jobId
						AND JW.commcellId = JI.commCellId
				)
BEGIN
SET @retVal = 112
	GOTO CX_EXIT
END
DECLARE	@retCode 	INT
DECLARE	@l_now 		INT
SET 		@l_now 		= dbo.GetUnixTime(GETUTCDATE())
-- This temp table must be created and populated before calling stored procedure archSetJobsAgedViaTable
CREATE TABLE #ToBeAgedJob (
	jobId 					INT,
	archGrpId 			INT,
	archGrpCopyId 	INT,
	dataType 				INT,
	commCellId 			INT,
	status 					INT,
	disabled 				INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId)
)
-- DO NOT PRUNE any jobs for SILO AppId
INSERT	INTO #ToBeAgedJob
SELECT	jobId, archGrpId, archGrpCopyId, dataType, commCellId, status, disabled
FROM	JMJobDataStats WITH (NOLOCK)
WHERE	jobId = @i_jobId
AND 	archGrpCopyId = @i_copyId
AND 	commCellId = @i_commCellId
AND		appId NOT IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
-- DO NOT PRUNE any jobs on MIRROR Copy
DELETE #ToBeAgedJob
FROM	#ToBeAgedJob T, archGroupCopy AGC WITH (NOLOCK)
WHERE	T.archGrpCopyId = AGC.id
AND 	AGC.isSnapCopy > 0
AND 	AGC.isMirrorCopy > 0
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
-- PRUNE jobs on Mirror Copy if the copy is source of Mirror Snap Copy
INSERT	INTO #ToBeAgedJob
SELECT	JDS.jobId, JDS.archGrpId, JDS.archGrpCopyId, JDS.dataType, JDS.commCellId, JDS.status, JDS.disabled
FROM	JMJobDataStats JDS WITH (NOLOCK), @tblCopy T
WHERE	JDS.jobId = @i_jobId
AND 	JDS.commCellId = @i_commCellId
AND 	JDS.archGrpCopyId = T.archCopyId
AND		T.sourceCopyId = @i_copyId
AND 	T.isSnapCopy > 0
AND 	T.isMirrorCopy > 0
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
IF	EXISTS (SELECT * FROM #ToBeAgedJob) AND
NOT EXISTS (SELECT * FROM #ToBeAgedJob WHERE disabled & 2 <> 0)
BEGIN
EXEC @retCode = archSetJobsAgedViaTable 1024, @l_now
	SET	@retVal = @@ERROR
	IF	@retVal = 0 SET @retVal = @retCode
	IF	@retVal = 0
	BEGIN
		EXEC @retCode = archDisallowJobForCopy @i_jobId, @i_commCellId, @i_copyId, @l_now
		SET	@retVal = @@ERROR
		IF	@retVal = 0 SET @retVal = @retCode
	END
END
CX_EXIT:
	-- Added condition to insert value into temp table, if this stored procedure called for pruning volume reconciliation dangled jobs
	if OBJECT_ID('tempdb.dbo.#TblDeleteBackupByJobCopyResult') IS NOT NULL
		INSERT INTO #TblDeleteBackupByJobCopyResult	SELECT @retVal
	ELSE
		SELECT	@retVal
	if object_id('tempdb.dbo.#ToBeAgedJob') is not null DROP TABLE #ToBeAgedJob
	if object_id('tempdb.dbo.#ReqDDBBackupJobs') is not null DROP TABLE #ReqDDBBackupJobs
	RETURN	@retVal
GO

IF EXISTS (select * from GxQscripts where name = 'deleteBackupByJobCopy')
	delete from GxQscripts where name = 'deleteBackupByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteBackupByJobCopy')
	delete from GXDBVersions where aliasname = 'deleteBackupByJobCopy'
GO

insert into GXDBVersions values(2, 'deleteBackupByJobCopy',  '00010092000200050000', 'deleteBackupByJobCopy', '00010092000200050000')
GO

