

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/deleteBackupByAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/deleteBackupByAppId.sp,v $ $Id: deleteBackupByAppId.sp,v 1.75.56.4 2020/09/17 01:35:59 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='deleteBackupByAppId')
BEGIN
	print '>>> Drop Stored Procedure: deleteBackupByAppId <<<'
	drop procedure deleteBackupByAppId
END
IF EXISTS (select * from GxQscripts where name='deleteBackupByAppId')
	delete from GxQscripts where name = 'deleteBackupByAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteBackupByAppId')
	delete from GXDBVersions where aliasname = 'deleteBackupByAppId'
GO
print '... Creating Procedure: deleteBackupByAppId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure deleteBackupByAppId
  @i_appId INTEGER
AS
  DECLARE @retVal INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT, afcFlags INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
BEGIN TRY
	DECLARE	@CurrDateTime	DATETIME
	DECLARE	@CurrentTime	INT
	DECLARE	@magneticBytes	BIGINT
	SET	@CurrDateTime	= GetUTCDate()
	SET	@CurrentTime	= dbo.GetUnixTime(@CurrDateTime)
	INSERT	INTO #ToBeAgedAFC
	SELECT	a.archFileId, a.commCellId, a.archCopyId, a.flags
	FROM	archFileCopy a WITH (NOLOCK), archFile b WITH (NOLOCK)
	WHERE	a.archFileId = b.Id AND a.commCellId = b.commCellId AND b.appId = @i_appId
	IF	EXISTS (SELECT	id FROM archGroupCopy WITH (NOLOCK)
WHERE	id IN (SELECT DISTINCT archCopyId FROM #ToBeAgedAFC WHERE (afcFlags & 256) = 0)
AND (flags & 16777216) <> 0)
	BEGIN
SET	@retVal = 92
		GOTO FINISH
	END
	-- Check if any snap of this subclient is still mounted
	IF	EXISTS (SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE isSnapCopy = 1
				AND id IN (SELECT DISTINCT archCopyId FROM #ToBeAgedAFC))
	BEGIN
		IF	EXISTS (SELECT T.archCopyId FROM SMSnapResource R WITH (NOLOCK),
					SMVolume V WITH (NOLOCK), #ToBeAgedAFC T
					WHERE R.SMVolumeId = V.SMVolumeId
					AND V.ArchFileId = T.ArchFileId
					AND V.CommCellId = T.CommCellId
					AND V.CopyId = T.archCopyId)
		BEGIN
SET	@retVal = 85
			GOTO FINISH
		END
	END
	EXEC	@retVal = archFileDeleteViaTable 0, @magneticBytes OUTPUT
	IF @retVal <> 0 GOTO FINISH
	--Delete archive files from archVSAAppAFLink table before deleting from archFile table
	DELETE	archVSAAppAFLink
	FROM	archFile AF WITH (NOLOCK), archVSAAppAFLink AFL
	WHERE	AF.id = AFL.childAFId
	AND 	AF.commCellId = AFL.commCellId
	AND		AF.appId = @i_appId
	DELETE	archVSAAppAFLink
	FROM	archFile AF WITH (NOLOCK), archVSAAppAFLink AFL
	WHERE	AF.id = AFL.ParentIndexAFId
	AND 	AF.commCellId = AFL.commCellId
	AND		AF.appId = @i_appId
	DELETE	archFile WITH(PAGLOCK)
	WHERE	appId = @i_appId
	--Delete archFailedKilledJobInfo table entries when appId is DELETED
	DELETE archFailedKilledJobInfo WITH (PAGLOCK)
	WHERE	appId = @i_appId
	-- do not delete the backup jobs. Just update the mediaDeletedTime so that qnet has a chance
	-- to sync up this job with qnet server
	UPDATE JMJobSnapshotStats
SET 	disabled = (disabled | 1)
	WHERE	appId = @i_appId
	AND 	materializationStatus IN (101, 102, 103)
AND 	(disabled & 1) = 0
	UPDATE	JMJobDataStats WITH(PAGLOCK)
SET		status = 1000, disabled = (disabled | 256), agedBy = (agedBy | 1048576),
			agedTime = @CurrentTime, mediaDeletedTime = @CurrentTime, modifiedTime = @CurrentTime
	WHERE	appId = @i_appId AND mediaDeletedTime = 0
	UPDATE	JMBkpStats WITH(PAGLOCK)
	SET		dataStatus = 2, agedTime = @CurrentTime, mediaDeletedTime = @CurrentTime, modifiedTime = @CurrentTime
	WHERE	appId = @i_appId AND mediaDeletedTime = 0
	DELETE	archPipeConfig
	WHERE	appNumber = @i_appId
	DELETE	archCopyToApp
	WHERE	subClientId = @i_appId
	DELETE	archContentIndexingApp
	WHERE	subClientId = @i_appId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = (SELECT ERROR_NUMBER())
	/*
	Before doing any write operations check if there is an uncommittable transaction state.
	Otherwise this will throw an exception - 'The current transaction cannot be committed and
	cannot support operations that write to the log file.' and mask the actual error that caused us to be in catch
	*/
	IF(XACT_STATE() != -1)
	BEGIN
		IF OBJECT_ID('tempdb..#ToBeAgedAFC') IS NOT NULL
			DROP TABLE #ToBeAgedAFC
	END
	;THROW
END CATCH
FINISH:
    IF OBJECT_ID('tempdb..#ToBeAgedAFC') IS NOT NULL
		    DROP TABLE #ToBeAgedAFC
SELECT	@retVal
RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'deleteBackupByAppId')
	delete from GxQscripts where name = 'deleteBackupByAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteBackupByAppId')
	delete from GXDBVersions where aliasname = 'deleteBackupByAppId'
GO

insert into GXDBVersions values(2, 'deleteBackupByAppId',  '00010075005600040000', 'deleteBackupByAppId', '00010075005600040000')
GO

