

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/deleteArchFile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/deleteArchFile.sp,v $ $Id: deleteArchFile.sp,v 1.41.66.2 2018/03/22 01:08:40 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: deleteArchFile <<<'

IF EXISTS (select * from sysobjects where name='deleteArchFile')
	drop procedure deleteArchFile
IF EXISTS (select * from GxQscripts where name='deleteArchFile')
	delete from GxQscripts where name = 'deleteArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteArchFile')
	delete from GXDBVersions where aliasname = 'deleteArchFile'
GO
print '... Creating Procedure: deleteArchFile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure deleteArchFile
  @i_archFileId INTEGER,
  @i_commCellId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_jobId		INT
DECLARE @l_fileType		INT
DECLARE @l_archGroupId	INT
DECLARE @l_now			INT
DECLARE @l_dateTime		DATETIME
DECLARE	@magneticBytes	bigint
SET	@l_dateTime = GetUTCDate()
SET @l_now = dbo.GetUnixTime(@l_dateTime)
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
BEGIN TRANSACTION
SELECT	@l_jobId = jobId, @l_fileType = fileType, @l_archGroupId = archGroupId
FROM	archFile WITH (NOLOCK)
WHERE	id = @i_archFileId AND commCellId = @i_commCellId
IF	@@ERROR <> 0 OR @@ROWCOUNT = 0 GOTO FINISH
INSERT	INTO #ToBeAgedAFC
SELECT 	archFileId, commCellId, archCopyId
FROM 	archFileCopy WITH (NOLOCK)
WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
IF	@@ERROR <> 0 OR @@ROWCOUNT = 0 GOTO FINISH
EXEC @retVal = archFileDeleteViaTable 0, @magneticBytes OUTPUT
IF	@@ERROR <> 0 OR @retVal <> 0 GOTO FINISH
IF	NOT EXISTS (
	SELECT * FROM archFile WITH (NOLOCK)
	WHERE	jobId = @l_jobId AND commCellId = @i_commCellId
		AND fileType = @l_fileType AND archGroupId = @l_archGroupId
		AND id <> @i_archFileId)
BEGIN
	UPDATE	JMJobDataStats
SET		status = 1000, disabled = (disabled | 256), agedBy = (agedBy | 2048),
			mediaDeletedTime = @l_now, modifiedTime = @l_now
	WHERE	jobId = @l_jobId AND commCellId = @i_commCellId
		AND dataType = @l_fileType AND archGrpId = @l_archGroupId
	IF	@@ERROR <> 0 GOTO FINISH
END
	COMMIT	TRANSACTION
	SELECT	0
	RETURN
FINISH:
	ROLLBACK TRANSACTION
	SELECT	-1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'deleteArchFile')
	delete from GxQscripts where name = 'deleteArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteArchFile')
	delete from GXDBVersions where aliasname = 'deleteArchFile'
GO

insert into GXDBVersions values(2, 'deleteArchFile',  '00010041006600020000', 'deleteArchFile', '00010041006600020000')
GO

