

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daUpdateProcessedAppCopyList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daUpdateProcessedAppCopyList.sp,v $ $Id: daUpdateProcessedAppCopyList.sp,v 1.7.56.2 2018/12/27 16:44:30 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daUpdateProcessedAppCopyList()
--  |
--  | Description:  Mark the list as PROCESSED
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daUpdateProcessedAppCopyList')
BEGIN
	print '>>> Drop Stored Procedure: daUpdateProcessedAppCopyList <<<'
	drop procedure daUpdateProcessedAppCopyList
END
IF EXISTS (select * from GxQscripts where name='daUpdateProcessedAppCopyList')
	delete from GxQscripts where name = 'daUpdateProcessedAppCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daUpdateProcessedAppCopyList')
	delete from GXDBVersions where aliasname = 'daUpdateProcessedAppCopyList'
GO
print '... Creating Procedure: daUpdateProcessedAppCopyList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daUpdateProcessedAppCopyList
  @appSqlFlag INTEGER,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @currentTime 	INTEGER
	SET     @currentTime 	= dbo.GetUnixTime(GETUTCDATE())
	if object_id('tempdb.dbo.#tblAppCopyListBasicRet') is not null DROP TABLE #tblAppCopyListBasicRet
	CREATE TABLE #tblAppCopyListBasicRet (
			appId int,
			copyId int,
			fileType int,
			AgeTimeBasicRet int
			Primary key (appId, copyId, fileType)
			)
	if object_id('tempdb.dbo.#tblAppCopyListBasicDays') is not null DROP TABLE #tblAppCopyListBasicDays
	CREATE TABLE #tblAppCopyListBasicDays (
			appId int,
			copyId int,
			fileType int,
			AgeTimeByDays int
			Primary key (appId, copyId, fileType)
			)
	if object_id('tempdb.dbo.#tblAppCopyListBasicCycles') is not null DROP TABLE #tblAppCopyListBasicCycles
	CREATE TABLE #tblAppCopyListBasicCycles (
			appId int,
			copyId int,
			fileType int,
			AgeTimeByCycles int
			Primary key (appId, copyId, fileType)
			)
	-------------------------------------------------------------------------------
	-- All entries in #DA_JobCopyList with jobRetainedReason flag = 0
	-- are AGED jobs and eligible for pruning
	-- SQL Data will be marked with AGESTATUS_SQLTOBECHAINED flag and will
	-- be processed later
	-------------------------------------------------------------------------------
	-- Calculate the AgeTimeBasicRet for each copy
	INSERT	INTO #tblAppCopyListBasicRet
	SELECT	a.AppId, a.CopyId, a.FileType, MIN(a.StartTime)
	FROM #DA_JobCopyList a, JMJobDataStats JDS WITH (NOLOCK)
	WHERE a.jobId = JDS.jobId
	AND		a.commCellId = JDS.commCellId
	AND		a.CopyId = JDS.archGrpCopyId
	AND		(
					(a.fileType IN (0, 1) AND JDS.dataType = 1)
					OR
					(a.fileType = 4 AND JDS.dataType = 4)
				)
AND		a.jobRetainReason & (2 | 16 | 32 | 4194304 |
1024 | 2048 | 134217728) > 0
	AND  	a.OnLinkedSP = 0
	AND		((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0))
	GROUP BY a.AppId, a.CopyId, a.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #DA_AppCopyList
	SET AgeTimeBasicRet = b.AgeTimeBasicRet
	FROM  #DA_AppCopyList a, #tblAppCopyListBasicRet b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set the AgeTimeBasicRet to current time if all jobs are prunable by basic retention
	UPDATE 	#DA_AppCopyList
	SET 		AgeTimeBasicRet = @currentTime
	WHERE 	AgeTimeBasicRet = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate the AgeTimeByDays for each copy
	INSERT	INTO #tblAppCopyListBasicDays
	SELECT	a.AppId, a.CopyId, a.FileType, MIN(a.StartTime)
	FROM #DA_JobCopyList a
WHERE jobRetainReason & (16 | 2048) > 0
	AND 	a.OnLinkedSP = 0
	AND		((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0))
	GROUP BY a.AppId, a.CopyId, a.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #DA_AppCopyList
	SET AgeTimeByDays = b.AgeTimeByDays
	FROM  #DA_AppCopyList a, #tblAppCopyListBasicDays b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set the AgeTimeByDays to current time if all jobs are prunable by basic days
	UPDATE 	#DA_AppCopyList
	SET 		AgeTimeByDays = @currentTime
	WHERE 	AgeTimeByDays = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT	INTO #tblAppCopyListBasicCycles
	SELECT	a.AppId, a.CopyId, a.FileType, MIN(a.StartTime)
	FROM #DA_JobCopyList a, JMJobDataStats JDS WITH (NOLOCK)
	WHERE a.jobId = JDS.jobId
	AND		a.commCellId = JDS.commCellId
	AND		a.CopyId = JDS.archGrpCopyId
	AND		a.fileType IN (0, 1)
	AND 	JDS.dataType = 1
AND 	a.jobRetainReason & (32 | 1024 | 2048 | 134217728) > 0
	AND 	a.OnLinkedSP = 0
	AND		((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0))
	GROUP BY a.AppId, a.CopyId, a.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #DA_AppCopyList
	SET AgeTimeByCycles = b.AgeTimeByCycles
	FROM  #DA_AppCopyList a, #tblAppCopyListBasicCycles b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set the AgeTimeByCycles to current time if all jobs are prunable by basic cycles
	UPDATE 	#DA_AppCopyList
	SET 		AgeTimeByCycles = @currentTime
	WHERE 	AgeTimeByCycles = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Mark the selected appId copy as processed
	-- Mark the SQL subclient to be chained and
	-- it will be processed separetely
	-------------------------------------------------------------------------------
	-- Mark all selected Subclient on Copy as Processed
	UPDATE	#DA_AppCopyList
SET 	AgeStatus = 6
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Do not age SQL subclients, mark them to be chained
	UPDATE	#DA_AppCopyList
SET 	AgeStatus = 3
	WHERE	@appSqlFlag > 0
	AND		DoNotAge = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update aging results, some columns are updated for log aging
UPDATE	ArchAppCopyToBeAged
	SET 	AgeStatus = b.AgeStatus,
				DoNotAge = b.DoNotAge,
				AgeTimeBasicRet = b.AgeTimeBasicRet,
				AgeTimeByDays = b.AgeTimeByDays,
				AgeTimeByCycles = b.AgeTimeByCycles
				--StartTimeOldestJob = b.StartTimeOldestJob
FROM	ArchAppCopyToBeAged a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#tblAppCopyListBasicRet') is not null DROP TABLE #tblAppCopyListBasicRet
	if object_id('tempdb.dbo.#tblAppCopyListBasicDays') is not null DROP TABLE #tblAppCopyListBasicDays
	if object_id('tempdb.dbo.#tblAppCopyListBasicCycles') is not null DROP TABLE #tblAppCopyListBasicCycles
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daUpdateProcessedAppCopyList')
	delete from GxQscripts where name = 'daUpdateProcessedAppCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daUpdateProcessedAppCopyList')
	delete from GXDBVersions where aliasname = 'daUpdateProcessedAppCopyList'
GO

insert into GXDBVersions values(2, 'daUpdateProcessedAppCopyList',  '00010007005600020000', 'daUpdateProcessedAppCopyList', '00010007005600020000')
GO

