

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daUpdateJobHistory.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daUpdateJobHistory()
--  | Description:  Update job histories.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daUpdateJobHistory.sp,v $ $Id: daUpdateJobHistory.sp,v 1.1.276.8 2020/03/19 21:58:21 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daUpdateJobHistory')
BEGIN
	print '>>> Drop Stored Procedure: daUpdateJobHistory <<<'
	drop procedure daUpdateJobHistory
END
IF EXISTS (select * from GxQscripts where name='daUpdateJobHistory')
	delete from GxQscripts where name = 'daUpdateJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daUpdateJobHistory')
	delete from GXDBVersions where aliasname = 'daUpdateJobHistory'
GO
print '... Creating Procedure: daUpdateJobHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure daUpdateJobHistory
  @i_dummy integer
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
/*
	-- Create and populate this table before calling this SP
	CREATE TABLE #tblJobToUpdate
	(
		jobId 			int,
		commCellId 	int,
		primary key (jobId, commCellId)
	)
*/
  DECLARE @ErrorMessage 	NVARCHAR(MAX)
  SET			@ErrorMessage   = ''
	DECLARE @ErrorSeverity INTEGER
	SET			@ErrorSeverity = 0
  DECLARE @ErrorState INTEGER
  SET			@ErrorState = 0
	DECLARE @retVal	INTEGER
	SET 		@retVal = 0
	DECLARE @rowsUpdated	INTEGER
	SET 		@rowsUpdated	= 0
	DECLARE @currentTime INTEGER
	SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
	CREATE TABLE #tblJobAged
	(
			jobId 						int,
			commCellId 				int,
			agedTime 					int,
			mediaDeletedTime	int,
			dataStatus				int,
			isVSAV2Parent			int
			primary key (jobId, commCellId)
	)
	CREATE TABLE #VSAV2ParentJobStatus
	(
		parentJobId 			int,
		commCellId 				int,
		minDataStatus			int,
		maxDataStatus			int,
		agedTime					int,
		mediaDeletedTime	int,
		primary key (parentJobId, commCellId)
	)
	DECLARE @maxRetry INTEGER
	SET @maxRetry = 2
	SELECT @maxRetry = isnull(value, 2)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_NUMBER_OF_RETRY_ON_LOCK'
	DECLARE @retryCnt INTEGER
	SET @retryCnt = 0
	WHILE @retryCnt <= @maxRetry
	BEGIN
		BEGIN TRANSACTION
			BEGIN TRY
			BEGIN
				SET @retVal = 0
				SET	@ErrorMessage = ''
				SET	@ErrorSeverity = 0
				SET	@ErrorState = 0
				SET @rowsUpdated = 0
				-- Compute agedTime for VSA V2 parent jobs
				TRUNCATE TABLE #VSAV2ParentJobStatus
				--VSA V2 Parent job - convert to Job History without Data if VM level job history is still available
				INSERT INTO #VSAV2ParentJobStatus
				SELECT JDL.parentJobId, JDL.commCellId, MIN(JBKP.dataStatus), MAX(JBKP.dataStatus), MAX(JBKP.agedTime), MAX(JBKP.mediaDeletedTime)
				FROM 	#tblJobToUpdate A, JMJobDataLink JDL WITH (NOLOCK), JMBkpStats JBKP WITH (NOLOCK)
				WHERE A.jobId = JDL.parentJobId
				AND 	A.commCellId = JDL.commCellId
				AND		JDL.childJobId = JBKP.jobId
				AND		JDL.commCellId = JBKP.commCellId
AND		JDL.linkType IN (7, 8)
				GROUP BY JDL.parentJobId, JDL.commCellId
				-- Update the status to deleted from media for AGED jobs with NO DATA
				UPDATE	JMJobDataStats
				SET 	status = 1000, mediaDeletedTime = @currentTime
				FROM	#tblJobToUpdate A INNER JOIN JMJobDataStats B
				ON		A.jobId = B.jobId
				AND 	A.commCellId = B.commCellId
				LEFT OUTER JOIN archFile AF WITH (NOLOCK)
				ON		A.jobId = AF.jobId
				AND 	A.commCellId = AF.commCellId
				WHERE AF.jobId IS NULL
				AND		B.status IN (2, 3, 100, 102, 103)
AND		(B.disabled & 256) = 256
				SELECT @rowsUpdated = @rowsUpdated + @@ROWCOUNT
				-- Get agedTime for aged jobs
				TRUNCATE TABLE #tblJobAged
				INSERT	INTO #tblJobAged
				SELECT	a.jobId, a.commCellId, isnull(max(B.agedTime), @currentTime), isnull(max(B.mediaDeletedTime), @currentTime), 0, 0
				FROM	#tblJobToUpdate A left outer join JMJobDataStats B WITH (NOLOCK)
				ON		A.jobId = B.jobId
				AND 	A.commCellId = B.commCellId
				GROUP	BY a.jobId, a.commCellId
				--Update VSA V2 Parent Job history
				UPDATE TMP
				SET		TMP.agedTime = CASE 	WHEN (T.minDataStatus IN (0, 3) OR T.maxDataStatus = 3) THEN 0
																		WHEN (T.minDataStatus IN (1, 2)) THEN T.agedTime
																		ELSE TMP.agedTime
													 	 END,
							TMP.mediaDeletedTime = CASE 	WHEN (T.minDataStatus IN (0, 3) OR T.maxDataStatus = 3) THEN 0
																						WHEN (T.minDataStatus = 2) THEN T.mediaDeletedTime
																						ELSE TMP.mediaDeletedTime
													 					 END,
							TMP.dataStatus = CASE 	WHEN (T.minDataStatus IN (0, 3) OR T.maxDataStatus = 3) THEN 3
																			WHEN (T.minDataStatus = 1) THEN 1
																			WHEN (T.minDataStatus = 2) THEN 2
																			ELSE 3
													 		 END,
							TMP.isVSAV2Parent = 1
				FROM 	#tblJobAged TMP INNER JOIN JMBkpStats JBKP WITH (NOLOCK)
				ON		TMP.jobId = JBKP.jobId
				AND 	TMP.commCellId = JBKP.commCellId
				INNER JOIN #VSAV2ParentJobStatus T
				ON		JBKP.jobId = T.parentJobId
				AND 	JBKP.commCellId = T.commCellId
				-- Reset mediaDeletedTime for jobs still have data on media
				UPDATE	#tblJobAged SET mediaDeletedTime = 0
				FROM	#tblJobAged A, JMJobDataStats B WITH (NOLOCK)
				WHERE	A.jobId = B.jobId
				AND 	A.commCellId = B.commCellId
				AND		B.status in (2, 3, 100, 102, 103)
				--Set dataStatus for rest of the jobs
				UPDATE	#tblJobAged
				SET 		dataStatus = CASE mediaDeletedTime WHEN 0 THEN 1 ELSE 2 END
				WHERE 	isVSAV2Parent = 0
				-- Update job histories for aged job
				UPDATE	JMBkpStats
				SET		modifiedTime = @currentTime,
						agedTime = B.agedTime,
						mediaDeletedTime = B.mediaDeletedTime,
						dataStatus = B.dataStatus
				FROM	JMBkpStats A, #tblJobAged B
				WHERE	A.jobId = B.jobId
				AND 	A.commCellId = B.commCellId
				AND   (			A.agedTime <> B.agedTime
								OR 	A.mediaDeletedTime <> B.mediaDeletedTime
								OR 	A.dataStatus <> B.dataStatus
							)
				SELECT @rowsUpdated = @rowsUpdated + @@ROWCOUNT
				UPDATE	JMAdminJobStatsTable
				SET		dataStatus = B.dataStatus
				FROM	JMAdminJobStatsTable A, #tblJobAged B
				WHERE	A.jobId = B.jobId
				AND 	A.commCellId = B.commCellId
				AND 	A.dataStatus <> B.dataStatus
				SELECT @rowsUpdated = @rowsUpdated + @@ROWCOUNT
				--Clean up tracked retention info when the job is aged
				DELETE A
				FROM DAJobRetentionInfo A, #tblJobAged B
				WHERE	A.jobId = B.jobId
				AND 	A.commCellId = B.commCellId
			COMMIT TRANSACTION
			BREAK
		END
		END TRY
  	BEGIN CATCH
  	BEGIN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @retVal = ERROR_NUMBER()
			SET	@ErrorSeverity = ERROR_SEVERITY()
			SET	@ErrorState = ERROR_STATE()
			SET @ErrorMessage = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @retVal) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
    	ROLLBACK TRANSACTION
    	IF @retVal NOT IN (1222, 1205)
    	BEGIN
    		BREAK
    	END
    	ELSE
    	BEGIN
    		SET @retryCnt = @retryCnt + 1
    		WAITFOR DELAY '00:00:05'
    		CONTINUE
    	END
    END
  	END CATCH;
	END
	IF @retVal != 0
	BEGIN
		RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState)
		RETURN -1
	END
	ELSE
	BEGIN
		RETURN @rowsUpdated
	END
GO

IF EXISTS (select * from GxQscripts where name = 'daUpdateJobHistory')
	delete from GxQscripts where name = 'daUpdateJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daUpdateJobHistory')
	delete from GXDBVersions where aliasname = 'daUpdateJobHistory'
GO

insert into GXDBVersions values(2, 'daUpdateJobHistory',  '00010001027600080000', 'daUpdateJobHistory', '00010001027600080000')
GO

