

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daUpdateEdgeJobStatus.sp] ---------- 

--  +========================================================================+
--  |		Name		:	daUpdateEdgeJobStatus
--  |		Description	:	Update the Edge backup status to Partial Success of non successful jobs before
--	|						running the DataAging job.
--	|		Author		:	Gokul Pattabiraman.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daUpdateEdgeJobStatus <<<'

IF EXISTS (select * from sysobjects where name='daUpdateEdgeJobStatus')
	drop procedure daUpdateEdgeJobStatus
IF EXISTS (select * from GxQscripts where name='daUpdateEdgeJobStatus')
	delete from GxQscripts where name = 'daUpdateEdgeJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daUpdateEdgeJobStatus')
	delete from GXDBVersions where aliasname = 'daUpdateEdgeJobStatus'
GO
print '... Creating Procedure: daUpdateEdgeJobStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daUpdateEdgeJobStatus
  @i_jobId integer,
  @i_commcellId integer
AS
  DECLARE @errorCode integer
BEGIN TRY
BEGIN TRAN
	SET NOCOUNT ON
	DECLARE @retVal integer = 0
	DECLARE @rowCnt integer = 0
	SET @retVal = 0
IF NOT EXISTS(SELECT * FROM App_Client(NOLOCK) Where status & 0x10000000 = 0x10000000)
	BEGIN
		GOTO ALL_DONE
	END
	WHILE ( 1 = 1)
	BEGIN
		-- We are marking all the non successful jobs as partial success..
		UPDATE TOP(1000)
		JmBkpStats
		SET status = 3
WHERE bkpAttributesEx & 0x200 = 0x200
		AND status not in (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
		SELECT @retVal = @@ERROR, @rowCnt = @@ROWCOUNT
		IF @retVal <> 0
			BREAK
		IF @rowCnt = 0
		BEGIN
			SET @retVal = 0
			BREAK
		END
	END
ALL_DONE:
	COMMIT TRAN
END TRY
BEGIN CATCH
	SET @retVal = 1
	ROLLBACK TRANSACTION
END CATCH;
SELECT @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'daUpdateEdgeJobStatus')
	delete from GxQscripts where name = 'daUpdateEdgeJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daUpdateEdgeJobStatus')
	delete from GXDBVersions where aliasname = 'daUpdateEdgeJobStatus'
GO

insert into GXDBVersions values(2, 'daUpdateEdgeJobStatus',  '00000000000000000000', 'daUpdateEdgeJobStatus', '00000000000000000000')
GO

