

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTsRptArchPruneSpoolCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTsRptArchPruneSpoolCopy.sp,v $ $Id: daTsRptArchPruneSpoolCopy.sp,v 1.3.304.2 2018/03/22 03:03:42 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTsRptArchPruneSpoolCopy <<<'

IF EXISTS (select * from sysobjects where name='daTsRptArchPruneSpoolCopy')
	drop procedure daTsRptArchPruneSpoolCopy
IF EXISTS (select * from GxQscripts where name='daTsRptArchPruneSpoolCopy')
	delete from GxQscripts where name = 'daTsRptArchPruneSpoolCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTsRptArchPruneSpoolCopy')
	delete from GXDBVersions where aliasname = 'daTsRptArchPruneSpoolCopy'
GO
print '... Creating Procedure: daTsRptArchPruneSpoolCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTsRptArchPruneSpoolCopy
  @i_archGroupId integer,
  @i_spoolCopyId integer
--:PARAM  runByDataAging	integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--DECLARE	@l_now INT
--SET @l_now = dbo.GetUnixTime(GETUTCDATE())
DECLARE @AP_PRUNE_PRUNABLE INTEGER
SET		@AP_PRUNE_PRUNABLE = 1
-- This is a shared temp table with stored procedure archSetJobsAgedViaTable
CREATE TABLE #ToBeAgedJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT, status INT, disabled INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
CREATE TABLE #TargetCopy (id INT)
CREATE TABLE #NotAgedJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT, status INT, disabled INT, doNotAge INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
SET	@retVal = 0
/*
if @runByDataAging = 0
BEGIN
	-- Do nothing if DataAging is running.
	IF EXISTS (SELECT * FROM JMJobTaskLink WHERE opType = 10)
		GOTO FINISH
	-- Do nothing if DataAging is disabled from Job Activity Control.
	IF EXISTS (SELECT * FROM JMJobAction WHERE opType = 10 AND action = 1)
		GOTO FINISH
	-- Do nothing if DataAging is disabled for the spool copy.
	-- Do nothing if Just-in-time Pruning is enabled for the spool copy.
	IF NOT EXISTS (
		SELECT * FROM archAgingRule
		WHERE	copyId = @i_spoolCopyId
			AND retentionDays = 0 AND fullCycles = 0
AND flags & (4 + 8) = 0)
		GOTO FINISH
END
*/
INSERT	INTO #TargetCopy
SELECT	id
FROM	archGroupCopy WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
	AND id <> @i_spoolCopyId
	AND (sourceCopyId = 0 OR sourceCopyId = @i_spoolCopyId)
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Get all jobs in spool copy which are not aged and not retained.
INSERT	INTO #ToBeAgedJob
SELECT	jobId, archGrpId, archGrpCopyId, dataType, commCellId, status, disabled
FROM	JMJobDataStats WITH (NOLOCK)
WHERE	archGrpCopyId = @i_spoolCopyId
AND disabled & 256 = 0
	AND retentionFlags = 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Filter out jobs which are not fully copied or not even picked to any copy
INSERT	INTO #NotAgedJob
SELECT T.jobId, T.archGrpId, T.archGrpCopyId, T.dataType, T.commCellId, T.status, T.disabled,
CASE WHEN J.status = 101 OR J.status = 102 OR J.status = 103 OR J.jobId IS null THEN 512
ELSE 8
			END
FROM	#ToBeAgedJob T LEFT OUTER JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = T.jobId AND J.dataType = T.dataType AND J.commCellId = T.commCellId
			AND J.archGrpCopyId IN (SELECT id FROM #TargetCopy)
WHERE	T.status = 100
AND T.disabled & 1 = 0
	AND (J.jobId IS null OR
J.status IN (101, 102, 103) AND J.disabled & (1 + 256) = 0)
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DELETE	#ToBeAgedJob
FROM	#ToBeAgedJob T, #NotAgedJob N
WHERE	T.jobId = N.jobId
	AND	T.archGrpCopyId = N.archGrpCopyId
	AND	T.dataType = N.dataType
	AND T.commCellId = N.commCellId
/*
DELETE	#ToBeAgedJob
FROM	#ToBeAgedJob T LEFT OUTER JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = T.jobId AND J.dataType = T.dataType AND J.commCellId = T.commCellId
WHERE	T.status = 100
AND T.disabled & 1 = 0
	AND J.archGrpCopyId IN (SELECT id FROM #TargetCopy)
	AND (J.jobId IS null OR
J.status IN (101, 102, 103) AND J.disabled & (1 + 256) = 0)
*/
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--
-- Need to add more code to mark not age spool copy
-- Need to move populate ASR & SQL Log to daTSRptPopulateRptTempTbl
UPDATE	#ArchJobCopy
	SET		pruneStatus = @AP_PRUNE_PRUNABLE
	FROM	#ArchJobCopy a, #ToBeAgedJob b
	WHERE	a.jobId = b.jobId
	AND		a.copyId = b.archGrpCopyId
	AND		(a.FileType = b.dataType OR a.FileType = 0)
	AND		a.commCellId = b.commCellId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
UPDATE	#ArchJobCopy
	SET		pruneStatus = pruneStatus | b.doNotAge,
				jobRetainReason = jobRetainReason | b.doNotAge
	FROM	#ArchJobCopy a, #NotAgedJob b
	WHERE	a.jobId = b.jobId
	AND		a.copyId = b.archGrpCopyId
	AND		(a.FileType = b.dataType OR a.FileType = 0)
	AND		a.commCellId = b.commCellId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
/*
-- Set jobs in the shared temp table #ToBeAgedJob as aged
IF EXISTS (SELECT * FROM #ToBeAgedJob)
BEGIN
	BEGIN TRANSACTION
	DECLARE	@retCode INT
EXEC @retCode = archSetJobsAgedViaTable 32768, @l_now
	SET	@retVal = @@ERROR
	IF	@retVal = 0 SET @retVal = @retCode
	IF	@retVal = 0
		COMMIT TRANSACTION
	ELSE
		ROLLBACK TRANSACTION
END
*/
FINISH:
DROP TABLE #TargetCopy
DROP TABLE #ToBeAgedJob
DROP TABLE #NotAgedJob
SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'daTsRptArchPruneSpoolCopy')
	delete from GxQscripts where name = 'daTsRptArchPruneSpoolCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTsRptArchPruneSpoolCopy')
	delete from GXDBVersions where aliasname = 'daTsRptArchPruneSpoolCopy'
GO

insert into GXDBVersions values(2, 'daTsRptArchPruneSpoolCopy',  '00010003030400020000', 'daTsRptArchPruneSpoolCopy', '00010003030400020000')
GO

