

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptSelectAppIdToBeAged.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptSelectAppIdToBeAged.sp,v $ $Id: daTSRptSelectAppIdToBeAged.sp,v 1.22.86.14 2020/05/10 01:15:52 pveeravalli Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptSelectAppIdToBeAged()
--  |
--  | Description:  Select the AppId to be pruned in the #ArchAppCopyToBeAged
--	| table based on the selected CopyId.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptSelectAppIdToBeAged')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptSelectAppIdToBeAged <<<'
	drop procedure daTSRptSelectAppIdToBeAged
END
IF EXISTS (select * from GxQscripts where name='daTSRptSelectAppIdToBeAged')
	delete from GxQscripts where name = 'daTSRptSelectAppIdToBeAged'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptSelectAppIdToBeAged')
	delete from GXDBVersions where aliasname = 'daTSRptSelectAppIdToBeAged'
GO
print '... Creating Procedure: daTSRptSelectAppIdToBeAged'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptSelectAppIdToBeAged
  @i_jobId INTEGER
AS
  DECLARE @o_retVal INTEGER
SET NOCOUNT ON
	DECLARE @userId		integer
	SET			@userId		= 0
	DECLARE 	@haveCopyIdList			INTEGER
	SET				@haveCopyIdList			=	0
	DECLARE @clientOpt		integer
	DECLARE @appTypeOpt		integer
	DECLARE @subClientOpt	integer
	DECLARE @locId				integer
	DECLARE @flags				bigint
	SET @o_retVal = 0
	-- Declare table variables
	if object_id('tempdb.dbo.#tmpSelectedCopy') is not null DROP TABLE #tmpSelectedCopy
	CREATE TABLE #tmpSelectedCopy	(archGrpId int, archGrpCopyId int PRIMARY KEY (archGrpId, archGrpCopyId))
	if object_id('tempdb.dbo.#tmpSelectedClient') is not null DROP TABLE #tmpSelectedClient
	CREATE TABLE #tmpSelectedClient (clientId int PRIMARY KEY (clientId))
	if object_id('tempdb.dbo.#tmpSelectedApptype') is not null DROP TABLE #tmpSelectedApptype
	CREATE TABLE #tmpSelectedApptype (appType int PRIMARY KEY (appType))
	if object_id('tempdb.dbo.#tmpSubClientList') is not null DROP TABLE #tmpSubClientList
	CREATE TABLE #tmpSubClientList (clientId int, agentId int, instanceId int, backupsetId int, subClientId int, exclude int)
	if object_id('tempdb.dbo.#tmpSelectedSubClient') is not null DROP TABLE #tmpSelectedSubClient
	CREATE TABLE #tmpSelectedSubClient (subClientId int PRIMARY KEY (subclientId))
	if object_id('tempdb..#tmpSelectedLibraries') is not null DROP TABLE #tmpSelectedLibraries
	CREATE TABLE #tmpSelectedLibraries (LibraryId int PRIMARY KEY (LibraryId))
	DECLARE @tblMirrorSrcCopy TABLE( archGrpId INT, CopyId INT, sourceCopyId INT)
	-- Get current user info
	EXEC RptOptGetUserFlags @i_jobid, @userId OUTPUT, @locId OUTPUT, @flags OUTPUT
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	IF object_id('tempdb.dbo.#daForeCastRptUserObjects') IS NOT null DROP TABLE #daForeCastRptUserObjects
create table  #daForeCastRptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	DECLARE @xmlText XML
	DECLARE @handle INT
	SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_jobid))
	EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
	DECLARE @SPOpt INT
	INSERT INTO #tmpSelectedCopy EXEC RptOptGetStoragePolicies @i_jobId, @SPOpt OUTPUT
	IF (@SPOpt = 0)	--All SPs selected
	BEGIN
		INSERT INTO #tmpSelectedCopy
		SELECT AG.id , AGC.id
		FROM archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE AG.id = AGC.archGroupId
		AND AG.id > 1
AND AGC.type <> 5
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
	END
	ELSE IF (@SPOpt = 1) --User selected specific policies
	BEGIN
		INSERT INTO #tmpSelectedCopy
		SELECT T.archGrpId , AGC.id
		FROM #tmpSelectedCopy T, archGroupCopy AGC WITH (NOLOCK)
		WHERE T.archGrpId = AGC.archGroupId
		AND T.archGrpCopyId = 0
		AND AGC.id > 0
AND AGC.type <> 5
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		delete FROM #tmpSelectedCopy
		FROM #tmpSelectedCopy T, archGroupCopy AGC WITH (NOLOCK)
		WHERE T.archGrpId = AGC.archGroupId
		AND T.archGrpCopyId = 0
AND AGC.type <> 5
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
	END
	ELSE --Libraries selected
	BEGIN
		--Even if user selects all libraries we have the entire list in the XML so fetch the list
		INSERT INTO #tmpSelectedLibraries
		SELECT DISTINCT libraryId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/libraryList', 1) WITH (libraryId int)
		--If the library entity is 0, user selection is all libraries.
		IF EXISTS(SELECT 1 FROM #tmpSelectedLibraries WHERE libraryId = 0)
		BEGIN
			IF NOT EXISTS(SELECT 1 FROM #tmpSelectedLibraries WHERE libraryId > 0)
			BEGIN
				TRUNCATE TABLE #tmpSelectedLibraries
				INSERT INTO #tmpSelectedLibraries
				SELECT libraryId FROM MMLibrary WITH(NOLOCK) WHERE libraryId > 0
			END
			ELSE --If it's a mix of zero and non-zero, ignore the 0 entries and process only the non-zero library ids. But ideally we shouldn't get here.
				DELETE FROM #tmpSelectedLibraries WHERE libraryId = 0
		END
		--Filter out libraries on which user has permissions to run report
		IF(@userId > 0)
		BEGIN
			DELETE #daForeCastRptUserObjects
			-- Get libraries on which user has permissions
EXEC sec_getUserObjects @userId, 2049, 0, '#daForeCastRptUserObjects'
			SELECT	@o_retVal =  @@error
			IF (@o_retVal != 0) GOTO CX_EXIT
			IF EXISTS(SELECT 1 FROM #daForeCastRptUserObjects WHERE libraryId > 0) --Restricted library list
				DELETE FROM #tmpSelectedLibraries WHERE libraryId NOT IN (SELECT libraryId FROM #daForeCastRptUserObjects WHERE libraryId > 0)
			ELSE IF NOT EXISTS(SELECT 1 FROM #daForeCastRptUserObjects WHERE libraryId = 0) --User does not have access to any library
				DELETE FROM #tmpSelectedLibraries
			--ELSE
				--User has permissions on all libraries
			SELECT	@o_retVal =  @@error
			IF (@o_retVal != 0) GOTO CX_EXIT
		END
		INSERT INTO #tmpSelectedCopy
		SELECT DISTINCT AGC.archGroupId, AGC.id
		FROM #tmpSelectedLibraries LIB INNER JOIN MMMasterPool MP WITH (NOLOCK) ON LIB.LibraryId = MP.LibraryId
		INNER JOIN MMDrivePool MDP WITH (NOLOCK) ON MP.masterpoolId = MDP.masterpoolId
        INNER JOIN MMDataPath DPATH WITH (NOLOCK) ON MDP.DrivePoolId = DPATH.DrivePoolId
        INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AGC.id = DPATH.CopyId
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
	END
	--IF GDSP copy is selected, then pick all the child copies associated to GDSP
	INSERT INTO #tmpSelectedCopy
	SELECT	DISTINCT AGC.archGroupId, AGC.id
	FROM	archGroupCopy AGC WITH (NOLOCK),
			(SELECT DISTINCT c.archGroupId
			FROM archGroupCopy C WITH (NOLOCK), #tmpSelectedCopy T
			WHERE C.id = T.archGrpCopyId) TMP
			INNER JOIN archCopyToGlobalPolicy GP WITH (NOLOCK) ON TMP.archGroupId = GP.GlobalPolicyId
	WHERE	AGC.id = GP.CopyId
	AND 	NOT EXISTS (SELECT archGrpCopyId FROM #tmpSelectedCopy WHERE archGrpCopyId = AGC.id)
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	--Get selected Mirror copies with the sourceCopyId
	INSERT INTO @tblMirrorSrcCopy
	SELECT	AGC.archGroupId, AGC.id, (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
	FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK), #tmpSelectedCopy T
	WHERE		T.archGrpCopyId = AGC.id
	AND		AGC.archGroupId = AG.id
	AND		AGC.isMirrorCopy > 0
	AND		AGC.isSnapCopy > 0
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	WHILE EXISTS (SELECT T.sourceCopyId FROM @tblMirrorSrcCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE @tblMirrorSrcCopy
		SET sourceCopyId = (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
		FROM	@tblMirrorSrcCopy T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.archGroupId = AG.id
		AND		AGC.isMirrorCopy > 0
		AND		AGC.isSnapCopy > 0
	END
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	--IF Mirror copy is selected, then pick the source copy of that mirror
	INSERT INTO #tmpSelectedCopy
	SELECT DISTINCT T.archGrpId, T.sourceCopyId
	FROM	@tblMirrorSrcCopy T
	WHERE	NOT EXISTS (SELECT archGrpCopyId FROM #tmpSelectedCopy WHERE archGrpCopyId = T.sourceCopyId)
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	-- Get selected client
	INSERT INTO #tmpSelectedClient EXEC rptOptGetClients @i_jobid, @clientOpt OUTPUT
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	-- Get selected application type
	INSERT INTO #tmpSelectedApptype EXEC rptOptGetAppTypes @i_jobid, @appTypeOpt OUTPUT
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	-- Get selected subclient
	INSERT INTO #tmpSubClientList EXEC rptOptGetSubclients @i_jobid, @subClientOpt OUTPUT
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
  IF @subClientOpt > 0
	BEGIN
		INSERT INTO #tmpSelectedSubClient
    SELECT DISTINCT APP.id
    FROM APP_Application APP WITH (NOLOCK) INNER JOIN #tmpSubClientList T
    ON  (T.clientId = 0 OR APP.clientId = T.clientId)
    AND (T.agentId = 0 OR APP.appTypeId = T.agentId)
    AND (T.instanceId = 0 OR APP.instance = T.instanceId)
    AND (T.backupsetId = 0 OR APP.backupSet = T.backupsetId)
    AND (T.subclientId = 0 OR APP.id = T.subclientId)
    AND (T.exclude = 0)
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		DELETE  TMP
		FROM  #tmpSelectedSubClient TMP
    INNER JOIN APP_Application APP WITH (NOLOCK)
    ON 	APP.Id = TMP.subClientId
    INNER JOIN #tmpSubClientList T
    ON  (APP.clientId = T.clientId)
    AND (T.agentId = 0 OR APP.appTypeId = T.agentId)
    AND (T.instanceId = 0 OR APP.instance = T.instanceId)
    AND (T.backupsetId = 0 OR APP.backupSet = T.backupsetId)
    AND (T.subclientId = 0 OR APP.id = T.subclientId)
    AND (T.exclude = 1)
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
	END
	--Apply user security checks and select only those copies / clients  for which user have rights
	IF @userId > 0
	BEGIN
		delete #daForeCastRptUserObjects
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		-- Check for SP rights
EXEC sec_getUserObjects @userId, 2231, 0, '#daForeCastRptUserObjects'
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		delete #daForeCastRptUserObjects
		WHERE clientGroupId <> 0
		OR 		mediaAgentId <> 0
		OR 		clientId <> 0
		OR		libraryID <> 0
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		delete #tmpSelectedCopy
		FROM	#tmpSelectedCopy T
		WHERE NOT EXISTS (select * from #daForeCastRptUserObjects R where R.archGroupID in (0, T.archGrpId))
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		-- Check for client rights
		delete #daForeCastRptUserObjects
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
EXEC sec_getUserObjects @userId, 2013, 0, '#daForeCastRptUserObjects'
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		delete #daForeCastRptUserObjects
		WHERE clientGroupId <> 0
		OR 		mediaAgentId <> 0
		OR 		libraryID <> 0
		OR 		archGroupID <> 0
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		--When all clients are selected
		IF @clientOpt = 0
		BEGIN
			delete #tmpSelectedClient
			INSERT INTO #tmpSelectedClient
			SELECT DISTINCT AC.id
			FROM #daForeCastRptUserObjects R, APP_Client AC WITH (NOLOCK)
			WHERE (R.clientId = 0 OR R.clientId = AC.id)
		END
		ELSE
		BEGIN
			delete #tmpSelectedClient
			FROM	#tmpSelectedClient T
			WHERE NOT EXISTS (select * from #daForeCastRptUserObjects R where R.clientId in (0, T.clientId))
		END
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		-- Check for subclient rights
		delete #daForeCastRptUserObjects
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
EXEC sec_getUserObjects @userId, 2013, 0, '#daForeCastRptUserObjects'
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		delete #daForeCastRptUserObjects
		WHERE clientGroupId <> 0
		OR 		mediaAgentId <> 0
		OR 		libraryID <> 0
		OR 		archGroupID <> 0
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		--When subclients are selected
		IF @subClientOpt > 0
		BEGIN
			DELETE T
			FROM	#tmpSelectedSubClient T
			INNER JOIN APP_Application APP WITH (NOLOCK) ON App.id = T.subClientId
			LEFT OUTER JOIN #daForeCastRptUserObjects R ON R.clientId IN (0, APP.clientId)
							AND 	R.appTypeId IN (0,APP.appTypeId)
							AND 	R.instanceId IN (0,APP.instance)
							AND 	R.backupsetId IN (0,APP.backupSet)
							AND		R.subClientId IN (0, APP.Id)
			WHERE R.subClientId IS NULL AND R.backupsetId IS NULL AND R.instanceId IS NULL AND R.appTypeId IS NULL AND R.clientId IS NULL
		END
		SELECT	@o_retVal =  @@error
		IF (@o_retVal != 0) GOTO CX_EXIT
		DROP TABLE #daForeCastRptUserObjects
	END
	INSERT INTO #tmpSelectedCopies
	SELECT DISTINCT archGrpCopyId
	FROM  #tmpSelectedCopy
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
	-- Select the AppIds for selected Copies and Clients and appTypes
	IF @subClientOpt > 0
	BEGIN
		UPDATE	#ArchAppCopyToBeAged
		SET		appIdSelectedForProcessing = 1, appIdSelectedForPruning = 1
		FROM	#ArchAppCopyToBeAged a
		inner join #tmpSelectedCopy b ON a.copyId = b.archGrpCopyId
		inner join #tmpSelectedSubClient c ON a.appId = c.subClientId
	END
	ELSE
	BEGIN
		IF @appTypeOpt = 0
			UPDATE	#ArchAppCopyToBeAged
			SET		appIdSelectedForProcessing = 1, appIdSelectedForPruning = 1
			FROM	#ArchAppCopyToBeAged a
			inner join #tmpSelectedCopy b ON a.copyId = b.archGrpCopyId
			inner join #tmpSelectedClient c ON a.clientId = c.clientId
		ELSE
			UPDATE	#ArchAppCopyToBeAged
			SET		appIdSelectedForProcessing = 1, appIdSelectedForPruning = 1
			FROM	#ArchAppCopyToBeAged a
			inner join #tmpSelectedCopy b ON a.copyId = b.archGrpCopyId
			inner join #tmpSelectedClient c ON a.clientId = c.clientId
			inner join #tmpSelectedApptype d ON a.appType = d.appType
	END
	SELECT	@o_retVal =  @@error
	IF (@o_retVal != 0) GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#tmpSelectedCopy') is not null DROP TABLE #tmpSelectedCopy
	if object_id('tempdb.dbo.#tmpSelectedClient') is not null DROP TABLE #tmpSelectedClient
	if object_id('tempdb.dbo.#tmpSelectedApptype') is not null DROP TABLE #tmpSelectedApptype
	if object_id('tempdb.dbo.#tmpSelectedSubClient') is not null DROP TABLE #tmpSelectedSubClient
	if object_id('tempdb.dbo.#tmpSubClientList') is not null DROP TABLE #tmpSubClientList
	EXEC sp_xml_removedocument @handle
	--SELECT   @o_retVal
	RETURN	@o_retVal
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptSelectAppIdToBeAged')
	delete from GxQscripts where name = 'daTSRptSelectAppIdToBeAged'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptSelectAppIdToBeAged')
	delete from GXDBVersions where aliasname = 'daTSRptSelectAppIdToBeAged'
GO

insert into GXDBVersions values(2, 'daTSRptSelectAppIdToBeAged',  '00010022008600140000', 'daTSRptSelectAppIdToBeAged', '00010022008600140000')
GO

