

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptPopulateRptTempTbl.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptPopulateRptTempTbl.sp,v $ $Id: daTSRptPopulateRptTempTbl.sp,v 1.24.14.4 2020/03/05 21:07:02 hkapadia Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptPopulateRptTempTbl()
--  |
--  | Description: initialize job information on all the selected copies
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptPopulateRptTempTbl')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptPopulateRptTempTbl <<<'
	drop procedure daTSRptPopulateRptTempTbl
END
IF EXISTS (select * from GxQscripts where name='daTSRptPopulateRptTempTbl')
	delete from GxQscripts where name = 'daTSRptPopulateRptTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptPopulateRptTempTbl')
	delete from GXDBVersions where aliasname = 'daTSRptPopulateRptTempTbl'
GO
print '... Creating Procedure: daTSRptPopulateRptTempTbl'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptPopulateRptTempTbl
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @cs_attrNameCloudPaas INTEGER
	SET			@cs_attrNameCloudPaas = CHECKSUM(N'Cloud PaaS Backup Enabled')
	DECLARE @currentTime INTEGER
	SET     @currentTime = dbo.GetUnixTime(GETUTCDATE()) + @dummy * 24 * 3600
	--DECLARE @AP_PRUNE_OTHERS		INTEGER  --not prunable of other reasons
	--SET			@AP_PRUNE_OTHERS		= 2097152
	INSERT	INTO #ExpiredManualRetainedJob
	SELECT	DISTINCT JDS.archGrpCopyId, JDS.JobId, JDS.CommCellId
	FROM	JMJobDataStats JDS WITH (NOLOCK), #ArchAppCopyToBeAged a
	WHERE	JDS.AppId = a.AppId
	AND		JDS.archGrpCopyId = a.copyId
	AND		(a.FileType IN (0, 512) OR a.FileType = JDS.dataType)
AND		(JDS.Disabled & 2) != 0
	AND		JDS.manualRetentionEndTime < @currentTime
	AND		JDS.manualRetentionEndTime > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Get the data for all the appIds
	-- Since need to maintain the prunable job status for each jobs
	-- to calculate media summary information
	-------------------------------------------------------------------------------
	INSERT	INTO #ArchJobCopy
	SELECT	DISTINCT
					CASE
						WHEN MAX(a.DoNotAge) <> 0 THEN MAX(a.DoNotAge)
						ELSE 0
					END,
					a.AppId, a.AppFlags,
					a.CopyId, a.FileType,
					b.JobId, b.CommCellId, '',
					StartTime = -1, EndTime = -1,
					BkpLevel = -1, JobStatus = -1,
DataStatus = MAX(b.status), Disabled = MAX(b.Disabled & 1),
ManualRet = MAX(b.Disabled & 2), RetainForAuxCopy = 0,
					ExtendedJob = 0, OnLinkedSP = 0,
					fullCycleNum = 0, cyclesequence = 0, CycleId = 0,
					extRetentionFlags = 0, jobRetainReason = MAX(a.DoNotAge),
					retentionDays = MAX(a.retentionDays), estimatedAgingDate = 0,
					BkpAttributes = 0,
JobFlags = MAX(CASE WHEN (b.Disabled & 64) <> 0 THEN 1 ELSE 0 END),
					0, 0, a.TimeZoneToHonor, CAST(b.JobId AS VARCHAR(MAX))
	FROM	#ArchAppCopyToBeAged a, JMJobDataStats b WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND		a.copyId = b.archGrpCopyId
	AND 	(a.FileType IN (0, 512) OR a.FileType = b.dataType)
	AND 	b.status <> 1000
AND 	b.Disabled & 256 = 0
	AND		b.status NOT IN (2, 3)
	AND		a.appIdSelectedForProcessing = 1
	GROUP	BY a.AppId, b.archGrpId, a.CopyId, b.JobId, b.CommCellId, a.FileType, a.AppFlags, a.TimeZoneToHonor
	SET @errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Create indexes here
	CREATE INDEX Idx_ArchJobCopy_1 ON #ArchJobCopy (AppId, CopyId, AppFlags)
	CREATE INDEX Idx_ArchJobCopy_2 ON #ArchJobCopy (JobId, CommCellId, CopyId, AppFlags)
	-- Filtering out failed and killed ER backup jobs.
	DELETE	#ArchJobCopy
	FROM	#ArchJobCopy a, JMAdminJobStatsTable b WITH (NOLOCK)
	WHERE	a.jobId = b.jobId
	AND		a.commcellId = b.commcellId
	AND		b.status in (2, 4)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Reset manual retention end time
	UPDATE	#ArchJobCopy
	SET		ManualRet = 0
	FROM	#ArchJobCopy a, #ExpiredManualRetainedJob b
	WHERE	a.CopyId = b.CopyId
	AND		a.JobId = b.JobId
	AND		a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Mark Foreign CommCell jobs and CommCell Name
	UPDATE #ArchJobCopy
SET		JobFlags = (J.JobFlags | (CASE WHEN C.type > 1 THEN 2 ELSE 0 END)),
				CommCellName = C.aliasName
	FROM	#ArchJobCopy J, APP_CommCell C WITH (NOLOCK)
	WHERE J.commCellId = C.id
	SET @errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update Snap jobs with BCD Index archive files
	UPDATE	#ArchJobCopy
SET 	JobFlags = JobFlags | 4
	FROM	#ArchJobCopy a, #ArchAppCopyToBeAged b, JMJobDataStats JDS WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		b.copyIsSnap <> 0
	AND		a.JobId = JDS.JobId
	AND		a.commCellId = JDS.commCellId
	AND		a.CopyId = JDS.archGrpCopyId
AND		JDS.dataType = 6
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update Cloud Paas subclients
	-- Need this to just include jobs on report against "No Media" association as these jobs don't create any chunks
	UPDATE #ArchJobCopy
SET		AppFlagsExt = AppFlagsExt | 1
	FROM 	#ArchJobCopy T, APP_SubclientProp P WITH (NOLOCK)
	WHERE	T.appId = P.componentNameId
	AND 	P.attrName = N'Cloud PaaS Backup Enabled'
	AND 	P.cs_attrName = @cs_attrNameCloudPaas
	AND		P.attrVal = '1'
	AND		P.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Mark jobs with partial/failed verification status
	UPDATE	#ArchJobCopy
	SET 	JobFlags = (a.JobFlags | (CASE JDS.archCheckStatus
WHEN 4 THEN 16		-- ACS_PARTCHECKED
WHEN 6 THEN 8			-- ACS_FAILED
																			 ELSE 0
																	END))
	FROM	#ArchJobCopy a, JMJobDataStats JDS WITH (NOLOCK)
	WHERE	a.JobId = JDS.JobId
	AND		a.commCellId = JDS.commCellId
	AND		a.CopyId = JDS.archGrpCopyId
	AND 	(a.FileType = 0 OR a.FileType = JDS.dataType)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	----------------------------------------------------------------------------------------------
	-- Get the Start Time, End Time, Backuplevel, JobStatus and fullCycleNum of the selected jobs
	----------------------------------------------------------------------------------------------
	-- Update job info for regular backup
	UPDATE	#ArchJobCopy
	SET 	StartTime = b.ServStartDate,
				EndTime = b.ServEndDate,
BkpLevel = CASE WHEN (((b.bkpattributes & 0x4000) <> 0 OR (b.bkpattributes & 0x10000) <> 0)
AND ((b.bkpattributes & 0x1000) = 0 AND (b.bkpattributes & 0x2000) = 0))
											THEN 2 ELSE b.BkpLevel END, -- Config/Control File ONLY Backups should not be FULL backups
				JobStatus = b.Status,
				fullCycleNum = b.fullCycleNum,
				cyclesequence = b.cyclesequence,
				BkpAttributes = b.bkpAttributes
	FROM	#ArchJobCopy a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update job info for DR backup and ERASE backup
	UPDATE	#ArchJobCopy
	SET 	StartTime = b.ServStart,
				EndTime = b.ServEnd,
				BkpLevel = b.ER_BkpLevel,
				JobStatus = b.Status,
				fullCycleNum = b.fullCycleNum
	FROM	#ArchJobCopy a, JMAdminJobStatsTable b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--remove invalid ASR backup jobs
	DELETE #ArchJobCopy
	WHERE BkpLevel = 512
	AND	  FileType != 512
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- DO NOT PRUNE FOREIGN JOBS
	-----------------------------------------------------------------------------
	UPDATE	#ArchJobCopy
SET		jobRetainReason = 2097152,
pruneStatus = 2097152
WHERE	(JobFlags & 2) <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
/*
	-- Process them as if Index only data is written then the overall job status will be 101 and disabled but jobs will never be pruned.
	-----------------------------------------------------------------------------
	-- Do not process disabled job without data
	-----------------------------------------------------------------------------
	DELETE	#ArchJobCopy
	WHERE	DataStatus = 101
	AND		Disabled > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
*/
	-----------------------------------------------------------------------------
	-- Do not process the Failed/Killed jobs here
	-----------------------------------------------------------------------------
	DELETE	#ArchJobCopy
	WHERE JobStatus NOT IN (1, 3, 14) -- Success / Completed With Errors / Completed With Warnings
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- In case if no job history is available then do not process such jobs
	-----------------------------------------------------------------------------
	DELETE	#ArchJobCopy
	WHERE StartTime = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptPopulateRptTempTbl')
	delete from GxQscripts where name = 'daTSRptPopulateRptTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptPopulateRptTempTbl')
	delete from GXDBVersions where aliasname = 'daTSRptPopulateRptTempTbl'
GO

insert into GXDBVersions values(2, 'daTSRptPopulateRptTempTbl',  '00010024001400040000', 'daTSRptPopulateRptTempTbl', '00010024001400040000')
GO

