

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptPopulateExtendedRetainedJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptPopulateExtendedRetainedJobs.sp,v $ $Id: daTSRptPopulateExtendedRetainedJobs.sp,v 1.7.12.2 2018/12/27 16:32:25 vikashkumar Exp $";
--  +===================================================================================+
--  | Stored Proc:  daTSRptPopulateExtendedRetainedJobs()
--  |
--  | Description:  Populate the extended retained jobs in ArchJobCopyExtended table
--  +===================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptPopulateExtendedRetainedJobs')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptPopulateExtendedRetainedJobs <<<'
	drop procedure daTSRptPopulateExtendedRetainedJobs
END
IF EXISTS (select * from GxQscripts where name='daTSRptPopulateExtendedRetainedJobs')
	delete from GxQscripts where name = 'daTSRptPopulateExtendedRetainedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptPopulateExtendedRetainedJobs')
	delete from GXDBVersions where aliasname = 'daTSRptPopulateExtendedRetainedJobs'
GO
print '... Creating Procedure: daTSRptPopulateExtendedRetainedJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptPopulateExtendedRetainedJobs
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @AppIdListCursorFlag 		INTEGER
	SET 	@AppIdListCursorFlag 			= 0
	DECLARE @curAppId			INTEGER
	SET 	@curAppId				= 0
	DECLARE @curAppTypeId			INTEGER
	SET 	@curAppTypeId				= 0
	DECLARE 	@IgnoreCWEJobOption 	INTEGER
	SET		@IgnoreCWEJobOption 			= 0
	DECLARE @HonorExtRetForRegularFull 	INTEGER
	SET			@HonorExtRetForRegularFull 	= 1
	DECLARE @nextSchedFullTime	INTEGER
	SET 	@nextSchedFullTime		= 0
	DECLARE @nextSchedTime	INTEGER
	SET 	@nextSchedTime		= 0
	DECLARE	@appNextSchedFullTime TABLE (
			nextSchedTime 		INTEGER
			)
	-------------------------------------------------------------------------------
	-------- Consider CWE jobs for extended retention based on param value --------
	-------------------------------------------------------------------------------
	SELECT @IgnoreCWEJobOption = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_IGNORE_CWE_OPTION_FOR_EXT_RET'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @HonorExtRetForRegularFull = isnull(value, 1)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_HONOR_EXTENDED_RETENTION_FOR_ORACLE_SAP_REGULAR_FULL_JOBS'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	----------------- Populate the Extended Retained Jobs -------------------------
	-------------------------------------------------------------------------------
	-- Update ExtendedJob flag for jobs to be retained by extended retention
	-- Truncate the ArchJobCopyExtended table
DELETE	FROM #archJobCopyExtendedRpt
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#DA_JobCopyList
	SET 	ExtendedJob = 1
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	b.ExtendedRetention = 1
AND		(a.JobFlags & 32) = 0 		-- Do not consider index copy jobs for extended retention
AND		(a.JobFlags & 33554432) = 0
	AND		(
(a.JobFlags & 64 = 0)
					OR
(a.JobFlags & 128 > 0)
				)
AND 	( ( (b.AppFlags & 1024 = 0) AND (b.AppFlags & 2097152 = 0 OR b.appType = 135) AND (b.AppFlags & 4194304 = 0) AND (a.BkpLevel = 1 OR dbo.GetBkpLevelOfSnapJobs(a.JobId, a.CommCellId, a.CopyId) = 1) )
OR  	  ( ( (b.AppFlags & 1024 > 0) OR (b.AppFlags & 2097152 > 0) ) AND ( a.JobFlags & 262144 > 0) )
OR  	  ( ( (b.AppFlags & 1024 > 0) OR (b.AppFlags & 2097152 > 0) ) AND (@HonorExtRetForRegularFull != 0 AND b.subclientStatus & 0x0040 = 0 AND a.BkpLevel = 1 AND a.JobFlags & 8388608 > 0) )
OR			( (b.AppFlags & 4194304 > 0) AND (a.BkpLevel = 1 AND a.JobFlags & 8388608 > 0) )
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Select Jobs to be processed by Extended Retention
	-- Do Not Consider the jobs that are marked "BAD" for Extended Retention
INSERT	INTO #archJobCopyExtendedRpt
	SELECT	AppId, JobId, CopyId, FileType, CommCellId,
			StartTime, EndTime, DataStatus, JobStatus,
			Disabled, ManualRet, RetainForAuxCopy, 0, '',
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM	#DA_JobCopyList
	WHERE	ExtendedJob = 1
	AND 	OnLinkedSP = 0
	AND 	(
					(@IgnoreCWEJobOption != 0 AND JobStatus IN (1, 3, 14))
					OR
					(@IgnoreCWEJobOption = 0 AND isCWEjobValid != 0 AND JobStatus IN (1, 3, 14))
					OR
			 		(@IgnoreCWEJobOption = 0 AND isCWEjobValid = 0 AND JobStatus IN (1, 14))
				)
AND (JobFlags & 1) = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	/*
	Ext Retention is supported on DB2 appType cmd line subclients only if the job ran on 10.0 or higher
	So check the earliest time the clients got a version 10.0 or higher and remove those jobs that have their
	start time less than the upgrade time
	*/
	DECLARE @clientUpgradeTime TABLE(clientId int, upgradeDateTime datetime, upgradeTime int)
	INSERT INTO @clientUpgradeTime
	SELECT DISTINCT clientId, null, 0
	FROM #DA_AppCopyList
WHERE appType IN (37, 62, 103)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @clientUpgradeTime
	SET upgradeDateTime = (SELECT TOP 1 CreateTimeUTC FROM LicUsageHistory WITH (NOLOCK) WHERE ReleaseId >= 15 AND LicType NOT IN (71, 10, 26) AND Cid = clientId ORDER BY CreateTimeUTC ASC)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @clientUpgradeTime
	SET upgradeTime = ISNULL(dbo.getUnixTime(upgradeDateTime), 0)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
DELETE #archJobCopyExtendedRpt
FROM #archJobCopyExtendedRpt a, #DA_AppCopyList c, @clientUpgradeTime d
	WHERE a.appId = c.appId AND a.copyId = c.copyId
AND c.appType IN (37, 62, 103)
AND (c.subclientStatus & 0x0040) = 0x0040
	AND c.clientId = d.clientId
	AND (d.upgradeTime = 0 OR a.StartTime < d.upgradeTime)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update calendarId and TimeZoneToHonor Info
UPDATE #archJobCopyExtendedRpt
	SET calendarId = AAC.calendarId, timeZoneStdName = AAC.TimeZoneToHonor
FROM #archJobCopyExtendedRpt JCE WITH (NOLOCK), #ArchAppCopyToBeAged AAC WITH (NOLOCK)
	WHERE	JCE.appId = AAC.appId
	AND 	JCE.copyId = AAC.copyId
	AND 	JCE.dataType = AAC.fileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update weekStart and monthStart info for copy
UPDATE #archJobCopyExtendedRpt
	SET weekStart = AAR.weekStart, monthStart = AAR.monthStart, minutesSinceDayStarts = AAR.minutesSinceDayStarts
FROM #archJobCopyExtendedRpt JCE WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
	WHERE	JCE.copyId = AAR.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update EveryXHours
UPDATE #archJobCopyExtendedRpt
	SET EveryXHours = AARE.EveryXHours
FROM #archJobCopyExtendedRpt JCE WITH (NOLOCK), archAgingRuleExtended AARE WITH (NOLOCK)
	WHERE	JCE.copyId = AARE.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate the LocalTime based on the TimeZone selected for Storage Policy
UPDATE #archJobCopyExtendedRpt
	SET localStartTime = dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(startTime), timeZoneStdName))
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the period StartTime for each job based on their LocalTime
UPDATE #archJobCopyExtendedRpt
	SET hourStartTime = dbo.DAGetHourlyStart(localStartTime, EveryXHours, minutesSinceDayStarts),
	dayStartTime = dbo.DAGetDailyStart(localStartTime, minutesSinceDayStarts),
	weekStartTime = dbo.DAGetWeekStart(localStartTime, weekStart),
	monthStartTime = dbo.DAGetMonthStart(localStartTime, calendarId, monthStart),
	quarterStartTime = dbo.DAGetQuarterStart(localStartTime, calendarId),
	halfYearStartTime = dbo.DAGetHalfYearStart(localStartTime, calendarId),
	yearStartTime = dbo.DAGetYearStart(localStartTime, calendarId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
UPDATE #archJobCopyExtendedRpt
	SET hourEndTime = dbo.DAGetHourlyEnd(localStartTime, EveryXHours, minutesSinceDayStarts),
	dayEndTime = dbo.DAGetDailyEnd(localStartTime, minutesSinceDayStarts),
	weekEndTime = dbo.DAGetWeekEnd(localStartTime, weekStart),
	monthEndTime = dbo.DAGetMonthEnd(localStartTime, calendarId, monthStart),
	quarterEndTime = dbo.DAGetQuarterEnd(localStartTime, calendarId),
	halfYearEndTime = dbo.DAGetHalfYearEnd(localStartTime, calendarId),
	yearEndTime = dbo.DAGetYearEnd(localStartTime, calendarId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	DECLARE	AppIdListCursor CURSOR STATIC FOR
		SELECT	DISTINCT AppId
FROM	#archJobCopyExtendedRpt
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SET		@AppIdListCursorFlag = 1
	OPEN	AppIdListCursor
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	FETCH	NEXT
	FROM AppIdListCursor
	INTO	@curAppId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SELECT @curAppTypeId = appTypeId
		FROM APP_Application WITH (NOLOCK)
		WHERE id = @curAppId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		DELETE @appNextSchedFullTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO @appNextSchedFullTime
		EXEC TM_GetNextScheduleRunTime @curAppId, 1, 0, 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SELECT TOP 1 @nextSchedFullTime = nextSchedTime
		FROM @appNextSchedFullTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SET @nextSchedTime = 0
		--Get next backup time (Full or non-full only for FS like, NAS or VSA
		IF (@curAppTypeId IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) -- APPGRP_FileSystemIDA
			  OR @curAppTypeId IN (88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/) )
		BEGIN
			DELETE @appNextSchedFullTime
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			INSERT INTO @appNextSchedFullTime
			EXEC TM_GetNextScheduleRunTime @curAppId, 0, 0, 1
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			SELECT TOP 1 @nextSchedTime = nextSchedTime
			FROM @appNextSchedFullTime
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
		--Set Next Full Job time if job is on Non-Snap Copy OR "Consider Incremental as Full" is not enabled on Storage Policy OR AppType is not FS Like, NAS AND VSA
UPDATE #archJobCopyExtendedRpt
		SET nextFullTime = ISNULL(dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(@nextSchedFullTime), JCE.timeZoneStdName)), 0)
FROM #archJobCopyExtendedRpt JCE, archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE JCE.appId = @curAppId
		AND		JCE.copyId = AGC.id
		AND		AGC.archGroupId = AG.id
AND		AGC.type <> 2
		AND		(		 (AGC.isSnapCopy = 0)
						OR (AGC.isSnapCopy = 1 AND AG.flags & 32768 = 0) -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
						OR (@curAppTypeId NOT IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) AND @curAppTypeId NOT IN (88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/))
					)
		AND		@nextSchedFullTime > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Set Next Full or Non-Full Job time if job is on Snap Copy AND "Consider Incremental as Full" is Enabled on Storage Policy AND AppType is FS Like, NAS AND VSA
UPDATE #archJobCopyExtendedRpt
		SET nextFullTime = ISNULL(dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(@nextSchedTime), JCE.timeZoneStdName)), 0)
FROM #archJobCopyExtendedRpt JCE, archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE JCE.appId = @curAppId
		AND		JCE.copyId = AGC.id
		AND		AGC.archGroupId = AG.id
AND		AGC.type <> 2
		AND		AGC.isSnapCopy = 1
		AND 	AG.flags & 32768 > 0 -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
		AND 	(@curAppTypeId IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) OR @curAppTypeId IN (88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/))
		AND		@nextSchedTime > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM AppIdListCursor
		INTO	@curAppId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF @AppIdListCursorFlag = 1
	BEGIN
			CLOSE				AppIdListCursor
			DEALLOCATE	AppIdListCursor
	END
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptPopulateExtendedRetainedJobs')
	delete from GxQscripts where name = 'daTSRptPopulateExtendedRetainedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptPopulateExtendedRetainedJobs')
	delete from GXDBVersions where aliasname = 'daTSRptPopulateExtendedRetainedJobs'
GO

insert into GXDBVersions values(2, 'daTSRptPopulateExtendedRetainedJobs',  '00010007001200020000', 'daTSRptPopulateExtendedRetainedJobs', '00010007001200020000')
GO

