

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptJobCopyVol.sp] ---------- 

--  +========================================================================+
--  | Cursor Name:  DaTSRptJobCopyVol
--  | Description:  Retrieves the list of volumes and all jobs on it
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptJobCopyVol.sp,v $ $Id: daTSRptJobCopyVol.sp,v 1.33.36.10 2020/03/27 02:00:38 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptJobCopyVol')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptJobCopyVol <<<'
	drop procedure daTSRptJobCopyVol
END
IF EXISTS (select * from GxQscripts where name='daTSRptJobCopyVol')
	delete from GxQscripts where name = 'daTSRptJobCopyVol'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptJobCopyVol')
	delete from GXDBVersions where aliasname = 'daTSRptJobCopyVol'
GO
print '... Creating Procedure: daTSRptJobCopyVol'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptJobCopyVol
  @in_taskId integer
AS
  DECLARE @o_error integer;
SET NOCOUNT ON
	DECLARE @userId					INTEGER
	DECLARE @locId					INTEGER
	DECLARE @flags					BIGINT
	DECLARE @orderBy 				INTEGER
	DECLARE	@showPrunableJob 		INTEGER = 1
	DECLARE @showUnprunableJob	 	INTEGER = 1
	DECLARE @showJobRetainedBeyondBasicRetOnly	INTEGER = 0
	DECLARE @clientOpt				INTEGER
	DECLARE @appTypeOpt				INTEGER
	DECLARE @errorCode integer
	SET @errorCode = 0
	DECLARE @media_in		 	integer
SET	@media_in = dbo.GetJobOption(@in_taskId, 1522453899)
	DECLARE @media_out		 	integer
SET	@media_out = dbo.GetJobOption(@in_taskId, 48575486)
	DECLARE @rowCount integer
	IF object_id('tempdb.dbo.#tblJobVol') IS NOT null
		DROP TABLE #tblJobVol
	CREATE TABLE #tblJobVol
	(
			archFileId 			int,
			commCellId 			int,
			copyId 				int,
			volumeId 			int,
			jobId 				int,
			fileType			int,
			pruneStatus 		int,
			dedupedSize		bigint
	)
	DECLARE @tblOpticalMedia TABLE
	(
			MediaId 		int,
			VolumeFlags int
			PRIMARY KEY (MediaId)
	)
	IF object_id('tempdb.dbo.#tblMediaInfo') IS NOT null
		DROP TABLE #tblMediaInfo
	CREATE TABLE #tblMediaInfo
	(
			SIDBStoreId		int,
			commCellId	 	int,
			LibraryId		int,
			copyId 			int,
			mediaId 		int,
			MagSizeToFree 	bigint,
			MagSizeToKeep 	bigint
			PRIMARY KEY (SIDBStoreId, commCellId, LibraryId, copyId, mediaId)
	)
	CREATE TABLE #tblMediaPruneStatus
	(
			LibraryId 	int,
			BarCode 		nvarchar(1024),
			copyId			int,
			pruneStatus int
	)
	CREATE CLUSTERED INDEX Idx_tblMediaPruneStatus_1 ON #tblMediaPruneStatus (LibraryId, copyId, pruneStatus)
	CREATE TABLE #tblStorePruneStatus
	(
			SidbStoreId			int,
			commCellId			int,
			pruneStatus 		int
			PRIMARY KEY (SidbStoreId, commCellId)
	)
	CREATE TABLE #tblVolCopyEstAgingDate
	(
			CopyId 							int,
			VolumeId 						int,
			SidbStoreId					int,
			commCellId					int,
			VolumeEstAgingDate 	bigint,
			MinVolEstAgingDate	bigint
			PRIMARY KEY (CopyId, VolumeId, SidbStoreId, commCellId)
	)
	CREATE TABLE #tblMediaEstAgingDate
	(
			SidbStoreId			int,
			commCellId			int,
			MediaId					int,
			EstAgingDate		bigint,
			MinEstAgingDate	bigint,
			PRIMARY KEY (SidbStoreId, commCellId, MediaId)
	)
	CREATE TABLE #tblStoreEstAgingDate
	(
			SidbStoreId			int,
			commCellId			int,
			EstAgingDate		bigint,
			MinEstAgingDate	bigint,
			PRIMARY KEY (SidbStoreId, commCellId)
	)
	IF object_id('tempdb.dbo.#tblNumJobperVolCopy') IS NOT null
		DROP TABLE #tblNumJobperVolCopy
	CREATE TABLE #tblNumJobperVolCopy
	(
		numJobOnStore 	INTEGER,
		numJobOnVol 	INTEGER,
		SIDBStoreId		INTEGER,
		CommCellId		INTEGER,
		volumeId 		INTEGER,
		copyId 			INTEGER
	)
	-- Get parameters
	EXEC RptOptGetUserFlags @in_taskId, @userId OUTPUT, @locId OUTPUT, @flags OUTPUT
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
SET @orderBy = (CASE WHEN (@flags & 0x80) > 0 THEN 1 ELSE 0 END)
SET @showPrunableJob = (CASE WHEN (@flags & 0x20) > 0 THEN 1 ELSE 0 END)
SET @showUnPrunableJob = (CASE WHEN (@flags & 0x40) > 0 THEN 1 ELSE 0 END)
SET	@showJobRetainedBeyondBasicRetOnly = dbo.GetJobOption(@in_taskId, 1933013597)
	/*
	-- Cannot have this since even if no jobs on SP/Copy we still need to calculate for media summary information
	SELECT @rowCount = count(*) FROM #ArchJobCopy
	IF @rowCount = 0 GOTO CX_EXIT
	*/
	delete from #CopyIdInfo
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all copies info for accurate media status information
	INSERT INTO #CopyIdInfo
	SELECT a.id, (CASE WHEN b.isSnapCopy > 0 THEN a.defaultSnapCopy ELSE a.defaultCopy END), b.id, b.type, c.fullCycles, c.retentionDays, a.name, b.name, c.flags, b.isActive
	FROM archGroup a WITH (NOLOCK), archGroupCopy b WITH (NOLOCK), archAgingRule c WITH (NOLOCK)
	WHERE a.id = b.archGroupId
	and 	b.id = c.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get info of only those appIds that are selected for processing
	INSERT INTO #AppIdInfo
	SELECT a.id, a.subclientName,
		a.appTypeId, (SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE type = a.appTypeId),
		clientId, (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = a.clientId),
		a.instance, (SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = a.instance),
		a.backupSet, (SELECT name FROM APP_BackupSetName WITH (NOLOCK) WHERE id = a.backupSet),
        (SELECT displayname FROM APP_Client WITH (NOLOCK) WHERE id = a.clientId)
	FROM APP_Application a WITH (NOLOCK)
	WHERE id IN (SELECT DISTINCT appId FROM #ArchAppCopyToBeAged WHERE appIdSelectedForProcessing = 1)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @userId > 0
	BEGIN
		IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
EXEC sec_getUserObjects @userId, 2013, 0, '#rptUserObjects'
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		delete #rptUserObjects
		WHERE clientGroupId != 0
		OR 		mediaAgentId != 0
		OR 		libraryID != 0
		OR 		archGroupID != 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		delete	#AppIdInfo
		FROM	#AppIdInfo T
		WHERE	NOT EXISTS (SELECT	*
							FROM #rptUserObjects U
							WHERE	U.clientId IN (0, T.clientId)
							AND 	U.appTypeId IN (0,T.appType)
							AND 	U.instanceId IN (0,T.instanceId)
							AND 	U.backupsetId IN (0,T.backupSetId)
							AND 	U.subClientId IN (0,T.appId)
						)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		DROP TABLE #rptUserObjects
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	-- Get Job-Volume info
	INSERT	INTO #tblJobVol
	SELECT	ACM.archFileId, ACM.commCellId, ACM.archCopyId, AC.volumeId, ACM.jobId, 0, 0, SUM(ACM.dedupedSize)
	FROM	archChunkMapping ACM WITH (NOLOCK), archchunk AC WITH (NOLOCK)
	WHERE	ACM.archChunkId = AC.id
	AND 	ACM.chunkCommCellId = AC.commCellId
	AND		(ACM.flags & 256) = 0
	GROUP BY ACM.archFileId, ACM.commCellId, ACM.archCopyId, AC.volumeId, ACM.jobId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#tblJobVol
	SET		fileType = b.fileType
	FROM	#tblJobVol a, archFile b WITH (NOLOCK)
	WHERE	a.archFileId = b.id
	AND 	a.commCellId = b.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_tblJobVol_2 ON #tblJobVol (jobId, commCellId, copyId, fileType)
	CREATE INDEX Idx_tblJobVol_3 ON #tblJobVol (volumeId)
	-- Set pruneStatus for failed/killed jobs
	UPDATE	#tblJobVol
	SET		pruneStatus = 1
	FROM	#tblJobVol a, JMJobDataStats JDS WITH (NOLOCK)
	WHERE	a.jobId = JDS.jobId
	AND		a.commCellId = JDS.commCellId
	AND		a.copyId = JDS.archGrpCopyId
	AND		a.fileType = JDS.dataType
	AND		JDS.status IN (2, 3)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get arch chunk mapping prune status
	UPDATE	#tblJobVol
	SET		pruneStatus = 1
	FROM	#tblJobVol a, #ArchJobCopy b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.copyId
	AND 	(			(b.fileType = 0)
					OR 	(a.fileType = b.fileType)
OR 	(a.fileType <> b.fileType AND a.fileType NOT IN (6, 4) AND b.fileType <> 4)
				)
	AND		b.pruneStatus = 1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set prune status for BCD Index
	UPDATE	#tblJobVol
	SET		pruneStatus = 0
	FROM	#tblJobVol a, (	SELECT jobId, commCellId, copyId, MAX(pruneStatus) AS pruneStatus
													FROM #ArchJobCopy
													GROUP BY jobId, commCellId, copyId) b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.copyId
AND 	a.fileType = 6
	AND		b.pruneStatus > 1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT	INTO #JobMediaPruneInfo
	SELECT	DISTINCT b.PruneStatus, b.jobId, b.commCellId,
			b.AppId, b.AppFlags, b.copyId, a.volumeId, '', 0, 0,
			0, 0, 0, '', 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0
	FROM	#tblJobVol a, #ArchJobCopy b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.copyId
	AND 	(			(b.fileType = 0)
					OR 	(a.fileType = b.fileType)
OR 	(a.fileType = 6 AND b.fileType IN (1, 4))
OR 	(a.fileType <> b.fileType AND a.fileType NOT IN (6, 4) AND b.fileType <> 4)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get volume info
	UPDATE #JobMediaPruneInfo
	SET 	BarCode = M.BarCode,
				MediaTypeId = M.MediaTypeId,
				LibraryId = M.LibraryId,
				MediaLocationId = M.MediaLocation,
				ExportlocationId = M.ExportlocationId,
				ContainerId = M.ContainerId,
				volumeFlags = V.VolumeFlags,
				mediaId = V.mediaId,
				MediaSideId = V.MediaSideId,
				SIDBStoreId = V.SIDBStoreId
	FROM #JobMediaPruneInfo TMP, MMVolume V WITH (NOLOCK), MMMedia M WITH (NOLOCK)
	WHERE TMP.volumeId = V.volumeId
	AND		V.MediaId = M.MediaId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get SIDB info
	UPDATE #JobMediaPruneInfo
	SET 	SIDBStoreName = SS.SIDBStoreName,
				SIDBStatus = SS.Status,
				SIDBFlags = SS.flags
	FROM #JobMediaPruneInfo TMP, IdxSIDBStore SS WITH (NOLOCK)
	WHERE TMP.SIDBStoreId = SS.SIDBStoreId
	AND		TMP.commCellId = SS.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Barcode becomes mount path for magnetic library
	-- We don't care about volumeFlags for magnetic volume, assume they are full by default
	UPDATE	#JobMediaPruneInfo
	SET		BarCode = MP.MountPathName,
				MountPathTypeId = MP.MountPathTypeId,
				VolumeFlags = 4
	FROM #JobMediaPruneInfo TMP, MMS2getMountPathNameGUIView MP  WITH (NOLOCK)
	WHERE	TMP.MediaSideId = MP.MediaSideId
AND		TMP.MediaTypeId = 10001
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get the Library Names
	UPDATE	#JobMediaPruneInfo
	SET		LibraryName = L.aliasName
	FROM #JobMediaPruneInfo TMP, MMLibrary L WITH (NOLOCK)
	WHERE	TMP.libraryId = L.libraryId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_JobMediaPruneInfo_1 ON #JobMediaPruneInfo (AppId, CopyId, AppFlags)
	CREATE INDEX Idx_JobMediaPruneInfo_2 ON #JobMediaPruneInfo (JobId, CommCellId, CopyId, AppFlags)
	CREATE INDEX Idx_JobMediaPruneInfo_3 ON #JobMediaPruneInfo (mediaId)
	CREATE INDEX Idx_JobMediaPruneInfo_4 ON #JobMediaPruneInfo (SIDBStoreId, CommCellId, VolumeId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get volume prune info
	INSERT	INTO #VolumePruneInfo
	SELECT	DISTINCT 0, TMP.BarCode, TMP.VolumeFlags,
					TMP.MediaId, TMP.MediaTypeId, TMP.MountPathTypeId,
					C.PolicyId, C.PrimaryCopyId, C.CopyId, C.CopyType,
					C.RetentionCycles, C.RetentionDays,
					C.PolicyName, C.CopyName, C.AgingRuleFlags, 0, 0,
					TMP.LibraryId, TMP.LibraryName, TMP.MediaLocationId,
					TMP.ExportlocationId, '', TMP.ContainerId, '', 0,
					TMP.commcellId, TMP.SIDBStoreId, TMP.SIDBStoreName, SIDBStatus, SIDBFlags, 0, 0
	FROM #JobMediaPruneInfo TMP, #CopyIdInfo C
	WHERE	TMP.copyId = c.copyId
	AND 	(
					(TMP.MediaLocationId != 3 AND @media_in > 0)
					OR
					(TMP.MediaLocationId = 3 AND @media_out > 0)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_VolumePruneInfo_2 ON #VolumePruneInfo (SIDBStoreId, commCellId, mediaId)
	CREATE INDEX Idx_VolumePruneInfo_3 ON #VolumePruneInfo (LibraryId, CopyId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get media size to free/ media size to keep for each mount path
	INSERT INTO #tblMediaInfo
	SELECT	b.SIDBStoreId, b.commCellId, b.libraryId, b.copyId, b.mediaId,
			SUM (CASE WHEN (t.pruneStatus = 1) THEN t.dedupedSize ELSE 0 END) AS MagSizeToFree,
			SUM (CASE WHEN (t.pruneStatus = 0) THEN t.dedupedSize ELSE 0 END) AS MagSizeToKeep
	FROM	#tblJobVol t, #VolumePruneInfo b, MMVolume v WITH (NOLOCK)
	WHERE	t.volumeId = v.volumeId
	AND		v.mediaId = b.mediaId
	AND		v.SIDBStoreId = b.SIDBStoreId
	AND		t.commCellId = b.commCellId
	AND		t.copyId = b.copyId
	GROUP	BY b.SIDBStoreId, b.commCellId, b.libraryId, b.copyId, b.mediaId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF object_id('tempdb.dbo.#tblJobVol') IS NOT null DROP TABLE #tblJobVol
	UPDATE	#VolumePruneInfo
	SET		MagSizeToFree = tmp.MagSizeToFree, MagSizeToKeep = tmp.MagSizeToKeep
	FROM	#VolumePruneInfo a, #tblMediaInfo tmp
	WHERE	a.SIDBStoreId = tmp.SIDBStoreId
	AND		a.commCellId = tmp.commCellId
	AND		a.libraryId = tmp.libraryId
	AND		a.copyId = tmp.copyId
	AND		a.mediaId = tmp.mediaId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF object_id('tempdb.dbo.#tblMediaInfo') IS NOT null DROP TABLE #tblMediaInfo
	DELETE FROM #JobMediaPruneInfo
	WHERE	mediaId NOT IN (SELECT DISTINCT mediaId FROM #VolumePruneInfo)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT	INTO @tblOpticalMedia
	SELECT	DISTINCT MediaId, VolumeFlags
	FROM	#VolumePruneInfo
WHERE	MediaTypeId > 20001
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- If one side is bad, whole tape is bad
	UPDATE	#VolumePruneInfo
	SET		VolumeFlags = 4
	WHERE	EXISTS (SELECT MediaId FROM @tblOpticalMedia WHERE mediaId = #VolumePruneInfo.mediaId and VolumeFlags = 4)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- If one side is readonly, whole tape is readonly
	UPDATE	#VolumePruneInfo
	SET		VolumeFlags = 3
	WHERE	EXISTS (SELECT MediaId FROM @tblOpticalMedia WHERE mediaId = #VolumePruneInfo.mediaId and VolumeFlags = 3)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- If one side is active, whole tape is active
	UPDATE	#VolumePruneInfo
	SET		VolumeFlags = 1
	WHERE	EXISTS (SELECT MediaId FROM @tblOpticalMedia WHERE mediaId = #VolumePruneInfo.mediaId and VolumeFlags = 1)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get the PruneStatus for each media
	INSERT	INTO #tblMediaPruneStatus
	SELECT	LibraryId, BarCode, copyId, MAX(pruneStatus)
	FROM	#JobMediaPruneInfo
	GROUP	BY LibraryId, BarCode, copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update volume prune status
	UPDATE #VolumePruneInfo
	SET PruneStatus = TMP.pruneStatus
	FROM #VolumePruneInfo T, #tblMediaPruneStatus TMP
	WHERE T.LibraryId = TMP.LibraryId
	AND		T.BarCode = TMP.BarCode
	AND		T.copyId = TMP.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF object_id('tempdb.dbo.#tblMediaPruneStatus') IS NOT null DROP TABLE #tblMediaPruneStatus
	-- Set the updated volumeFlags
	UPDATE #JobMediaPruneInfo
	SET VolumeFlags = TMP.VolumeFlags,
			MediaPruneStatus = TMP.PruneStatus
	FROM #JobMediaPruneInfo T, #VolumePruneInfo TMP
	WHERE T.mediaId = TMP.mediaId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate Volume Estimated Aging Time
	INSERT	INTO #tblVolCopyEstAgingDate
	SELECT	JC.CopyId, JV.VolumeId, JV.SIDBStoreId, JV.CommCellId, max(JC.estimatedAgingDate), min(JC.estimatedAgingDate)
	FROM	#JobMediaPruneInfo JV, #ArchJobCopy JC
	WHERE	JV.copyId = JC.copyId
	AND 	JV.CommcellId = JC.CommcellId
	AND 	JV.JobId = JC.JobId
	GROUP BY JC.copyId, JV.volumeId, JV.SIDBStoreId, JV.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblVolCopyEstAgingDate
	SET		VolumeEstAgingDate = MinVolEstAgingDate
	WHERE	MinVolEstAgingDate = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #JobMediaPruneInfo
	SET		VolumeEstAgingDate = b.VolumeEstAgingDate
	FROM	#JobMediaPruneInfo a, #tblVolCopyEstAgingDate b
	WHERE	a.copyId = b.copyId
	AND		a.volumeId = b.volumeId
	AND		a.SIDBStoreId = b.SIDBStoreId
	AND		a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF object_id('tempdb.dbo.#tblVolCopyEstAgingDate') IS NOT null DROP TABLE #tblVolCopyEstAgingDate
	-- Calculate Media Estimated Aging Time
	INSERT INTO #tblMediaEstAgingDate
			(SIDBStoreId, CommCellId, MediaId, EstAgingDate, MinEstAgingDate)
	SELECT SIDBStoreId, CommCellId, mediaId, max(VolumeEstAgingDate), min(VolumeEstAgingDate)
	FROM #JobMediaPruneInfo
	GROUP BY SIDBStoreId, CommCellId, mediaId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#tblMediaEstAgingDate
	SET		EstAgingDate = MinEstAgingDate
	WHERE	MinEstAgingDate = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#VolumePruneInfo
	SET		MediaEstAgingDate = b.EstAgingDate
	FROM	#VolumePruneInfo a, #tblMediaEstAgingDate b
	WHERE	a.SIDBStoreId = b.SIDBStoreId
	AND		a.CommCellId = b.CommCellId
	AND		a.MediaId = b.MediaId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF object_id('tempdb.dbo.#tblMediaEstAgingDate') IS NOT null DROP TABLE #tblMediaEstAgingDate
	-- Calculate SIDB Store Estimated Aging Time
	INSERT INTO #tblStoreEstAgingDate
			(SidbStoreId, commCellId, EstAgingDate, MinEstAgingDate)
	SELECT	SidbStoreId, commCellId, max(VolumeEstAgingDate), min(VolumeEstAgingDate)
	FROM #JobMediaPruneInfo
	GROUP BY SidbStoreId, commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#tblStoreEstAgingDate
	SET		EstAgingDate = MinEstAgingDate
	WHERE	MinEstAgingDate = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #JobMediaPruneInfo
	SET		StoreEstAgingDate = b.EstAgingDate
	FROM	#JobMediaPruneInfo a, #tblStoreEstAgingDate b
	WHERE	a.SidbStoreId = b.SidbStoreId
	AND		a.commCellId = b.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#VolumePruneInfo
	SET		StoreEstAgingDate = b.EstAgingDate
	FROM	#VolumePruneInfo a, #tblStoreEstAgingDate b
	WHERE	a.SidbStoreId = b.SidbStoreId
	AND		a.commCellId = b.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF object_id('tempdb.dbo.#tblStoreEstAgingDate') IS NOT null DROP TABLE #tblStoreEstAgingDate
	--Get Store prune status
	INSERT	INTO #tblStorePruneStatus
	SELECT	SIDBStoreId, commCellId, MAX(pruneStatus)
	FROM	#JobMediaPruneInfo
	GROUP	BY SIDBStoreId, commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update store prune status
	UPDATE #JobMediaPruneInfo
	SET StorePruneStatus = TMP.pruneStatus
	FROM #JobMediaPruneInfo T, #tblStorePruneStatus TMP
	WHERE	T.SidbStoreId = TMP.SidbStoreId
	AND		T.commCellId = TMP.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update store prune status
	UPDATE #VolumePruneInfo
	SET StorePruneStatus = TMP.pruneStatus
	FROM #VolumePruneInfo T, #tblStorePruneStatus TMP
	WHERE	T.SidbStoreId = TMP.SidbStoreId
	AND		T.commCellId = TMP.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF object_id('tempdb.dbo.#tblStorePruneStatus') IS NOT null DROP TABLE #tblStorePruneStatus
	UPDATE	#VolumePruneInfo
	SET		ExportLocation = E.ExportLocation
	FROM	#VolumePruneInfo V, MMExportLocation E WITH (NOLOCK)
	WHERE	V.mediaLocationId = 3
	AND		V.ExportlocationId <> 0
	AND		E.ExportLocationId = V.ExportLocationId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#VolumePruneInfo
	SET		ContainerName = C.ContainerName
	FROM	#VolumePruneInfo V, MMContainer C WITH (NOLOCK)
	where	C.containerId = V.containerId
	AND		V.containerId <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Only choose one volume for a given job/copy and store combination
	-- when job/copy is saved on magnetic disk
	DELETE #JobMediaPruneInfo
	FROM	#JobMediaPruneInfo J, (SELECT JobId, CommCellId, AppFlags, CopyId, SIDBStoreId, max(VolumeId) as VolumeId
								   FROM	#JobMediaPruneInfo
WHERE MediaTypeId = 10001
								   GROUP BY JobId, CommCellId, AppFlags, CopyId, SIDBStoreId) M
		WHERE	J.JobId = M.JobId
		AND		J.CommCellId = M.CommCellId
		AND		J.AppFlags= M.AppFlags
		AND		J.CopyId = M.CopyId
		AND		J.SIDBStoreId = M.SIDBStoreId
		AND		J.VolumeId != M.VolumeId
AND		J.MediaTypeId = 10001
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Remove the jobs that cannot be displayed due to security filters
	delete #JobMediaPruneInfo
	FROM #JobMediaPruneInfo A, #ArchAppCopyToBeAged AC
	WHERE	A.AppId = AC.AppId
	AND A.CopyId = AC.CopyId
	AND	A.appflags = AC.appflags
	AND AC.appIdSelectedForPruning = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	delete #JobMediaPruneInfo
	FROM #JobMediaPruneInfo A LEFT OUTER JOIN #AppIdInfo APP
	ON A.AppId = APP.appId
	WHERE APP.appId IS null
	OR (pruneStatus = 1 AND @showPrunableJob = 0)
	OR (pruneStatus != 1 AND @showUnPrunableJob = 0)
	IF @showJobRetainedBeyondBasicRetOnly != 0
	BEGIN
		--Remove all the jobs that are retained based on basic days retention (Days\Infinite\Job Based retention)
		DELETE #JobMediaPruneInfo
		FROM #JobMediaPruneInfo a, #ArchJobCopy b
		WHERE	a.jobId = b.jobId
		AND		a.commCellId = b.commCellId
		AND		a.copyId = b.copyId
		AND 	a.appflags = b.appflags
AND		(b.jobRetainReason & (16 | 2 | 4194304)) > 0
	END
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @orderBy != 1 --Order by Copy
	BEGIN
		INSERT INTO #tblNumJobperVolCopy
		SELECT	0, count(*), SIDBStoreId, CommCellId, volumeId, CopyId
		FROM	#JobMediaPruneInfo
		GROUP	BY SIDBStoreId, CommCellId, volumeId, CopyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tblNumJobperVolCopy
		SET		numJobOnStore = b.numJobOnStore
		FROM	#tblNumJobperVolCopy a,
				(SELECT SUM(T.numJobOnVol) as numJobOnStore, T.SIDBStoreId AS SIDBStoreId, T.CommCellId AS CommCellId, T.copyId AS copyId
				FROM	#tblNumJobperVolCopy T
				GROUP	BY T.SIDBStoreId, T.CommCellId, T.copyId
				) b
		WHERE	a.SIDBStoreId = b.SIDBStoreId
		AND		a.CommCellId = b.CommCellId
		AND		a.copyId = b.copyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #JobMediaPruneInfo
		SET		NumJobonStoreCopy = b.numJobOnStore,
					NumJobonVolCopy = b.numJobOnVol
		FROM	#JobMediaPruneInfo a, #tblNumJobperVolCopy b
		WHERE	a.SIDBStoreId = b.SIDBStoreId
		AND		a.commCellId = b.commCellId
		AND		a.volumeId = b.volumeId
		AND		a.copyId = b.copyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF object_id('tempdb.dbo.#tblJobVol') IS NOT null DROP TABLE #tblJobVol
	IF object_id('tempdb.dbo.#tblMediaInfo') IS NOT null DROP TABLE #tblMediaInfo
	IF object_id('tempdb.dbo.#tblMediaPruneStatus') IS NOT null DROP TABLE #tblMediaPruneStatus
	IF object_id('tempdb.dbo.#tblStorePruneStatus') IS NOT null DROP TABLE #tblStorePruneStatus
	IF object_id('tempdb.dbo.#tblVolCopyEstAgingDate') IS NOT null DROP TABLE #tblVolCopyEstAgingDate
	IF object_id('tempdb.dbo.#tblMediaEstAgingDate') IS NOT null DROP TABLE #tblMediaEstAgingDate
	IF object_id('tempdb.dbo.#tblStoreEstAgingDate') IS NOT null DROP TABLE #tblStoreEstAgingDate
	IF object_id('tempdb.dbo.#tblNumJobperVolCopy') IS NOT null DROP TABLE #tblNumJobperVolCopy
	SELECT @errorCode
	RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptJobCopyVol')
	delete from GxQscripts where name = 'daTSRptJobCopyVol'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptJobCopyVol')
	delete from GXDBVersions where aliasname = 'daTSRptJobCopyVol'
GO

insert into GXDBVersions values(2, 'daTSRptJobCopyVol',  '00010033003600100000', 'daTSRptJobCopyVol', '00010033003600100000')
GO

