

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptExtRetUpdate.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daTSRptExtRetUpdate()
--  | Description:  1. Retention flags should be marked for child-logs
--	|				   of selective online full.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptExtRetUpdate.sp,v $ $Id: daTSRptExtRetUpdate.sp,v 1.6.290.1 2018/03/22 03:18:06 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptExtRetUpdate <<<'

IF EXISTS (select * from sysobjects where name='daTSRptExtRetUpdate')
	drop procedure daTSRptExtRetUpdate
IF EXISTS (select * from GxQscripts where name='daTSRptExtRetUpdate')
	delete from GxQscripts where name = 'daTSRptExtRetUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptExtRetUpdate')
	delete from GXDBVersions where aliasname = 'daTSRptExtRetUpdate'
GO
print '... Creating Procedure: daTSRptExtRetUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptExtRetUpdate
  @dummy INTEGER
AS
  DECLARE @o_numJobRetained integer;
	SET NOCOUNT ON
	DECLARE @numJobRetained	INTEGER
	SET		@numJobRetained	= 0
	DECLARE	@tblJobSelOnline TABLE (
			jobId int,
			copyId int,
			dataType int,
			commCellId int,
			retentionFlags int,
			primary key (jobId, copyId, dataType, commCellId)
			)
	-- Retention flags should be marked for child-logs of selective online full
	-- This is for both Oracle and SAP Selective Online Full
	INSERT	INTO @tblJobSelOnline
	SELECT	b.childJobId, a.copyId, 0, a.commCellId,
	(MAX(a.retentionFlags & 1) | MAX(a.retentionFlags & 2) | MAX(a.retentionflags & 4) | MAX(a.retentionFlags & 8) |
	 MAX(a.retentionFlags & 16) | MAX(a.retentionFlags & 32) | MAX(a.retentionFlags & 64) | MAX(a.retentionFlags & 256) |
	 MAX(a.retentionFlags & 512) | MAX(a.retentionFlags & 1024) | MAX(a.retentionFlags & 2048) | MAX(a.retentionFlags & 4096) |
	 MAX(a.retentionFlags & 8192) | MAX(a.retentionFlags & 16384) | MAX(a.retentionFlags & 32768) | MAX(a.retentionFlags & 65536) |
	 MAX(a.retentionFlags & 131072) | MAX(a.retentionFlags & 262144) | MAX(a.retentionFlags & 524288) |
	 MAX(a.retentionFlags & 1048576) | MAX(a.retentionFlags & 2097152) | MAX(a.retentionFlags & 4194304) | MAX(a.retentionFlags & 8388608))
FROM	#archJobCopyExtendedRpt a, JMJobDataLink b
	WHERE	a.retentionFlags > 0
	AND		a.jobId = b.parentJobId
	AND		a.commCellId = b.commCellId
	GROUP BY b.childJobId, a.copyId, a.commCellId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#DA_JobCopyList
SET		jobRetainReason = jobRetainReason | 128
FROM	 #DA_JobCopyList a,  #archJobCopyExtendedRpt b
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.CopyId = b.copyId
AND		((b.dataType = 0) OR (b.dataType = 1 AND a.fileType <> 4) OR (b.dataType = 4 AND a.fileType IN (4, 6)))
IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Retain Index Archive File after Snap Movement to tape until Data/Log are extended retained
UPDATE	#DA_JobCopyList
SET		jobRetainReason = jobRetainReason | 128
FROM	 #DA_JobCopyList a,  #archJobCopyExtendedRpt b, archFile AF WITH (NOLOCK)
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
AND		b.dataType = 4
	AND		a.jobId = AF.jobId
	AND		a.commCellId = AF.commCellId
AND 	AF.fileType = 2
AND		(AF.flags & (4 | 4096)) > 0
	AND		a.CopyId = b.copyId
	AND		a.fileType = AF.fileType
IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- DO NOT join on dataType since SAP for MaxDB can have data or logs as child jobs
UPDATE	#DA_JobCopyList
SET		jobRetainReason = jobRetainReason | 128
FROM	#DA_JobCopyList a, @tblJobSelOnline b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.CopyId = b.copyId
--	AND		a.fileType = b.dataType
IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	UPDATE	#ArchJobCopy
	SET		extRetentionFlags = b.retentionflags,
jobRetainReason = jobRetainReason | 128
	FROM	#ArchJobCopy a, #archJobCopyExtendedRpt b
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.copyId = b.copyId
AND		((b.dataType = 0) OR (b.dataType = 1 AND a.FileType <> 4) OR (b.dataType = 4 AND a.FileType IN (4, 6)))
	AND		a.commCellId = b.commCellId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	UPDATE	#ArchJobCopy
	SET		extRetentionFlags = b.retentionflags,
jobRetainReason = jobRetainReason | 128
	FROM	#ArchJobCopy a, @tblJobSelOnline b
	WHERE	a.jobId = b.jobId
	AND		a.copyId = b.copyId
--	AND		a.FileType = b.dataType
	AND		a.commCellId = b.commCellId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
-- Remove duplicated jobid to get the right number of jobs selected
DELETE	@tblJobSelOnline
FROM	@tblJobSelOnline a, #archJobCopyExtendedRpt b
WHERE	a.jobId = b.jobId
AND		a.copyId = b.copyId
AND		a.commCellId = b.commCellId
SET		@numJobRetained	= (SELECT COUNT(*) FROM @tblJobSelOnline) +
(SELECT COUNT(*) FROM  #archJobCopyExtendedRpt WHERE retentionFlags > 0)
CX_EXIT:
	--COMMIT TRANSACTION TranExtRetUpdate
	SELECT @numJobRetained
	RETURN
CX_ERROR_EXIT:
	--ROLLBACK TRANSACTION TranExtRetUpdate
	SELECT -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptExtRetUpdate')
	delete from GxQscripts where name = 'daTSRptExtRetUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptExtRetUpdate')
	delete from GXDBVersions where aliasname = 'daTSRptExtRetUpdate'
GO

insert into GXDBVersions values(2, 'daTSRptExtRetUpdate',  '00010006029000010000', 'daTSRptExtRetUpdate', '00010006029000010000')
GO

