

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptEstAgingDate.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptEstAgingDate.sp,v $ $Id: daTSRptEstAgingDate.sp,v 1.21.80.7 2019/12/12 19:18:20 pkrishnan Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptEstAgingDate()
--  |
--  | Description: Calculate Estimated Aging Date
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptEstAgingDate')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptEstAgingDate <<<'
	drop procedure daTSRptEstAgingDate
END
IF EXISTS (select * from GxQscripts where name='daTSRptEstAgingDate')
	delete from GxQscripts where name = 'daTSRptEstAgingDate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptEstAgingDate')
	delete from GXDBVersions where aliasname = 'daTSRptEstAgingDate'
GO
print '... Creating Procedure: daTSRptEstAgingDate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptEstAgingDate
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @currentTime INTEGER
	SET 		@currentTime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @AP_PRUNE_PRUNABLE INTEGER
	SET			@AP_PRUNE_PRUNABLE = 1
	DECLARE @dayInSeconds INTEGER
	SET			@dayInSeconds = 24 * 3600
	DECLARE	@RetentionDaysWhenCyclesIgnored		INTEGER
	SET			@RetentionDaysWhenCyclesIgnored		= 30
	DECLARE	@RetainDependentJobsInCycle	INTEGER
	SET			@RetainDependentJobsInCycle	= 1
	if object_id('tempdb.dbo.#AppCopyLastJobInCycle') is not null DROP TABLE #AppCopyLastJobInCycle
	CREATE TABLE #AppCopyLastJobInCycle(
			AppId int,
			CopyId int,
			FullCycleNum int,
			StartTime int
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	if object_id('tempdb.dbo.#tblJobCopyExtended') is not null DROP TABLE #tblJobCopyExtended
	CREATE TABLE #tblJobCopyExtended (
			JobId 			int,
			CopyId 			int,
			Commcellid 		int,
			ExtAgingDate	bigint
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	if object_id('tempdb.dbo.#tblJobsOnStore') is not null DROP TABLE #tblJobsOnStore
	CREATE TABLE #tblJobsOnStore (
			SIDBStoreId 	int,
			CommCellId 		int,
			JobId			int,
			archCopyId		int,
			EstAgingDate	bigint
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	if object_id('tempdb.dbo.#tblStoreEstAgingDate') is not null DROP TABLE #tblStoreEstAgingDate
	CREATE TABLE #tblStoreEstAgingDate (
			SIDBStoreId 	int,
			CommCellId 		int,
			EstAgingDate	bigint
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	if object_id('tempdb.dbo.#tblSILOJobsVolumeStore') is not null DROP TABLE #tblSILOJobsVolumeStore
	CREATE TABLE #tblSILOJobsVolumeStore (
			JobId			int,
			CommCellId 		int,
			SiloVolumeId	int,
			SIDBStoreId 	int,
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	if object_id('tempdb.dbo.#tblSILOJobsOnStore') is not null DROP TABLE #tblSILOJobsOnStore
	CREATE TABLE #tblSILOJobsOnStore (
			SIDBStoreId 	int,
			CommCellId 		int,
			JobId			int,
			EstAgingDate	bigint
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	if object_id('tempdb..#tblVSAJobAgingDate') is not null DROP TABLE #tblVSAJobAgingDate
	CREATE TABLE #tblVSAJobAgingDate (
			ParentVSAJobId 	int,
			CommCellId 			int,
			CopyId 					int,
			EstAgingDate		bigint,
			PRIMARY KEY (ParentVSAJobId, CommCellId, CopyId)
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	if object_id('tempdb.dbo.#tblReqCycles') is not null DROP TABLE #tblReqCycles
	CREATE TABLE #tblReqCycles (
			AppId int, CopyId int, FileType int, CommCellId int,
			JobId int, StartTime int, fullCycleNum int,
			retainIncrBeforeDiff int, lastDiffStartTime int,
			isFullJobCWE int, isFullJobCS int,
			retentionDays int, retentionCycles int,
			manualRetentionEndTime bigint
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_tblReqCycles_1 ON #tblReqCycles (AppId, CopyId, FileType, fullCycleNum)
	SELECT @RetentionDaysWhenCyclesIgnored = isnull(value, 30)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @RetainDependentJobsInCycle = isnull(value, 1)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETAIN_DEPENDENT_JOBS_IN_CYCLE_FOR_PINNED_JOBS'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	DECLARE @computeVSAJobRetention int = 0
	SELECT @computeVSAJobRetention = ISNULL(value, 0)
	FROM MMConfigs WITH(NOLOCK)
	WHERE name = 'MMCONFIG_COMPUTE_VSA_JOB_RETENTION_BASED_ON_VM_JOBS'
	IF @computeVSAJobRetention = 1
	BEGIN
	  INSERT INTO	#AppCopyLastJobInCycle (AppId, CopyId, FullCycleNum, StartTime)
	  SELECT	AppId, CopyId, FullCycleNum, max(StartTime)
	  FROM	#ArchJobCopy
WHERE	(FileType & 4) = 0
AND		(appFlags & 2048) = 0
AND		(appFlags & 1048576) = 0
AND		(appFlags & CAST(2147483648 AS bigint)) = 0	/*For VSA V2 parent jobs there is no dependency with last job in the cycle*/
	  GROUP 	BY AppId, CopyId, FullCycleNum
       	  SET	@errorCode	=	@@ERROR
	  IF	@errorCode != 0 GOTO CX_EXIT
	END
	ELSE
	BEGIN
	  INSERT INTO	#AppCopyLastJobInCycle (AppId, CopyId, FullCycleNum, StartTime)
	  SELECT	AppId, CopyId, FullCycleNum, max(StartTime)
	  FROM	#ArchJobCopy
WHERE	(FileType & 4) = 0
AND		(appFlags & 2048) = 0
AND		(appFlags & 1048576) = 0
	  GROUP 	BY AppId, CopyId, FullCycleNum
       	  SET	@errorCode	=	@@ERROR
	  IF	@errorCode != 0 GOTO CX_EXIT
	END
	CREATE INDEX Idx_AppCopyLastJobInCycle ON #AppCopyLastJobInCycle (AppId, CopyId, FullCycleNum)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate Estimated Aging Date for Archiver agent jobs or days based subclients
	UPDATE	#ArchJobCopy
	SET			estimatedAgingDate =
CASE WHEN jobRetainReason & (2 + 4) > 0 THEN -1
							ELSE StartTime + retentionDays * @dayInSeconds
						END
	FROM		#ArchJobCopy
	WHERE		pruneStatus & @AP_PRUNE_PRUNABLE = 0
AND			(FileType & 4) = 0
AND			((appFlags & 2048) > 0 OR (appFlags & 1048576) > 0)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate Estimated Aging Date for Data
	UPDATE	#ArchJobCopy
	SET			estimatedAgingDate =
CASE WHEN a.jobRetainReason & (2 + 4) > 0 THEN -1
							ELSE b.StartTime + a.retentionDays * @dayInSeconds
						END
	FROM		#ArchJobCopy a, #AppCopyLastJobInCycle b
	WHERE		b.AppId = a.AppId
	AND			b.CopyId = a.CopyId
	AND			b.FullCycleNum = a.FullCycleNum
AND			(a.FileType & 4) = 0
	AND			a.pruneStatus & @AP_PRUNE_PRUNABLE = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set Estimated Aging Date for Foreign Data Jobs as INFINITE
	UPDATE	#ArchJobCopy
	SET			estimatedAgingDate = -1
	WHERE		pruneStatus & @AP_PRUNE_PRUNABLE = 0
AND			jobRetainReason & 2097152 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate Log Estimated Aging Date
	UPDATE	#ArchJobCopy
	SET			estimatedAgingDate =
CASE WHEN a.jobRetainReason & (2 + 4) > 0 THEN -1
							ELSE a.StartTime + a.retentionDays*@dayInSeconds
						END
	FROM		#ArchJobCopy a
	WHERE		a.pruneStatus & @AP_PRUNE_PRUNABLE = 0
AND			(a.FileType & 4) > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #tblJobCopyExtended (JobId, CopyId, Commcellid, ExtAgingDate)
	SELECT	a.JobId, a.CopyId, a.Commcellid, CASE WHEN (MIN(b.retentionDays) = -1) THEN (CAST(-1 AS BIGINT)) ELSE (CAST(MAX(b.retentionDays) AS BIGINT) * @dayInSeconds) END
	FROM	#ArchJobCopy a, archAgingRuleExtended b WITH (NOLOCK)
	WHERE	a.pruneStatus & @AP_PRUNE_PRUNABLE = 0
	AND		a.extRetentionFlags > 0
	AND		b.copyId = a.copyId
	AND		(
				((b.retentionRule & a.extRetentionFlags) > 0)
				OR
				((b.retentionRule & 262144) > 0 AND (a.extRetentionFlags & 4194304) > 0)		-- EXTENDED_GRACE_HOUR
				OR
				((b.retentionRule & 524288) > 0 AND (a.extRetentionFlags & 8388608) > 0)		-- EXTENDED_GRACE_DAY
				OR
				((b.retentionRule & 4) > 0 AND (a.extRetentionFlags & 256) > 0)					-- EXTENDED_GRACE_WEEK
				OR
				((b.retentionRule & 8) > 0 AND (a.extRetentionFlags & 512) > 0)					-- EXTENDED_GRACE_MONTH
				OR
				((b.retentionRule & 16) > 0 AND (a.extRetentionFlags & 1024) > 0)				-- EXTENDED_GRACE_QUARTER
				OR
				((b.retentionRule & 32) > 0 AND (a.extRetentionFlags & 2048) > 0)				-- EXTENDED_GRACE_HALFYEAR
				OR
				((b.retentionRule & 64) > 0 AND (a.extRetentionFlags & 4096) > 0)				-- EXTENDED_GRACE_YEAR
			)
	GROUP BY	a.JobId, a.CopyId, a.Commcellid
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblJobCopyExtended
	SET		 ExtAgingDate = CASE WHEN (a.ExtAgingDate = -1) THEN a.ExtAgingDate ELSE (a.ExtAgingDate + b.StartTime) END
	FROM	#tblJobCopyExtended a, #ArchJobCopy b
	WHERE	b.JobId = a.JobId
	AND		b.copyId = a.copyId
	AND		b.CommcellId = a.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#ArchJobCopy
	SET			estimatedAgingDate =
						case when b.ExtAgingDate = -1 then -1
								 when a.estimatedAgingDate >= b.ExtAgingDate then a.estimatedAgingDate
								else b.ExtAgingDate
						end
	FROM		#ArchJobCopy a, #tblJobCopyExtended b
	WHERE		a.pruneStatus & @AP_PRUNE_PRUNABLE = 0
	AND			a.JobId = b.JobId
	AND			a.EstimatedAgingDate != -1
	AND			a.CopyId = b.CopyId
	AND			a.Commcellid = b.Commcellid
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @computeVSAJobRetention = 1
	BEGIN
		DECLARE @timeNow BIGINT = dbo.GetUnixTime(GETUTCDATE())
		--For VSA parents jobs set estimated aging date to be current time. Then we will override with manual retention or child job retention whichever is higher
		UPDATE	#ArchJobCopy
		SET estimatedAgingDate = @timeNow
WHERE (appFlags & CAST(2147483648 AS bigint)) > 0
	END
	-- Update for manuall retained jobs
	UPDATE	#ArchJobCopy
	SET		estimatedAgingDate =
				CASE WHEN b.manualRetentionEndTime = -1 THEN -1
						WHEN b.manualRetentionEndTime > a.estimatedAgingDate THEN b.manualRetentionEndTime
						ELSE a.estimatedAgingDate
				END
	FROM	#ArchJobCopy a, JMJobDataStats b WITH (NOLOCK)
	WHERE	a.ManualRet > 0
	AND		b.JobId = a.JobId
	AND		b.archGrpCopyId = a.CopyId
	AND		b.CommCellId = a.CommCellId
	AND		a.EstimatedAgingDate != -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @RetainDependentJobsInCycle = 1
	BEGIN
		IF @computeVSAJobRetention = 1
		BEGIN
		  -- Get the last job on each copy and cycle that is retaind by manual retention
		  INSERT	INTO #tblReqCycles
		  SELECT DISTINCT AppId, CopyId, FileType, 0, 0, MAX(StartTime), fullCycleNum, 1, 0, 0, 0, 0, 0, 0
		  FROM	#ArchJobCopy
WHERE jobRetainReason & 256 = 256
AND		appFlags & 2 > 0
AND		appFlags & CAST(2147483648 AS bigint) = 0
		  GROUP BY AppId, CopyId, FileType, fullCycleNum
		  SET	@errorCode	=	@@ERROR
		  IF	@errorCode != 0 GOTO CX_EXIT
		END
		ELSE
		BEGIN
		   -- Get the last job on each copy and cycle that is retaind by manual retention
		  INSERT	INTO #tblReqCycles
		  SELECT DISTINCT AppId, CopyId, FileType, 0, 0, MAX(StartTime), fullCycleNum, 1, 0, 0, 0, 0, 0, 0
		  FROM	#ArchJobCopy
WHERE jobRetainReason & 256 = 256
AND		appFlags & 2 > 0
		  GROUP BY AppId, CopyId, FileType, fullCycleNum
		  SET	@errorCode	=	@@ERROR
		  IF	@errorCode != 0 GOTO CX_EXIT
		END
		UPDATE #tblReqCycles
		SET commCellId = b.commCellId,
		jobId = b.JobId
		FROM #tblReqCycles a, #ArchJobCopy b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.StartTime = b.StartTime
		AND		a.fullCycleNum = b.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Check the JobStatus of corresponding Full job if it is CWE / Custom Scripts Job
		UPDATE #tblReqCycles
		SET isFullJobCWE = CASE WHEN (b.JobStatus IN (3)) THEN 1 ELSE 0 END,
isFullJobCS = CASE WHEN (b.JobFlags & 16777216 > 0 AND b.JobFlags & 8388608 = 0) THEN 1 ELSE 0 END
		FROM #tblReqCycles a, #ArchJobCopy b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.fullCycleNum = b.fullCycleNum
		AND		b.BkpLevel = 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tblReqCycles
		SET retentionDays = CASE WHEN ((a.isFullJobCS = 1 OR (a.isFullJobCWE = 1 AND b.isCWEjobValid != 1)) AND b.retentionDays = 0 AND b.retentionCycles > 0) THEN @RetentionDaysWhenCyclesIgnored ELSE b.retentionDays END,
			retentionCycles = CASE WHEN ((a.isFullJobCS = 1 OR (a.isFullJobCWE = 1 AND b.isCWEjobValid != 1)) AND b.retentionDays = 0 AND b.retentionCycles > 0) THEN 0 ELSE b.retentionCycles END,
			retainIncrBeforeDiff = b.retainIncrBeforeDiff
		FROM #tblReqCycles a, #ArchAppCopyToBeAged b
		WHERE a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tblReqCycles
		SET manualRetentionEndTime = b.manualRetentionEndTime
		FROM #tblReqCycles a, JMJobDataStats b WITH (NOLOCK)
		WHERE	a.JobId = b.JobId
		AND		a.CommCellId = b.CommCellId
		AND		a.CopyId = b.archGrpCopyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		/*
		--Commenting this for now
		--Retain entire cycle based on the latest job pinned in the cycle
		--Do not honor retainIncrBeforeDiff option
		--Since there could be multiple pinned jobs and applying rule	for eack pinned jobs in a cycle will require CURSOR FOR LOOP which may cause performance issues
		UPDATE #tblReqCycles
		SET lastDiffStartTime = b.lastDiffStartTime
		FROM #tblReqCycles a,
					(SELECT T.AppId, T.CopyId, T.fileType, T.fullCycleNum, MAX(T.StartTime) AS lastDiffStartTime
						FROM #ArchJobCopy T, #tblReqCycles T1
						WHERE T.DataStatus = 100
						AND		T.BkpLevel = 4
						AND		T.AppId = T1.AppId
						AND 	T.CopyId = T1.CopyId
						AND 	T.FileType = T1.FileType
						AND		T.fullCycleNum = T1.fullCycleNum
						AND		T.StartTime <= T1.StartTime
						GROUP BY T.AppId, T.CopyId, T.fileType, T.fullCycleNum) b
		WHERE a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.fullCycleNum = b.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		*/
		UPDATE	#ArchJobCopy
		SET		estimatedAgingDate =
					CASE WHEN b.manualRetentionEndTime = -1 THEN -1
							WHEN b.manualRetentionEndTime > a.estimatedAgingDate THEN b.manualRetentionEndTime
							ELSE a.estimatedAgingDate
					END
		FROM	#ArchJobCopy a, #tblReqCycles b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND 	a.CommCellId = b.CommCellId
		AND		a.StartTime < b.StartTime
		AND		a.fullCycleNum = b.fullCycleNum
		AND		(b.retainIncrBeforeDiff = 1 OR b.lastDiffStartTime = 0)
		AND		(b.retentionDays > 0 OR b.retentionCycles > 0)
AND 	(a.appFlags & 1048576 = 0)
AND		(a.appFlags & 2048) = 0
		AND		a.EstimatedAgingDate != -1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	#ArchJobCopy
		SET		estimatedAgingDate =
					CASE WHEN b.manualRetentionEndTime = -1 THEN -1
							WHEN b.manualRetentionEndTime > a.estimatedAgingDate THEN b.manualRetentionEndTime
							ELSE a.estimatedAgingDate
					END
		FROM	#ArchJobCopy a, #tblReqCycles b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND 	a.CommCellId = b.CommCellId
		AND		a.StartTime < b.StartTime
		AND		a.fullCycleNum = b.fullCycleNum
		AND		b.retainIncrBeforeDiff = 0
		AND		b.lastDiffStartTime > 0
		AND		(a.BkpLevel = 1 OR a.StartTime >= b.lastDiffStartTime)
		AND		(b.retentionDays > 0 OR b.retentionCycles > 0)
AND 	(a.appFlags & 1048576 = 0)
AND		(a.appFlags & 2048) = 0
AND		(a.appFlags & 1048576) = 0
		AND		a.EstimatedAgingDate != -1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	IF @computeVSAJobRetention = 1
	BEGIN
	  /*
	  Any new logic to calculate retention end time that can impact retention end time of child VM jobs should be above this, as that impacts parent's retention end time
	  */
	  INSERT INTO #tblVSAJobAgingDate
	  SELECT a.jobId, a.commcellId, a.copyId, CASE WHEN MIN(b.estimatedAgingDate) = -1 THEN -1 ELSE MAX(b.estimatedAgingDate) END
	  FROM #ArchJobCopy a INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON a.jobId = JDL.parentJobId AND a.commcellId = JDL.commcellId
	  INNER JOIN #ArchJobCopy b ON JDL.childJobId = b.jobId AND JDL.commcellId = b.commcellId AND a.copyId = b.copyId
WHERE JDL.linkType IN (7, 8)
	  AND	a.pruneStatus & @AP_PRUNE_PRUNABLE = 0
	  AND	b.pruneStatus & @AP_PRUNE_PRUNABLE = 0
	  GROUP BY a.jobId, a.commcellId, a.copyId
	  SET	@errorCode	=	@@ERROR
	  IF	@errorCode != 0 GOTO CX_EXIT
	  UPDATE #ArchJobCopy
	  SET estimatedAgingDate = T.estAgingDate
	  FROM  #ArchJobCopy a INNER JOIN #tblVSAJobAgingDate T ON a.jobId = T.ParentVSAJobId AND a.commcellId = T.commcellId AND a.copyId = T.copyId
	  WHERE a.estimatedAgingDate != -1 and (T.estAgingDate = -1 OR a.estimatedAgingDate < T.estAgingDate)
	  SET	@errorCode	=	@@ERROR
	  IF	@errorCode != 0 GOTO CX_EXIT
	END
	-- Calculate the Estimated Aging Date for SILO Tape Backup Jobs
	INSERT INTO #tblJobsOnStore
	SELECT JOS.StoreId, JOS.commCellId, JOS.JobId, JOS.archCopyId, CASE WHEN MIN(a.estimatedAgingDate) = -1 THEN -1 ELSE MAX(a.estimatedAgingDate) END
	FROM archJobsOnStoreInfo JOS WITH (NOLOCK), #ArchJobCopy a
	WHERE JOS.JobId = a.jobId
	AND		JOS.commCellId = a.commCellId
	AND		JOS.archCopyId = a.CopyId
	GROUP BY JOS.StoreId, JOS.commCellId, JOS.JobId, JOS.archCopyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #tblStoreEstAgingDate
	SELECT JOS.SIDBStoreId, JOS.commCellId, CASE WHEN MIN(JOS.EstAgingDate) = -1 THEN -1 ELSE MAX(JOS.EstAgingDate) END
	FROM #tblJobsOnStore JOS
	GROUP BY JOS.SIDBStoreId, JOS.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Estimated Aging Date for SILO Tape Backup Jobs will be same across all copies (if they are aux copied)
	INSERT INTO #tblSILOJobsVolumeStore
	SELECT DISTINCT AF.JobId, AF.commCellId, AFSV.siloVolumeId, 0
	FROM archFile AF WITH (NOLOCK), archFileSiloVolume AFSV WITH (NOLOCK), #ArchJobCopy a
	WHERE AF.Id = AFSV.archFileId
	AND		AF.commCellId = AFSV.commCellId
	AND		AF.jobId = a.jobId
	AND		AF.commCellId = a.commCellId
	AND		a.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK))
	UPDATE #tblSILOJobsVolumeStore
	SET SIDBStoreId = V.SIDBStoreId
	FROM #tblSILOJobsVolumeStore A, MMVolume V WITH (NOLOCK)
	WHERE A.SiloVolumeId = V.VolumeId
	AND	  A.commCellId = (CASE V.OrigCCCommCellId WHEN 0 THEN 2 ELSE V.OrigCCCommCellId END)
	AND 	V.sidbStoreId > 0
	INSERT INTO #tblSILOJobsOnStore
	SELECT DISTINCT SIDBStoreId, commCellId, JobId, -1 -- DEFAULT to infinite retention
	FROM #tblSILOJobsVolumeStore
	WHERE	sidbStoreId > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblSILOJobsOnStore
	SET EstAgingDate = CASE WHEN SAD.EstAgingDate = 0 THEN @currentTime ELSE SAD.EstAgingDate END
	FROM #tblSILOJobsOnStore SJOS, #tblStoreEstAgingDate SAD
	WHERE SJOS.SIDBStoreId = SAD.SIDBStoreId
	AND		SJOS.commCellId = SAD.commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Estimated Aging Date for SILO Tape Backup Jobs will be same across all copies (if they are aux copied)
	UPDATE	#ArchJobCopy
	SET		estimatedAgingDate = tmp.EstAgingDate
	FROM	#ArchJobCopy a, (SELECT SJOS.JobId, SJOS.commCellId, CASE WHEN MIN(SJOS.EstAgingDate) = -1 THEN -1 ELSE MAX(SJOS.EstAgingDate) END AS EstAgingDate
													FROM #tblSILOJobsOnStore SJOS
													GROUP BY SJOS.JobId, SJOS.commCellId) AS tmp
	WHERE a.jobId = tmp.jobId
	AND		a.commCellId = tmp.commCellId
	AND		a.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK))
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#AppCopyLastJobInCycle') is not null DROP TABLE #AppCopyLastJobInCycle
	if object_id('tempdb.dbo.#tblJobCopyExtended') is not null DROP TABLE #tblJobCopyExtended
	if object_id('tempdb.dbo.#tblJobsOnStore') is not null DROP TABLE #tblJobsOnStore
	if object_id('tempdb.dbo.#tblStoreEstAgingDate') is not null DROP TABLE #tblStoreEstAgingDate
	if object_id('tempdb.dbo.#tblSILOJobsVolumeStore') is not null DROP TABLE #tblSILOJobsVolumeStore
	if object_id('tempdb.dbo.#tblSILOJobsOnStore') is not null DROP TABLE #tblSILOJobsOnStore
	if object_id('tempdb.dbo.#tblReqCycles') is not null DROP TABLE #tblReqCycles
	if object_id('tempdb..#tblVSAJobAgingDate') is not null DROP TABLE #tblVSAJobAgingDate
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptEstAgingDate')
	delete from GxQscripts where name = 'daTSRptEstAgingDate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptEstAgingDate')
	delete from GXDBVersions where aliasname = 'daTSRptEstAgingDate'
GO

insert into GXDBVersions values(2, 'daTSRptEstAgingDate',  '00010021008000070000', 'daTSRptEstAgingDate', '00010021008000070000')
GO

