

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptCalculateLogPruneTime.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptCalculateLogPruneTime.sp,v $ $Id: daTSRptCalculateLogPruneTime.sp,v 1.2.276.1 2018/03/22 02:57:30 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptCalculateLogPruneTime()
--  |
--  | Description:  Process non sql log archive files after all data aging and
--	|								aging time for log have been calculated.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptCalculateLogPruneTime <<<'

IF EXISTS (select * from sysobjects where name='daTSRptCalculateLogPruneTime')
	drop procedure daTSRptCalculateLogPruneTime
IF EXISTS (select * from GxQscripts where name='daTSRptCalculateLogPruneTime')
	delete from GxQscripts where name = 'daTSRptCalculateLogPruneTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptCalculateLogPruneTime')
	delete from GXDBVersions where aliasname = 'daTSRptCalculateLogPruneTime'
GO
print '... Creating Procedure: daTSRptCalculateLogPruneTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptCalculateLogPruneTime
  @dummy INTEGER,
  @agingAsofDays INTEGER
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_numAppIdToAge INTEGER;
	SET NOCOUNT ON
	DECLARE @numAppIdToAge	INTEGER
	SET		  @numAppIdToAge	= 0
	DECLARE @honorBasicCyclesOnlyToApplyLogRule INTEGER
	SET 		@honorBasicCyclesOnlyToApplyLogRule	= 0
	DECLARE @errorCode		INTEGER
	SET		  @errorCode		= 0
	DECLARE @currentTime INTEGER
		SET     @currentTime = dbo.GetUnixTime(GETUTCDATE()) + @agingAsofDays * 24 * 3600
	DECLARE	@tblLogInstance TABLE ( InstanceId int, AgeTimeForLog int, oldestJobId int)
	DECLARE	@tblLogBackupSet TABLE ( BackupSetId int, AgeTimeForLog int, oldestJobId int)
	DECLARE	@tblLogSubclient TABLE ( AppId int, AgeTimeForLog int, oldestJobId int)
	--Get parameter to find oldest full based on basic retention or basic cycle only retention
	SELECT @honorBasicCyclesOnlyToApplyLogRule = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_HONOR_BASIC_CYCLES_ONLY_TO_APPLY_LOG_RULE'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Keep logs forever if its related data are not aged successfully
	-- Do not check for restore chaining for subclients of SQL Database
	-- installed before 6.1.
UPDATE	#ArchAppCopyToBeAged
SET		AgeStatus = 2,
DoNotAge = DoNotAge | 1,
			AgeTimeForLog = -1
FROM	#ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
	AND 	LinkToLog > 0
AND		AgeStatus NOT IN (5, 6)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Retain log based on data retained by basic retention
	-- Do not calculate AgeTimeForLog for Documentum here
	-- since it is already calculated while pruning data
	-- use same values to calculate log pruning
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeForLog = CASE WHEN @honorBasicCyclesOnlyToApplyLogRule = 0 THEN AgeTimeBasicRet ELSE AgeTimeByCycles END
WHERE	AppFlags & 2 > 0
AND		AgeStatus in (5, 6)
	AND		LinkToLog > 0
AND   appType <> 128
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get time for the oldest logs to be retained on Instance level
	-- Do not consider the jobs on Selective copies
	INSERT	INTO @tblLogInstance
	SELECT	InstanceId, MIN(AgeTimeForLog), 0
FROM	#ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
	AND		copyType <> 2  -- (Selective Copy)
	AND		copyIsSnapMirror = 0 -- Do Not consider Snap Mirror
AND		logAgingLevel = 1
	GROUP	BY InstanceId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get time for the oldest logs to be retained on BackupSet level
	-- Do not consider the jobs on Selective copies
	INSERT	INTO @tblLogBackupSet
	SELECT	BackupSetId, MIN(AgeTimeForLog), 0
FROM	#ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
	AND		copyType <> 2  -- (Selective Copy)
	AND		copyIsSnapMirror = 0 -- Do Not consider Snap Mirror
AND		logAgingLevel = 2
	GROUP	BY BackupSetId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get time for the oldest logs to be retained for Subclient on multiple copy
	-- Do not consider the jobs on Selective copies
	INSERT	INTO @tblLogSubclient
	SELECT	AppId, MIN(AgeTimeForLog), 0
FROM	#ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
	AND		copyType <> 2  -- (Selective Copy)
	AND		copyIsSnapMirror = 0 -- Do Not consider Snap Mirror
AND		logAgingLevel = 3
	GROUP	BY AppId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update time for the oldest logs to be retained on Instance level
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
FROM	#ArchAppCopyToBeAged a, @tblLogInstance b
WHERE	a.AppFlags & 4 > 0
	AND 	a.InstanceId = b.InstanceId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update time for the oldest logs to be retained on BackupSet level
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
FROM	#ArchAppCopyToBeAged a, @tblLogBackupSet b
WHERE	a.AppFlags & 4 > 0
	AND 	a.BackupSetId = b.BackupSetId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update time for the oldest logs to be retained on Subclient level
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
FROM	#ArchAppCopyToBeAged a, @tblLogSubclient b
WHERE	a.AppFlags & 4 > 0
	AND 	a.AppId = b.AppId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Do not age log if any subclient failed to be aged for its log aging level
UPDATE	#ArchAppCopyToBeAged
SET		AgeStatus = 2,
DoNotAge = DoNotAge | 1
FROM	#ArchAppCopyToBeAged
WHERE	AppFlags & 4 > 0
	AND		AgeTimeForLog = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get age time for Subclient based on retention days
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeByDays = @currentTime - RetentionDays * 24 * 60 * 60
WHERE	AppFlags & 4 > 0
	AND		DoNotAge = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Use @currentTime as AgeTimeForLog if no data is found for given log
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeForLog = @currentTime
WHERE	AppFlags & 4 > 0
	AND		DoNotAge = 0
	AND		AgeTimeForLog = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblLogInstance
	SET oldestJobId = A.jobId
FROM @tblLogInstance T, #ArchJobCopy A, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 2 > 0
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
AND 	B.logAgingLevel = 1
	AND		T.InstanceId = B.InstanceId
	AND		T.AgeTimeForLog = A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblLogBackupSet
	SET oldestJobId = A.jobId
FROM @tblLogBackupSet T, #ArchJobCopy A, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 2 > 0
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
AND 	B.logAgingLevel = 2
	AND		T.BackupSetId = B.BackupSetId
	AND		T.AgeTimeForLog = A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblLogSubclient
	SET oldestJobId = A.jobId
FROM @tblLogSubclient T, #ArchJobCopy A, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 2 > 0
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
AND 	B.logAgingLevel = 3
	AND		T.AppId = B.AppId
	AND		T.AgeTimeForLog = A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #ArchJobCopy
	SET oldestJobId = T.oldestJobId
FROM #ArchJobCopy A, @tblLogInstance T, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 4 > 0
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
	AND		T.InstanceId = B.InstanceId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #ArchJobCopy
	SET oldestJobId = T.oldestJobId
FROM #ArchJobCopy A, @tblLogBackupSet T, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 4 > 0
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
	AND		T.BackupSetId = B.BackupSetId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #ArchJobCopy
	SET oldestJobId = T.oldestJobId
FROM #ArchJobCopy A, @tblLogSubclient T, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 4 > 0
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
	AND		T.appId = B.appId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SET		@numAppIdToAge	= (
			SELECT	COUNT(*)
FROM #ArchAppCopyToBeAged
WHERE	AppFlags & 4 > 0
			AND 	AgeStatus = 0
			AND		DoNotAge = 0
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @errorCode != 0
	BEGIN
		SELECT	@errorCode, -1
	END
	ELSE
	BEGIN
		SELECT	@errorCode, @numAppIdToAge
	END
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptCalculateLogPruneTime')
	delete from GxQscripts where name = 'daTSRptCalculateLogPruneTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptCalculateLogPruneTime')
	delete from GXDBVersions where aliasname = 'daTSRptCalculateLogPruneTime'
GO

insert into GXDBVersions values(2, 'daTSRptCalculateLogPruneTime',  '00010002027600010000', 'daTSRptCalculateLogPruneTime', '00010002027600010000')
GO

