

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyVSAJobLinkRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyVSAJobLinkRule.sp,v $ $Id: daTSRptApplyVSAJobLinkRule.sp,v 1.2.56.2 2018/12/27 16:35:28 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyVSAJobLinkRule()
--  |
--  | Description:  Apply Job Link Rule for VSA jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptApplyVSAJobLinkRule')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptApplyVSAJobLinkRule <<<'
	drop procedure daTSRptApplyVSAJobLinkRule
END
IF EXISTS (select * from GxQscripts where name='daTSRptApplyVSAJobLinkRule')
	delete from GxQscripts where name = 'daTSRptApplyVSAJobLinkRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyVSAJobLinkRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyVSAJobLinkRule'
GO
print '... Creating Procedure: daTSRptApplyVSAJobLinkRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyVSAJobLinkRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @maxIntVal 		INTEGER
	SET			@maxIntVal 		= 2147483647
	CREATE TABLE #VSAJobsToRetain (
			jobId					INTEGER,
			childJobId		INTEGER,
 			commCellId 		INTEGER
 			PRIMARY KEY (jobId, childJobId, commCellId)
			)
	CREATE TABLE #VSAJobsOnCopy (
 			JobId 				INTEGER,
 			CommCellId 		INTEGER,
 			archGrpId 		INTEGER,
 			archGrpCopyId INTEGER,
 			appId					INTEGER,
 			retentionDays	INTEGER,
 			isBad					INTEGER,
 			appFlags		BIGINT,
 			retained 			INTEGER
 			PRIMARY KEY (JobId, CommCellId, archGrpCopyId)
			)
	CREATE TABLE #VSAJobMaxRet (
			JobId 				INTEGER,
			CommCellId 		INTEGER,
			archGrpId 		INTEGER,
			retentionDays INTEGER,
			Primary Key (JobId, CommCellId, archGrpId)
			)
	CREATE TABLE #VSACyclesToRetain (
 			appId					INTEGER,
 			archGrpCopyId INTEGER,
 			fullCycleNum	INTEGER,
 			StartTime			INTEGER,
 			JobId 				INTEGER,
 			CommCellId 		INTEGER,
 			PRIMARY KEY (appId, archGrpCopyId, fullCycleNum)
			)
	CREATE INDEX Idx_tmpVSACyclesToRetain_JobId_commCellId_archGrpCopyId ON #VSACyclesToRetain (JobId, CommCellId, archGrpCopyId)
	-------------------------------------------------------------------------------
	---------------------- Apply Job Link Rule for VSA jobs -----------------------
	-------------------------------------------------------------------------------
		-- Get all VSA jobs that are linked to non-aged child Jobs
		INSERT	INTO #VSAJobsToRetain
		SELECT	DISTINCT VAJ.parentJobId, VAJ.childJobId, VAJ.commCellId
FROM	#DA_JobCopyList JCL, JMVSAAppJobLink VAJ WITH (NOLOCK), #ArchJobCopy JDS WITH (NOLOCK)
		WHERE	JCL.JobId = VAJ.parentJobId
		AND 	JCL.CommCellId = VAJ.CommCellId
		AND		VAJ.childJobId = JDS.JobId
		AND		VAJ.CommCellId = JDS.CommCellId
		AND		JDS.dataStatus = 100
		AND		JDS.jobRetainReason > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get VSA jobs on all available copies
		INSERT	INTO #VSAJobsOnCopy
		SELECT	JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
						CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END,
MAX(JC.JobFlags & 1), JC.appFlags, 0
FROM	#VSAJobsToRetain T, #DA_JobCopyList JC, #ArchAppCopyToBeAged AC
		WHERE	T.jobId = JC.jobId
		AND 	T.commCellId = JC.commCellId
		AND		JC.appId = AC.appId
		AND		JC.copyId = AC.copyId
		AND		JC.FileType = AC.FileType
		AND		JC.dataStatus = 100
		GROUP BY JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
						CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END, JC.appFlags
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention and not marked BAD
		INSERT	INTO #VSAJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#VSAJobsOnCopy TMP, #ArchAppCopyToBeAged A
		WHERE		TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
		AND			TMP.isBad = 0
AND			A.appFlags & 33554432 = 0
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention if no good job found
		INSERT	INTO #VSAJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#VSAJobsOnCopy TMP, #ArchAppCopyToBeAged A
		WHERE		NOT EXISTS (SELECT T.JobId FROM #VSAJobMaxRet AS T
											WHERE TMP.JobId = T.jobId
											AND 	TMP.CommCellId = T.CommCellId
											AND		TMP.archGrpId = T.archGrpId)
		AND			TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
AND			A.appFlags & 33554432 = 0
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- VSA Jobs linked to non-aged App jobs on same copy cannot be aged
		UPDATE a
		SET retained = 1
FROM #VSAJobsOnCopy a, #VSAJobsToRetain b, #ArchJobCopy c WITH (NOLOCK)
		WHERE	a.JobId = b.JobId
		AND 	a.CommCellId = b.CommCellId
		AND		b.childJobId = c.jobId
		AND		b.CommCellId = c.CommCellId
--AND		a.appFlags & 33554432 = 0
		AND		a.archGrpCopyId = c.CopyId
		AND		c.dataStatus = 100
		AND		c.jobRetainReason > 0
		-- VSA Jobs linked to non-aged App jobs on highest retention copy cannot be aged
		UPDATE	a
		SET 	retained = 1
		FROM	#VSAJobsOnCopy a
		INNER JOIN #VSAJobMaxRet b
		ON 		a.JobId = b.JobId
		AND 	a.CommCellId = b.CommCellId
		AND		a.archGrpId = b.archGrpId
		AND		a.retentionDays = b.retentionDays
AND 	a.appFlags & 33554432 = 0
		LEFT OUTER JOIN #VSAJobsOnCopy c ON a.jobId = c.JobId AND a.CommCellId = c.CommCellId AND c.retained = 1
		WHERE c.JobId IS NULL
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	a
SET 	jobRetainReason = a.jobRetainReason | 1024
		FROM	#DA_JobCopyList a INNER JOIN #VSAJobsOnCopy b ON a.jobId = b.jobId AND a.commcellId = b.commcellId AND a.copyId = b.archGrpCopyId
		WHERE 	b.retained = 1
		-- Update the jobId that retains the VSA job with DONOTAGE_REQBYJOB
		UPDATE	#ArchJobCopy
		SET 	retainedByJobIds = CASE WHEN T.JobList IS NULL THEN T1.retainedByJobIds ELSE T1.retainedByJobIds + ', ' + T.JobList END
		FROM	#ArchJobCopy T1, ( SELECT a.JobId, a.commCellId, a.archGrpCopyId, SUBSTRING((	SELECT DISTINCT ( ', ' + CAST(TMP.childJobId AS VARCHAR(10)))
																FROM 	#VSAJobsToRetain TMP
																WHERE	a.JobId = TMP.JobId
																AND 	a.CommCellId = TMP.CommCellId
																FOR XML PATH('') ), 2, 99999999) AS JobList
									FROM	#VSAJobsOnCopy a WHERE a.retained = 1
														) T
		WHERE	T1.JobId = T.JobId
		AND 	T1.CommCellId = T.CommCellId
		AND 	T1.CopyId = T.archGrpCopyId
		-- Get the cycle numbers of VSA linked jobs that are retained on highest retention copy
		-- Exclude snap copies as snap don't need entire VSA cycle for restorability of application jobs
		INSERT INTO #VSACyclesToRetain
		SELECT a.appId, a.CopyId, a.fullCycleNum, MAX(a.startTime), 0, 0
		FROM	#DA_JobCopyList a, #DA_AppCopyList b, #VSAJobsOnCopy c
		WHERE a.appId = b.appId
		AND   a.CopyId = b.CopyId
		AND   a.fileType = b.fileType
		AND   b.copyIsSnap = 0
		AND		a.JobId = c.JobId
		AND 	a.CommCellId = c.CommCellId
		AND 	a.CopyId = c.archGrpCopyId
AND		a.appFlags & 33554432 = 0
AND		a.jobRetainReason & 1024 > 0
		GROUP BY a.appId, a.CopyId, a.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get the latest jobId in the cycle that will keep the cycle image
		UPDATE	#VSACyclesToRetain
		SET 	jobId = b.jobId,
					commCellId = b.commCellId
		FROM	#VSACyclesToRetain a, #DA_JobCopyList b
		WHERE a.appId = b.appId
		AND		a.archGrpCopyId = b.CopyId
		AND		a.fullCycleNum = b.fullCycleNum
		AND		a.startTime = b.startTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain all VSA Jobs in same cycle that ran before VSA linked job for cycle dependency
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 1024
		FROM	#DA_JobCopyList a, #VSACyclesToRetain b
		WHERE a.appId = b.appId
		AND 	a.CopyId = b.archGrpCopyId
		AND 	a.fullCycleNum = b.fullCycleNum
		AND		a.startTime <= b.startTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the jobId that retains the VSA job with DONOTAGE_REQBYJOB
		UPDATE	#ArchJobCopy
		SET 	retainedByJobIds = retainedByJobIds + ', ' + CAST(b.JobId AS VARCHAR(10))
		FROM	#ArchJobCopy a, #VSACyclesToRetain b
		WHERE	a.appId = b.appId
		AND 	a.CopyId = b.archGrpCopyId
		AND 	a.fullCycleNum = b.fullCycleNum
		AND		a.startTime <= b.startTime
		AND		a.retainedByJobIds NOT LIKE CAST(b.JobId AS VARCHAR(10))
		AND		a.retainedByJobIds NOT LIKE '%' + CAST(b.JobId AS VARCHAR(10)) + ',%'
		AND		a.retainedByJobIds NOT LIKE '%, ' + CAST(b.JobId AS VARCHAR(10)) + ',%'
		AND		a.retainedByJobIds NOT LIKE '%, ' + CAST(b.JobId AS VARCHAR(10)) + '%'
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyVSAJobLinkRule')
	delete from GxQscripts where name = 'daTSRptApplyVSAJobLinkRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyVSAJobLinkRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyVSAJobLinkRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyVSAJobLinkRule',  '00010002005600020000', 'daTSRptApplyVSAJobLinkRule', '00010002005600020000')
GO

