

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplySQLChainRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplySQLChainRule.sp,v $ $Id: daTSRptApplySQLChainRule.sp,v 1.4.34.1 2018/03/22 03:19:00 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplySQLChainRule()
--  |
--  | Description: Retain the data required for restore chain
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplySQLChainRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplySQLChainRule')
	drop procedure daTSRptApplySQLChainRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplySQLChainRule')
	delete from GxQscripts where name = 'daTSRptApplySQLChainRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplySQLChainRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplySQLChainRule'
GO
print '... Creating Procedure: daTSRptApplySQLChainRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplySQLChainRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE 	@errorCode		INTEGER
	SET		@errorCode		= 0
	DECLARE 	@IgnoreLogRule 	INTEGER
	SET				@IgnoreLogRule 	= 0
	DECLARE 	@HonorLogRuleTS 	INTEGER
	SET		@HonorLogRuleTS 	= 0
	DECLARE @currentTime 	INTEGER
	SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#tblJobMaxRet') is not null DROP TABLE #tblJobMaxRet
	CREATE TABLE #tblJobMaxRet (
			JobId			int,
			CommCellId		int,
			AgeTimeByDays	int,
			)
	CREATE INDEX Idx_tblJobMaxRet_1 ON #tblJobMaxRet (JobId, CommCellId, AgeTimeByDays)
	-------------------------------------------------------------------------------
	---------------- Apply SQL Chain Rule based on Param Value --------------------
	-------------------------------------------------------------------------------
	SELECT @IgnoreLogRule = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_PRUNE_ALL_DB_AGENT_LOGS_BY_DAYS_ONLY_RETENTION'
	SELECT @HonorLogRuleTS = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_TIMESTAMP_TO_HONOR_LOG_RULE'
	-------------------------------------------------------------------------------
	------------------------ Apply the SQL Chain Rule -----------------------------
	-------------------------------------------------------------------------------
	-- AgeTimeByDays will be 0 for copy with infinite retention
	-- Get job max retention time
	-- This filter is only for SQL data jobs. Logs will be retained by another SP
	IF @IgnoreLogRule = 0
	BEGIN
		if object_id('tempdb.dbo.#DA_ArchAppCopyToBeAged') is not null DROP TABLE #DA_ArchAppCopyToBeAged
		-- Create just the table
		SELECT	*
		INTO	#DA_ArchAppCopyToBeAged
FROM #ArchAppCopyToBeAged
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Set the AgeTimeByDays for each appId Copy
		UPDATE	#DA_ArchAppCopyToBeAged
		SET 		AgeTimeByDays = @currentTime - RetentionDays * 24 * 3600
		WHERE		RetentionDays >= 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy where job is NOT marked BAD
		INSERT	INTO #tblJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
FROM	#ArchSQLJobCopyToBeRetained a, #DA_ArchAppCopyToBeAged b, #DA_JobCopyList c
		WHERE	a.AppId = c.AppId
		AND 	a.CopyId = c.CopyId
		AND 	a.FileType = c.FileType
		AND		a.jobId = c.jobId
		AND		a.CommCellId = c.CommCellId
		AND		a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.appFlags & 2 > 0
AND   b.appFlags & 32 > 0
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(c.JobFlags & 1) = 0
AND		(a.jobRetainReason & 32768) = 32768
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy with jobs marked BAD if no good jobs are available
		INSERT	INTO #tblJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
FROM	#ArchSQLJobCopyToBeRetained a, #DA_ArchAppCopyToBeAged b, #DA_JobCopyList c
		WHERE	a.AppId = c.AppId
		AND 	a.CopyId = c.CopyId
		AND 	a.FileType = c.FileType
		AND		a.jobId = c.jobId
		AND		a.CommCellId = c.CommCellId
		AND		a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.appFlags & 2 > 0
AND   b.appFlags & 32 > 0
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(a.jobRetainReason & 32768) = 32768
		AND		NOT EXISTS (SELECT T.JobId FROM #tblJobMaxRet AS T
											WHERE a.JobId = T.jobId
											AND 	a.CommCellId = T.CommCellId)
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain chained SQL data on copy with max retention days
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 32768
		FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b, #tblJobMaxRet c
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND		b.appFlags & 2 > 0
AND   b.appFlags & 32 > 0
AND		b.appFlags & 33554432 = 0
		AND		b.AgeTimeByDays = c.AgeTimeByDays
		AND		a.JobId = c.JobId
		AND 	a.CommCellId = c.CommCellId
		AND		(@HonorLogRuleTS = 0 OR a.StartTime <= @HonorLogRuleTS)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	#ArchJobCopy
		SET 	retainedByJobIds = retainedByJobIds + ', ' + T1.JobList
		FROM #ArchJobCopy T, ( SELECT DISTINCT a.JobId, a.commCellId, a.copyId, a.fileType,
																						SUBSTRING((	SELECT DISTINCT ( ', ' + CAST(TMP.chainedJobId AS VARCHAR(10)))
FROM 	#ArchSQLJobCopyToBeRetained TMP
																												WHERE	a.JobId = TMP.JobId
																												AND 	a.CommCellId = TMP.CommCellId
																												AND		a.CopyId = TMP.CopyId
																												AND		a.FileType = TMP.FileType
																												FOR XML PATH('') ), 2, 99999999) AS JobList
FROM	#DA_JobCopyList a, #ArchSQLJobCopyToBeRetained b
														WHERE	a.jobId = b.jobId
														AND		a.CommCellId = b.CommCellId
														AND		a.CopyId = b.CopyId
														AND 	a.FileType = b.FileType
AND		(a.jobRetainReason & 32768) > 0
														AND		b.chainedJobId > 0
													) T1
		WHERE	T.jobId = T1.jobId
		AND		T.CommCellId = T1.CommCellId
		AND		T.CopyId = T1.CopyId
		AND 	T.FileType = T1.FileType
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	if object_id('tempdb.dbo.#DA_ArchAppCopyToBeAged') is not null DROP TABLE #DA_ArchAppCopyToBeAged
	if object_id('tempdb.dbo.#tblJobMaxRet') is not null DROP TABLE #tblJobMaxRet
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplySQLChainRule')
	delete from GxQscripts where name = 'daTSRptApplySQLChainRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplySQLChainRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplySQLChainRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplySQLChainRule',  '00010004003400010000', 'daTSRptApplySQLChainRule', '00010004003400010000')
GO

