

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyRetainLatestBackupCopiedJobRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyRetainLatestBackupCopiedJobRule.sp,v $ $Id: daTSRptApplyRetainLatestBackupCopiedJobRule.sp,v 1.1.4.4 2018/12/27 16:50:16 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyRetainLatestBackupCopiedJobRule()
--  |
--  | Description:  Apply latest backup copied job retention rule
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptApplyRetainLatestBackupCopiedJobRule')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptApplyRetainLatestBackupCopiedJobRule <<<'
	drop procedure daTSRptApplyRetainLatestBackupCopiedJobRule
END
IF EXISTS (select * from GxQscripts where name='daTSRptApplyRetainLatestBackupCopiedJobRule')
	delete from GxQscripts where name = 'daTSRptApplyRetainLatestBackupCopiedJobRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyRetainLatestBackupCopiedJobRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyRetainLatestBackupCopiedJobRule'
GO
print '... Creating Procedure: daTSRptApplyRetainLatestBackupCopiedJobRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyRetainLatestBackupCopiedJobRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @rowCount		INTEGER
	SET			@rowCount		= 0
	DECLARE @rowCnt		INTEGER
	SET			@rowCnt		= 0
	DECLARE @RetainLatestBackupCopiedSnapJob INTEGER
	SET 		@RetainLatestBackupCopiedSnapJob = 1
	SELECT @RetainLatestBackupCopiedSnapJob = isnull(value, 1)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_RETAIN_LATEST_BACKUP_COPIED_SNAP_JOB'
	SELECT 	@errorCode = @@ERROR
	IF		@errorCode != 0 GOTO CX_EXIT
	IF (@RetainLatestBackupCopiedSnapJob = 1)
	BEGIN
		if object_id('tempdb.dbo.#tmpAppIdList') is not null DROP TABLE #tmpAppIdList
		CREATE	TABLE #tmpAppIdList(
				appId					INTEGER
				primary key 	(appId)
				)
		if object_id('tempdb.dbo.#tmpAppIdToProcess') is not null DROP TABLE #tmpAppIdToProcess
		CREATE	TABLE #tmpAppIdToProcess(
				appId						INTEGER,
				fullArchGrpId		INTEGER,
				incrArchGrpId		INTEGER
				primary key 	(appId)
				)
		if object_id('tempdb.dbo.#tmpLatestBackupCopiedJobs') is not null DROP TABLE #tmpLatestBackupCopiedJobs
		CREATE	TABLE #tmpLatestBackupCopiedJobs (
				AppId									int,
				StartTime							int,
				archGrpId							int,
				JobId									int,
				CommCellId						int,
				isBackupCopyEnabled 	int
				)
		CREATE INDEX Idx_tmpLatestBackupCopiedJobs_1 ON #tmpLatestBackupCopiedJobs (AppId, StartTime)
		CREATE INDEX Idx_tmpLatestBackupCopiedJobs_2 ON #tmpLatestBackupCopiedJobs (JobId, CommCellId)
		if object_id('tempdb.dbo.#tmpReqByJobs') is not null DROP TABLE #tmpReqByJobs
		CREATE	TABLE #tmpReqByJobs (
				AppId									int,
				StartTime							int,
				archGrpId							int,
				JobId									int,
				CommCellId						int,
				bkpLevel							int,
				isBackupCopyEnabled 	int
				)
		CREATE INDEX Idx_tmpReqByJobs_1 ON #tmpReqByJobs (AppId, StartTime)
		CREATE INDEX Idx_tmpReqByJobs_2 ON #tmpReqByJobs (JobId, CommCellId)
		if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
		CREATE TABLE #archGroupToAppId (
		archGroupId			INTEGER,
		AppId				INTEGER
		)
		CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
		if object_id('tempdb.dbo.#archGroupIdToProcess') is not null DROP TABLE #archGroupIdToProcess
		CREATE TABLE #archGroupIdToProcess ( archGroupId  INTEGER,  isExclusionList INTEGER DEFAULT(0), srcCopyId INTEGER DEFAULT(0)
											primary key 	(archGroupId))
	if object_id('tempdb.dbo.#tmpCBTEnabledSubclients') is not null DROP TABLE #tmpCBTEnabledSubclients
	CREATE	TABLE #tmpCBTEnabledSubclients(
			appId					INTEGER
			primary key 	(appId)
			)
		--Get appIds to keep latest backup copied jobs for SnapDiff requirements
		INSERT	INTO #tmpAppIdList
		EXEC getCIFSNFSSubclient
		SELECT 	@errorCode = @@ERROR, @rowCount = @@ROWCOUNT
		IF		@errorCode != 0 GOTO CX_EXIT
		--Get appIds to keep latest backup copied jobs for CBT requirements
		INSERT INTO #tmpCBTEnabledSubclients
		EXEC GetCBTEnabledAppIdList
		SELECT 	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
		IF		@errorCode != 0 GOTO CX_EXIT
		IF EXISTS (SELECT 1 FROM #tmpCBTEnabledSubclients WHERE appId = -1)
		BEGIN
			SET 	@errorCode = -1
			IF		@errorCode != 0 GOTO CX_EXIT
		END
		IF @rowCnt > 0
		BEGIN
			INSERT	INTO #tmpAppIdList
			SELECT appId
			FROM #tmpCBTEnabledSubclients
			SELECT 	@errorCode = @@ERROR, @rowCount = @rowCount + @@ROWCOUNT
			IF		@errorCode != 0 GOTO CX_EXIT
		END
		IF @rowCount = 0 GOTO CX_EXIT
		--Get appIds to process
		INSERT INTO #tmpAppIdToProcess (appId, fullArchGrpId, incrArchGrpId)
		SELECT DISTINCT AC.appId, AC.fullArchGrpId, AC.incrArchGrpId
		FROM #tmpAppIdList T, #DA_AppCopyList AC
		WHERE T.appId = AC.appId
		SELECT 	@errorCode = @@ERROR, @rowCount = @@ROWCOUNT
		IF		@errorCode != 0 GOTO CX_EXIT
		IF 		@rowCount = 0 GOTO CX_EXIT
		-- Get the latest snap job that is moved to tape and available on source of backup copy
		INSERT INTO #tmpLatestBackupCopiedJobs (AppId, StartTime, archGrpId, JobId, CommCellId, isBackupCopyEnabled)
		SELECT AC.AppId, MAX(JBK.ServStartDate), 0, 0, 0, 0
FROM	#tmpAppIdToProcess T, #ArchAppCopyToBeAged AC,
					JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBK WITH (NOLOCK), JMJobSnapShotStats JS WITH (NOLOCK)
		WHERE	T.appId = AC.appId
		AND		AC.copyIsSnap > 0
		AND		AC.copyIsMatSource > 0
		AND		AC.appId = JDS.appId
		AND		AC.copyId = JDS.archGrpCopyId
		AND		JDS.status = 100
		AND		JDS.dataType = 1
AND		(JDS.disabled & 256) = 0
		AND		JDS.JobId = JS.JobId
		AND 	JDS.CommCellId = JS.CommCellId
		AND 	JS.materializationStatus IN (100)
		AND		JDS.jobId = JBK.jobId
		AND		JDS.commCellId = JBK.commCellId
		GROUP BY AC.AppId
		SELECT 	@errorCode = @@ERROR, @rowCount = @@ROWCOUNT
		IF		@errorCode != 0 GOTO CX_EXIT
		IF 		@rowCount = 0 GOTO CX_EXIT
		UPDATE #tmpLatestBackupCopiedJobs
		SET jobId = JBK.jobId,
				commcellId = JBK.commcellId,
				archGrpId = JBK.dataArchGrpId
		FROM #tmpLatestBackupCopiedJobs T, JMBkpStats JBK WITH (NOLOCK)
		WHERE T.appId = JBK.appId
		AND		T.StartTime = JBK.ServStartDate
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpLatestBackupCopiedJobs
		SET isBackupCopyEnabled = 1
		FROM archMaterializeSnapshotProp SP WITH (NOLOCK), #tmpLatestBackupCopiedJobs t, #tmpAppIdToProcess AC
		WHERE T.appId = AC.appId AND  AC.fullArchGrpId = SP.archGroupId
			AND	SP.enabled > 0
		INSERT INTO #archGroupIdToProcess(archGroupId)
		SELECT DISTINCT fullArchGrpId FROM #tmpAppIdToProcess
		WHERE EXISTS (SELECT 1 FROM archGroupToApp WHERE fullArchGrpId = archGroupId AND assocType <> 2)
		INSERT INTO #archGroupToAppId
		SELECT DISTINCT t_AG.archGroupId, T.appId
		FROM #tmpLatestBackupCopiedJobs T, #archGroupIdToProcess  t_AG, #tmpAppIdToProcess AC
		WHERE AC.fullArchGrpId = t_AG.archGroupId AND T.appId = AC.appId
		exec archGetArchGroupToAppAssociations 0, 1 -- operationID would be 1 as this is applicable only for backup copy and agID is being passed as 0 because the input is in the table archGroupIdToProcess
		-- Check backup copy is enabled\disabled on current associated SP
		UPDATE #tmpLatestBackupCopiedJobs
		SET isBackupCopyEnabled = 0
		FROM archMaterializeSnapshotProp SP WITH (NOLOCK), #archGroupIdToProcess  t_AG, #tmpLatestBackupCopiedJobs T INNER JOIN #tmpAppIdToProcess AC ON T.appId = AC.appId
				LEFT JOIN #archGroupToAppId T1 ON T1.archGroupId = AC.fullArchGrpId AND T.appId = T1.AppId
		WHERE 	t_AG.archGroupId = AC.fullArchGrpId
		AND		AC.fullArchGrpId = SP.archGroupId
		AND		SP.enabled > 0
		AND		T1.appId IS NULL
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		-- Get the next job after latest backup copied job that is not moved to tape
		INSERT INTO #tmpReqByJobs (AppId, StartTime, archGrpId, JobId, CommCellId, bkpLevel, isBackupCopyEnabled)
		SELECT T.AppId, MIN(JBK.ServStartDate), 0, 0, 0, 0, 1
		FROM	#tmpLatestBackupCopiedJobs T, JMBkpStats JBK WITH (NOLOCK), JMJobSnapShotStats JS WITH (NOLOCK)
		WHERE	T.appId = JBK.appId
		AND		JBK.JobId = JS.JobId
		AND 	JBK.CommCellId = JS.CommCellId
		AND 	JS.materializationStatus IN (101, 102, 103)
		AND		(JS.disabled & 1) = 0
		AND		JBK.ServStartDate > T.StartTime
		GROUP BY T.AppId
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpReqByJobs
		SET jobId = JBK.jobId,
				commcellId = JBK.commcellId,
				archGrpId = JBK.dataArchGrpId,
				bkpLevel = JBK.bkpLevel
		FROM #tmpReqByJobs T, JMBkpStats JBK WITH (NOLOCK)
		WHERE T.appId = JBK.appId
		AND		T.StartTime = JBK.ServStartDate
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		INSERT INTO #archGroupIdToProcess(archGroupId)
		SELECT DISTINCT archGrpId FROM #tmpReqByJobs
		WHERE NOT EXISTS ( SELECT 1
							FROM #archGroupIdToProcess WHERE archGroupId = archGrpId)
		IF @@ROWCOUNT > 0 -- a new storage policy was inserted
			exec archGetArchGroupToAppAssociations 0, 1 -- operationID would be 1 as this is applicable only for backup copy
		-- Check backup copy is enabled\disabled on SP associated with pending backup copy job
		UPDATE #tmpReqByJobs
		SET isBackupCopyEnabled = 0
		FROM archMaterializeSnapshotProp SP WITH (NOLOCK), #archGroupIdToProcess  t_AG, #tmpReqByJobs T LEFT JOIN #archGroupToAppId T1 ON T1.archGroupId = T.archGrpId AND T.appId = T1.AppId
		WHERE T.archGrpId = SP.archGroupId
		AND		SP.enabled > 0
		AND		T1.appId IS NULL
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		----------------------------------------------------------------------------------------
		-- Retain the latest backup copied job on source of backup copy
		-- even if there are no pending backup copy job after it for the active subclients
		----------------------------------------------------------------------------------------
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 1024
		FROM	#DA_JobCopyList JC INNER JOIN #DA_AppCopyList AC
		ON		JC.appId = AC.appId
		AND		JC.copyId = AC.copyId
		AND		JC.fileType = AC.fileType
		INNER JOIN #tmpLatestBackupCopiedJobs TMP
		ON 		JC.JobId = TMP.JobId
		AND		JC.CommCellId = TMP.CommCellId
		LEFT OUTER JOIN #tmpReqByJobs T
		ON 		TMP.appId = T.appId
		WHERE AC.copyIsSnap > 0
		AND		AC.copyIsMatSource > 0
AND 	JC.appFlags & (32768 | 65536) = 0
		AND		(
						(T.appId IS NULL AND TMP.isBackupCopyEnabled = 1)
						OR
						(T.appId IS NOT NULL AND T.bkpLevel NOT IN (1, 64) AND T.isBackupCopyEnabled = 1)
					)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the jobId that retains the latest backup copied job with DONOTAGE_REQBYJOB
		UPDATE	#ArchJobCopy
		SET 	retainedByJobIds = retainedByJobIds + ', ' + CAST(T.JobId AS VARCHAR(10))
		FROM	#ArchJobCopy JC, #DA_AppCopyList AC, #tmpLatestBackupCopiedJobs TMP, #tmpReqByJobs T
		WHERE	JC.appId = AC.appId
		AND		JC.copyId = AC.copyId
		AND		JC.fileType = AC.fileType
		AND		AC.copyIsSnap > 0
		AND		AC.copyIsMatSource > 0
		AND		JC.JobId = TMP.JobId
		AND		JC.CommCellId = TMP.CommCellId
AND 	JC.appFlags & (32768 | 65536) = 0
	 	AND		TMP.appId = T.appId
	 	AND		T.bkpLevel NOT IN (1, 64)
	 	AND		T.isBackupCopyEnabled = 1
		AND		JC.retainedByJobIds NOT LIKE CAST(T.JobId AS VARCHAR(10))
		AND		JC.retainedByJobIds NOT LIKE '%' + CAST(T.JobId AS VARCHAR(10)) + ',%'
		AND		JC.retainedByJobIds NOT LIKE '%, ' + CAST(T.JobId AS VARCHAR(10)) + ',%'
		AND		JC.retainedByJobIds NOT LIKE '%, ' + CAST(T.JobId AS VARCHAR(10)) + '%'
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	if object_id('tempdb.dbo.#tmpAppIdList') is not null DROP TABLE #tmpAppIdList
	if object_id('tempdb.dbo.#tmpAppIdToProcess') is not null DROP TABLE #tmpAppIdToProcess
	if object_id('tempdb.dbo.#tmpLatestBackupCopiedJobs') is not null DROP TABLE #tmpLatestBackupCopiedJobs
	if object_id('tempdb.dbo.#tmpReqByJobs') is not null DROP TABLE #tmpReqByJobs
	if object_id('tempdb.dbo.#archGroupIdToProcess') is not null DROP TABLE #archGroupIdToProcess
	if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
	if object_id('tempdb.dbo.#tmpCBTEnabledSubclients') is not null DROP TABLE #tmpCBTEnabledSubclients
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyRetainLatestBackupCopiedJobRule')
	delete from GxQscripts where name = 'daTSRptApplyRetainLatestBackupCopiedJobRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyRetainLatestBackupCopiedJobRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyRetainLatestBackupCopiedJobRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyRetainLatestBackupCopiedJobRule',  '00010001000400040000', 'daTSRptApplyRetainLatestBackupCopiedJobRule', '00010001000400040000')
GO

