

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyMaterializationRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyMaterializationRule.sp,v $ $Id: daTSRptApplyMaterializationRule.sp,v 1.1.294.1 2018/03/22 03:00:02 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyMaterializationRule()
--  |
--  | Description:  Do not age the jobs that are not yet materialized
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyMaterializationRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyMaterializationRule')
	drop procedure daTSRptApplyMaterializationRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyMaterializationRule')
	delete from GxQscripts where name = 'daTSRptApplyMaterializationRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyMaterializationRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyMaterializationRule'
GO
print '... Creating Procedure: daTSRptApplyMaterializationRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyMaterializationRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	if object_id('tempdb.dbo.#tblCatalogSrcCopy') is not null DROP TABLE #tblCatalogSrcCopy
	CREATE	TABLE #tblCatalogSrcCopy(
		archGroupId INT,
		sourceCopyId INT
	)
	------------------------------------------------------------------------------------
	------------------------- Apply the Materialization Rule ---------------------------
	------------------------------------------------------------------------------------
	-- The Jobs on snap copy which are not yet materialized will be retained for materialization but snap jobs yet to be delayed cataloged will not be retained
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 131072
	FROM	#DA_JobCopyList a, #DA_AppCopyList b, JMJobSnapShotStats c WITH (NOLOCK)
	WHERE	a.appId = b.appId
	AND		a.CopyId = b.CopyId
	AND		a.fileType = b.fileType
	AND		b.copyIsSnap > 0
	AND		b.copyIsMatSource > 0
	AND		a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	(c.Disabled & 1) = 0
	AND 	c.materializationStatus in (101, 102, 103)
AND		c.flags & 1 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--For jobs to be cataloged we dont retain even if it is pending catalog but if catalog is currently running we need to retain
	INSERT INTO #tblCatalogSrcCopy
	SELECT a.id, c.id
	FROM	archGroup a WITH (NOLOCK), archDeferredCatalogProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
	WHERE	a.id = b.archGroupId
	AND		a.id = c.archGroupId
	AND		c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	AND		c.isSnapCopy > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set Catalog Source Copy as source of Mirror copy, if Catalog Source Copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM #tblCatalogSrcCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE #tblCatalogSrcCopy
		SET sourceCopyId = (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
		FROM	#tblCatalogSrcCopy T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		T.archGroupId = AGC.archGroupId
		AND		AGC.archGroupId = AG.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
	END
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	DECLARE @jobsCurrentlyCataloged table(jobId int, commcellId int)
	INSERT INTO @jobsCurrentlyCataloged
	SELECT jwf.processedJobId, jwf.processedCommcellId FROM
	JMJobInfo rj WITH (NOLOCK) inner join JMJobWF jwf WITH (NOLOCK) ON
	jwf.childJobId = rj.jobId AND jwf.commcellId = rj.commCellId AND rj.subOpType = 96 --Delayed catalog job type
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 16777216
	FROM	#DA_JobCopyList a, #tblCatalogSrcCopy b, JMJobSnapDeferredCatalogStats c WITH (NOLOCK), @jobsCurrentlyCataloged d
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND		a.copyId = b.sourceCopyId
	AND 	(c.Disabled & 1) = 0
	AND 	c.catalogStatus in (101, 102, 103)
	AND		c.jobId = d.jobId
	AND		c.commcellId = d.commcellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#tblCatalogSrcCopy') is not null DROP TABLE #tblCatalogSrcCopy
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyMaterializationRule')
	delete from GxQscripts where name = 'daTSRptApplyMaterializationRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyMaterializationRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyMaterializationRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyMaterializationRule',  '00010001029400010000', 'daTSRptApplyMaterializationRule', '00010001029400010000')
GO

