

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyManualRetentionRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyManualRetentionRule.sp,v $ $Id: daTSRptApplyManualRetentionRule.sp,v 1.1.304.2 2018/09/21 04:09:04 pkrishnan Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyManualRetentionRule()
--  |
--  | Description:  Do not age the manually retained jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyManualRetentionRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyManualRetentionRule')
	drop procedure daTSRptApplyManualRetentionRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyManualRetentionRule')
	delete from GxQscripts where name = 'daTSRptApplyManualRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyManualRetentionRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyManualRetentionRule'
GO
print '... Creating Procedure: daTSRptApplyManualRetentionRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyManualRetentionRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	-------------------------------------------------------------------------------
	--------------------- Apply the Manual Retention Rule -------------------------
	-------------------------------------------------------------------------------
	DECLARE	@RetentionDaysWhenCyclesIgnored		INTEGER
	SET			@RetentionDaysWhenCyclesIgnored		= 30
	DECLARE	@RetainDependentJobsInCycle	INTEGER
	SET			@RetainDependentJobsInCycle	= 1
	if object_id('tempdb.dbo.#tblReqCycles') is not null DROP TABLE #tblReqCycles
	CREATE TABLE #tblReqCycles (
			AppId int, CopyId int, FileType int, CommCellId int,
			JobId int, StartTime int, fullCycleNum int,
			retainIncrBeforeDiff int, lastDiffStartTime int,
			isFullJobCWE int, isFullJobCS int,
			retentionDays int, retentionCycles int
			)
	CREATE INDEX Idx_tblReqCycles_1 ON #tblReqCycles (AppId, CopyId, FileType, fullCycleNum)
	SELECT @RetentionDaysWhenCyclesIgnored = isnull(value, 30)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @RetainDependentJobsInCycle = isnull(value, 1)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETAIN_DEPENDENT_JOBS_IN_CYCLE_FOR_PINNED_JOBS'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobRetainReason flag with DONOTAGE_BY_MANUALRETENTION
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 256
	WHERE	manualRet > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @RetainDependentJobsInCycle = 1
	BEGIN
		-- Get the last job on each copy and cycle that is retaind by manual retention
		INSERT	INTO #tblReqCycles
		SELECT DISTINCT AppId, CopyId, FileType, 0, 0, MAX(StartTime), fullCycleNum, 1, 0, 0, 0, 0, 0
		FROM	#DA_JobCopyList
WHERE jobRetainReason & 256 = 256
AND		appFlags & 2 > 0
AND		appFlags & (33554432 | 67108864 | 2048 | 1048576) = 0
		GROUP BY AppId, CopyId, FileType, fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tblReqCycles
		SET commCellId = b.commCellId,
		jobId = b.JobId
		FROM #tblReqCycles a, #DA_JobCopyList b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.StartTime = b.StartTime
		AND		a.fullCycleNum = b.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Check the JobStatus of corresponding Full job if it is CWE / Custom Scripts Job
		UPDATE #tblReqCycles
		SET isFullJobCWE = CASE WHEN (b.JobStatus IN (3)) THEN 1 ELSE 0 END,
isFullJobCS = CASE WHEN (b.JobFlags & 16777216 > 0 AND b.JobFlags & 8388608 = 0) THEN 1 ELSE 0 END
		FROM #tblReqCycles a, #DA_JobCopyList b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.fullCycleNum = b.fullCycleNum
		AND		b.BkpLevel = 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tblReqCycles
		SET retentionDays = CASE WHEN ((a.isFullJobCS = 1 OR (a.isFullJobCWE = 1 AND b.isCWEjobValid != 1)) AND b.retentionDays = 0 AND b.retentionCycles > 0) THEN @RetentionDaysWhenCyclesIgnored ELSE b.retentionDays END,
			retentionCycles = CASE WHEN ((a.isFullJobCS = 1 OR (a.isFullJobCWE = 1 AND b.isCWEjobValid != 1)) AND b.retentionDays = 0 AND b.retentionCycles > 0) THEN 0 ELSE b.retentionCycles END,
			retainIncrBeforeDiff = b.retainIncrBeforeDiff
FROM #tblReqCycles a, #ArchAppCopyToBeAged b
		WHERE a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
/*
		--Commenting this for now
		--Retain entire cycle based on the latest job pinned in the cycle
		--Do not honor retainIncrBeforeDiff option
		--Since there could be multiple pinned jobs and applying rule	for eack pinned jobs in a cycle will require CURSOR FOR LOOP which may cause performance issues
		UPDATE #tblReqCycles
		SET lastDiffStartTime = b.lastDiffStartTime
		FROM #tblReqCycles a,
					(SELECT T.AppId, T.CopyId, T.fileType, T.fullCycleNum, MAX(T.StartTime) AS lastDiffStartTime
						FROM #DA_JobCopyList T, #tblReqCycles T1
						WHERE T.DataStatus = 100
						AND		T.BkpLevel = 4
						AND		T.AppId = T1.AppId
						AND 	T.CopyId = T1.CopyId
						AND 	T.FileType = T1.FileType
						AND		T.fullCycleNum = T1.fullCycleNum
						AND		T.StartTime <= T1.StartTime
						GROUP BY T.AppId, T.CopyId, T.fileType, T.fullCycleNum) b
		WHERE a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.fullCycleNum = b.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
*/
		-- Update the jobRetainReason flag with DONOTAGE_BY_MANUALRETENTION
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 256
		FROM	#DA_JobCopyList a, #tblReqCycles b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND 	a.CommCellId = b.CommCellId
		AND		a.StartTime < b.StartTime
		AND		a.fullCycleNum = b.fullCycleNum
		AND		(b.retainIncrBeforeDiff = 1 OR b.lastDiffStartTime = 0)
		AND		(b.retentionDays > 0 OR b.retentionCycles > 0)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the jobRetainReason flag with DONOTAGE_BY_MANUALRETENTION
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 256
		FROM	#DA_JobCopyList a, #tblReqCycles b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND 	a.CommCellId = b.CommCellId
		AND		a.StartTime < b.StartTime
		AND		a.fullCycleNum = b.fullCycleNum
		AND		b.retainIncrBeforeDiff = 0
		AND		b.lastDiffStartTime > 0
		AND		(a.BkpLevel = 1 OR a.StartTime >= b.lastDiffStartTime)
		AND		(b.retentionDays > 0 OR b.retentionCycles > 0)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the jobId that retains the jobs with DONOTAGE_BY_MANUALRETENTION
		UPDATE	#ArchJobCopy
		SET 	retainedByJobIds = retainedByJobIds + ', ' + CAST(b.JobId AS VARCHAR(10))
		FROM	#DA_JobCopyList a, #tblReqCycles b, #ArchJobCopy c
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND 	a.CommCellId = b.CommCellId
AND 	(a.jobRetainReason & 256) > 0
		AND		a.StartTime < b.StartTime
		AND		a.fullCycleNum = b.fullCycleNum
		AND		a.AppId = c.AppId
		AND 	a.CopyId = c.CopyId
		AND 	a.FileType = c.FileType
		AND		a.jobId = c.jobId
		AND 	a.CommCellId = c.CommCellId
		AND		c.retainedByJobIds NOT LIKE CAST(b.JobId AS VARCHAR(10))
		AND		c.retainedByJobIds NOT LIKE '%' + CAST(b.JobId AS VARCHAR(10)) + ',%'
		AND		c.retainedByJobIds NOT LIKE '%, ' + CAST(b.JobId AS VARCHAR(10)) + ',%'
		AND		c.retainedByJobIds NOT LIKE '%, ' + CAST(b.JobId AS VARCHAR(10)) + '%'
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyManualRetentionRule')
	delete from GxQscripts where name = 'daTSRptApplyManualRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyManualRetentionRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyManualRetentionRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyManualRetentionRule',  '00010001030400020000', 'daTSRptApplyManualRetentionRule', '00010001030400020000')
GO

