

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyJobDependencyRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyJobDependencyRule.sp,v $ $Id: daTSRptApplyJobDependencyRule.sp,v 1.3.196.1 2018/03/22 03:15:40 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyJobDependencyRule()
--  |
--  | Description:  Retain the jobs for other non-prunable job's requirement
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyJobDependencyRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyJobDependencyRule')
	drop procedure daTSRptApplyJobDependencyRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyJobDependencyRule')
	delete from GxQscripts where name = 'daTSRptApplyJobDependencyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyJobDependencyRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyJobDependencyRule'
GO
print '... Creating Procedure: daTSRptApplyJobDependencyRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyJobDependencyRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	if object_id('tempdb.dbo.#DA_JobsPendingToCatalog') is not null DROP TABLE #DA_JobsPendingToCatalog
	CREATE	TABLE #DA_JobsPendingToCatalog (
			AppId							int,
			CopyId						int,
			fullCycleNum			int,
			StartTime					int
			)
	CREATE INDEX Idx_DA_JobsPendingToCatalog_1 ON #DA_JobsPendingToCatalog (AppId, CopyId, fullCycleNum, StartTime)
	if object_id('tempdb.dbo.#DA_CatalogedJobsToKeep') is not null DROP TABLE #DA_CatalogedJobsToKeep
	CREATE	TABLE #DA_CatalogedJobsToKeep (
			AppId							int,
			CopyId						int,
			fullCycleNum			int,
			StartTime					int
			)
	CREATE INDEX Idx_DA_CatalogedJobsToKeep_1 ON #DA_CatalogedJobsToKeep (AppId, CopyId, fullCycleNum, StartTime)
	if object_id('tempdb.dbo.#DA_KeepJobsWithCatalog') is not null DROP TABLE #DA_KeepJobsWithCatalog
	CREATE	TABLE #DA_KeepJobsWithCatalog (
			AppId										int,
			CopyId									int,
			fullCycleNum						int,
			JobId										int,
			CommCellId							int,
			bkpLevel								int,
			CatalogedJobId					int,
			CatalogedJobCCId				int
			)
	CREATE INDEX Idx_DA_KeepJobsWithCatalog_1 ON #DA_KeepJobsWithCatalog (AppId, CopyId, fullCycleNum)
	--Get the first job startTime that is pending for cataloging
	INSERT INTO #DA_JobsPendingToCatalog
	SELECT JC.appId, JC.copyId, JC.fullCycleNum, MIN(JC.startTime) AS startTime
	FROM 	#DA_JobCopyList JC, JMJobSnapshotStats SS WITH (NOLOCK), archMaterializeSnapshotProp SP WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE JC.jobId = SS.jobId
	AND		JC.commCellId = SS.commCellId
	AND  	JC.appId = SS.appId
	AND		JC.bkpLevel = 2						-- Incremental job that is pending for cataloging
	AND		SS.flags = 1							-- picked for Deferred Catalog
	AND		SS.materializationStatus IN (101, 102, 103)
	AND		SS.disabled & 1 = 0
	AND		SS.archGrpId = SP.archGroupId
	AND		SP.archGroupId = AG.id
	AND		SP.enabled = 2					-- SP enabled for Deferred Catalog
	AND		(CASE WHEN SP.sourceCopyId = 0 THEN AG.defaultSnapCopy ELSE SP.sourceCopyId END) = JC.copyId
	AND 	JC.jobRetainReason > 0
	GROUP BY JC.appId, JC.copyId, JC.fullCycleNum
	UNION
	--Get the first differential job startTime that is pending for cataloging
	SELECT JC.appId, JC.copyId, JC.fullCycleNum, MIN(JC.startTime) AS startTime
	FROM 	#DA_JobCopyList JC, JMJobSnapshotStats SS WITH (NOLOCK), archMaterializeSnapshotProp SP WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE JC.jobId = SS.jobId
	AND		JC.commCellId = SS.commCellId
	AND  	JC.appId = SS.appId
	AND		JC.bkpLevel = 4					-- Differential job that is pending for cataloging
	AND		SS.flags = 1						-- picked for Deferred Catalog
	AND		SS.materializationStatus IN (101, 102, 103)
	AND		SS.disabled & 1 = 0
	AND		SS.archGrpId = SP.archGroupId
	AND		SP.archGroupId = AG.id
	AND		SP.enabled = 2					-- SP enabled for Deferred Catalog
	AND		(CASE WHEN SP.sourceCopyId = 0 THEN AG.defaultSnapCopy ELSE SP.sourceCopyId END) = JC.copyId
	AND 	JC.jobRetainReason > 0
	GROUP BY JC.appId, JC.copyId, JC.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Retain latest job with catalog by DONOTAGE_REQBYJOB reason if the job being retained is picked for Deferred Cataloging
	INSERT INTO #DA_CatalogedJobsToKeep
	SELECT JC.appId, JC.CopyId, JC.fullCycleNum, MAX(JBK.servStartDate) AS startTime
	FROM #DA_JobsPendingToCatalog JC, JMBkpStats JBK WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE JC.appId = JBK.appId
	AND		JC.fullCycleNum = JBK.fullCycleNum
	AND		JC.startTime > JBK.servStartDate
	AND		JBK.jobId = JDS.jobId
	AND		JBK.commCellId = JDS.commCellId
	AND		JDS.archGrpCopyId = JC.CopyId
	AND		JDS.dataType IN (2, 6)
AND		JDS.disabled & 256 = 0
	GROUP BY JC.appId, JC.CopyId, JC.fullCycleNum
	UNION
	SELECT JC.appId, JC.CopyId, JC.fullCycleNum, MAX(JBK.servStartDate) AS startTime
	FROM #DA_JobsPendingToCatalog JC, JMBkpStats JBK WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE JC.appId = JBK.appId
	AND		JC.fullCycleNum = JBK.fullCycleNum
	AND		JC.startTime > JBK.servStartDate
	AND		JBK.bkpLevel = 1
	AND		JBK.jobId = JDS.jobId
	AND		JBK.commCellId = JDS.commCellId
	AND		JDS.archGrpCopyId = JC.CopyId
	AND		JDS.dataType IN (2, 6)
AND		JDS.disabled & 256 = 0
	GROUP BY JC.appId, JC.CopyId, JC.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #DA_KeepJobsWithCatalog
	SELECT T.appId, T.copyId, T.fullCycleNum, T.jobId, T.commcellId, T.bkpLevel, 0, 0
	FROM 	#DA_JobCopyList T, #DA_JobsPendingToCatalog TMP
	WHERE T.appId = TMP.appId
	AND		T.CopyId = TMP.CopyId
	AND		T.fullCycleNum = TMP.fullCycleNum
	AND		T.startTime = TMP.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Keep the corresponding Full Job that is cataloged for pending Differential or incremental jobs
	UPDATE #DA_KeepJobsWithCatalog
	SET CatalogedJobId = T2.jobId, CatalogedJobCCId = T2.commCellId
	FROM #DA_KeepJobsWithCatalog T1,(	SELECT T.appId, T.copyId, T.fullCycleNum, T.jobId, T.commcellId
																		FROM 	#DA_JobCopyList T, #DA_CatalogedJobsToKeep TMP
																		WHERE T.appId = TMP.appId
																		AND		T.CopyId = TMP.CopyId
																		AND		T.fullCycleNum = TMP.fullCycleNum
																		AND		T.startTime = TMP.startTime
																		AND		T.bkpLevel = 1
																	) T2
	WHERE T1.appId = T2.appId
	AND		T1.CopyId = T2.CopyId
	AND		T1.fullCycleNum = T2.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Keep the latest Job that is cataloged for pending incremental jobs
	UPDATE #DA_KeepJobsWithCatalog
	SET CatalogedJobId = T2.jobId, CatalogedJobCCId = T2.commCellId
	FROM #DA_KeepJobsWithCatalog T1,(	SELECT T.appId, T.copyId, T.fullCycleNum, T.jobId, T.commcellId
																		FROM 	#DA_JobCopyList T, #DA_CatalogedJobsToKeep TMP
																		WHERE T.appId = TMP.appId
																		AND		T.CopyId = TMP.CopyId
																		AND		T.fullCycleNum = TMP.fullCycleNum
																		AND		T.startTime = TMP.startTime
																		AND		T.bkpLevel != 1
																	) T2
	WHERE T1.appId = T2.appId
	AND		T1.CopyId = T2.CopyId
	AND		T1.fullCycleNum = T2.fullCycleNum
	AND		T1.bkpLevel = 2
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Update with corresponding Full JobId if no cataloged job found and if Full job is picked for cataloging and not aged
	UPDATE #DA_KeepJobsWithCatalog
	SET CatalogedJobId = T2.jobId, CatalogedJobCCId = T2.commCellId
	FROM #DA_KeepJobsWithCatalog T1,(	SELECT T.appId, T.copyId, T.fullCycleNum, T.jobId, T.commcellId
																		FROM 	#DA_JobCopyList T, #DA_JobsPendingToCatalog JC, JMJobSnapshotStats SS WITH (NOLOCK)
																		WHERE T.appId = JC.appId
																		AND		T.CopyId = JC.CopyId
																		AND		T.fullCycleNum = JC.fullCycleNum
																		AND		T.startTime < JC.startTime
																		AND		T.bkpLevel = 1
																		AND		T.jobId = SS.jobId
																		AND		T.commCellId = SS.commCellId
																		AND  	T.appId = SS.appId
																		AND		SS.flags = 1						-- picked for Deferred Catalog
																		AND		SS.materializationStatus IN (101, 102, 103)
																		AND		SS.disabled & 1 = 0
																	) T2
	WHERE T1.appId = T2.appId
	AND		T1.CopyId = T2.CopyId
	AND		T1.fullCycleNum = T2.fullCycleNum
	AND 	T1.CatalogedJobId = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--------------------------------------------------------------------------------------
	-- Retain the jobs with catalog
	--------------------------------------------------------------------------------------
	-- Update the jobRetainReason flag with DONOTAGE_REQBYJOB
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 1024
	FROM	#DA_JobCopyList a, #DA_KeepJobsWithCatalog b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND		a.JobId = b.CatalogedJobId
	AND		a.CommCellId = b.CatalogedJobCCId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobId that retains the jobs with DONOTAGE_REQBYJOB
	UPDATE	#ArchJobCopy
	SET 	retainedByJobIds = a.retainedByJobIds + ', ' + b.JobList
	FROM	#ArchJobCopy a, ( SELECT T1.AppId, T1.CopyId, T1.CatalogedJobId, T1.CatalogedJobCCId, SUBSTRING((	SELECT DISTINCT ( ', ' + CAST(T2.JobId AS VARCHAR(10)))
																																																					FROM 	#DA_KeepJobsWithCatalog T2
																																																					WHERE T1.AppId = T2.AppId
																																																					AND		T1.CopyId = T2.CopyId
																																																					AND		T1.CatalogedJobId = T2.CatalogedJobId
																																																					AND		T1.CatalogedJobCCId = T2.CatalogedJobCCId
																																																					FOR XML PATH('') ), 2, 99999999) AS JobList
													 FROM #DA_KeepJobsWithCatalog T1
													 GROUP BY T1.AppId, T1.CopyId, T1.CatalogedJobId, T1.CatalogedJobCCId
												 ) b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND		a.JobId = b.CatalogedJobId
	AND		a.CommCellId = b.CatalogedJobCCId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#DA_KeepJobsWithCatalog') is not null DROP TABLE #DA_KeepJobsWithCatalog
	if object_id('tempdb.dbo.#DA_CatalogedJobsToKeep') is not null DROP TABLE #DA_CatalogedJobsToKeep
	if object_id('tempdb.dbo.#DA_JobsPendingToCatalog') is not null DROP TABLE #DA_JobsPendingToCatalog
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyJobDependencyRule')
	delete from GxQscripts where name = 'daTSRptApplyJobDependencyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyJobDependencyRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyJobDependencyRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyJobDependencyRule',  '00010003019600010000', 'daTSRptApplyJobDependencyRule', '00010003019600010000')
GO

