

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyJobBasedRetentionRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyJobBasedRetentionRule.sp,v $ $Id: daTSRptApplyJobBasedRetentionRule.sp,v 1.4.50.1 2018/03/22 03:14:05 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyJobBasedRetentionRule()
--  |
--  | Description:  Retain the jobs based on job retention on each copy
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyJobBasedRetentionRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyJobBasedRetentionRule')
	drop procedure daTSRptApplyJobBasedRetentionRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyJobBasedRetentionRule')
	delete from GxQscripts where name = 'daTSRptApplyJobBasedRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyJobBasedRetentionRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyJobBasedRetentionRule'
GO
print '... Creating Procedure: daTSRptApplyJobBasedRetentionRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyJobBasedRetentionRule
  @i_PickToBeCopiedJobs INTEGER,
  @i_dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @AppCopyListCursorFlag 						INTEGER
	DECLARE @curAppId									INTEGER
	DECLARE @curCopyId									INTEGER
	DECLARE @curRetentionJobs							INTEGER
	DECLARE @JobCount									INTEGER
	SET 	@AppCopyListCursorFlag 						= 0
	SET 	@curAppId									= 0
	SET 	@curCopyId									= 0
	SET		@curRetentionJobs							= 0
	SET		@JobCount 									= 0
	if object_id('tempdb.dbo.#DA_ReqJobs') is not null DROP TABLE #DA_ReqJobs
	CREATE	TABLE #DA_ReqJobs (
			JobCopyId	int IDENTITY(1,1),
			AppId		int,
			CopyId		int,
			JobId		int,
			CommCellId	int,
			StartTime	int
			Primary Key (JobCopyId)
			)
	CREATE INDEX Idx_DA_ReqJobs_1 ON #DA_ReqJobs (AppId, CopyId, JobId, CommCellId)
	-------------------------------------------------------------------------------
	------------------- Apply the Job Based Retention Rule ------------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------- Declare cursor for AppId Copy to be processed -----------------
	-------------------------------------------------------------------------------
		-- report needs to calculate cycle for all application including jobs already
		-- marked as do not age
		DECLARE	AppCopyListCursor CURSOR STATIC FOR
				SELECT	DISTINCT AppId, CopyId, retentionJobs
				FROM	#DA_AppCopyList
WHERE	AppFlags & 33554432 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SET		@AppCopyListCursorFlag = 1
	OPEN	AppCopyListCursor
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	FETCH	NEXT
	FROM AppCopyListCursor
	INTO	@curAppId, @curCopyId, @curRetentionJobs
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		-- Partial or Disabled full will be treated as valid job based on appType settings
		-- Do Not consider the jobs that are marked bad for job retention
		INSERT	INTO #DA_ReqJobs
				( AppId, CopyId, JobId, CommCellId, StartTime )
		SELECT	DISTINCT TOP (@curRetentionJobs) a.AppId, a.CopyId, a.JobId, a.CommCellId, a.StartTime
		FROM	#DA_JobCopyList a
		WHERE	a.AppId = @curAppId
		AND 	a.CopyId = @curCopyId
		AND 	(
						(@i_PickToBeCopiedJobs = 0 AND a.DataStatus = 100)
						OR
						(@i_PickToBeCopiedJobs = 1 AND ((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0)))
					)
		AND 	(
						(a.isCWEjobValid = 1 AND a.JobStatus IN (1, 3, 14))
						OR
				 		(a.isCWEjobValid <> 1 AND a.JobStatus IN (1, 14))
					)
AND		(a.JobFlags & 1) = 0
		ORDER	BY a.AppId, a.CopyId, a.StartTime DESC
		SELECT 	@errorCode = @@ERROR, @JobCount = @@ROWCOUNT
		IF		@errorCode != 0 GOTO CX_EXIT
		-- If no/less job(s) found on copy, then get the required jobs including CWE status to retain them
		IF		@JobCount < @curRetentionJobs
		BEGIN
			INSERT	INTO #DA_ReqJobs
					( AppId, CopyId, JobId, CommCellId, StartTime )
			SELECT	DISTINCT TOP (@curRetentionJobs - @JobCount) a.AppId, a.CopyId, a.JobId, a.CommCellId, a.StartTime
			FROM	#DA_JobCopyList a
			WHERE	a.AppId = @curAppId
			AND 	a.CopyId = @curCopyId
		AND 	(
						(@i_PickToBeCopiedJobs = 0 AND a.DataStatus = 100)
						OR
						(@i_PickToBeCopiedJobs = 1 AND ((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0)))
					)
			AND 	a.JobStatus IN (3)
AND		(a.JobFlags & 1) = 0
			AND NOT EXISTS (SELECT * FROM #DA_ReqJobs tt
											WHERE a.AppId = tt.AppId
											AND a.CopyId = tt.CopyId
											AND a.JobId = tt.JobId
											AND	a.CommCellId = tt.CommCellId)
			ORDER	BY a.AppId, a.CopyId, a.StartTime DESC
			SELECT 	@errorCode = @@ERROR, @JobCount = @JobCount + @@ROWCOUNT
			IF		@errorCode != 0 GOTO CX_EXIT
		END
		-- If no/less job(s) found on copy, then get the required jobs including CWE or BAD status to retain them
		IF		@JobCount < @curRetentionJobs
		BEGIN
			INSERT	INTO #DA_ReqJobs
					( AppId, CopyId, JobId, CommCellId, StartTime )
			SELECT	DISTINCT TOP (@curRetentionJobs - @JobCount) a.AppId, a.CopyId, a.JobId, a.CommCellId, a.StartTime
			FROM	#DA_JobCopyList a
			WHERE	a.AppId = @curAppId
			AND 	a.CopyId = @curCopyId
			AND 	(
							(@i_PickToBeCopiedJobs = 0 AND a.DataStatus = 100)
							OR
							(@i_PickToBeCopiedJobs = 1 AND ((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0)))
						)
			AND 	a.JobStatus IN (1, 3, 14)
AND		(a.JobFlags & 1) > 0
			AND NOT EXISTS (SELECT * FROM #DA_ReqJobs tt
											WHERE a.AppId = tt.AppId
											AND a.CopyId = tt.CopyId
											AND a.JobId = tt.JobId
											AND	a.CommCellId = tt.CommCellId)
			ORDER	BY a.AppId, a.CopyId, a.StartTime DESC
			SELECT 	@errorCode = @@ERROR, @JobCount = @JobCount + @@ROWCOUNT
			IF		@errorCode != 0 GOTO CX_EXIT
		END
		-- Apply job count retention on all jobs including to-be-copied/disabled so that they don't get pruned immediately
		INSERT	INTO #DA_ReqJobs
				( AppId, CopyId, JobId, CommCellId, StartTime )
		SELECT	DISTINCT TOP (@curRetentionJobs) a.AppId, a.CopyId, a.JobId, a.CommCellId, a.StartTime
		FROM	#DA_JobCopyList a
		WHERE	a.AppId = @curAppId
		AND 	a.CopyId = @curCopyId
		AND 	a.DataStatus IN (100, 101, 102, 103)
		AND 	(
						(a.isCWEjobValid = 1 AND a.JobStatus IN (1, 3, 14))
						OR
				 		(a.isCWEjobValid <> 1 AND a.JobStatus IN (1, 14))
					)
AND		(a.JobFlags & 1) = 0
		ORDER	BY a.AppId, a.CopyId, a.StartTime DESC
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM AppCopyListCursor
		INTO	@curAppId, @curCopyId, @curRetentionJobs
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	--------------------------------------------------------------------------------------
	-- Retain the jobs based on Job Retention
	--------------------------------------------------------------------------------------
	-- Update the jobRetainReason flag with DONOTAGE_BYJOBS
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 4194304
	FROM	#DA_JobCopyList a, #DA_ReqJobs b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND		a.JobId = b.JobId
	AND		a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @AppCopyListCursorFlag = 1
	BEGIN
			CLOSE		AppCopyListCursor
			DEALLOCATE	AppCopyListCursor
	END
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyJobBasedRetentionRule')
	delete from GxQscripts where name = 'daTSRptApplyJobBasedRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyJobBasedRetentionRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyJobBasedRetentionRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyJobBasedRetentionRule',  '00010004005000010000', 'daTSRptApplyJobBasedRetentionRule', '00010004005000010000')
GO

