

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyExtendedAllFullRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyExtendedAllFullRule.sp,v $ $Id: daTSRptApplyExtendedAllFullRule.sp,v 1.2.278.1 2018/03/22 03:03:49 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyExtendedAllFullRule()
--  |
--  | Description:  Retain the jobs based on extended retention All Full rule
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyExtendedAllFullRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyExtendedAllFullRule')
	drop procedure daTSRptApplyExtendedAllFullRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyExtendedAllFullRule')
	delete from GxQscripts where name = 'daTSRptApplyExtendedAllFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyExtendedAllFullRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyExtendedAllFullRule'
GO
print '... Creating Procedure: daTSRptApplyExtendedAllFullRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyExtendedAllFullRule
  @agingAsofDays INTEGER,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @currentTime 	INTEGER
		SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE()) + @agingAsofDays * 24 * 3600
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE	@ExtRetCopyInfo TABLE (
			copyId 					INTEGER,
			retentionDays		INTEGER,
			extRetEndTime 	BIGINT,
			firstOfPeriod 	INTEGER
			PRIMARY KEY (copyId)
			)
	-------------------------------------------------------------------------------
	--------------- Apply the Extended Retention All Full Rule --------------------
	-------------------------------------------------------------------------------
	-- Get all Extended Retention Info for current list of copies being processed
	INSERT INTO @ExtRetCopyInfo
SELECT DISTINCT JCE.copyId, AARE.retentionDays, (@currentTime - cast(AARE.retentionDays as bigint) * 24 * 3600), (AAR.flags & 1)
FROM #archJobCopyExtendedRpt JCE WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK), archAgingRuleExtended AARE WITH (NOLOCK)
	WHERE JCE.copyId = AAR.copyId
	AND		AAR.copyId = AARE.copyId
	AND		AARE.retentionRule & 2 = 2 -- EXTENDED_ALLFULL
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set Extended Retention Info for current list of copies being processed
	-- Set the retentionFlags even for TO-BE-COPIED/DISABLED/PARTIAL_SUCCESSFUL FULL jobs
UPDATE #archJobCopyExtendedRpt
	SET retentionFlags = retentionFlags | 2 -- EXTENDED_ALLFULL
FROM #archJobCopyExtendedRpt JCE WITH (NOLOCK), @ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyExtendedAllFullRule')
	delete from GxQscripts where name = 'daTSRptApplyExtendedAllFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyExtendedAllFullRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyExtendedAllFullRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyExtendedAllFullRule',  '00010002027800010000', 'daTSRptApplyExtendedAllFullRule', '00010002027800010000')
GO

