

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyDocumentumDataRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyDocumentumDataRule.sp,v $ $Id: daTSRptApplyDocumentumDataRule.sp,v 1.3.206.1 2018/03/22 03:00:57 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyDocumentumDataRule()
--  |
--  | Description: Retain the data required for Documentum iDA
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyDocumentumDataRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyDocumentumDataRule')
	drop procedure daTSRptApplyDocumentumDataRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyDocumentumDataRule')
	delete from GxQscripts where name = 'daTSRptApplyDocumentumDataRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyDocumentumDataRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyDocumentumDataRule'
GO
print '... Creating Procedure: daTSRptApplyDocumentumDataRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyDocumentumDataRule
  @dummy INTEGER,
  @agingAsofDays INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET		  @errorCode		= 0
	DECLARE @currentTime INTEGER
		SET     @currentTime = dbo.GetUnixTime(GETUTCDATE()) + @agingAsofDays * 24 * 3600
	DECLARE	@tblDataInstance TABLE ( InstanceId int, AgeTimeForLog int, oldestJobId int)
	if object_id('tempdb.dbo.#tblJobMaxRet') is not null DROP TABLE #tblJobMaxRet
	CREATE TABLE #tblJobMaxRet (
			JobId int,
			CommCellId int,
			AgeTimeByDays int,
			Primary Key (JobId, CommCellId)
			)
	if object_id('tempdb.dbo.#tblAppCopyListBasicRet') is not null DROP TABLE #tblAppCopyListBasicRet
	CREATE TABLE #tblAppCopyListBasicRet (
			appId int,
			copyId int,
			fileType int,
			AgeTimeBasicRet int
			Primary key (appId, copyId, fileType)
			)
	if object_id('tempdb.dbo.#DA_ArchAppCopyToBeAged') is not null DROP TABLE #DA_ArchAppCopyToBeAged
	--The appId/copy not processed will have AgeTimeForLog = 0
	--This covers the cases of Infinite Retention / DA disabled etc
	INSERT	INTO #tblAppCopyListBasicRet
	SELECT A.appId, A.CopyId, A.fileType, MIN(B.ServStartDate)
FROM #ArchAppCopyToBeAged A, JMJobDataStats J WITH (NOLOCK), JMBkpStats B WITH (NOLOCK)
WHERE A.appType IN (128)
AND		A.AppFlags & 2 > 0
	AND		A.AgeTimeForLog = 0
	AND		A.AppId = J.AppId
	AND 	A.CopyId = J.archGrpCopyId
	AND 	(A.fileType = 0 OR A.FileType = J.dataType)
	AND		J.JobId = B.JobId
	AND		J.CommCellId = B.CommCellId
AND		(B.bkpattributes & 0x1000) > 0
	AND 	B.status IN (1, 3, 14)
	AND		J.status = 100
AND		J.Disabled & 256 = 0
	GROUP BY A.appId, A.CopyId, A.fileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update time for the oldest data to be retained on Instance level
	-- Use this to retain logs also
UPDATE	#ArchAppCopyToBeAged
	SET AgeTimeForLog = b.AgeTimeBasicRet
FROM  #ArchAppCopyToBeAged a, #tblAppCopyListBasicRet b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	DELETE #tblAppCopyListBasicRet
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Create just the table
	SELECT	A.*
	INTO	#DA_ArchAppCopyToBeAged
FROM #ArchAppCopyToBeAged A, #DA_AppCopyList T
WHERE A.appType IN (128)
AND		A.AppFlags & 2 > 0
	AND		A.AppId = T.AppId
	AND 	A.CopyId = T.CopyId
	AND 	A.FileType = T.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set the AgeTimeByDays for each appId Copy
	UPDATE	#DA_ArchAppCopyToBeAged
	SET 		AgeTimeByDays = @currentTime - RetentionDays * 24 * 3600
	WHERE		RetentionDays >= 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate the oldest DB Full time retained by BASIC Retention for each copy
	INSERT	INTO #tblAppCopyListBasicRet
	SELECT	a.AppId, a.CopyId, a.FileType, MIN(a.StartTime)
	FROM #DA_JobCopyList a
	WHERE a.DataStatus = 100
	AND 	a.JobStatus IN (1, 3, 14)
AND		a.jobRetainReason & (2 | 16 | 32 | 4194304 | 1024 | 2048) > 0
	AND  	a.OnLinkedSP = 0
AND 	( a.JobFlags & 8388608 > 0)
	GROUP BY a.AppId, a.CopyId, a.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Reset AgeTimeForLog for AppCopyList picked up for processing
	UPDATE #DA_ArchAppCopyToBeAged
	SET AgeTimeForLog = 0
	FROM  #DA_ArchAppCopyToBeAged A, #DA_AppCopyList T
	WHERE	A.AppId = T.AppId
	AND 	A.CopyId = T.CopyId
	AND 	A.FileType = T.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #DA_ArchAppCopyToBeAged
	SET AgeTimeForLog = b.AgeTimeBasicRet
	FROM  #DA_ArchAppCopyToBeAged a, #tblAppCopyListBasicRet b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Update the AgeTimeForLog for Instances being processed
UPDATE	#ArchAppCopyToBeAged
	SET AgeTimeForLog = b.AgeTimeForLog
FROM  #ArchAppCopyToBeAged a, #DA_ArchAppCopyToBeAged b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Use @currentTime as AgeTimeForLog if no data is found
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeForLog = @currentTime
WHERE appType IN (128)
AND		AppFlags & 2 > 0
	AND		AgeTimeForLog = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get time for the oldest data to be retained on Instance level
	-- Do not consider the jobs on Selective copies
	INSERT	INTO @tblDataInstance
	SELECT	InstanceId, MIN(AgeTimeForLog), 0
FROM	#ArchAppCopyToBeAged
WHERE	appType IN (128)
AND		AppFlags & 2 > 0
	AND		copyType <> 2  -- (Selective Copy)
	GROUP	BY InstanceId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update time for the oldest data to be retained on Instance level
	UPDATE	#DA_ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
	FROM	#DA_ArchAppCopyToBeAged a, @tblDataInstance b
	WHERE	a.InstanceId = b.InstanceId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update time for the oldest data to be retained on Instance level
	-- Use this to retain logs also
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
FROM	#ArchAppCopyToBeAged a, @tblDataInstance b
WHERE	a.appType IN (128)
AND		a.AppFlags & 2 > 0
	AND		a.InstanceId = b.InstanceId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get the Max Retention copy where job is NOT marked BAD
	INSERT	INTO #tblJobMaxRet
	SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
	FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(a.JobFlags & 1) = 0
	GROUP BY a.JobId, a.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get the Max Retention copy with jobs marked BAD if no good jobs are available
	INSERT	INTO #tblJobMaxRet
	SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
	FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
	AND		NOT EXISTS (SELECT T.JobId FROM #tblJobMaxRet AS T
											WHERE a.JobId = T.jobId
											AND 	a.CommCellId = T.CommCellId)
	GROUP BY a.JobId, a.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Jobs on copy with max retention days after AgeTimeForLog cannot be aged
	-- This rule is applied for all Documentum Data
	UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 8192
	FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b, #tblJobMaxRet c
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
AND 	b.AppFlags & 2 > 0
AND		b.appFlags & 33554432 = 0
	AND		b.AgeTimeByDays = c.AgeTimeByDays
	AND		a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND		a.StartTime >= b.AgeTimeForLog
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblDataInstance
	SET oldestJobId = A.jobId
FROM @tblDataInstance T, #ArchJobCopy A, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 2 > 0
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
AND 	B.appType IN (128)
AND		B.logAgingLevel = 1
	AND		T.InstanceId = B.InstanceId
	AND		T.AgeTimeForLog = A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #ArchJobCopy
	SET oldestJobId = T.oldestJobId
FROM #ArchJobCopy A, @tblDataInstance T, #ArchAppCopyToBeAged B
WHERE A.AppFlags & 2 > 0
AND 	B.appType IN (128)
	AND		A.appId = B.appId
	AND		A.copyId = B.copyId
	AND		A.appFlags = B.appFlags
	AND		T.InstanceId = B.InstanceId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#ArchJobCopy
	SET 	retainedByJobIds = retainedByJobIds + ', ' + CAST(c.oldestJobId AS VARCHAR(10))
	FROM	#DA_JobCopyList a, #ArchJobCopy c
	WHERE	a.AppId = c.AppId
	AND 	a.CopyId = c.CopyId
	AND 	a.FileType = c.FileType
	AND		a.jobId = c.jobId
	AND 	a.CommCellId = c.CommCellId
AND		(a.jobRetainReason & 8192) > 0
	AND		c.oldestJobId > 0
	AND		c.retainedByJobIds NOT LIKE CAST(c.oldestJobId AS VARCHAR(10))
	AND		c.retainedByJobIds NOT LIKE '%' + CAST(c.oldestJobId AS VARCHAR(10)) + ',%'
	AND		c.retainedByJobIds NOT LIKE '%, ' + CAST(c.oldestJobId AS VARCHAR(10)) + ',%'
	AND		c.retainedByJobIds NOT LIKE '%, ' + CAST(c.oldestJobId AS VARCHAR(10)) + '%'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyDocumentumDataRule')
	delete from GxQscripts where name = 'daTSRptApplyDocumentumDataRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyDocumentumDataRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyDocumentumDataRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyDocumentumDataRule',  '00010003020600010000', 'daTSRptApplyDocumentumDataRule', '00010003020600010000')
GO

