

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyDDBBackupRetentionRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyDDBBackupRetentionRule.sp,v $ $Id: daTSRptApplyDDBBackupRetentionRule.sp,v 1.4.50.1 2018/03/22 03:09:56 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyDDBBackupRetentionRule()
--  |
--  | Description:  Retain the DDB Backup jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyDDBBackupRetentionRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyDDBBackupRetentionRule')
	drop procedure daTSRptApplyDDBBackupRetentionRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyDDBBackupRetentionRule')
	delete from GxQscripts where name = 'daTSRptApplyDDBBackupRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyDDBBackupRetentionRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyDDBBackupRetentionRule'
GO
print '... Creating Procedure: daTSRptApplyDDBBackupRetentionRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyDDBBackupRetentionRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @errorCode		INTEGER
	SET		@errorCode		= 0
	DECLARE	@RetainDDBBkpsOfSealedStores	INTEGER
	SET			@RetainDDBBkpsOfSealedStores	= 0
	if object_id('tempdb.dbo.#DA_ReqDDBBackupJobs') is not null DROP TABLE #DA_ReqDDBBackupJobs
	CREATE	TABLE #DA_ReqDDBBackupJobs (
			SIDBStoreId			INTEGER,
			SubStoreId			INTEGER,
			commCellId			INTEGER,
			JobId						INTEGER,
			JobCommCellId		INTEGER,
			)
	CREATE INDEX Idx_DA_ReqDDBBackupJobs_1 ON #DA_ReqDDBBackupJobs (SIDBStoreId, SubStoreId, CommCellId)
	CREATE INDEX Idx_DA_ReqDDBBackupJobs_2 ON #DA_ReqDDBBackupJobs (JobId, JobCommCellId)
	SELECT @RetainDDBBkpsOfSealedStores = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETAIN_DDB_BACKUPS_OF_SEALED_STORES'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
DECLARE @DDBBkpsToRetain INT = 0
DECLARE @prevDDBBkpsRetained INT = 0
DECLARE @err INT = 0
SET @DDBBkpsToRetain = (SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_RETAIN_NO_OF_DDB_BACKUPS')
IF @DDBBkpsToRetain > 1
BEGIN
    -- T.rn >= @DDBBkpsToRetain because we maintain old backup info in IdxSIDBSubStoreBackupInfo and latest in IdxSIDBSubStore table
    -- Delete the old DDB Backups
    DELETE I
    FROM IdxSIDBSubStoreBackupInfo I,
		(SELECT SIDBStoreId, SubStoreId, LastSnapJobId, ROW_NUMBER() OVER(PARTITION BY SIDBStoreId, SubStoreId ORDER BY LastSnapTime DESC) AS rn
		FROM IdxSIDBSubStoreBackupInfo WITH (READUNCOMMITTED)
		) T
    WHERE I.SIDBStoreId = T.SIDBStoreId
	AND I.SubStoreId = T.SubStoreId
	AND I.LastSnapJobId = T.LastSnapJobId
	AND T.rn >= @DDBBkpsToRetain
    SET	@err	=	@@ERROR
END
ELSE
BEGIN
    DELETE FROM IdxSIDBSubStoreBackupInfo
END
	SET @errorCode = @err
	IF	@errorCode != 0 GOTO CX_EXIT
	--DDB Backup before DR backup job should be retained for DDB Sync
	INSERT INTO #DA_ReqDDBBackupJobs
	SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, ISNULL(EP.longlongVal, 0), SS.CommCellId
	FROM 	IdxSIDBSubStore SS WITH (NOLOCK), MMEntityProp EP WITH (NOLOCK)
	WHERE	SS.SubStoreId = EP.EntityId
	AND	SS.commCellId = EP.commCellId
AND	EP.EntityType = 7
	AND	EP.propertyName = N'DDBDRLastBackupJobId'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #DA_ReqDDBBackupJobs
	SET JobCommCellId = C.id
	FROM #DA_ReqDDBBackupJobs T, MMEntityProp P WITH (NOLOCK), APP_CommCell C WITH (NOLOCK)
WHERE 	P.EntityType = 7
	AND	P.propertyName = N'DDBDRLastBackupJobCommCellGUID'
	AND	P.EntityId = T.SubStoreId
	AND	P.CommCellId = T.commCellId
	AND	RTRIM(LTRIM(ISNULL(P.stringVal, ''))) = RTRIM(LTRIM(ISNULL(C.csGUID, '')))
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--DDB Backup of all non-aged stores should be retained
	INSERT INTO #DA_ReqDDBBackupJobs
	SELECT DISTINCT SS.SIDBStoreId, SS.SubStoreId, SS.commCellId, SS.LastSnapJobId, CASE WHEN C.id IS NULL THEN SS.commCellId ELSE C.id END
	FROM IdxSIDBSubStore SS WITH (NOLOCK)
	INNER JOIN IdxSIDBStore S WITH (NOLOCK)
		ON 	SS.SIDBStoreId = S.SIDBStoreId
		AND	SS.commCellId = S.commCellId
	LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK)
	ON RTRIM(LTRIM(SS.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
	WHERE	SS.LastSnapJobId > 0
AND	(S.flags & 256) = 0
	AND		(	(@RetainDDBBkpsOfSealedStores = 1)
					OR
					(@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Older DDB backups of non-aged stores should also be retained
	INSERT INTO #DA_ReqDDBBackupJobs
	SELECT DISTINCT SB.SIDBStoreId, SB.SubStoreId, SB.commCellId, SB.LastSnapJobId, CASE WHEN C.id IS NULL THEN SB.commCellId ELSE C.id END
	FROM IdxSIDBSubStoreBackupInfo SB WITH (NOLOCK)
		INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON S.SIDBStoreId = SB.SIDBStoreId AND S.commCellId = SB.commCellId
	LEFT OUTER JOIN APP_CommCell C WITH (NOLOCK) ON RTRIM(LTRIM(SB.DDBBackupCSGUID)) = RTRIM(LTRIM(C.csGUID))
	WHERE SB.LastSnapJobId > 0
AND	(S.flags & 256) = 0
	AND		(	(@RetainDDBBkpsOfSealedStores = 1)
					OR
					(@RetainDDBBkpsOfSealedStores = 0 AND S.SealedTime = 0)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	--------------------- Apply DDB Backup Retention Rule -------------------------
	-------------------------------------------------------------------------------
	-- Update the jobRetainReason flag with DONOTAGE_DDB_BACKUP
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 8388608
	FROM	#DA_JobCopyList a, #DA_ReqDDBBackupJobs b
	WHERE	a.JobId = b.JobId
	AND		a.CommCellId = b.JobCommCellId
AND		a.AppFlags & 67108864 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyDDBBackupRetentionRule')
	delete from GxQscripts where name = 'daTSRptApplyDDBBackupRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyDDBBackupRetentionRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyDDBBackupRetentionRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyDDBBackupRetentionRule',  '00010004005000010000', 'daTSRptApplyDDBBackupRetentionRule', '00010004005000010000')
GO

