

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyCompliancePolicyRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyCompliancePolicyRule.sp,v $ $Id: daTSRptApplyCompliancePolicyRule.sp,v 1.1.290.1 2018/03/22 03:16:23 jiechen Exp $";
--  +============================================================================+
--  | Stored Proc:  daTSRptApplyCompliancePolicyRule()
--  |
--  | Description:  Do not age the jobs if they are not processed
--	|								by Compliance Policy
--  +============================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyCompliancePolicyRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyCompliancePolicyRule')
	drop procedure daTSRptApplyCompliancePolicyRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyCompliancePolicyRule')
	delete from GxQscripts where name = 'daTSRptApplyCompliancePolicyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyCompliancePolicyRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyCompliancePolicyRule'
GO
print '... Creating Procedure: daTSRptApplyCompliancePolicyRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyCompliancePolicyRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE	@errorCode		INTEGER
	SET		@errorCode		= 0
	DECLARE 	@IgnoreCompliancePolicyRule 	INTEGER
	SET		@IgnoreCompliancePolicyRule 	= 0
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @tblCISourceCopyList TABLE
	(
		archGrpId		INT,
		copyId			INT
		PRIMARY KEY (archGrpId, copyId)
	)
	-------------------------------------------------------------------------------
	------------ Apply Compliance Policy Rule based on Param Value ----------------
	-------------------------------------------------------------------------------
	SELECT @IgnoreCompliancePolicyRule = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_IGNORE_COMPLIANCE_POLICY_RULE'
	-------------------------------------------------------------------------------
	--------------------- Apply the Compliance Policy Rule ------------------------
	-------------------------------------------------------------------------------
	IF @IgnoreCompliancePolicyRule = 0
	BEGIN
		-- Call the JM Stored Procedure to populate the jobs pending to be processed
		-- by each available Compliance Policy
		EXEC @errorCode = JMFillCompPolicyQualifiedJobs 0
		IF	@@ERROR != 0 GOTO CX_EXIT
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO @tblCISourceCopyList
		SELECT DISTINCT CIR.archGroupId, AC.copyId
		FROM archContentIndexingRules CIR WITH (NOLOCK), #DA_AppCopyList AC
		WHERE CIR.archGroupId = AC.archGrpId
		AND		(CIR.sourceCopyId = AC.copyId OR CIR.sourceCopyId = 0)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 1048576
		FROM	#DA_JobCopyList JC, @tblCISourceCopyList SC, JMCompliancePolicyQualifiedJobs CP WITH (NOLOCK)
		WHERE	JC.jobId = CP.jobId
		AND		JC.commCellId = CP.commCellId
		AND		JC.CopyId = SC.copyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyCompliancePolicyRule')
	delete from GxQscripts where name = 'daTSRptApplyCompliancePolicyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyCompliancePolicyRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyCompliancePolicyRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyCompliancePolicyRule',  '00010001029000010000', 'daTSRptApplyCompliancePolicyRule', '00010001029000010000')
GO

