

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyBasicDaysRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyBasicDaysRule.sp,v $ $Id: daTSRptApplyBasicDaysRule.sp,v 1.1.164.1 2018/03/22 03:12:42 jiechen Exp $";
--  +===============================================================================+
--  | Stored Proc:  daTSRptApplyBasicDaysRule()
--  |
--  | Description:  Do not age jobs that have not yet met the basic days retention
--  +===============================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daTSRptApplyBasicDaysRule <<<'

IF EXISTS (select * from sysobjects where name='daTSRptApplyBasicDaysRule')
	drop procedure daTSRptApplyBasicDaysRule
IF EXISTS (select * from GxQscripts where name='daTSRptApplyBasicDaysRule')
	delete from GxQscripts where name = 'daTSRptApplyBasicDaysRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyBasicDaysRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyBasicDaysRule'
GO
print '... Creating Procedure: daTSRptApplyBasicDaysRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyBasicDaysRule
  @agingAsofDays INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE	@tblCWEORCSFullCycle TABLE (
			AppId			INTEGER,
			CopyId			INTEGER,
			FileType		INTEGER,
			fullCycleNum	INTEGER
			PRIMARY KEY (AppId, CopyId, FileType, fullCycleNum)
			)
	DECLARE	@RetentionDaysWhenCyclesIgnored		INTEGER
	SET			@RetentionDaysWhenCyclesIgnored		= 30
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @currentTime 	INTEGER
		SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE()) + @agingAsofDays * 24 * 3600
	-------------------------------------------------------------------------------
	--------------- Get number of days when cycles are ignored --------------------
	-------------------------------------------------------------------------------
	SELECT @RetentionDaysWhenCyclesIgnored = isnull(value, 30)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	----------------- Apply the Basic Retention Days Rule -------------------------
	-------------------------------------------------------------------------------
	-- Set the AgeTimeByDays for each appId Copy
	UPDATE	#DA_AppCopyList
	SET 		AgeTimeByDays = @currentTime - RetentionDays * 24 * 3600
	WHERE		RetentionDays >= 0
	--WHERE		DoNotAge = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobRetainReason flag with DONOTAGE_BYDAYS
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 16
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.StartTime >= b.AgeTimeByDays
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobRetainReason flag with DONOTAGE_BYDAYS
	-- for CWE FULL jobs not treated as valid Full / Custom Script FULL jobs
	-- when days retention is 0 and cycles are ignored
	INSERT INTO @tblCWEORCSFullCycle
	SELECT  DISTINCT a.AppId, a.CopyId, a.FileType, a.fullCycleNum
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	b.RetentionDays = 0
	AND		b.RetentionCycles > 0
AND		(a.AppFlags & 2) = 2
	AND 	a.BkpLevel = 1
	AND		(
				(a.isCWEjobValid != 1 AND a.JobStatus IN (3))
				OR
(a.JobFlags & 16777216 > 0 AND a.JobFlags & 8388608 = 0)
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 16
	FROM	#DA_JobCopyList a,  @tblCWEORCSFullCycle t
	WHERE	a.AppId = t.AppId
	AND 	a.CopyId = t.CopyId
	AND 	a.FileType = t.FileType
	AND		a.fullCycleNum = t.fullCycleNum
AND		(a.AppFlags & 2) = 2
	AND		a.StartTime >= (@currentTime - @RetentionDaysWhenCyclesIgnored * 24 * 3600)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #ArchJobCopy
		SET retentionDays = @RetentionDaysWhenCyclesIgnored
		FROM #ArchJobCopy a, @tblCWEORCSFullCycle t
		WHERE a.AppId = t.AppId
		AND   a.CopyId = t.CopyId
		AND	  a.FileType = t.FileType
		AND		a.fullCycleNum = t.fullCycleNum
AND		(a.AppFlags & 2) = 2
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	-- Special case for calculating AgeTimeByDays
	-- When SP for a subclient is changed, do not prune the incrementals
	-- on new SP until a FULL is found on new SP
	-- These incrementals on new SP without the FULL will be pruned
	-- based on days retention once the new FULL is found
	-- Update the jobRetainReason flag with DONOTAGE_SPCHANGE_KEEPLASTFULL
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 2048
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.StartTime >= b.StartTimeLastFull
--	AND 	b.AgeTimeByDays > b.StartTimeLastFull
	AND		b.StartTimeLastFull > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update for infinite retention
	UPDATE #DA_JobCopyList
SET jobRetainReason = (a.jobRetainReason & (~16))| 2
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
AND		b.DoNotAge & 2 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyBasicDaysRule')
	delete from GxQscripts where name = 'daTSRptApplyBasicDaysRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyBasicDaysRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyBasicDaysRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyBasicDaysRule',  '00010001016400010000', 'daTSRptApplyBasicDaysRule', '00010001016400010000')
GO

