

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daTSRptApplyBasicCyclesRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daTSRptApplyBasicCyclesRule.sp,v $ $Id: daTSRptApplyBasicCyclesRule.sp,v 1.2.78.2 2018/12/27 16:49:31 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daTSRptApplyBasicCyclesRule()
--  |
--  | Description:  Retain the jobs based on cycle retention on each copy
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daTSRptApplyBasicCyclesRule')
BEGIN
	print '>>> Drop Stored Procedure: daTSRptApplyBasicCyclesRule <<<'
	drop procedure daTSRptApplyBasicCyclesRule
END
IF EXISTS (select * from GxQscripts where name='daTSRptApplyBasicCyclesRule')
	delete from GxQscripts where name = 'daTSRptApplyBasicCyclesRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyBasicCyclesRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyBasicCyclesRule'
GO
print '... Creating Procedure: daTSRptApplyBasicCyclesRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daTSRptApplyBasicCyclesRule
  @i_PickToBeCopiedJobs INTEGER,
  @i_dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @AppCopyListCursorFlag 						INTEGER
	DECLARE @curAppId													INTEGER
	DECLARE @curCopyId												INTEGER
	DECLARE @curFileType											INTEGER
	DECLARE @curRetentionCycles								INTEGER
	DECLARE @fullJobFound 										INTEGER
	SET 	@AppCopyListCursorFlag 							= 0
	SET 	@curAppId														= 0
	SET 	@curCopyId													= 0
	SET 	@curFileType												= 0
	SET		@curRetentionCycles									= 0
	SET		@fullJobFound 											= 0
	if object_id('tempdb.dbo.#ReqFullCycles') is not null DROP TABLE #ReqFullCycles
	CREATE	TABLE #ReqFullCycles(
			AppId int, CopyId int, FileType int,
			CommCellId int, StartTime int, fullCycleNum int
			)
	if object_id('tempdb.dbo.#tblRetainRequiredJobs') is not null DROP TABLE #tblRetainRequiredJobs
	CREATE	TABLE	#tblRetainRequiredJobs  (
			AppId int, CopyId int, FileType int,
			fullCycleNum int, StartTime int,
			retainIncrBeforeDiff int, lastDiffStartTime int
			)
	CREATE INDEX Idx_tblRetainRequiredJobs_1 ON #tblRetainRequiredJobs (AppId, CopyId, FileType, fullCycleNum)
	if object_id('tempdb.dbo.#tblFullCycles') is not null DROP TABLE #tblFullCycles
	CREATE	TABLE	#tblFullCycles (
			JobCopyId int IDENTITY(1,1),
			AppId int, CopyId int, FileType int, CommCellId int,
			StartTime int, fullCycleNum int
			)
	CREATE INDEX Idx_tblFullCycles_1 ON #tblFullCycles (AppId, CopyId, FileType, fullCycleNum)
	DECLARE @minCycleId INTEGER
	-------------------------------------------------------------------------------
	----------------- Apply the Basic Retention Cycles Rule -----------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------- Declare cursor for AppId Copy to be processed -----------------
	-------------------------------------------------------------------------------
		-- report needs to calculate cycle for all application including jobs already
		-- marked as do not age
		DECLARE	AppCopyListCursor CURSOR STATIC FOR
				SELECT	DISTINCT AppId, CopyId, FileType, RetentionCycles
				FROM	#DA_AppCopyList
				WHERE RetentionCycles > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SET		@AppCopyListCursorFlag = 1
	OPEN	AppCopyListCursor
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	FETCH	NEXT
	FROM AppCopyListCursor
	INTO	@curAppId, @curCopyId, @curFileType, @curRetentionCycles
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		-- Clean the temp table for each appId/CopyId
		TRUNCATE TABLE #ReqFullCycles
		-- Do not Consider the jobs on linked storage policy copy
		-- Partial or Disabled full will be treated as valid cycle based on appType settings
		-- Do Not consider the jobs that are marked bad for cycles retention
		INSERT	INTO #DA_ReqFullCycles
				( AppId, CopyId, FileType, CommCellId, JobId, StartTime, fullCycleNum )
		SELECT	TOP (@curRetentionCycles) a.AppId, a.CopyId, a.FileType, a.CommCellId, a.JobId, a.StartTime, a.fullCycleNum
		FROM	#DA_JobCopyList a
		WHERE	a.AppId = @curAppId
		AND 	a.CopyId = @curCopyId
		AND 	a.FileType = @curFileType
		AND 	a.BkpLevel = 1
		AND 	(
						(a.isCWEjobValid = 1 AND a.JobStatus IN (1, 3, 14))
						OR
				 		(a.isCWEjobValid <> 1 AND a.JobStatus IN (1, 14))
					)
		AND		(
(a.JobFlags & 16777216 = 0)
						OR
(a.JobFlags & 16777216 > 0 AND a.JobFlags & 8388608 > 0)
					)
		AND		(
(a.JobFlags & 64 = 0)
						OR
(a.JobFlags & 128 > 0)
					)
		AND 	(
						(@i_PickToBeCopiedJobs = 0 AND a.DataStatus = 100)
						OR
						(@i_PickToBeCopiedJobs = 1 AND ((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0)))
					)
AND		(a.JobFlags & 1) = 0
AND		(a.JobFlags & 32) = 0
		ORDER	BY a.AppId, a.CopyId, a.FileType, a.StartTime DESC
		SELECT 	@errorCode = @@ERROR, @fullJobFound = @@ROWCOUNT
		IF		@errorCode != 0 GOTO CX_EXIT
		-- If no valid Full job found on copy, then get the required cycle numbers to retain them
		IF		@fullJobFound = 0
		BEGIN
			INSERT	INTO #ReqFullCycles
					( AppId, CopyId, FileType, CommCellId, StartTime, fullCycleNum )
			SELECT	a.AppId, a.CopyId, a.FileType, a.CommCellId, MAX(a.StartTime), a.fullCycleNum
			FROM	#DA_JobCopyList a
			WHERE	a.AppId = @curAppId
			AND 	a.CopyId = @curCopyId
			AND 	a.FileType = @curFileType
			AND 	(
							(a.isCWEjobValid = 1 AND a.JobStatus IN (1, 3, 14))
							OR
					 		(a.isCWEjobValid <> 1 AND a.JobStatus IN (1, 14))
						)
			AND		(
(a.JobFlags & 16777216 = 0)
							OR
(a.JobFlags & 16777216 > 0 AND a.JobFlags & 8388608 > 0)
						)
			AND 	(
							(@i_PickToBeCopiedJobs = 0 AND a.DataStatus = 100)
							OR
							(@i_PickToBeCopiedJobs = 1 AND ((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0)))
						)
AND		(a.JobFlags & 32) = 0
			GROUP BY a.AppId, a.CopyId, a.FileType, a.CommCellId, a.fullCycleNum
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			INSERT	INTO #DA_ReqFullCycles
					( AppId, CopyId, FileType, CommCellId, JobId, StartTime, fullCycleNum )
			SELECT	TOP (@curRetentionCycles) a.AppId, a.CopyId, a.FileType, a.CommCellId, 0, 0, a.fullCycleNum
			FROM	#ReqFullCycles a
			ORDER	BY a.AppId, a.CopyId, a.FileType, a.StartTime DESC
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
			-- Calculate Cycle Numbers for report
			INSERT	INTO #tblFullCycles
					( AppId, CopyId, FileType, CommCellId, StartTime, fullCycleNum )
			SELECT	a.AppId, a.CopyId, a.FileType, a.CommCellId, a.StartTime, a.fullCycleNum
			FROM	#DA_JobCopyList a
			WHERE	a.AppId = @curAppId
			AND 	a.CopyId = @curCopyId
			AND 	a.FileType = @curFileType
			AND 	a.BkpLevel = 1
			AND 	(
							(a.isCWEjobValid = 1 AND a.JobStatus IN (1, 3, 14))
							OR
					 		(a.isCWEjobValid <> 1 AND a.JobStatus IN (1, 14))
						)
			AND		(
(a.JobFlags & 16777216 = 0)
							OR
(a.JobFlags & 16777216 > 0 AND a.JobFlags & 8388608 > 0)
						)
			AND		(
(a.JobFlags & 64 = 0)
							OR
(a.JobFlags & 128 > 0)
						)
			AND 	a.DataStatus = 100
			--No need to check for "Do Not Copy" flag since now we have BAD flag. Job should be ignored only when marked BAD and not when they are just marked "Do Not Copy"
			--AND 	a.Disabled = 0
AND		(a.JobFlags & 1) = 0
AND		(a.JobFlags & 32) = 0
			ORDER	BY a.AppId, a.CopyId, a.FileType, a.StartTime DESC
			SELECT 	@errorCode = @@ERROR, @fullJobFound = @@ROWCOUNT
			IF		@errorCode != 0 GOTO CX_EXIT
			-- If no valid Full job found on copy, then get any available job
			IF		@fullJobFound = 0
			BEGIN
				INSERT	INTO #tblFullCycles
						( AppId, CopyId, FileType, CommCellId, StartTime, fullCycleNum )
				SELECT	a.AppId, a.CopyId, a.FileType, a.CommCellId, MAX(a.StartTime), a.fullCycleNum
				FROM	#DA_JobCopyList a
				WHERE	a.AppId = @curAppId
				AND 	a.CopyId = @curCopyId
				AND 	a.FileType = @curFileType
				AND 	(
								(a.isCWEjobValid = 1 AND a.JobStatus IN (1, 3, 14))
								OR
						 		(a.isCWEjobValid <> 1 AND a.JobStatus IN (1, 14))
							)
				AND		(
(a.JobFlags & 16777216 = 0)
								OR
(a.JobFlags & 16777216 > 0 AND a.JobFlags & 8388608 > 0)
							)
			AND 	a.DataStatus = 100
AND		(a.JobFlags & 32) = 0
			GROUP BY a.AppId, a.CopyId, a.FileType, a.CommCellId, a.fullCycleNum
			ORDER	BY a.AppId, a.CopyId, a.FileType, MAX(a.StartTime) DESC
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
			END
			SELECT @minCycleId = min(JobCopyId) FROM #tblFullCycles
			-- Update the cycle id
			UPDATE	#DA_JobCopyList
			SET 	CycleId = b.JobCopyId - @minCycleId + 1
			FROM	#DA_JobCopyList a, #tblFullCycles b
			WHERE	a.AppId = b.AppId
			AND 	a.CopyId = b.CopyId
			AND 	a.FileType = b.FileType
			AND		a.CommCellId = b.CommCellId
			AND 	a.fullCycleNum = b.fullCycleNum
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #tblFullCycles
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM AppCopyListCursor
		INTO	@curAppId, @curCopyId, @curFileType, @curRetentionCycles
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	INSERT INTO #tblRetainRequiredJobs
	SELECT a.AppId, a.CopyId, a.FileType, a.fullCycleNum, a.StartTime, b.retainIncrBeforeDiff, 0
FROM #DA_ReqFullCycles a, #ArchAppCopyToBeAged b
	WHERE a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblRetainRequiredJobs
	SET lastDiffStartTime = b.lastDiffStartTime
	FROM #tblRetainRequiredJobs a,
				(SELECT AppId, CopyId, fileType, fullCycleNum, MAX(StartTime) AS lastDiffStartTime
				FROM #DA_JobCopyList
				WHERE BkpLevel = 4
				GROUP BY AppId, CopyId, fileType, fullCycleNum) b
	WHERE a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.fullCycleNum = b.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--------------------------------------------------------------------------------------
	-- Retain the jobs based on cycle number
	--------------------------------------------------------------------------------------
	-- Update the jobRetainReason flag with DONOTAGE_BYCYCLES
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 32
	FROM	#DA_JobCopyList a, #tblRetainRequiredJobs b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.fullCycleNum = b.fullCycleNum
	AND		(b.retainIncrBeforeDiff = 1 OR b.lastDiffStartTime = 0)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobRetainReason flag with DONOTAGE_BYCYCLES
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 32
	FROM	#DA_JobCopyList a, #tblRetainRequiredJobs b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.fullCycleNum = b.fullCycleNum
	AND		b.retainIncrBeforeDiff = 0
	AND		b.lastDiffStartTime > 0
	AND		(a.BkpLevel = 1 OR a.StartTime >= b.lastDiffStartTime)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobRetainReason flag with DONOTAGE_BYCYCLES
	-- Retain all jobs after the Full retained with BASIC_CYCLES for OnePass
	-- Do not age later jobs based on days retention if they are marked BAD
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 32
	FROM	#DA_JobCopyList a, (
															SELECT appId, copyId, fileType, MIN(StartTime) AS StartTime
															FROM #tblRetainRequiredJobs
															GROUP BY appId, copyId, fileType) b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.StartTime >= b.StartTime
AND		a.appFlags & CAST(68719476736 AS bigint) > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @AppCopyListCursorFlag = 1
	BEGIN
			CLOSE				AppCopyListCursor
			DEALLOCATE	AppCopyListCursor
	END
	if object_id('tempdb.dbo.#ReqFullCycles') is not null DROP TABLE #ReqFullCycles
	if object_id('tempdb.dbo.#tblRetainRequiredJobs') is not null DROP TABLE #tblRetainRequiredJobs
	if object_id('tempdb.dbo.#tblFullCycles') is not null DROP TABLE #tblFullCycles
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daTSRptApplyBasicCyclesRule')
	delete from GxQscripts where name = 'daTSRptApplyBasicCyclesRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daTSRptApplyBasicCyclesRule')
	delete from GXDBVersions where aliasname = 'daTSRptApplyBasicCyclesRule'
GO

insert into GXDBVersions values(2, 'daTSRptApplyBasicCyclesRule',  '00010002007800020000', 'daTSRptApplyBasicCyclesRule', '00010002007800020000')
GO

