

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daSqlChainJobOldDB.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daSqlChainJobOldDB.sp,v $ $Id: daSqlChainJobOldDB.sp,v 1.2.304.1 2018/03/20 19:50:22 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daSqlChainJobOldDB()
--  |
--  | Description:  Get SQL Full jobs to be chained.
--	|				It is used by sql ida installed at 5.9 and before.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daSqlChainJobOldDB <<<'

IF EXISTS (select * from sysobjects where name='daSqlChainJobOldDB')
	drop procedure daSqlChainJobOldDB
IF EXISTS (select * from GxQscripts where name='daSqlChainJobOldDB')
	delete from GxQscripts where name = 'daSqlChainJobOldDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daSqlChainJobOldDB')
	delete from GXDBVersions where aliasname = 'daSqlChainJobOldDB'
GO
print '... Creating Procedure: daSqlChainJobOldDB'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daSqlChainJobOldDB
  @inAppId INTEGER,
  @inCopyId INTEGER,
  @inTime INTEGER
AS
  DECLARE @o_jobId INTEGER;
  DECLARE @o_commCellId INTEGER;
  DECLARE @o_startTime INTEGER;
	SET NOCOUNT ON
	DECLARE	 @tempJob TABLE(
			jobId int, copyId int,
			dataType int, commCellId int,
			servStartDate int,
			primary key (jobId, copyId, dataType, commCellId)
			)
	INSERT	INTO @tempJob
	SELECT	jobId, @inCopyId, 1, commCellId, servStartDate
	FROM	JMBkpStats WITH (NOLOCK)
	WHERE	appId = @inAppId
	AND		servStartDate < @inTime
	AND		bkpLevel = 1
	AND		status = 1
	-- To be copied jobs will be checked too for sql chain
	SELECT	b.jobId, b.commCellId, b.servStartDate
	FROM	JMJobDataStats a WITH (NOLOCK), @tempJob b
	WHERE	a.jobId = b.jobId
	AND		a.archGrpCopyId = b.copyId
	AND		a.dataType = b.dataType
	AND		a.commCellId = b.commCellId
	AND		a.disabled & 256 = 0
	AND		(a.status = 100 or a.status in (101, 102, 103) and a.disabled = 0)
	ORDER	BY b.servStartDate ASC
GO

IF EXISTS (select * from GxQscripts where name = 'daSqlChainJobOldDB')
	delete from GxQscripts where name = 'daSqlChainJobOldDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daSqlChainJobOldDB')
	delete from GXDBVersions where aliasname = 'daSqlChainJobOldDB'
GO

insert into GXDBVersions values(2, 'daSqlChainJobOldDB',  '00010002030400010000', 'daSqlChainJobOldDB', '00010002030400010000')
GO

