

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daSqlChainDataOldDB.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daSqlChainDataOldDB.sp,v $ $Id: daSqlChainDataOldDB.sp,v 1.1.304.2 2018/03/20 20:00:11 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daSqlChainDataOldDB()
--  |
--  | Description:  Update the age time for data of sql ida installed before 6.1.
--	|				It is to be called after all subclients have been checked
--	|				for sql chain individually by calling sql ida function.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daSqlChainDataOldDB <<<'

IF EXISTS (select * from sysobjects where name='daSqlChainDataOldDB')
	drop procedure daSqlChainDataOldDB
IF EXISTS (select * from GxQscripts where name='daSqlChainDataOldDB')
	delete from GxQscripts where name = 'daSqlChainDataOldDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daSqlChainDataOldDB')
	delete from GXDBVersions where aliasname = 'daSqlChainDataOldDB'
GO
print '... Creating Procedure: daSqlChainDataOldDB'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daSqlChainDataOldDB
AS
  DECLARE @o_error INTEGER;
	SET NOCOUNT ON
	BEGIN TRANSACTION TranDaSqlChainDataOldDB
	-- Update DoNotAge based on AgeTimeSqlChain
	UPDATE	ArchAppCopyToBeAged
SET 	AgeStatus = 1,
DoNotAge = DoNotAge | 64,
			AgeTimeBasicRet = StartTimeOldestJob
WHERE	AppFlags & 16 > 0
AND 	AgeStatus = 4
	AND 	StartTimeOldestJob >= AgeTimeSqlChain
	AND		AgeTimeSqlChain > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Update AgeTimeBasicRet based on AgeTimeSqlChain
	UPDATE	ArchAppCopyToBeAged
	SET 	AgeTimeBasicRet = AgeTimeSqlChain
WHERE	AppFlags & 16 > 0
AND 	AgeStatus = 4
	AND 	AgeTimeBasicRet > AgeTimeSqlChain
	AND		AgeTimeSqlChain > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	COMMIT TRANSACTION TranDaSqlChainDataOldDB
	SELECT 0
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TranDaSqlChainDataOldDB
	SELECT	-1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daSqlChainDataOldDB')
	delete from GxQscripts where name = 'daSqlChainDataOldDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daSqlChainDataOldDB')
	delete from GXDBVersions where aliasname = 'daSqlChainDataOldDB'
GO

insert into GXDBVersions values(2, 'daSqlChainDataOldDB',  '00010001030400020000', 'daSqlChainDataOldDB', '00010001030400020000')
GO

