

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daSqlChainData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daSqlChainData.sp,v $ $Id: daSqlChainData.sp,v 1.2.304.2 2018/03/20 20:06:07 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daSqlChainData()
--  |
--  | Description:  Get the age time for data of sql ida installed in 6.1 and after.
--	|				It is to be called after all other subclients have been aged
--	|				by calling daAgeAppIdByRules.sp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daSqlChainData <<<'

IF EXISTS (select * from sysobjects where name='daSqlChainData')
	drop procedure daSqlChainData
IF EXISTS (select * from GxQscripts where name='daSqlChainData')
	delete from GxQscripts where name = 'daSqlChainData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daSqlChainData')
	delete from GXDBVersions where aliasname = 'daSqlChainData'
GO
print '... Creating Procedure: daSqlChainData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daSqlChainData
  @numAppIdToChain INTEGER
AS
  DECLARE @o_numAppIdChained INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode			INTEGER
	DECLARE @numAppIdChained	INTEGER
	SET		@errorCode			= 0
	SET		@numAppIdChained	= 0
	BEGIN TRANSACTION TranDaSqlChainData
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_ArchFileSQLDB') is not null DROP TABLE #DA_ArchFileSQLDB
	-- Identity used to prevent two archive files have the same cTime
	CREATE	TABLE #DA_ArchFileSQLDB (
			AFileId int IDENTITY(1,1),
			AppId int, ArchFileId int, FileType int,
			JobId int, CommCellId int,
			StartTime int, SqlDbBackupFileId int,
			Primary Key (AFileId)
			)
	CREATE INDEX Idx_DA_ArchFileSQLDB_1 ON #DA_ArchFileSQLDB (JobId, CommCellId)
	CREATE INDEX Idx_DA_ArchFileSQLDB_2 ON #DA_ArchFileSQLDB (ArchFileId, CommCellId)
	CREATE INDEX Idx_DA_ArchFileSQLDB_3 ON #DA_ArchFileSQLDB (SqlDbBackupFileId)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	DECLARE @tblAppIdList TABLE (
			rowId int IDENTITY(1,1),
			appId int,
			fileType int,
			backupSetId int,
			Primary key (appId, fileType)
			)
	DECLARE	@tblAppIdSQL TABLE ( AppId int )
	DECLARE	@tbAppIdSQLDB TABLE(
			AppId int, CopyId int,
			AFileId int, SqlDbBackupFileId int
			)
	DECLARE	@tblAppIdSqlChain TABLE(
			AppId int, CopyId int,
			SqlDbBackupFileId int, SqlLastLogBackup int,
			StartTimeSqlFull int, StartTimeLog int
			)
	-------------------------------------------------------------------------------
	------------------- GET AppId TO BE PROCESSED ---------------------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblAppIdList
			(appId, fileType, backupSetId)
	SELECT	DISTINCT appId, fileType, backupSetId
	FROM	ArchAppCopyToBeAged
WHERE	AgeStatus = 3
AND		AppFlags & 32 > 0
	ORDER	BY appId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdToChain > 0
			DELETE	FROM @tblAppIdList
			WHERE	rowId > @numAppIdToChain
	-- Get appId to be processed
	SELECT	b.*
	INTO	#DA_AppCopyList
	FROM	@tblAppIdList a, ArchAppCopyToBeAged b
WHERE	b.AgeStatus = 3
	AND 	a.appId = b.appId
	AND 	a.fileType = b.fileType
	SELECT 	@errorCode = @@ERROR, @numAppIdChained = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdChained = 0 GOTO CX_UPDATE
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	----  PROCESS SQL IDA CHAINING RULE For IDA INSTALLED IN 6.1 AND AFTER  -------
	-------------------------------------------------------------------------------
	-- Get all subclients for SQL backupsets to be processed
	INSERT	INTO @tblAppIdSQL
	SELECT	DISTINCT b.Id as AppId
	FROM	@tblAppIdList a, App_Application b WITH (NOLOCK)
	WHERE	a.BackupSetId = b.BackupSet
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Get archive files on all copies for SQL subclients to be processed
	INSERT	INTO #DA_ArchFileSQLDB
			(AppId, ArchFileId, FileType, JobId, CommCellId, StartTime, SqlDbBackupFileId)
	SELECT	a.AppId, b.Id, b.FileType, b.JobId, b.CommCellId, b.cTime, 0
	FROM	@tblAppIdSQL a, archFile b WITH (NOLOCK), archFileCopy c WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	b.id = c.archFileId
	AND 	b.CommCellId = c.CommCellId
	AND 	b.isValid = 1
	AND		b.isValid = 1
	AND 	c.flags & 256 = 0
	GROUP	BY a.AppId, b.Id, b.FileType, b.JobId, b.CommCellId, b.cTime
	ORDER	BY b.cTime ASC
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_ArchFileSQLDB
	SET 	StartTime = b.ServStartDate
	FROM	#DA_ArchFileSQLDB a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_ArchFileSQLDB
	SET 	SqlDbBackupFileId = b.SqlDbBackupFileId
	FROM	#DA_ArchFileSQLDB a, SqlArchiveInfo b WITH (NOLOCK)
	WHERE	a.ArchFileId = b.AFileId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Get the oldest data archive file created after AgeTimeBasicRet
	INSERT	INTO @tbAppIdSQLDB
	SELECT	b.AppId, b.CopyId, MIN(a.AFileId), 0
	FROM	#DA_ArchFileSQLDB a, #DA_AppCopyList b
WHERE	b.AppFlags & 32 > 0
	AND 	a.AppId = b.AppId
	AND		b.FileType = 1
	AND 	a.StartTime >= b.AgeTimeBasicRet
	GROUP	BY b.AppId, b.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tbAppIdSQLDB
	SET 	SqlDbBackupFileId = b.SqlDbBackupFileId
	FROM	@tbAppIdSQLDB a, #DA_ArchFileSQLDB b
	WHERE	a.AFileId = b.AFileId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Get the SqlDbBackupFileId chained with archive file
	INSERT	INTO @tblAppIdSqlChain
	SELECT	a.AppId, a.CopyId, MIN(c.SqlDbBackupFileId), 0, 0, 0
	FROM	@tbAppIdSQLDB a, SqlDbBackupInfo b WITH (NOLOCK), #DA_ArchFileSQLDB c
	WHERE	a.AppId = b.AppId
	AND 	b.Type = 'D'
	AND 	a.SqlDbBackupFileId > b.Id
	AND 	a.SqlDbBackupFileId < b.SqlLastLogBackup
	AND 	b.Id = c.SqlDbBackupFileId
	GROUP	BY a.AppId, a.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblAppIdSqlChain
	SET 	SqlLastLogBackup = b.SqlLastLogBackup
	FROM	@tblAppIdSqlChain a, SqlDbBackupInfo b WITH (NOLOCK)
	WHERE	a.SqlDbBackupFileId = b.Id
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblAppIdSqlChain
	SET 	StartTimeSqlFull = b.StartTime
	FROM	@tblAppIdSqlChain a, #DA_ArchFileSQLDB b
	WHERE	a.SqlDbBackupFileId = b.SqlDbBackupFileId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblAppIdSqlChain
	SET 	StartTimeLog = b.StartTime
	FROM	@tblAppIdSqlChain a, #DA_ArchFileSQLDB b
	WHERE	a.sqlLastLogBackup = b.SqlDbBackupFileId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeSqlChain = b.StartTimeSqlFull
	FROM	#DA_AppCopyList a, @tblAppIdSqlChain b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	------------  Update AgeTimeBasicRet based on AgeTimeSqlChain -----------------
	------------  This applies to both new and old sql databases  -----------------
	-------------------------------------------------------------------------------
CX_UPDATE:
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeBasicRet = AgeTimeSqlChain
	FROM	#DA_AppCopyList
	WHERE	AgeTimeBasicRet > AgeTimeSqlChain
	AND		AgeTimeSqlChain > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
SET 	AgeStatus = 4
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
SET 	AgeStatus = 1,
DoNotAge = DoNotAge | 64,
			AgeTimeBasicRet = StartTimeOldestJob
	FROM	#DA_AppCopyList
	WHERE	StartTimeOldestJob >= AgeTimeSqlChain
	AND		AgeTimeSqlChain > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	ArchAppCopyToBeAged
	SET 	AgeStatus = b.AgeStatus,
			DoNotAge = b.DoNotAge,
			AgeTimeBasicRet = b.AgeTimeBasicRet,
			AgeTimeSqlChain = b.AgeTimeSqlChain
	FROM	ArchAppCopyToBeAged a, #DA_AppCopyList b
WHERE	a.AgeStatus = 3
	AND		a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND		a.FileType = b.FileType
	SELECT 	@errorCode = @@ERROR, @numAppIdChained = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_ArchFileSQLDB') is not null DROP TABLE #DA_ArchFileSQLDB
	COMMIT TRANSACTION TranDaSqlChainData
	SELECT @numAppIdChained
	RETURN
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_ArchFileSQLDB') is not null DROP TABLE #DA_ArchFileSQLDB
	ROLLBACK TRANSACTION TranDaSqlChainData
	SELECT	-1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daSqlChainData')
	delete from GxQscripts where name = 'daSqlChainData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daSqlChainData')
	delete from GXDBVersions where aliasname = 'daSqlChainData'
GO

insert into GXDBVersions values(2, 'daSqlChainData',  '00010002030400020000', 'daSqlChainData', '00010002030400020000')
GO

