

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daResetAppIdRefTime.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daResetAppIdRefTime()
--  | Description:  Reset subclient reference time to start next job full
--	|				for selected appType.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daResetAppIdRefTime.sp,v $ $Id: daResetAppIdRefTime.sp,v 1.15.276.6 2019/04/09 21:17:06 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daResetAppIdRefTime')
BEGIN
	print '>>> Drop Stored Procedure: daResetAppIdRefTime <<<'
	drop procedure daResetAppIdRefTime
END
IF EXISTS (select * from GxQscripts where name='daResetAppIdRefTime')
	delete from GxQscripts where name = 'daResetAppIdRefTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daResetAppIdRefTime')
	delete from GXDBVersions where aliasname = 'daResetAppIdRefTime'
GO
print '... Creating Procedure: daResetAppIdRefTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure daResetAppIdRefTime
AS
  DECLARE @numAppIdReset integer;
SET NOCOUNT ON
	BEGIN TRANSACTION TranResetAppIdRefTime
	DECLARE @currentTime 				INTEGER
	DECLARE @attrType 					INTEGER
	DECLARE	@attrName						VARCHAR(1024)
	DECLARE	@attrVal						VARCHAR(1024)
	DECLARE @resetCount		 			INTEGER
	DECLARE @errorCode					INTEGER
	SET 	@currentTime 					= dbo.GetUnixTime(GETUTCDATE())
	SET 	@attrType							= 7
	SET 	@attrName							= 'Reason last backup time cleared'
SET 	@attrVal							= '11'
	SET		@resetCount 					= 0
	SET		@errorCode						= 0
	DECLARE @checkSumSysFullCycleNum INTEGER
	SET @checkSumSysFullCycleNum = CHECKSUM(N'sys:full cycle num')
	DECLARE @checkSumArchiverRet INTEGER
	SET @checkSumArchiverRet = CHECKSUM(N'Honor Archiver Agent Retention')
	DECLARE @checkSumSysLastFull INTEGER
	SET @checkSumSysLastFull = CHECKSUM(N'sys:last full')
	DECLARE @checkSumLastBkpTimeCleared INTEGER
	SET @checkSumLastBkpTimeCleared = CHECKSUM(N'Reason last backup time cleared')
	DECLARE @checkSumIsTurboSC INTEGER
	SET @checkSumIsTurboSC = CHECKSUM(N'Is Turbo Subclient')
	DECLARE @checkSumFirstTurboJob INTEGER
	SET @checkSumFirstTurboJob = CHECKSUM(N'First Turbo Job Id')
	DECLARE @checkSumTurboLastFull INTEGER
	SET @checkSumTurboLastFull = CHECKSUM(N'turbo:last full')
	DECLARE @checkSumTurboLastIncr INTEGER
	SET @checkSumTurboLastIncr = CHECKSUM(N'turbo:last incr')
	if object_id('tempdb.dbo.#tblAppIdToCheck') is not null DROP TABLE #tblAppIdToCheck
	if object_id('tempdb.dbo.#tblAppIdWithJob') is not null DROP TABLE #tblAppIdWithJob
	if object_id('tempdb.dbo.#tblAppIdToReset') is not null DROP TABLE #tblAppIdToReset
	if object_id('tempdb.dbo.#tblAppIdWithDaysOnlyRet') is not null DROP TABLE #tblAppIdWithDaysOnlyRet
	CREATE TABLE #tblAppIdToCheck ( appId INTEGER PRIMARY KEY (appId) )
	CREATE TABLE #tblAppIdWithJob ( appId INTEGER PRIMARY KEY (appId) )
	CREATE TABLE #tblAppIdToReset ( appId INTEGER PRIMARY KEY (appId) )
	CREATE TABLE #tblAppIdWithDaysOnlyRet ( appId INTEGER PRIMARY KEY (appId) )
	-- Do not consider the DR Subclient and Online CI Subclient
	INSERT	INTO #tblAppIdToCheck
	SELECT	DISTINCT A.id
	FROM	APP_Application A WITH (NOLOCK)
	WHERE appTypeId NOT IN (1000, 93) AND
	/*Do not force full for log subclient of lotus notes DB. They run forever incremental*/
	(
A.appTypeId NOT IN(59, 77)
OR A.subclientStatus & 0x0080 = 0
	)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	-- Do not consider the new appId for which no jobs are run at all
	DELETE #tblAppIdToCheck
	FROM #tblAppIdToCheck APP LEFT OUTER JOIN APP_SubClientProp PROP WITH (NOLOCK)
	ON	APP.appId = PROP.componentNameId
	AND	PROP.attrName = N'sys:full cycle num'
	AND PROP.cs_attrName = @checkSumSysFullCycleNum
	AND PROP.attrVal != '0'
	AND PROP.modified = 0
	WHERE PROP.componentNameId IS NULL
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	-- Get appId with valid FULL job
	INSERT	INTO #tblAppIdWithJob
	SELECT	DISTINCT A.appId
	FROM	JMJobDataStats A WITH (NOLOCK), #tblAppIdToCheck B, JMBkpStats C WITH (NOLOCK)
	WHERE	A.appId = B.appId
	AND 	A.jobId = C.jobId
	AND		A.commCellId = C.commCellId
	AND 	C.bkpLevel in (1, 64, 128, 1024, 32768, 131072, 262144)
	AND		A.status = 100
AND		A.disabled & 64 = 0
AND		A.disabled & 256 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	-- Get appId without valid FULL on data storage policy
	DELETE	#tblAppIdToCheck
	FROM	#tblAppIdToCheck A, #tblAppIdWithJob B
	WHERE	A.appId = B.appId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	TRUNCATE TABLE #tblAppIdWithJob
	-- Ignore VSA live sync direct subclients if there are some valid jobs. They will not have backup copy and they only do snaps for replication
	-- which will be pruned based on subclient based job retention count
	DECLARE @checkSumVSALiveSync int
	SET @checkSumVSALiveSync = CHECKSUM(N'Virtual Server Number Of Snaps To Retain')
	DECLARE @checkSumVSARetOverride int
	SET @checkSumVSARetOverride = CHECKSUM(N'Virtual Server Retention override')
	DELETE T
	FROM #tblAppIdToCheck T, App_SubclientProp App1 WITH(NOLOCK), App_SubclientProp App2 WITH(NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE	T.appId = App1.componentNameId
	AND		App1.componentNameId = App2.componentNameId
	AND 	App1.attrName = N'Virtual Server Number Of Snaps To Retain'
	AND 	App1.cs_attrName = @checkSumVSALiveSync
	AND 	CAST(App1.attrVal AS INT) > 0
	AND 	App1.modified = 0
	AND		App2.attrName = N'Virtual Server Retention override'
	AND		App2.cs_attrName = @checkSumVSARetOverride
	AND		CAST(App2.attrVal AS INT) > 0
	AND		App2.modified = 0
	AND		T.appId = JDS.appId
	AND		JDS.dataType = 1
	AND		JDS.status = 100
AND		JDS.disabled & 64 = 0
AND		JDS.disabled & 256 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	-- Get appId that must have valid FULL job
	-- Do not consider the AppId on the copy with Ignore Job Dependency checks
	INSERT	INTO #tblAppIdToReset
	SELECT	DISTINCT A.appId
	FROM	#tblAppIdToCheck A, JMJobDataStats B WITH (NOLOCK), archAgingRule C WITH (NOLOCK), APP_Application D WITH (NOLOCK)
	WHERE	A.appId = B.appId
	AND		A.appId = D.Id
	AND		D.dataArchGrpId = B.archGrpId
	AND		B.archGrpCopyId = C.copyId
	AND		C.flags & 16 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	-- Do not consider the AppId honoring days only retention
	INSERT	INTO #tblAppIdWithDaysOnlyRet
	EXEC getDaysOnlyRetentionSubclient
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	DELETE #tblAppIdToReset
	FROM #tblAppIdToReset T, #tblAppIdWithDaysOnlyRet T1
	WHERE T.appId = T1.appId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	DELETE #tblAppIdToReset
	FROM #tblAppIdToReset T, App_SubclientProp T1 WITH (NOLOCK)
	WHERE	T.appId = T1.componentNameId
	AND		T1.attrName = N'Honor Archiver Agent Retention'
	AND 	T1.cs_attrName = @checkSumArchiverRet
	AND		T1.attrVal = '1'
	AND		T1.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	-- Reset only those appId for which attrVal is not reset by any other process
	DELETE	#tblAppIdToReset
	FROM	#tblAppIdToReset APP LEFT OUTER JOIN APP_SubClientProp PROP
	ON	APP.appId = PROP.componentNameId
	AND	PROP.attrName = N'sys:last full'
	AND	PROP.cs_attrName = @checkSumSysLastFull
	AND	PROP.modified = 0
	WHERE PROP.componentNameId IS NULL
	OR 		PROP.attrVal 	= '0'
	OR 		PROP.attrVal 	= ''
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	DELETE	APP_SubClientProp
	FROM 		APP_SubClientProp PROP, #tblAppIdToReset APP
	WHERE	PROP.ComponentNameId = APP.appId
	AND		PROP.attrName = N'sys:last full'
	AND		PROP.cs_attrName = @checkSumSysLastFull
	AND		modified 	= 0
	AND   attrVal 	!= '0'
	AND		attrVal 	!= ''
	SELECT	@errorCode	=	@@ERROR, @resetCount = @@ROWCOUNT
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	UPDATE	APP_SubClientProp
	SET 	modified = @currentTime
	FROM 	APP_SubClientProp PROP, #tblAppIdToReset APP
	WHERE	PROP.ComponentNameId = APP.appId
	AND		PROP.attrName = N'Reason last backup time cleared'
	AND		PROP.cs_attrName = @checkSumLastBkpTimeCleared
	AND		PROP.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	INSERT INTO APP_SubClientProp
	SELECT 	APP.AppId, @attrName, @attrType, @attrVal, @currentTime, 0, 0
	FROM 		#tblAppIdToReset APP
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	TRUNCATE TABLE #tblAppIdToReset
	--Get list of turbo subclients with no valid jobs
	INSERT INTO #tblAppIdToReset
	SELECT	DISTINCT T.componentNameId
	FROM	App_SubclientProp T WITH (NOLOCK), App_SubclientProp T1 WITH (NOLOCK), #tblAppIdToCheck A
	WHERE	T.componentNameId = A.appId
	AND		T.componentNameId = T1.componentNameId
	AND		T.attrName = N'Is Turbo Subclient'
	AND		T.cs_attrName = @checkSumIsTurboSC
	AND		T.attrVal = '1'
	AND		T.modified = 0
	AND		T1.attrName = N'First Turbo Job Id'
	AND		T1.cs_attrName = @checkSumFirstTurboJob
	AND		CAST(T1.attrVal AS INT) != 0
	AND		T1.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	DELETE #tblAppIdToReset
	FROM	#tblAppIdToReset A, JMJobDataStats B WITH (NOLOCK)
	WHERE	A.appId = B.appId
	AND		B.dataType = 1
	AND		B.status = 100
AND		B.disabled & 64 = 0
AND		B.disabled & 256 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	DELETE	APP_SubClientProp
	FROM 		APP_SubClientProp PROP, #tblAppIdToReset APP
	WHERE	PROP.ComponentNameId = APP.appId
	AND		PROP.attrName = N'turbo:last full'
	AND		PROP.cs_attrName = @checkSumTurboLastFull
	AND		modified 	= 0
	AND   attrVal 	!= '0'
	AND		attrVal 	!= ''
	SELECT	@errorCode	=	@@ERROR, @resetCount = @resetCount + @@ROWCOUNT
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	DELETE	APP_SubClientProp
	FROM 		APP_SubClientProp PROP, #tblAppIdToReset APP
	WHERE	PROP.ComponentNameId = APP.appId
	AND		PROP.attrName = N'turbo:last incr'
	AND		PROP.cs_attrName = @checkSumTurboLastIncr
	AND		modified 	= 0
	AND   attrVal 	!= '0'
	AND		attrVal 	!= ''
	SELECT	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	UPDATE	APP_SubClientProp
	SET 	modified = @currentTime
	FROM 	APP_SubClientProp PROP, #tblAppIdToReset APP
	WHERE	PROP.ComponentNameId = APP.appId
	AND		PROP.attrName = N'Reason last backup time cleared'
	AND		PROP.cs_attrName = @checkSumLastBkpTimeCleared
	AND		PROP.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	INSERT INTO APP_SubClientProp
	SELECT 	APP.AppId, @attrName, @attrType, @attrVal, @currentTime, 0, 0
	FROM 		#tblAppIdToReset APP
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	COMMIT TRANSACTION TranResetAppIdRefTime
	SELECT @resetCount
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TranResetAppIdRefTime
	SELECT -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daResetAppIdRefTime')
	delete from GxQscripts where name = 'daResetAppIdRefTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daResetAppIdRefTime')
	delete from GXDBVersions where aliasname = 'daResetAppIdRefTime'
GO

insert into GXDBVersions values(2, 'daResetAppIdRefTime',  '00010015027600060000', 'daResetAppIdRefTime', '00010015027600060000')
GO

