

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daRecomputeRetentionFlags.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daRecomputeRetentionFlags()
--  | Description:  1. Retention flags should be marked for child-logs
--	|				   				 of selective online full.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daRecomputeRetentionFlags.sp,v $ $Id: daRecomputeRetentionFlags.sp,v 1.3.88.1 2018/03/20 19:45:26 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daRecomputeRetentionFlags')
BEGIN
	print '>>> Drop Stored Procedure: daRecomputeRetentionFlags <<<'
	drop procedure daRecomputeRetentionFlags
END
IF EXISTS (select * from GxQscripts where name='daRecomputeRetentionFlags')
	delete from GxQscripts where name = 'daRecomputeRetentionFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daRecomputeRetentionFlags')
	delete from GXDBVersions where aliasname = 'daRecomputeRetentionFlags'
GO
print '... Creating Procedure: daRecomputeRetentionFlags'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daRecomputeRetentionFlags
  @dummy INTEGER
AS
  DECLARE @o_numJobRetained integer;
	SET NOCOUNT ON
	DECLARE @numJobRetained	INTEGER
	SET			@numJobRetained	= 0
	DECLARE	@errorCode INTEGER
	SET			@errorCode = 0
	DECLARE	@tblCopySource TABLE(
			CopyId 					int,
			sourceCopyId 		int,
			primaryCopy 		int,
			isMirrorCopy		int,
			Primary Key (CopyId)
			)
	DECLARE	@tblCopyExtRetInfo TABLE(
			CopyId 					int,
			retainType	 		int,
			Primary Key (CopyId)
			)
	if object_id('tempdb.dbo.#tblJobSelOnline') is not null DROP TABLE #tblJobSelOnline
	CREATE TABLE #tblJobSelOnline (
			jobId 					int,
			copyId 					int,
			dataType 				int,
			commCellId 			int,
			retentionFlags 	int,
			primary key (jobId, copyId, dataType, commCellId)
	)
	if object_id('tempdb.dbo.#tmpSourceJobRetention') is not null DROP TABLE #tmpSourceJobRetention
	CREATE TABLE #tmpSourceJobRetention (
			jobId 					int,
			copyId 					int,
			dataType 				int,
			commCellId 			int,
			retentionFlags 	int,
			primary key (jobId, copyId, dataType, commCellId)
	)
	if object_id('tempdb.dbo.#tmpSnapIncrToFullJobs') is not null DROP TABLE #tmpSnapIncrToFullJobs
	CREATE TABLE #tmpSnapIncrToFullJobs (
			IncrJobId 			int,
			FullJobId				int,
			copyId 					int,
			dataType 				int,
			commCellId 			int,
			retentionFlags	int,
			primary key (IncrJobId, FullJobId, copyId, dataType, commCellId)
	)
	if object_id('tempdb.dbo.#tmpJobCopyCycleToRetain') is not null DROP TABLE #tmpJobCopyCycleToRetain
	CREATE	TABLE #tmpJobCopyCycleToRetain (
			AppId 					int,
			CopyId 					int,
			FileType 				int,
			fullCycleNum 		int,
			retentionFlags	int,
			retainType	 		int,
			primary key (AppId, CopyId, FileType, fullCycleNum)
			)
	-- Get source copy information for all Snap Copies
	INSERT	INTO @tblCopySource
	SELECT	a.id, a.sourceCopyId, b.defaultSnapCopy, a.isMirrorCopy
	FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
	WHERE	a.archGroupId = b.id
	AND		a.isSnapCopy > 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- The source copy will be source of Mirror copy if source copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopySource T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopySource
		SET 	sourceCopyId = AGC.sourceCopyId
		FROM	@tblCopySource T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SELECT	@errorCode = @@ERROR
		IF @errorCode > 0 GOTO CX_ERROR_EXIT
	END
	-- The source copy will be primary copy if no source copy defined
	UPDATE	@tblCopySource
	SET 	sourceCopyId = primaryCopy
	WHERE	sourceCopyId = 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	--Get all snap incremental jobs that are retained by extended retention
	INSERT INTO #tmpSnapIncrToFullJobs
	SELECT a.JobId, 0, a.CopyId, a.dataType, a.commCellId, a.retentionFlags
FROM ArchJobCopyExtended a, #DA_AppCopyList b, #DA_JobCopyList c
	WHERE a.appId = b.appId
	AND		a.copyId = b.copyId
	AND		a.dataType = b.fileType
	AND		b.copyIsSnap > 0
	AND		a.appId = c.appId
	AND		a.jobId = c.jobId
	AND		a.commcellId = c.commcellId
	AND		a.copyId = c.copyId
	AND		a.dataType = c.fileType
	AND		a.retentionFlags > 0
	AND		c.bkpLevel != 1
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	--Get Full job associated to extended retained Incremental Snap job
	UPDATE #tmpSnapIncrToFullJobs
	SET FullJobId = c.jobId
	FROM #tmpSnapIncrToFullJobs a, #DA_JobCopyList b, #DA_JobCopyList c
	WHERE a.IncrJobId = b.jobId
	AND		a.commcellId = b.commcellId
	AND		a.copyId = b.copyId
	AND		a.dataType = b.fileType
	AND		b.appId = c.appId
	AND		b.jobId != c.jobId
	AND		b.commcellId = c.commcellId
	AND		b.copyId = c.copyId
	AND		b.fileType = c.fileType
	AND		b.bkpLevel != 1
	AND		c.bkpLevel = 1
	AND		b.fullCycleNum = c.fullCycleNum
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	--Set retentionFlags on associated Full jobs
UPDATE ArchJobCopyExtended
	SET retentionFlags = J.retentionFlags | T.retentionFlags
FROM ArchJobCopyExtended J, (SELECT a.FullJobId, a.commcellId, a.copyId, a.dataType,
																			 (MAX(a.retentionFlags & 1) | MAX(a.retentionFlags & 2) | MAX(a.retentionflags & 4) |
																				MAX(a.retentionFlags & 8) | MAX(a.retentionFlags & 16) | MAX(a.retentionFlags & 32) |
																				MAX(a.retentionFlags & 64) | MAX(a.retentionFlags & 256) | MAX(a.retentionFlags & 512) |
																				MAX(a.retentionFlags & 1024) | MAX(a.retentionFlags & 2048) | MAX(a.retentionFlags & 4096) |
																		 		MAX(a.retentionFlags & 8192) | MAX(a.retentionFlags & 16384) | MAX(a.retentionFlags & 32768) |
																		 		MAX(a.retentionFlags & 65536) | MAX(a.retentionFlags & 131072) | MAX(a.retentionFlags & 262144) |
																		 		MAX(a.retentionFlags & 524288) | MAX(a.retentionFlags & 1048576) | MAX(a.retentionFlags & 2097152) |
																		 		MAX(a.retentionFlags & 4194304) | MAX(a.retentionFlags & 8388608)) AS retentionFlags
																 FROM #tmpSnapIncrToFullJobs a
																 GROUP BY a.FullJobId, a.commCellId, a.copyId, a.dataType) T
	WHERE J.jobId = T.FullJobId
	AND		J.commcellId = T.commcellId
	AND		J.copyId = T.copyId
	AND		J.dataType = T.dataType
	AND		T.FullJobId > 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	INSERT INTO	@tblCopyExtRetInfo
	SELECT DISTINCT EntityId, intVal
	FROM MMEntityProp WITH (NOLOCK)
	WHERE propertyName = 'ExtendRetainAllJobsInCycle'
	AND		EntityType = 2 				-- Copy Entity
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpJobCopyCycleToRetain
	SELECT 	DISTINCT A.appId, A.copyId, A.fileType, A.fullCycleNum, T.retentionFlags, C.retainType
FROM #DA_JobCopyList A, ArchJobCopyExtended T, @tblCopyExtRetInfo C
	WHERE A.jobId = T.JobId
	AND		A.commCellId = T.commCellId
	AND		A.appId = T.appId
	AND		A.copyId = T.copyId
	AND		A.fileType = T.dataType
	AND		A.bkpLevel = 1
	AND		T.retentionFlags > 0
	AND		A.copyId = C.copyId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	--Extended retain all the jobs in a cycle for Full job that is extended retained on a copy where option is enabled
	--Insert all the incremental\differential jobs in same cycle in JOBCOPYEXTENDEDTABLE table so that the rest of the dependent jobs get computed automatically.
	UPDATE T
	SET 	T.retentionFlags = T.retentionFlags | TMP.retentionFlags
FROM	ArchJobCopyExtended T, #DA_JobCopyList A, #tmpJobCopyCycleToRetain TMP
	WHERE	T.jobId = A.JobId
	AND		T.commCellId = A.commCellId
	AND		T.appId = A.appId
	AND		T.copyId = A.copyId
	AND		T.dataType = A.fileType
	AND		A.appId = TMP.appId
	AND		A.copyId = TMP.copyId
	AND		A.FileType = TMP.FileType
	AND		A.fullCycleNum = TMP.fullCycleNum
	AND		((TMP.retainType = 2)					--Extend Retain all jobs in cycle along with the Full job
					OR
				 (TMP.retainType = 1 AND A.bkpLevel = 4) --Extend Retain only differential jobs in cycle along with the Full job
				)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
INSERT	INTO ArchJobCopyExtended
	SELECT	DISTINCT A.AppId, A.JobId, A.CopyId, A.FileType, A.CommCellId,
			A.StartTime, A.EndTime, A.DataStatus, A.JobStatus,
			A.Disabled, A.ManualRet, A.RetainForAuxCopy, TMP.retentionFlags, '',
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM	#DA_JobCopyList A, #tmpJobCopyCycleToRetain TMP
	WHERE	A.appId = TMP.appId
	AND		A.copyId = TMP.copyId
	AND		A.FileType = TMP.FileType
	AND		A.fullCycleNum = TMP.fullCycleNum
	AND		((TMP.retainType = 2)					--Extend Retain all jobs in cycle along with the Full job
					OR
				 (TMP.retainType = 1 AND A.bkpLevel = 4) --Extend Retain only differential jobs in cycle along with the Full job
				)
	AND		NOT EXISTS (SELECT T.*
FROM ArchJobCopyExtended T
										WHERE T.jobId = A.JobId
										AND		T.commCellId = A.commCellId
										AND		T.appId = A.appId
										AND		T.copyId = A.copyId
										AND		T.dataType = A.fileType
										)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- First unset the retentionFlags on the current set of app/copy list being processed
	-- Retention flags should be unset for child-logs of selective online full
	INSERT	INTO #tblJobSelOnline
	SELECT	b.childJobId, a.copyId, 0, a.commCellId, 0
	FROM	ArchJobCopyExtended a WITH (NOLOCK), JMJobDataLink b WITH (NOLOCK)
	WHERE	a.jobId = b.parentJobId
	AND		a.commCellId = b.commCellId
	GROUP BY b.childJobId, a.copyId, a.commCellId
	UNION
	SELECT	a.jobId, a.copyId, 0, a.commCellId, 0
	FROM	ArchJobCopyExtended a WITH (NOLOCK), JMBkpStats b WITH (NOLOCK)
	WHERE	a.jobId = b.JobId
	AND		a.commCellId = b.commCellId
	AND		b.bkpLevel IN (1024, 32768)		--Selective Online\Offline Full (if JMJobDataLink entry is missing)
	GROUP BY a.JobId, a.copyId, a.commCellId
	UNION
	SELECT	c.childJobId, a.copyId, 0, c.commCellId, 0
	FROM	#DA_AppCopyList a, JMJobDataStats b WITH (NOLOCK), JMJobDataLink c WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.archGrpCopyId
	AND		b.jobId = c.parentJobId
	AND		b.commCellId = c.commCellId
	AND		b.dataType = 1 					-- Check the status of the Data Job
	AND		((b.status = 1000) OR (b.disabled & 256 = 256) OR (b.retentionFlags = 0))
	GROUP BY c.childJobId, a.copyId, c.commCellId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Update the data only for selected appId Copy for Extended Retention
	UPDATE	JMJobDataStats
	SET		retentionFlags = 0
	FROM	JMJobDataStats a, #DA_AppCopyList b
	WHERE	a.retentionFlags > 0
	AND		a.appId = b.appId
	AND		a.archGrpCopyId = b.copyId
	AND		a.status NOT IN (2, 3, 1000)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Update the flags on Mirror copies
	UPDATE	JMJobDataStats
	SET		retentionFlags = 0
	FROM	JMJobDataStats a, #DA_AppCopyList b, @tblCopySource c
	WHERE	a.retentionFlags > 0
	AND		a.appId = b.appId
	AND		b.copyId = c.sourceCopyId
	AND		c.copyId = a.archGrpCopyId
	AND		c.isMirrorCopy > 0
	AND		a.status NOT IN (2, 3, 1000)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Retention flags should be unset for child-jobs of selective online full
	UPDATE	JMJobDataStats
	SET		retentionFlags = 0
	FROM	JMJobDataStats a, #tblJobSelOnline b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.archGrpCopyId = b.copyId
	AND		a.status NOT IN (2, 3, 1000)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Update the flags on Mirror copies
	UPDATE	JMJobDataStats
	SET		retentionFlags = 0
	FROM	JMJobDataStats a, #tblJobSelOnline b, @tblCopySource c
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.archGrpCopyId = c.copyId
	AND		c.sourceCopyId = b.copyId
	AND		c.isMirrorCopy > 0
	AND		a.status NOT IN (2, 3, 1000)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Cleanup the temp table
	TRUNCATE TABLE #tblJobSelOnline
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Retention flags should be marked for child-logs of selective online full
	-- This is for both Oracle and SAP Selective Online Full
	INSERT	INTO #tblJobSelOnline
	SELECT	b.childJobId, a.copyId, 0, a.commCellId,
	(MAX(a.retentionFlags & 1) | MAX(a.retentionFlags & 2) | MAX(a.retentionflags & 4) | MAX(a.retentionFlags & 8) |
	 MAX(a.retentionFlags & 16) | MAX(a.retentionFlags & 32) | MAX(a.retentionFlags & 64) | MAX(a.retentionFlags & 256) |
	 MAX(a.retentionFlags & 512) | MAX(a.retentionFlags & 1024) | MAX(a.retentionFlags & 2048) | MAX(a.retentionFlags & 4096) |
	 MAX(a.retentionFlags & 8192) | MAX(a.retentionFlags & 16384) | MAX(a.retentionFlags & 32768) | MAX(a.retentionFlags & 65536) |
	 MAX(a.retentionFlags & 131072) | MAX(a.retentionFlags & 262144) | MAX(a.retentionFlags & 524288) |
	 MAX(a.retentionFlags & 1048576) | MAX(a.retentionFlags & 2097152) | MAX(a.retentionFlags & 4194304) | MAX(a.retentionFlags & 8388608))
FROM	ArchJobCopyExtended a, JMJobDataLink b WITH (NOLOCK)
	WHERE	a.retentionFlags > 0
	AND		a.jobId = b.parentJobId
	AND		a.commCellId = b.commCellId
	GROUP BY b.childJobId, a.copyId, a.commCellId
	--Process Selective Online\Offline Full (if JMJobDataLink entry is missing)
	INSERT	INTO #tblJobSelOnline
	SELECT	a.JobId, a.copyId, 0, a.commCellId, MAX(a.retentionFlags)
FROM	ArchJobCopyExtended a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.retentionFlags > 0
	AND		a.jobId = b.JobId
	AND		a.commCellId = b.commCellId
	AND		b.bkpLevel IN (1024, 32768)		--Selective Online\Offline Full (if JMJobDataLink entry is missing)
	AND NOT EXISTS (SELECT T.jobId
									FROM #tblJobSelOnline T
									WHERE a.jobId = T.jobId
									AND		a.commCellId = T.commCellId
									AND		a.copyId = T.copyId
								 )
	GROUP BY a.JobId, a.copyId, a.commCellId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMJobDataStats
	SET		retentionFlags = b.retentionFlags
	FROM	JMJobDataStats a,  ArchJobCopyExtended b WITH (NOLOCK)
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.archGrpCopyId = b.copyId
AND		((b.dataType = 0) OR (b.dataType = 1 AND a.dataType <> 4) OR (b.dataType = 4 AND a.dataType IN (4, 6)))
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMJobDataStats
	SET		retentionFlags = b.retentionFlags
	FROM	JMJobDataStats a, ArchJobCopyExtended b WITH (NOLOCK), @tblCopySource c
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.archGrpCopyId = c.copyId
	AND		c.sourceCopyId = b.copyId
	AND		c.isMirrorCopy > 0
AND		((b.dataType = 0) OR (b.dataType = 1 AND a.dataType <> 4) OR (b.dataType = 4 AND a.dataType IN (4, 6)))
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	DELETE #tmpSourceJobRetention
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpSourceJobRetention
	SELECT TMP.jobId, TMP.commCellId, TMP.archGrpCopyId, TMP.dataType, TMP.retentionFlags
	FROM 	JMJobDataStats TMP WITH (NOLOCK), ArchJobCopyExtended b WITH (NOLOCK), @tblCopySource c
	WHERE TMP.jobId = b.jobId
	AND		TMP.commCellId = b.commCellId
	AND		TMP.archGrpCopyId = c.sourceCopyId
	AND		c.copyId = b.copyId
	AND		c.isMirrorCopy > 0
AND		((b.dataType = 0) OR (b.dataType = 1 AND TMP.dataType <> 4) OR (b.dataType = 4 AND TMP.dataType IN (4, 6)))
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMJobDataStats
	SET		retentionFlags = d.retentionFlags
	FROM	JMJobDataStats a, @tblCopySource c, #tmpSourceJobRetention d
	WHERE	a.jobId = d.jobId
	AND		a.commCellId = d.commCellId
	AND		a.dataType = d.dataType
	AND		a.archGrpCopyId = c.copyId
	AND		c.isMirrorCopy > 0
	AND		c.sourceCopyId = d.copyId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_JobCopyList
SET		jobRetainReason = jobRetainReason | 128
FROM	#DA_JobCopyList a,  ArchJobCopyExtended b WITH (NOLOCK)
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.copyId
AND		((b.dataType = 0) OR (b.dataType = 1 AND a.fileType <> 4) OR (b.dataType = 4 AND a.fileType IN (4, 6)))
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Retain Index Archive File after Snap Movement to tape until Data/Log are extended retained
	UPDATE	JMJobDataStats
	SET		retentionFlags = b.retentionFlags
	FROM	JMJobDataStats a,  ArchJobCopyExtended b WITH (NOLOCK), archFile AF WITH (NOLOCK)
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
AND		b.dataType = 4
	AND		a.jobId = AF.jobId
	AND		a.commCellId = AF.commCellId
AND 	AF.fileType = 2
AND		(AF.flags & (4 | 4096)) > 0
	AND		a.archGrpCopyId = b.copyId
	AND		a.dataType = AF.fileType
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMJobDataStats
	SET		retentionFlags = b.retentionFlags
	FROM	JMJobDataStats a, ArchJobCopyExtended b WITH (NOLOCK), archFile AF WITH (NOLOCK), @tblCopySource c
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
AND		b.dataType = 4
	AND		a.jobId = AF.jobId
	AND		a.commCellId = AF.commCellId
AND 	AF.fileType = 2
AND		(AF.flags & (4 | 4096)) > 0
	AND		a.dataType = AF.fileType
	AND		a.archGrpCopyId = c.copyId
	AND		c.sourceCopyId = b.copyId
	AND		c.isMirrorCopy > 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	DELETE #tmpSourceJobRetention
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpSourceJobRetention
	SELECT TMP.jobId, TMP.commCellId, TMP.archGrpCopyId, TMP.dataType, TMP.retentionFlags
	FROM 	JMJobDataStats TMP WITH (NOLOCK), ArchJobCopyExtended b WITH (NOLOCK), archFile AF WITH (NOLOCK), @tblCopySource c
	WHERE TMP.jobId = b.jobId
	AND		TMP.commCellId = b.commCellId
AND		b.dataType = 4
	AND		TMP.jobId = AF.jobId
	AND		TMP.commCellId = AF.commCellId
AND 	AF.fileType = 2
AND		(AF.flags & (4 | 4096)) > 0
	AND		TMP.dataType = AF.fileType
	AND		TMP.archGrpCopyId = c.sourceCopyId
	AND		c.copyId = b.copyId
	AND		c.isMirrorCopy > 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMJobDataStats
	SET		retentionFlags = d.retentionFlags
	FROM	JMJobDataStats a, @tblCopySource c, #tmpSourceJobRetention d
	WHERE	a.jobId = d.jobId
	AND		a.commCellId = d.commCellId
	AND		a.dataType = d.dataType
	AND		a.archGrpCopyId = c.copyId
	AND		c.isMirrorCopy > 0
	AND		c.sourceCopyId = d.copyId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_JobCopyList
SET		jobRetainReason = jobRetainReason | 128
FROM	 #DA_JobCopyList a,  ArchJobCopyExtended b WITH (NOLOCK), archFile AF WITH (NOLOCK)
	WHERE	b.retentionFlags > 0
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
AND		b.dataType = 4
	AND		a.jobId = AF.jobId
	AND		a.commCellId = AF.commCellId
AND 	AF.fileType = 2
AND		(AF.flags & (4 | 4096)) > 0
	AND		a.copyId = b.copyId
	AND		a.fileType = AF.fileType
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- DO NOT join on dataType since SAP for MaxDB can have data or logs as child jobs
	UPDATE	JMJobDataStats
	SET		retentionFlags = b.retentionFlags
	FROM	JMJobDataStats a, #tblJobSelOnline b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.archGrpCopyId = b.copyId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMJobDataStats
	SET		retentionFlags = b.retentionFlags
	FROM	JMJobDataStats a, #tblJobSelOnline b, @tblCopySource c
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.archGrpCopyId = c.copyId
	AND		c.sourceCopyId = b.copyId
	AND		c.isMirrorCopy > 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	DELETE #tmpSourceJobRetention
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpSourceJobRetention
	SELECT TMP.jobId, TMP.commCellId, TMP.archGrpCopyId, TMP.dataType, TMP.retentionFlags
	FROM 	JMJobDataStats TMP WITH (NOLOCK), #tblJobSelOnline b, @tblCopySource c
	WHERE TMP.jobId = b.jobId
	AND		TMP.commCellId = b.commCellId
	AND		TMP.archGrpCopyId = c.sourceCopyId
	AND		c.copyId = b.copyId
	AND		c.isMirrorCopy > 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMJobDataStats
	SET		retentionFlags = d.retentionFlags
	FROM	JMJobDataStats a, @tblCopySource c, #tmpSourceJobRetention d
	WHERE	a.jobId = d.jobId
	AND		a.commCellId = d.commCellId
	AND		a.dataType = d.dataType
	AND		a.archGrpCopyId = c.copyId
	AND		c.isMirrorCopy > 0
	AND		c.sourceCopyId = d.copyId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_JobCopyList
SET		jobRetainReason = jobRetainReason | 128
	FROM	#DA_JobCopyList a, #tblJobSelOnline b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.copyId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Remove duplicated jobid to get the right number of jobs selected
	DELETE	#tblJobSelOnline
FROM	#tblJobSelOnline a, ArchJobCopyExtended b
	WHERE	a.jobId = b.jobId
	AND		a.copyId = b.copyId
	AND		a.commCellId = b.commCellId
SET		@numJobRetained	= (SELECT COUNT(*) FROM #tblJobSelOnline) + (SELECT COUNT(*) FROM  ArchJobCopyExtended WHERE retentionFlags > 0)
CX_EXIT:
	if object_id('tempdb.dbo.#tblJobSelOnline') is not null DROP TABLE #tblJobSelOnline
	if object_id('tempdb.dbo.#tmpSourceJobRetention') is not null DROP TABLE #tmpSourceJobRetention
	if object_id('tempdb.dbo.#tmpJobCopyCycleToRetain') is not null DROP TABLE #tmpJobCopyCycleToRetain
	SELECT @numJobRetained
	RETURN
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#tblJobSelOnline') is not null DROP TABLE #tblJobSelOnline
	if object_id('tempdb.dbo.#tmpSourceJobRetention') is not null DROP TABLE #tmpSourceJobRetention
	if object_id('tempdb.dbo.#tmpJobCopyCycleToRetain') is not null DROP TABLE #tmpJobCopyCycleToRetain
	SELECT -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daRecomputeRetentionFlags')
	delete from GxQscripts where name = 'daRecomputeRetentionFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daRecomputeRetentionFlags')
	delete from GXDBVersions where aliasname = 'daRecomputeRetentionFlags'
GO

insert into GXDBVersions values(2, 'daRecomputeRetentionFlags',  '00010003008800010000', 'daRecomputeRetentionFlags', '00010003008800010000')
GO

