

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daRJApplyExtendedHalfYearlyFullRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daRJApplyExtendedHalfYearlyFullRule.sp,v $ $Id: daRJApplyExtendedHalfYearlyFullRule.sp,v 1.1.278.2 2018/09/21 04:45:45 hkapadia Exp $";
--  +=================================================================================+
--  | Stored Proc:  daRJApplyExtendedHalfYearlyFullRule()
--  |
--  | Description:  Retain the jobs based on extended retention Half Yearly Full rule
--  +=================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daRJApplyExtendedHalfYearlyFullRule <<<'

IF EXISTS (select * from sysobjects where name='daRJApplyExtendedHalfYearlyFullRule')
	drop procedure daRJApplyExtendedHalfYearlyFullRule
IF EXISTS (select * from GxQscripts where name='daRJApplyExtendedHalfYearlyFullRule')
	delete from GxQscripts where name = 'daRJApplyExtendedHalfYearlyFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daRJApplyExtendedHalfYearlyFullRule')
	delete from GXDBVersions where aliasname = 'daRJApplyExtendedHalfYearlyFullRule'
GO
print '... Creating Procedure: daRJApplyExtendedHalfYearlyFullRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daRJApplyExtendedHalfYearlyFullRule
  @agingAsofDays INTEGER,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @currentTime 	INTEGER
		SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-- Temp Tables for extended retention computation
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#ExtRetCopyInfo') is not null DROP TABLE #ExtRetCopyInfo
	CREATE TABLE #ExtRetCopyInfo (
			copyId 								INTEGER,
			retentionDays					INTEGER,
			extRetEndTime 				BIGINT,
			firstOfPeriod				 	INTEGER,
			pickJobFromLowerRule	INTEGER,
			maxExtRetEndTime			BIGINT,
			graceDays							INTEGER
			PRIMARY KEY (copyId)
			)
	if object_id('tempdb.dbo.#ExtRetJobInfo') is not null DROP TABLE #ExtRetJobInfo
	CREATE TABLE #ExtRetJobInfo (
			appId									INTEGER,
			copyId								INTEGER,
			halfYearStartTime			INTEGER,
			startTime							INTEGER,
			maxStartTime					INTEGER,
			firstOfPeriod				 	INTEGER,
			PRIMARY KEY (appId, copyId, halfYearStartTime)
			)
	if object_id('tempdb.dbo.#ExtRetJobInfoForLowerRetRule') is not null DROP TABLE #ExtRetJobInfoForLowerRetRule
	CREATE TABLE #ExtRetJobInfoForLowerRetRule (
			appId									INTEGER,
			copyId								INTEGER,
			halfYearStartTime			INTEGER,
			startTime							INTEGER,
			maxStartTime					INTEGER,
			firstOfPeriod				 	INTEGER,
			PRIMARY KEY (appId, copyId, halfYearStartTime)
			)
	if object_id('tempdb.dbo.#ExtRetToBeCopiedJobInfo') is not null DROP TABLE #ExtRetToBeCopiedJobInfo
	CREATE TABLE #ExtRetToBeCopiedJobInfo (
			appId									INTEGER,
			copyId								INTEGER,
			halfYearStartTime			INTEGER,
			startTime							INTEGER,
			maxStartTime					INTEGER,
			firstOfPeriod				 	INTEGER,
			PRIMARY KEY (appId, copyId, halfYearStartTime)
			)
	if object_id('tempdb.dbo.#ExtRetToBeCopiedJobInfoForLowerRetRule') is not null DROP TABLE #ExtRetToBeCopiedJobInfoForLowerRetRule
	CREATE TABLE #ExtRetToBeCopiedJobInfoForLowerRetRule (
			appId									INTEGER,
			copyId								INTEGER,
			halfYearStartTime			INTEGER,
			startTime							INTEGER,
			maxStartTime					INTEGER,
			firstOfPeriod				 	INTEGER,
			PRIMARY KEY (appId, copyId, halfYearStartTime)
			)
	if object_id('tempdb.dbo.#ExtRetLastJobInfo') is not null DROP TABLE #ExtRetLastJobInfo
	CREATE TABLE #ExtRetLastJobInfo (
			appId									INTEGER,
			copyId								INTEGER,
			maxStartTime					INTEGER,
			PRIMARY KEY (appId, copyId)
			)
	if object_id('tempdb.dbo.#ExtRetToBeCopiedLastJobInfo') is not null DROP TABLE #ExtRetToBeCopiedLastJobInfo
	CREATE TABLE #ExtRetToBeCopiedLastJobInfo (
			appId									INTEGER,
			copyId								INTEGER,
			maxStartTime					INTEGER,
			PRIMARY KEY (appId, copyId)
			)
	-------------------------------------------------------------------------------
	------------ Apply the Extended Retention Half Yearly Full Rule ---------------
	-------------------------------------------------------------------------------
	DECLARE	@retainLastFull	INTEGER
	SET			@retainLastFull	= 0
	SELECT @retainLastFull = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_EXTEND_RETAIN_LAST_FULL_JOB_OF_DECONFIGURED_CLIENT'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all Extended Retention Info for current list of copies being processed
	INSERT INTO #ExtRetCopyInfo
	SELECT DISTINCT JCE.copyId, AARE.retentionDays, (@currentTime - CAST(AARE.retentionDays as bigint) * 24 * 3600),
(AAR.flags & 1),
(AAR.flags & 32),
									0,
									AARE.graceDays
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK), archAgingRuleExtended AARE WITH (NOLOCK)
	WHERE JCE.copyId = AAR.copyId
	AND		AAR.copyId = AARE.copyId
	AND		AARE.retentionRule & 32 = 32 -- EXTENDED_HALFYEAR
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #ExtRetCopyInfo
	SET maxExtRetEndTime = (SELECT CASE WHEN MIN(AARE.retentionDays) = -1 THEN -1 ELSE (@currentTime - cast(MAX(AARE.retentionDays) as bigint) * 24 * 3600) END
													FROM archAgingRuleExtended AARE WITH (NOLOCK)
													WHERE AARE.copyId = ERCI.copyId
													GROUP BY AARE.copyId)
	FROM #ExtRetCopyInfo ERCI
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all Half Yearly Extended Retention jobs for First/Last Of Period
	-- Consider ALL Copied jobs to pick from lower rule
	INSERT INTO #ExtRetJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus = 100
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(JCE.retFlagsForLowerRule & (2 | 262144 | 524288 | 4 | 8 | 16)) > 0		-- Pick jobs if Hourly or Daily or Weekly or Monthly or Quarterly retention is set
	AND		(
					(ERCI.firstOfPeriod > 0 AND JCE.localStartTime < (JCE.halfYearStartTime + ERCI.graceDays * 24 * 3600))
					OR
					(ERCI.firstOfPeriod = 0 AND JCE.localStartTime > (JCE.halfYearEndTime - ERCI.graceDays * 24 * 3600))
				)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Process all jobs based on highest retention to pick from lower rule
	INSERT INTO #ExtRetJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus = 100
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(JCE.retFlagsForLowerRule & (2 | 262144 | 524288 | 4 | 8 | 16)) > 0		-- Pick jobs if Hourly or Daily or Weekly or Monthly or Quarterly retention is set
	AND		(
					(ERCI.firstOfPeriod > 0 AND JCE.localStartTime < (JCE.halfYearStartTime + ERCI.graceDays * 24 * 3600))
					OR
					(ERCI.firstOfPeriod = 0 AND JCE.localStartTime > (JCE.halfYearEndTime - ERCI.graceDays * 24 * 3600))
				)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Successful, Not Disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 1
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 1
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider completed with warning, Not disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 14
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 14
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Partial Successful, Not disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 3
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 3
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Successful, Disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 1
	AND		JCE.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 1
	AND		JCE.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider completed with warning, Disabled and Copied Jobs
	INSERT INTO #ExtRetJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 14
	AND		JCE.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 14
	AND		JCE.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Partial Successful, Disabled and Copied Jobs
	INSERT INTO #ExtRetJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 3
	AND		JCE.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus = 100
	AND		JCE.jobStatus = 3
	AND		JCE.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider ALL To be Copied Jobs to pick from lower rule
	INSERT INTO #ExtRetToBeCopiedJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(JCE.retFlagsForLowerRule & (2 | 262144 | 524288 | 4 | 8 | 16)) > 0		-- Pick jobs if Hourly or Daily or Weekly or Monthly or Quarterly retention is set
	AND		(
					(ERCI.firstOfPeriod > 0 AND JCE.localStartTime < (JCE.halfYearStartTime + ERCI.graceDays * 24 * 3600))
					OR
					(ERCI.firstOfPeriod = 0 AND JCE.localStartTime > (JCE.halfYearEndTime - ERCI.graceDays * 24 * 3600))
				)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetToBeCopiedJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(JCE.retFlagsForLowerRule & (2 | 262144 | 524288 | 4 | 8 | 16)) > 0		-- Pick jobs if Hourly or Daily or Weekly or Monthly or Quarterly retention is set
	AND		(
					(ERCI.firstOfPeriod > 0 AND JCE.localStartTime < (JCE.halfYearStartTime + ERCI.graceDays * 24 * 3600))
					OR
					(ERCI.firstOfPeriod = 0 AND JCE.localStartTime > (JCE.halfYearEndTime - ERCI.graceDays * 24 * 3600))
				)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Successful, To be Copied Jobs
	INSERT INTO #ExtRetToBeCopiedJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		JCE.jobStatus = 1
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetToBeCopiedJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		JCE.jobStatus = 1
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider completed with warning, To be Copied Jobs
	INSERT INTO #ExtRetToBeCopiedJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		JCE.jobStatus = 14
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetToBeCopiedJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		JCE.jobStatus = 14
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Partial Successful, To be Copied Jobs
	INSERT INTO #ExtRetToBeCopiedJobInfo
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		JCE.jobStatus = 3
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfo ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetToBeCopiedJobInfoForLowerRetRule
	SELECT JCE.appId, JCE.copyId, JCE.halfYearStartTime, CASE WHEN (MIN(ERCI.firstOfPeriod) > 0) THEN MIN(JCE.startTime) ELSE MAX(JCE.startTime) END, MAX(JCE.startTime), MIN(ERCI.firstOfPeriod)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		(ERCI.maxExtRetEndTime = -1 OR JCE.startTime >= ERCI.maxExtRetEndTime)
	AND		JCE.dataStatus IN (101, 102, 103)
	AND		JCE.jobStatus = 3
	AND		JCE.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfoForLowerRetRule ERJI
										WHERE JCE.appId = ERJI.appId
										and 	JCE.copyId = ERJI.copyId
										and 	JCE.halfYearStartTime = ERJI.halfYearStartTime)
	GROUP BY JCE.appId, JCE.copyId, JCE.halfYearStartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET Extended Retention Info for current list of copies being processed
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags | 32 -- EXTENDED_HALFYEAR
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetJobInfo ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND		JCE.startTime = ERJI.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET Extended Retention Info for current list of copies being processed
UPDATE #RJ_ArchJobCopyExtended
	SET retFlagsForLowerRule = retFlagsForLowerRule |  32 -- EXTENDED_HALFYEAR
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetJobInfoForLowerRetRule ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND		JCE.startTime = ERJI.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET the EXTENDED_CANDIDATE flag on jobs that are not actual First Of Period
	-- if there is a FULL schedule within Grace period to pick from lower tier
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.firstOfPeriod > 0
	AND		ERCI.pickJobFromLowerRule > 0
	AND		JCE.retentionFlags & 32 > 0
	AND		JCE.retFlagsForLowerRule & (2 | 262144 | 524288 | 4 | 8 | 16) = 0
	AND		JCE.halfYearStartTime <= JCE.nextFullTime
	AND		JCE.halfYearEndTime >= JCE.nextFullTime
	AND		JCE.localStartTime < JCE.nextFullTime
	AND 	JCE.nextFullTime < (JCE.halfYearStartTime + ERCI.graceDays * 24 * 3600)
	AND		(
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 262144 > 0)
						AND 	JCE.nextFullTime > JCE.HourEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 524288 > 0)
						AND 	JCE.nextFullTime > JCE.dayEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 4 > 0)
						AND 	JCE.nextFullTime > JCE.weekEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 8 > 0)
						AND 	JCE.nextFullTime > JCE.monthEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 16 > 0)
						AND 	JCE.nextFullTime > JCE.quarterEndTime)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
UPDATE #RJ_ArchJobCopyExtended
	SET retFlagsForLowerRule = retFlagsForLowerRule | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.firstOfPeriod > 0
	AND		ERCI.pickJobFromLowerRule > 0
	AND		JCE.retentionFlags & 32 > 0
	AND		JCE.retFlagsForLowerRule & (2 | 262144 | 524288 | 4 | 8 | 16) = 0
	AND		JCE.halfYearStartTime <= JCE.nextFullTime
	AND		JCE.halfYearEndTime >= JCE.nextFullTime
	AND		JCE.localStartTime < JCE.nextFullTime
	AND 	JCE.nextFullTime < (JCE.halfYearStartTime + ERCI.graceDays * 24 * 3600)
	AND		(
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 262144 > 0)
						AND 	JCE.nextFullTime > JCE.HourEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 524288 > 0)
						AND 	JCE.nextFullTime > JCE.dayEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 4 > 0)
						AND 	JCE.nextFullTime > JCE.weekEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 8 > 0)
						AND 	JCE.nextFullTime > JCE.monthEndTime)
					OR
					(	EXISTS (SELECT copyId from archAgingRuleExtended WITH (NOLOCK) WHERE copyId = JCE.copyId AND retentionRule & 16 > 0)
						AND 	JCE.nextFullTime > JCE.quarterEndTime)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET the EXTENDED_CANDIDATE flag on jobs that are not actual First Of Period
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfo ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND   JCE.retentionFlags & 32 > 0
	AND		ERJI.firstOfPeriod > 0
	AND		ERJI.startTime < JCE.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
UPDATE #RJ_ArchJobCopyExtended
	SET retFlagsForLowerRule = retFlagsForLowerRule | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfoForLowerRetRule ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND		JCE.retFlagsForLowerRule & 32 > 0
	AND		ERJI.firstOfPeriod > 0
	AND		ERJI.startTime < JCE.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET the EXTENDED_CANDIDATE flag on jobs that are not actual Last Of Period
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfo ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND   JCE.retentionFlags & 32 > 0
	AND		ERJI.firstOfPeriod = 0
	AND		ERJI.startTime > JCE.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
UPDATE #RJ_ArchJobCopyExtended
	SET retFlagsForLowerRule = retFlagsForLowerRule | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfoForLowerRetRule ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND   JCE.retFlagsForLowerRule & 32 > 0
	AND		ERJI.firstOfPeriod = 0
	AND		ERJI.startTime > JCE.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET the EXTENDED_CANDIDATE flag on jobs that are not actual Last Of Period based on NextFullSchedule
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.firstOfPeriod = 0
	AND   JCE.retentionFlags & 32 > 0
	AND		JCE.halfYearStartTime <= JCE.nextFullTime
	AND		JCE.halfYearEndTime >= JCE.nextFullTime
	AND		JCE.localStartTime < JCE.nextFullTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
UPDATE #RJ_ArchJobCopyExtended
	SET retFlagsForLowerRule = retFlagsForLowerRule | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		ERCI.firstOfPeriod = 0
	AND		JCE.retFlagsForLowerRule & 32 > 0
	AND		JCE.halfYearStartTime <= JCE.nextFullTime
	AND		JCE.halfYearEndTime >= JCE.nextFullTime
	AND		JCE.localStartTime < JCE.nextFullTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET Extended Retention Info on TO-BE-COPIED jobs for current list of copies being processed
	-- First of Period
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags |  32 -- EXTENDED_HALFYEAR
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfo ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND		JCE.startTime = ERJI.startTime
	AND		ERJI.firstOfPeriod > 0
	AND  	(
					EXISTS (SELECT *
										FROM 	#ExtRetJobInfo EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime
										AND		JCE.startTime < EJI.startTime)
					OR
					NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
UPDATE #RJ_ArchJobCopyExtended
	SET retFlagsForLowerRule = retFlagsForLowerRule |  32 -- EXTENDED_HALFYEAR
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfoForLowerRetRule ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND		JCE.startTime = ERJI.startTime
	AND		ERJI.firstOfPeriod > 0
	AND  	(
					EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime
										AND		JCE.startTime < EJI.startTime)
					OR
					NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET Extended Retention Info on TO-BE-COPIED jobs for current list of copies being processed
	-- Last of Period
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags |  32 -- EXTENDED_HALFYEAR
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfo ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND		JCE.startTime = ERJI.startTime
	AND		ERJI.firstOfPeriod = 0
	AND  	(
					EXISTS (SELECT *
										FROM 	#ExtRetJobInfo EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime
										AND		JCE.startTime > EJI.startTime)
					OR
					NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
UPDATE #RJ_ArchJobCopyExtended
	SET retFlagsForLowerRule = retFlagsForLowerRule |  32 -- EXTENDED_HALFYEAR
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfoForLowerRetRule ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.halfYearStartTime = ERJI.halfYearStartTime
	AND		JCE.startTime = ERJI.startTime
	AND		ERJI.firstOfPeriod = 0
	AND  	(
					EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime
										AND		JCE.startTime > EJI.startTime)
					OR
					NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfoForLowerRetRule EJI
										WHERE JCE.appId = EJI.appId
										AND 	JCE.copyId = EJI.copyId
										AND 	JCE.halfYearStartTime = EJI.halfYearStartTime)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF (@retainLastFull = 1)
	BEGIN
		INSERT INTO #ExtRetLastJobInfo
		SELECT ERJI.appId, ERJI.copyId, MAX(ERJI.maxStartTime)
		FROM #ExtRetJobInfo ERJI, App_Application APP WITH (NOLOCK)
		WHERE ERJI.appId = APP.id
AND 	APP.subclientStatus & 0x00002 > 0
		AND		ERJI.firstOfPeriod > 0
		GROUP BY ERJI.appId, ERJI.copyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO #ExtRetToBeCopiedLastJobInfo
		SELECT ERJI.appId, ERJI.copyId, MAX(ERJI.maxStartTime)
		FROM #ExtRetToBeCopiedJobInfo ERJI, App_Application APP WITH (NOLOCK)
		WHERE ERJI.appId = APP.id
AND 	APP.subclientStatus & 0x00002 > 0
		AND		ERJI.firstOfPeriod > 0
		GROUP BY ERJI.appId, ERJI.copyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- SET Extended Retention Info for current list of copies being processed
UPDATE #RJ_ArchJobCopyExtended
		SET retentionFlags = retentionFlags | (32 + 16777216) -- (EXTENDED_HALFYEAR + EXTENDED_LAST_JOB)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetLastJobInfo T
		WHERE JCE.appId = T.appId
		AND		JCE.copyId = T.copyId
		AND		JCE.startTime = T.maxStartTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- SET the EXTENDED_CANDIDATE flag on jobs that are not actual Last Of Period
UPDATE #RJ_ArchJobCopyExtended
		SET retentionFlags = retentionFlags | (1 + 65536) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_HALFYEAR)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedLastJobInfo ERJI
		WHERE JCE.appId = ERJI.appId
		AND		JCE.copyId = ERJI.copyId
		AND   JCE.retentionFlags & 32 > 0
		AND   JCE.retentionFlags & 16777216 > 0
		AND		ERJI.maxStartTime > JCE.startTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- SET Extended Retention Info on TO-BE-COPIED jobs for current list of copies being processed
UPDATE #RJ_ArchJobCopyExtended
		SET retentionFlags = retentionFlags | (32 + 16777216) -- (EXTENDED_HALFYEAR + EXTENDED_LAST_JOB)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedLastJobInfo T
		WHERE JCE.appId = T.appId
		AND		JCE.copyId = T.copyId
		AND		JCE.startTime = T.maxStartTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	--Update EXTENDED_FIRST bit for all jobs that are retained by EXTENDED_WEEK
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags | 33554432 -- EXTENDED_FIRST
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND ERCI.firstOfPeriod > 0
	AND	retentionFlags & 32 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#ExtRetCopyInfo') is not null DROP TABLE #ExtRetCopyInfo
	if object_id('tempdb.dbo.#ExtRetJobInfo') is not null DROP TABLE #ExtRetJobInfo
	if object_id('tempdb.dbo.#ExtRetJobInfoForLowerRetRule') is not null DROP TABLE #ExtRetJobInfoForLowerRetRule
	if object_id('tempdb.dbo.#ExtRetToBeCopiedJobInfo') is not null DROP TABLE #ExtRetToBeCopiedJobInfo
	if object_id('tempdb.dbo.#ExtRetToBeCopiedJobInfoForLowerRetRule') is not null DROP TABLE #ExtRetToBeCopiedJobInfoForLowerRetRule
	if object_id('tempdb.dbo.#ExtRetLastJobInfo') is not null DROP TABLE #ExtRetLastJobInfo
	if object_id('tempdb.dbo.#ExtRetToBeCopiedLastJobInfo') is not null DROP TABLE #ExtRetToBeCopiedLastJobInfo
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daRJApplyExtendedHalfYearlyFullRule')
	delete from GxQscripts where name = 'daRJApplyExtendedHalfYearlyFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daRJApplyExtendedHalfYearlyFullRule')
	delete from GXDBVersions where aliasname = 'daRJApplyExtendedHalfYearlyFullRule'
GO

insert into GXDBVersions values(2, 'daRJApplyExtendedHalfYearlyFullRule',  '00010001027800020000', 'daRJApplyExtendedHalfYearlyFullRule', '00010001027800020000')
GO

