

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daRJApplyExtendedAllFullRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daRJApplyExtendedAllFullRule.sp,v $ $Id: daRJApplyExtendedAllFullRule.sp,v 1.1.278.1 2018/03/20 20:02:35 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daRJApplyExtendedAllFullRule()
--  |
--  | Description:  Retain the jobs based on extended retention All Full rule
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daRJApplyExtendedAllFullRule <<<'

IF EXISTS (select * from sysobjects where name='daRJApplyExtendedAllFullRule')
	drop procedure daRJApplyExtendedAllFullRule
IF EXISTS (select * from GxQscripts where name='daRJApplyExtendedAllFullRule')
	delete from GxQscripts where name = 'daRJApplyExtendedAllFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daRJApplyExtendedAllFullRule')
	delete from GXDBVersions where aliasname = 'daRJApplyExtendedAllFullRule'
GO
print '... Creating Procedure: daRJApplyExtendedAllFullRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daRJApplyExtendedAllFullRule
  @agingAsofDays INTEGER,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @currentTime 	INTEGER
		SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE	@ExtRetCopyInfo TABLE (
			copyId 					INTEGER,
			retentionDays		INTEGER,
			extRetEndTime 	BIGINT,
			firstOfPeriod 	INTEGER
			PRIMARY KEY (copyId)
			)
	-------------------------------------------------------------------------------
	--------------- Apply the Extended Retention All Full Rule --------------------
	-------------------------------------------------------------------------------
	-- Get all Extended Retention Info for current list of copies being processed
	INSERT INTO @ExtRetCopyInfo
SELECT DISTINCT JCE.copyId, AARE.retentionDays, (@currentTime - cast(AARE.retentionDays as bigint) * 24 * 3600), (AAR.flags & 1)
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK), archAgingRuleExtended AARE WITH (NOLOCK)
	WHERE JCE.copyId = AAR.copyId
	AND		AAR.copyId = AARE.copyId
	AND		AARE.retentionRule & 2 = 2 -- EXTENDED_ALLFULL
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set Extended Retention Info for current list of copies being processed
	-- Set the retentionFlags even for TO-BE-COPIED/DISABLED/PARTIAL_SUCCESSFUL FULL jobs
UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags | 2 -- EXTENDED_ALLFULL
FROM #RJ_ArchJobCopyExtended JCE WITH (NOLOCK), @ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daRJApplyExtendedAllFullRule')
	delete from GxQscripts where name = 'daRJApplyExtendedAllFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daRJApplyExtendedAllFullRule')
	delete from GXDBVersions where aliasname = 'daRJApplyExtendedAllFullRule'
GO

insert into GXDBVersions values(2, 'daRJApplyExtendedAllFullRule',  '00010001027800010000', 'daRJApplyExtendedAllFullRule', '00010001027800010000')
GO

