

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daPruneDataSetAndMembers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daPruneDataSetAndMembers.sp,v $ $Id: daPruneDataSetAndMembers.sp,v 1.5.2.7 2018/03/20 19:51:55 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daPruneDataSetAndMembers <<<'

IF EXISTS (select * from sysobjects where name='daPruneDataSetAndMembers')
	drop procedure daPruneDataSetAndMembers
IF EXISTS (select * from GxQscripts where name='daPruneDataSetAndMembers')
	delete from GxQscripts where name = 'daPruneDataSetAndMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPruneDataSetAndMembers')
	delete from GXDBVersions where aliasname = 'daPruneDataSetAndMembers'
GO
print '... Creating Procedure: daPruneDataSetAndMembers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daPruneDataSetAndMembers
  @i_dummy INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@errorCode 	INTEGER
	SET			@errorCode 	= 0
	DECLARE	@currentTime 	INTEGER
	SET			@currentTime 	= dbo.getUnixTime(GETUTCDATE())
	DECLARE @DELETED_SUBCLIENT	INTEGER
	SET			@DELETED_SUBCLIENT	= 2
	DECLARE @OLD_STORAGE_POLICY	INTEGER
	SET			@OLD_STORAGE_POLICY	= 4
	DECLARE @NOT_PRUNABLE	INTEGER
	SET			@NOT_PRUNABLE	= 8
	DECLARE	@EnableDSAndMemberPruning		INTEGER
	SET			@EnableDSAndMemberPruning		= 0
	/*************************** Create Temp Tables ***************************/
	if object_id('tempdb.dbo.#DataSetList') is not null DROP TABLE #DataSetList
	CREATE	TABLE #DataSetList (
			DataSetId 	INTEGER,
			AppId				INTEGER,
			archCopyId	INTEGER,
			archGrpId		INTEGER,
			flags				INTEGER,
	)
	CREATE INDEX Idx_DataSetList_1 ON #DataSetList (DataSetId)
	CREATE INDEX Idx_DataSetList_2 ON #DataSetList (AppId)
	if object_id('tempdb.dbo.#MM_SMProcessDatasetsForPruningResultTable') is not null DROP TABLE #MM_SMProcessDatasetsForPruningResultTable
	CREATE TABLE #MM_SMProcessDatasetsForPruningResultTable (
			errCode			INTEGER,
			errMsg			VARCHAR(255)
	)
	--
	-- Check if DA is enabled before proceeding
	--
	declare @l_isDAEnabled integer
	set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
	if (@l_isDAEnabled = 0)
	begin
set @errorCode = -1000
		GOTO CX_EXIT
	end
	SELECT @EnableDSAndMemberPruning = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_SNAP_ENABLE_DS_AND_MEMBER_PRUNING'
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Do not prune DataSet and DataSet Members if pruning is disabled
	IF @EnableDSAndMemberPruning = 0
		GOTO CX_EXIT
	-- Get DataSets with associated copies and Storage Policies
	INSERT INTO #DataSetList
	SELECT DISTINCT DSSC.DataSetId, DSSC.AppId, CRM.archGroupCopyId, AGC.archGroupId, 0
	FROM SMDataSetToSubClientMap DSSC WITH (NOLOCK), SMCopyToRelationMap CRM WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE DSSC.SMRelationId = CRM.SMRelationId
	AND		CRM.archGroupCopyId = AGC.id
	AND		DSSC.AppId > 0
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Mark DataSets associated to deleted subclients
	UPDATE #DataSetList
	SET flags = T.flags | @DELETED_SUBCLIENT
	FROM #DataSetList T LEFT OUTER JOIN App_Application APP WITH (NOLOCK)
	ON T.AppId = APP.id
WHERE APP.subclientStatus & 0x00004 > 0
	OR		APP.id IS NULL
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Mark DataSets associated to old Storage Policies
	UPDATE #DataSetList
	SET flags = T.flags | @OLD_STORAGE_POLICY
	FROM #DataSetList T LEFT OUTER JOIN App_Application APP WITH (NOLOCK)
	ON T.AppId = APP.id
	WHERE APP.dataArchGrpId != T.archGrpId
	OR		APP.id IS NULL
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- DO NOT prune DataSets that are not prunable
	UPDATE #DataSetList
	SET flags = flags | @NOT_PRUNABLE
	WHERE flags = 0
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Mark the Datasets that cannot be pruned
	EXEC MM_SMProcessDatasetsForPruning
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT	@errorCode = errCode
	FROM	#MM_SMProcessDatasetsForPruningResultTable
	IF	@errorCode != 0 GOTO CX_EXIT
	-- DO NOT prune DataSets that cannot be pruned
	UPDATE #DataSetList
	SET flags = T.flags | @NOT_PRUNABLE
	FROM #DataSetList T, SMDataSet DS WITH (NOLOCK)
	WHERE T.DataSetId = DS.DataSetId
AND		DS.Flags & 1024 > 0
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- DO NOT prune DataSets associated with subclient-copies having Snaps not yet deleted
	UPDATE #DataSetList
	SET flags = T.flags | @NOT_PRUNABLE
	FROM #DataSetList T, SMVolume SV WITH (NOLOCK), SMVolSnapMap VSM WITH (NOLOCK), SMSnap SS WITH (NOLOCK)
	WHERE T.AppId = SV.AppId
	AND		T.archCopyId = SV.copyId
	AND		SV.SMVolumeId = VSM.SMVolumeId
	AND		VSM.SMSnapId = SS.SMSnapId
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- DO NOT prune DataSets associated with subclients having non-aged Snap jobs
	UPDATE #DataSetList
	SET flags = T.flags | @NOT_PRUNABLE
	FROM #DataSetList T, JMJobDataStats JDS WITH (NOLOCK)
	WHERE T.AppId = JDS.AppId
	AND		T.archCopyId = JDS.archGrpCopyId
	AND		JDS.status != 1000
AND		JDS.disabled & 256 = 0
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Ignore all AppId = 0 rows as they are dummy rows created for LREP requirements
	-- Mark the DataSets are prunable
	UPDATE SMDataSetToSubClientMap
SET Flags = DSSC.Flags | 256, AgedTime = @currentTime, AgedBy = AgedBy | 512
	FROM SMDataSetToSubClientMap DSSC, (SELECT DataSetId, AppId, MAX(Flags & @NOT_PRUNABLE) AS PrunableFlags
																			FROM #DataSetList
																			GROUP BY DataSetId, AppId) T
	WHERE DSSC.DataSetId = T.DataSetId
	AND		DSSC.AppId =  T.AppId
	AND		T.PrunableFlags = 0
AND		DSSC.Flags & 256 = 0
	AND		DSSC.AppId > 0
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Mark the DataSets are prunable
	UPDATE SMDataSet
SET Flags = DS.Flags | 256, AgedTime = @currentTime, AgedBy = DS.AgedBy | 512
FROM SMDataSet DS, (SELECT DataSetId, MIN(Flags & 256) AS AgedFlags
											FROM	SMDataSetToSubClientMap WITH (NOLOCK)
											--WHERE	AppId > 0
											GROUP BY DataSetId) T
	WHERE DS.DataSetId = T.DataSetId
	AND		T.AgedFlags > 0
AND		DS.Flags & 256 = 0
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Mark the DataSet members as prunable if all AppIds associated to a given DataSet is marked as prunable
	-- and there are no associated snaps to the Dataset Member
	UPDATE SMDataSetMember
SET Flags = DSM.Flags | 256, ModifiedTime = @currentTime, AgedTime = @currentTime, AgedBy = DSM.AgedBy | 512
	FROM SMDataSetMember DSM, SMDataSet DS WITH (NOLOCK)
	WHERE	DSM.DataSetId = DS.DataSetId
	--AND		DS.Flags & CVA_AGED_DATA_FLAG > 0
	AND 	(DSM.Flags & 1) = 1 			--Age only primary members
	AND		NOT EXISTS(SELECT * FROM SMDataSetToSubClientMap DSSC WITH(NOLOCK) WHERE DSSC.DataSetId = DSM.DataSetId AND DSSC.AppId = DSM.AppId AND DSSC.AppId > 0 AND DSSC.Flags & 256 = 0)
AND		DSM.Flags & 256 = 0
	AND 	NOT EXISTS (SELECT SDSM.DSMemberId FROM SMSnapToDatasetMemberMap SDSM WITH (NOLOCK) WHERE SDSM.DSMemberId = DSM.DataSetMemberId)
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#DataSetList') is not null
		DROP TABLE #DataSetList
	if object_id('tempdb.dbo.#MM_SMProcessDatasetsForPruningResultTable') is not null
		DROP TABLE #MM_SMProcessDatasetsForPruningResultTable
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daPruneDataSetAndMembers')
	delete from GxQscripts where name = 'daPruneDataSetAndMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPruneDataSetAndMembers')
	delete from GXDBVersions where aliasname = 'daPruneDataSetAndMembers'
GO

insert into GXDBVersions values(2, 'daPruneDataSetAndMembers',  '00010005000200070000', 'daPruneDataSetAndMembers', '00010005000200070000')
GO

