

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daPopulateToBeAgedJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daPopulateToBeAgedJobs.sp,v $ $Id: daPopulateToBeAgedJobs.sp,v 1.11.86.1 2018/03/20 19:54:28 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daPopulateToBeAgedJobs()
--  |
--  | Description:  Populate to be aged jobs into ArchJobCopyToBeAged table.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daPopulateToBeAgedJobs')
BEGIN
	print '>>> Drop Stored Procedure: daPopulateToBeAgedJobs <<<'
	drop procedure daPopulateToBeAgedJobs
END
IF EXISTS (select * from GxQscripts where name='daPopulateToBeAgedJobs')
	delete from GxQscripts where name = 'daPopulateToBeAgedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateToBeAgedJobs')
	delete from GXDBVersions where aliasname = 'daPopulateToBeAgedJobs'
GO
print '... Creating Procedure: daPopulateToBeAgedJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daPopulateToBeAgedJobs
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_numJobAged INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	DECLARE @numJobAged		INTEGER
	SET		@errorCode		= 0
	SET		@numJobAged		= 0
	DECLARE @AP_PRUNE_PRUNABLE INTEGER
	SET		@AP_PRUNE_PRUNABLE = 1
	DECLARE @numJobNotAged INTEGER
	SET		@numJobNotAged = 0
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @tblCopySource TABLE (
		archGroupId 	INT,
		CopyId				INT,
		sourceCopyId	INT,
		primaryCopyId INT,
		isSnapCopy		INT,
		isMirrorCopy	INT
		Primary Key (CopyId)
	)
	DECLARE @tblMatSrcCopy TABLE (
		archGroupId INT,
		sourceCopyId INT
	)
	DECLARE @tblSpoolCopyJobs	TABLE (
			commCellId 	int,
			JobId 			int,
			spoolCopyId int
	)
	DECLARE @tblSpoolCopyJobsNotCopied TABLE (
			commCellId int,
			JobId			 int,
			copyId		 int,
			doNotAge	 int
	)
	IF (OBJECT_ID('tempdb.dbo.#tblArchiverJobsToBeChecked') is not null)
		DROP TABLE #tblArchiverJobsToBeChecked
	CREATE TABLE #tblArchiverJobsToBeChecked (
			JobId int,
			CommcellId int,
			CopyId int,
			archGroupId int,
			defaultCopy int,
			PRIMARY KEY(JobId, CommcellId, copyId)
	)
	--Update DONOTAGE flag from APPCOPYTOBEAGEDTABLE
	--For NonPrunable App/Copy
	UPDATE #DA_JobCopyList
	SET jobRetainReason = jobRetainReason | b.DoNotAge
FROM	#DA_JobCopyList a, ArchAppCopyToBeAged b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		b.DoNotAge > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Reset all not prunable reasons on index copy jobs except for applicable reasons
	UPDATE #DA_JobCopyList
SET jobRetainReason = jobRetainReason & ((1 | 4 | 8 | 256 | 512 | 2048 | 131072 | 134217728 | 536870912))
	FROM	#DA_JobCopyList
WHERE AppFlags & CAST(4294967296 AS bigint) > 0
AND		JobFlags & 32 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get source copy information
	INSERT	INTO @tblCopySource
	SELECT	DISTINCT a.archGroupId, a.id, a.sourceCopyId, (CASE a.isSnapCopy WHEN 0 THEN b.defaultCopy ELSE b.defaultSnapCopy END), a.isSnapCopy, a.isMirrorCopy
	FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
	WHERE	a.archGroupId = b.id
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- The source copy will be source of Mirror copy if source copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopySource T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopySource
		SET 	sourceCopyId = AGC.sourceCopyId
		FROM	@tblCopySource T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	-- The source copy will be primary copy if no source copy defined
	UPDATE	@tblCopySource
	SET 	sourceCopyId = primaryCopyId
	WHERE	sourceCopyId = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get materialization source copy information
	INSERT INTO @tblMatSrcCopy
	SELECT DISTINCT T.archGroupId, (CASE b.sourceCopyId WHEN 0 THEN T.primaryCopyId ELSE b.sourceCopyId END)
	FROM	@tblCopySource T, archMaterializeSnapshotProp b WITH (NOLOCK)
	WHERE	T.archGroupId = b.archGroupId
	AND		T.CopyId = (CASE b.sourceCopyId WHEN 0 THEN T.primaryCopyId ELSE b.sourceCopyId END)
	AND		T.isSnapCopy > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- If tape movement is not enabled then set primary snap copy as default source for tape movement and apply safety checks on primary snap copy
	INSERT INTO @tblMatSrcCopy
	SELECT DISTINCT T.archGroupId, primaryCopyId
	FROM	@tblCopySource T
	WHERE	T.isSnapCopy > 0
	AND		NOT EXISTS (SELECT archGroupId FROM @tblMatSrcCopy WHERE archGroupId = T.archGroupId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set Materialization Source Copy as source of Mirror copy, if materialization Source Copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblMatSrcCopy T, @tblCopySource C WHERE T.sourceCopyId = C.CopyId AND C.isSnapCopy > 0 AND C.isMirrorCopy > 0)
	BEGIN
		UPDATE @tblMatSrcCopy
		SET sourceCopyId = C.sourceCopyId
		FROM	@tblMatSrcCopy T, @tblCopySource C
		WHERE	T.sourceCopyId = C.CopyId
		AND		T.archGroupId = C.archGroupId
		AND		C.isSnapCopy > 0
		AND		C.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	INSERT	INTO ArchJobCopyToBeAged
	SELECT	a.JobId, a.CopyId, a.FileType, a.CommCellId, a.AppId
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.OnLinkedSP = 0
	AND 	a.jobRetainReason = 0
	AND 	b.DoNotAge = 0
	AND 	b.AgeStatus = 0
	AND		b.appIdSelectedForPruning = 1
	SELECT 	@errorCode = @@ERROR, @numJobAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	-- Get the jobs on SNAP MIRROR Copies also and prune them
	INSERT	INTO ArchJobCopyToBeAged
	SELECT	DISTINCT JDS.JobId, JDS.archGrpCopyId, a.FileType, JDS.CommCellId, JDS.AppId
	FROM	#DA_JobCopyList a, #DA_AppCopyList b, JMJobDataStats JDS WITH (NOLOCK), @tblCopySource TT
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.OnLinkedSP = 0
	AND 	a.jobRetainReason = 0
	AND 	b.DoNotAge = 0
	AND 	b.AgeStatus = 0
	AND		b.appIdSelectedForPruning = 1
	AND		a.AppId = JDS.AppId
	AND		a.JobId = JDS.JobId
	AND		a.CommCellId = JDS.CommCellId
	AND		a.CopyId = TT.sourceCopyId
	AND		JDS.archGrpCopyId = TT.CopyId
	AND		TT.isSnapCopy > 0
	AND		TT.isMirrorCopy > 0
	SELECT 	@errorCode = @@ERROR, @numJobAged = @numJobAged + @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------
	-- Safe check
	-- Do not prune job from copy with data aging disabled
	-----------------------------------------------------------------
	DELETE	ArchJobCopyToBeAged
FROM	ArchJobCopyToBeAged a, archAgingRule b WITH (NOLOCK)
	WHERE	a.copyId = b.copyId
AND		b.flags & 4 > 0
	SELECT 	@errorCode = @@ERROR, @numJobNotAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	SET @numJobAged = @numJobAged - @numJobNotAged
	-----------------------------------------------------------------
	-- Safe check
	-- Do not prune manually retained job
	-----------------------------------------------------------------
	DELETE	ArchJobCopyToBeAged
FROM	ArchJobCopyToBeAged a, JMJobDataStats b WITH (NOLOCK)
	WHERE	a.jobId = b.jobId
	AND		a.copyId = b.archGrpCopyId
	AND		(a.dataType = b.dataType or a.dataType = 0)
	AND		a.commCellId = b.commCellId
	AND		b.disabled & 2 > 0
	SELECT 	@errorCode = @@ERROR, @numJobNotAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	SET @numJobAged = @numJobAged - @numJobNotAged
	-----------------------------------------------------------------
	-- Safe check
	-- Do not prune those jobs with copy as spool copy
	-- if jobs are not yet successfully copied on destination copy
	-----------------------------------------------------------------
	-- Get all spool copy jobs selected for pruning
	INSERT	INTO @tblSpoolCopyJobs
	SELECT	DISTINCT AJC.commCellId, AJC.JobId, AJC.copyId
FROM	ArchJobCopyToBeAged AJC, ArchAppCopyToBeAged AC
	WHERE	AJC.appId = AC.appId
	AND	AJC.copyId = AC.CopyId
	AND 	AC.retentionDays = 0
	AND 	AC.retentionCycles = 0
	AND	AC.copyIsSpool != 0
	SELECT 	@errorCode = @@ERROR
	IF		@errorCode != 0 GOTO CX_EXIT
	INSERT INTO @tblSpoolCopyJobsNotCopied
	SELECT DISTINCT SCJ.commCellId, SCJ.jobId, SCJ.spoolCopyId, 1
	FROM @tblSpoolCopyJobs SCJ INNER JOIN @tblCopySource T
	ON 	SCJ.spoolCopyId = T.sourceCopyId
	LEFT OUTER JOIN JMJobDataStats JDS
			ON 	JDS.jobId = SCJ.JobId
			AND JDS.commCellId = SCJ.commCellId
			AND JDS.archGrpCopyId = T.CopyId
			AND JDS.status = 100
	WHERE T.CopyId != SCJ.spoolCopyId
	AND	  T.isSnapCopy = 0
	GROUP BY SCJ.commCellId, SCJ.jobId, SCJ.spoolCopyId
	HAVING	 MAX(JDS.jobId) is null
	UNION
	SELECT DISTINCT SCJ.commCellId, SCJ.jobId, SCJ.spoolCopyId, 2
	FROM @tblSpoolCopyJobs SCJ INNER JOIN @tblCopySource T
	ON 	SCJ.spoolCopyId = T.sourceCopyId
		LEFT OUTER JOIN JMJobSnapShotStats J WITH (NOLOCK)
			ON		J.jobId = SCJ.JobId
			AND 	J.commCellId = SCJ.commCellId
			AND		J.materializationStatus = 100
			AND		SCJ.spoolCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
		LEFT OUTER JOIN JMJobDataStats JDS WITH (NOLOCK)
			ON	JDS.jobId = SCJ.JobId
			AND JDS.commCellId = SCJ.commCellId
			AND JDS.archGrpCopyId = T.CopyId
			AND	JDS.status = 100
		WHERE	T.CopyId != SCJ.spoolCopyId
		AND		T.isMirrorCopy = 0
		AND		T.isSnapCopy > 0
		GROUP BY SCJ.commCellId, SCJ.jobId, SCJ.spoolCopyId
		HAVING	 MAX(JDS.jobId) is null AND	MAX(J.jobId) IS null
	SELECT 	@errorCode = @@ERROR
	IF		@errorCode != 0 GOTO CX_EXIT
	-- Do not prune job from spool copy if job is not yet copied
	DELETE ArchJobCopyToBeAged
FROM  ArchJobCopyToBeAged AJC, @tblSpoolCopyJobsNotCopied SCJ
	WHERE AJC.commCellId = SCJ.commCellId
	AND 	AJC.jobId = SCJ.jobId
	AND		AJC.copyId = SCJ.copyId
	SELECT 	@errorCode = @@ERROR, @numJobNotAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	SET @numJobAged = @numJobAged - @numJobNotAged
	-------------------------------------------------------------------------------------------------------------
	-- Do not prune archiver jobs from the primary if there is a selective secondary copy and no synchronous copy
	-- and if those are not copied to that secondary
	-------------------------------------------------------------------------------------------------------------
	IF EXISTS (SELECT * FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_TREAT_ARCHIVER_DATA_AS_SPOOLED_COPY' AND value = 1)
	BEGIN
		INSERT INTO #tblArchiverJobsToBeChecked
		SELECT DISTINCT AJC.JobId, AJC.commCellId, AJC.copyId, ACT.archGrpId, ACT.primaryCopyId
FROM	ArchJobCopyToBeAged AJC
INNER JOIN ArchAppCopyToBeAged ACT ON ACT.appId = AJC.appId AND ACT.copyId = AJC.copyId
		AND (ACT.fileType = 0 OR ACT.fileType = AJC.dataType)
AND (ACT.appFlags & 2048) > 0
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		DECLARE @tblSrcDestCopyMap table (srcCopyId int, destCopyId int, destCopyType int)
		INSERT @tblSrcDestCopyMap
		SELECT CL.copyId, AGC.id, AGC.type
		FROM archGroupCopy AGC WITH (NOLOCK) INNER JOIN (SELECT DISTINCT copyId, defaultCopy, archGroupId FROM #tblArchiverJobsToBeChecked) CL
		ON CL.archGroupId = AGC.archGroupId AND AGC.id <> CL.copyId AND
		(
			(AGC.sourceCopyId > 0 AND CL.copyId = AGC.sourceCopyId)
			OR
			(AGC.sourceCopyId = 0 AND CL.copyId = CL.defaultCopy)
		)
WHERE AGC.type IN (1, 2) AND AGC.isSnapCopy = 0
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		--Need not prevent pruning for jobs in copies that has a destination sync. copy where job is picked
		DELETE #tblArchiverJobsToBeChecked
FROM #tblArchiverJobsToBeChecked AJ INNER JOIN @tblSrcDestCopyMap CL ON AJ.copyId = CL.srcCopyId AND CL.destCopyType = 1
		INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON AJ.jobId = JDS.jobId AND AJ.commcellId = JDS.commcellId AND CL.destCopyId = JDS.archGrpCopyId
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		--Need not prevent pruning for jobs in copies that does not have a destination copy
		DELETE #tblArchiverJobsToBeChecked
		FROM #tblArchiverJobsToBeChecked AJ LEFT OUTER JOIN @tblSrcDestCopyMap CL ON AJ.copyId = CL.srcCopyId
		WHERE CL.srcCopyId is null
		SELECT 	@errorCode = @@ERROR
		IF		@errorCode != 0 GOTO CX_EXIT
		-- Now jobs left in #tblArchiverJobsToBeChecked are those that do not have sync. destination copy but has selective destination copy
		-- Do not prune these archiver jobs if they are not copied to even any one of the destination selective copy
			DELETE ArchJobCopyToBeAged
FROM ArchJobCopyToBeAged T1 INNER JOIN
			(
				SELECT AJ.jobId, AJ.commCellId, AJ.copyId
				FROM  #tblArchiverJobsToBeChecked AJ
INNER JOIN @tblSrcDestCopyMap CL ON CL.srcCopyId = AJ.copyId AND CL.destCopyType = 2
				LEFT OUTER JOIN JMJobDataStats JDS WITH (NOLOCK)
				ON 	JDS.jobId = AJ.JobId
										AND JDS.commCellId = AJ.commCellId
										AND JDS.status = 100
										AND JDS.archGrpCopyId = CL.destCopyId
				GROUP BY AJ.jobId, AJ.commcellId, AJ.copyId
				HAVING (MAX(JDS.status) is null)
			) T2
			ON T1.jobId = T2.jobId AND T1.commCellId = T2.commCellId AND T1.copyId = T2.copyId
			SELECT 	@errorCode = @@ERROR, @numJobNotAged = @@ROWCOUNT
			IF		@errorCode != 0 GOTO CX_EXIT
			SET @numJobAged = @numJobAged - @numJobNotAged
	END
	IF (OBJECT_ID('tempdb.dbo.#tblArchiverJobsToBeChecked') is not null)
		DROP TABLE #tblArchiverJobsToBeChecked
CX_EXIT:
	IF @errorCode != 0
	BEGIN
		SELECT	@errorCode, -1
	END
	ELSE
	BEGIN
		SELECT	@errorCode, @numJobAged
	END
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daPopulateToBeAgedJobs')
	delete from GxQscripts where name = 'daPopulateToBeAgedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateToBeAgedJobs')
	delete from GXDBVersions where aliasname = 'daPopulateToBeAgedJobs'
GO

insert into GXDBVersions values(2, 'daPopulateToBeAgedJobs',  '00010011008600010000', 'daPopulateToBeAgedJobs', '00010011008600010000')
GO

