

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daPopulateTempTbl.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daPopulateTempTbl.sp,v $ $Id: daPopulateTempTbl.sp,v 1.10.208.4.54.1 2021/05/05 22:15:20 hkapadia Exp $";
--  +========================================================================+
--  | Stored Proc:  daPopulateTempTbl()
--  |
--  | Description:  Populate data of Subclients. ASR, LOG are not aged here.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='daPopulateTempTbl')
BEGIN
	print '>>> Drop Stored Procedure: daPopulateTempTbl <<<'
	drop procedure daPopulateTempTbl
END
IF EXISTS (select * from GxQscripts where name='daPopulateTempTbl')
	delete from GxQscripts where name = 'daPopulateTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateTempTbl')
	delete from GXDBVersions where aliasname = 'daPopulateTempTbl'
GO
print '... Creating Procedure: daPopulateTempTbl'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure daPopulateTempTbl
  @numAppIdToAge INTEGER,
  @appSqlFlag BIGINT,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobCopy INTEGER;
	SET NOCOUNT ON
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobCopy		INTEGER
	DECLARE @errorCode		INTEGER
	SET		@numAppIdAged	= 0
	SET		@numJobCopy		= 0
	SET		@errorCode		= 0
	DECLARE @ORACLE_RMAN_CUSTOMSCRIPT_BKP		BIGINT							-- JMBKP_ORACLE_RMAN_CUSTOMSCRIPT_BKP
	SET			@ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
	DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
	SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
	DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
	SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
	IF object_id('tempdb.dbo.#tblAppCopyList') IS NOT null DROP TABLE #tblAppCopyList
	CREATE TABLE #tblAppCopyList (
			AppCopyId int IDENTITY(1,1),
			appId int,
			copyId int,
			fileType int,
			Primary key (appId, copyId, fileType)
			)
	DECLARE	@tblJobSelFullLog TABLE (
			AppId int, CopyId int, FileType int,
			ParentJobId int, ChildJobId int, CommCellId int,
			DataStatus int, Disabled int
			)
	DECLARE @tblJobOnLinkedSP TABLE (
			AppId int, AppFlags bigint, CopyId int, FileType int,
			JobId int, CommCellId int
			)
	DECLARE	@tblChildJobs TABLE (
			parentJobId		int,
 			childJobId 		int,
 			commCellId 		int,
 			isChildJobBad	int
			)
	-------------------------------------------------------------------------------
	-- Get the @numAppIdToAge rows to be processed from ArchAppCopyToBeAged
	-- appId with logs will not be processed here
	-------------------------------------------------------------------------------
	-- Do not check the SQL restore chain for subclients installed before 6.1
	IF @appSqlFlag = 0
	BEGIN
			--First process all BLR FS subclients as source subclient jobs are dependent on Index copy job status
			INSERT	INTO #tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		AppFlags & (2 | 32 | 4194304 | 134217728 | CAST(2147483648 AS bigint)) =  2
AND		AppFlags & (CAST(4294967296 AS bigint)) > 0
AND		AppFlags & (33554432 | 67108864) = 0
			ORDER	BY appType, appId, copyId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			IF NOT EXISTS (SELECT appId FROM #tblAppCopyList)
			BEGIN
				INSERT	INTO #tblAppCopyList
						(appId, copyId, fileType)
				SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
				WHERE	AgeStatus = 0
AND		AppFlags & (2 | 32 | 4194304 | 134217728 | CAST(2147483648 AS bigint)) =  2
AND		AppFlags & (33554432 | 67108864) = 0
				ORDER	BY appType, appId, copyId
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
			END
	END
IF @appSqlFlag = 32
	BEGIN
			INSERT	INTO #tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		((appFlags & 2 > 0) AND (AppFlags & 32 > 0))
AND		AppFlags & (33554432 | 67108864) = 0
			ORDER	BY appType, appId, copyId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
	END
IF @appSqlFlag = 4194304
	BEGIN
			-- Order by instanceId since all the appId for an Instance needs to be processed together
			INSERT	INTO #tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		((appFlags & 2 > 0) AND (AppFlags & 4194304 > 0))
AND		AppFlags & (33554432 | 67108864) = 0
			ORDER	BY instanceId, appId, copyId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
	END
IF @appSqlFlag = 134217728
	BEGIN
			INSERT	INTO #tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		((appFlags & 2 > 0) AND (AppFlags & 134217728 > 0))
AND		AppFlags & (33554432 | 67108864) = 0
AND 	AppFlags & CAST(2147483648 AS bigint) = 0
			ORDER	BY appType, appId, copyId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
	END
IF @appSqlFlag = 33554432
	BEGIN
			--First process all Job based retention copies except for VSA AppAware data
			INSERT	INTO #tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		AppFlags & 33554432 > 0
AND		AppFlags & 134217728 = 0
AND		AppFlags & 67108864 = 0
AND 	AppFlags & CAST(2147483648 AS bigint) = 0
			ORDER	BY appType, appId, copyId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			--Now pick VSA AppAware data to process
			IF NOT EXISTS (SELECT appId FROM #tblAppCopyList)
			BEGIN
				INSERT	INTO #tblAppCopyList
						(appId, copyId, fileType)
				SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
				WHERE	AgeStatus = 0
AND		AppFlags & 33554432 > 0
AND		AppFlags & 134217728 > 0
AND		AppFlags & 67108864 = 0
AND 	AppFlags & CAST(2147483648 AS bigint) = 0
				ORDER	BY appType, appId, copyId
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
			END
	END
IF @appSqlFlag = 67108864
	BEGIN
			INSERT	INTO #tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		AppFlags & 67108864 > 0
			ORDER	BY appType, appId, copyId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
	END
IF @appSqlFlag = 2147483648
	BEGIN
			INSERT	INTO #tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		((appFlags & 2 > 0) AND (AppFlags & CAST(2147483648 AS bigint) > 0))
			ORDER	BY appType, appId, copyId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
	END
	IF	@numAppIdToAge > 0
			DELETE	FROM #tblAppCopyList
			WHERE	AppCopyId > @numAppIdToAge
IF @appSqlFlag = 4194304
	BEGIN
	--Select all subclient/copy of selected instances for Documentum since Data is AGED at instance level
		INSERT INTO	#DA_AppCopyList
		SELECT	b.*
FROM	ArchAppCopyToBeAged b
		WHERE	b.instanceId IN (SELECT DISTINCT A.instanceId
FROM ArchAppCopyToBeAged A, #tblAppCopyList T
														WHERE	T.appId = A.appId
														AND 	T.copyId = A.copyId
														AND 	T.fileType = A.fileType )
		AND b.AgeStatus = 0
AND	((b.appFlags & 2 > 0) AND (b.AppFlags & 4194304 > 0))
AND	b.AppFlags & (33554432 | 67108864) = 0
	END
ELSE IF @appSqlFlag = 33554432
	BEGIN
		-- Get appId to be processed
		-- Get Data and logs together for Job Based Retention
		INSERT INTO	#DA_AppCopyList
		SELECT	DISTINCT b.*
FROM	#tblAppCopyList a, ArchAppCopyToBeAged b
		WHERE	a.appId = b.appId
		AND 	a.copyId = b.copyId
AND		b.AppFlags & 33554432 > 0
AND		b.AppFlags & 67108864 = 0
	END
ELSE IF @appSqlFlag = 67108864
	BEGIN
		-- Get appId to be processed
		INSERT INTO	#DA_AppCopyList
		SELECT	DISTINCT b.*
FROM	#tblAppCopyList a, ArchAppCopyToBeAged b
		WHERE	a.appId = b.appId
		AND 	a.copyId = b.copyId
AND		b.AppFlags & 67108864 > 0
	END
ELSE IF @appSqlFlag = 2147483648
	BEGIN
		-- Get appId to be processed
		-- Data on copy which do not need to be aged will still be calculated
		-- to see if its retention is the highest for job
		INSERT INTO	#DA_AppCopyList
		SELECT	DISTINCT b.*
FROM	#tblAppCopyList a, ArchAppCopyToBeAged b
		WHERE	a.appId = b.appId
		AND 	a.fileType = b.fileType
		AND		b.appIdSelectedForProcessing = 1
AND		b.DoNotAge & (33554432 | 262144 | 524288 | 1) = 0
	END
	ELSE
	BEGIN
		-- Get appId to be processed
		-- Data on copy which do not need to be aged will still be calculated
		-- to see if its retention is the highest for job
		INSERT INTO	#DA_AppCopyList
		SELECT	DISTINCT b.*
FROM	#tblAppCopyList a, ArchAppCopyToBeAged b
		WHERE	a.appId = b.appId
		--AND 	a.copyId = b.copyId
		AND 	a.fileType = b.fileType
AND		b.AppFlags & (33554432 | 67108864) = 0
		AND		b.appIdSelectedForProcessing = 1
AND		b.DoNotAge & (33554432 | 262144 | 524288 | 1) = 0
	END
	SELECT 	@errorCode = @@ERROR
	IF		@errorCode != 0 GOTO CX_EXIT
	SELECT @numAppIdAged = count(*) FROM #DA_AppCopyList where AgeStatus = 0
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	-- Get the data from JMJobDataStats table for the appIds to be processed
	-- on all copies
	-- This table may contain entries for ASR backup
	-------------------------------------------------------------------------------
	INSERT	INTO #DA_JobDataStats
	SELECT	b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId, DataStatus=MAX(b.status),
Disabled=MAX(b.Disabled & 1),
ManualRet=MAX(b.Disabled & 2),
JobFlags = ((MAX(CASE WHEN (b.Disabled & 64) <> 0 THEN 1 ELSE 0 END)) | (MAX(CASE WHEN C.type > 1 THEN 2 ELSE 0 END)))
	FROM	#DA_AppCopyList a, JMJobDataStats b WITH (NOLOCK), APP_CommCell C WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	b.status <> 1000
AND 	b.Disabled & 256 = 0
AND		((a.FileType = 0) OR (a.FileType = 1 AND b.dataType != 4) OR (a.FileType = 4 AND b.dataType = 4))
	AND		b.CommCellId = c.id
	GROUP	BY b.AppId, b.archGrpId, b.archGrpCopyId, b.JobId, b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_JobDataStats ON #DA_JobDataStats (JobId, CommCellId, CopyId)
	-------------------------------------------------------------------------------
	-- Remove ASR backups if there are any
	-------------------------------------------------------------------------------
	DELETE	#DA_JobDataStats
	FROM	#DA_JobDataStats a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.CommCellId = b.CommCellId
	AND		b.BkpLevel = 512
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Remove Foreign backups if there are any
	-------------------------------------------------------------------------------
	DELETE	#DA_JobDataStats
WHERE	(JobFlags & 2) <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	/*
	While processing VSA V2 pseudo subclients as a separate set make sure we do not process any V1 jobs with them. Ideally we don't expect the subclients to
	have mix of V1 and V2 jobs as per current design. In case they mix, the V1 jobs of those subclients would stay unaged as they won't be processed at all.
	This is to prevent any dataloss occuring by such unexpected mixed jobs. This block can be removed in future when we are sure such mix cannot happen.
	*/
IF @appSqlFlag = 2147483648
	BEGIN
		DELETE	#DA_JobDataStats
		FROM	#DA_JobDataStats a, JMBkpStats b WITH (NOLOCK)
		WHERE	a.JobId = b.JobId
		AND		a.CommCellId = b.CommCellId
AND		b.bkpAttributesEx & 0x40000000 = 0
	END
	-------------------------------------------------------------------------------
	-- Get the data from #DA_JobDataStats table for the appIds to be processed
	-- on selected copies only
	-------------------------------------------------------------------------------
	INSERT	INTO #DA_JobCopyList
	SELECT	DISTINCT a.AppId, a.AppFlags,
					a.CopyId, a.FileType,
					b.JobId, b.CommCellId,
					StartTime = -1, EndTime = -1,
					BkpLevel = -1, JobStatus = -1,
					DataStatus = b.DataStatus, Disabled = b.Disabled,
					ManualRet = b.ManualRet, RetainForAuxCopy = 0,
					ExtendedJob = 0, OnLinkedSP = 0, fullCycleNum = 0,
					CycleId = 0, jobRetainReason = 0,
					a.isCWEjobValid, JobFlags = b.JobFlags
	FROM	#DA_AppCopyList a, #DA_JobDataStats b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	IF		@numJobCopy = 0 GOTO CX_EXIT
	--For Exchange DB (appType = 53), CWE jobs are valid only if bkpAttributesEx bit is set to JMBKP_EX_EXDB_DA_PICK_CWE (0x20000)
	--MR# 147927
	UPDATE	#DA_JobCopyList
SET 	isCWEjobValid = CASE WHEN (JBK.bkpAttributesEx & 0x400000) != 0 THEN 1 ELSE 0 END
	FROM	#DA_JobCopyList a, #DA_AppCopyList b, JMBkpStats JBK WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
AND		b.appType IN (53)
	AND		a.JobId = JBK.JobId
	AND		a.commCellId = JBK.commCellId
	AND		a.isCWEjobValid != 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	----------------------------------------------------------------------------------------------
	-- Get the Start Time, End Time, Backuplevel, JobStatus and fullCycleNum of the selected jobs
	----------------------------------------------------------------------------------------------
	-- Update job info for regular backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStartDate,
				EndTime = b.ServEndDate,
BkpLevel = CASE WHEN (((b.bkpattributes & 0x4000) <> 0 OR (b.bkpattributes & 0x10000) <> 0)
AND ((b.bkpattributes & 0x1000) = 0 AND (b.bkpattributes & 0x2000) = 0))
											THEN 2 ELSE b.BkpLevel END, -- Config/Control File ONLY Backups should not be FULL backups
				JobStatus = b.Status,
				fullCycleNum = b.fullCycleNum
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update job info for DR backup and ERASE backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStart,
				EndTime = b.ServEnd,
				BkpLevel = b.ER_BkpLevel,
				JobStatus = b.Status,
				fullCycleNum = b.fullCycleNum
	FROM	#DA_JobCopyList a, JMAdminJobStatsTable b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update Snap jobs with BCD Index archive files
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 4
	FROM	#DA_JobCopyList a, #DA_AppCopyList b, JMJobDataStats JDS WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		b.copyIsSnap <> 0
	AND		a.JobId = JDS.JobId
	AND		a.commCellId = JDS.commCellId
	AND		a.CopyId = JDS.archGrpCopyId
AND		JDS.dataType = 6
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	---------------------------------------------------------------------------------
	-- Update DataStatus and Disabled for Selective Online Full
	-- before applying any Rules
	---------------------------------------------------------------------------------
	IF EXISTS (SELECT * FROM #DA_JobCopyList WHERE BkpLevel = 32768)
	BEGIN
			-- Get logs linked to selective online full
			INSERT	INTO @tblJobSelFullLog
SELECT	a.AppId, a.CopyId, 4,
					b.ParentJobId, b.ChildJobId, b.CommCellId,
					DataStatus = a.DataStatus, Disabled = a.Disabled
			FROM	#DA_JobCopyList a, JMJobDataLink b WITH (NOLOCK)
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.BkpLevel = 32768
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Get job data status for selective online full logs
			UPDATE	@tblJobSelFullLog
SET 	DataStatus = b.status, Disabled = b.Disabled & 1
			FROM	@tblJobSelFullLog a, JMJobDataStats b WITH (NOLOCK)
			WHERE	a.ChildJobId = b.JobId
			AND 	a.CopyId = b.ArchGrpCopyId
			AND 	a.FileType = b.DataType
			AND 	a.CommCellId = b.CommCellId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Update DataStatus for selective online full
			-- Assume parent job is to-be-copied if its child job is to-be-copied
			UPDATE	#DA_JobCopyList
			SET 	DataStatus = b.DataStatus
			FROM	#DA_JobCopyList a, @tblJobSelFullLog b
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.CopyId = b.CopyId
			AND 	b.DataStatus <> 100
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Update Disabled for selective online full
			-- Assume parent job is disabled if its child job is disabled
			UPDATE	#DA_JobCopyList
			SET 	Disabled = 1
			FROM	#DA_JobCopyList a, @tblJobSelFullLog b
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.CopyId = b.CopyId
			AND 	b.Disabled > 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Update DataStatus for selective online full in #DA_JobDataStats also
			-- as the DataStatus value is used for Aux Copy check
			-- Assume parent job is to-be-copied if its child job is to-be-copied
			UPDATE	#DA_JobDataStats
			SET 	DataStatus = b.DataStatus
			FROM	#DA_JobDataStats a, @tblJobSelFullLog b
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.CopyId = b.CopyId
			AND 	b.DataStatus <> 100
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Update Disabled for selective online full in #DA_JobDataStats also
			-- as the Disabled value is used for Aux Copy check
			-- Assume parent job is disabled if its child job is disabled
			UPDATE	#DA_JobDataStats
			SET 	Disabled = 1
			FROM	#DA_JobDataStats a, @tblJobSelFullLog b
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.CopyId = b.CopyId
			AND 	b.Disabled > 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
	END
	-------------------------------------------------------------------------------
	-- Do not combine the jobs on incremental storage policy. Prune the jobs on  --
	-- each copy seperately without looking at the Full storage policy
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Set flag for appaware child jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 64
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		b.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for appaware child full jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 128
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		b.bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for online/offline fulls
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 262144
	WHERE	BkpLevel in (1024, 32768)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for custom script jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 16777216
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		(b.bkpattributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP) > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for Index Copy jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 32
	FROM	#DA_JobCopyList a, BlrParentAppMap b WITH (NOLOCK)
	WHERE	a.JobId = b.IndexCopyJobId
	AND 	a.CommCellId = b.IndexCopyCommCellId
AND		a.AppFlags & (CAST(4294967296 AS bigint)) > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Mark entire cycle as index copy (if more incrementals run after Index copy jobs)
	UPDATE	a
SET 	JobFlags = a.JobFlags | 32
	FROM	#DA_JobCopyList a, #DA_JobCopyList b
	WHERE	a.appId = b.appId
	AND		a.copyId = b.copyId
	AND		a.fileType = b.fileType
AND		a.AppFlags & CAST(4294967296 AS bigint) > 0
AND		a.JobFlags & 32 > 0
	AND		a.fullCycleNum = b.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for open chain jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 33554432
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		b.openChain <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set JOBFLAGS_FULL_DATA_BACKUP flag for all DB jobs to process them for
	-- extended retention and for Jobs to calculate the oldest job prune time
	-------------------------------------------------------------------------------
		UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 8388608
		FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
		WHERE	a.JobId = b.JobId
		AND 	a.CommCellId = b.CommCellId
AND		(b.bkpattributes & 0x1000) > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Treat Synthetic Fulls, offline fulls and Migrator Jobs as Regular Fulls
	-------------------------------------------------------------------------------
	--Set the BkpLevel to FULL
	UPDATE	#DA_JobCopyList
	SET 	BkpLevel = 1
	WHERE	BkpLevel in (64, 128, 1024, 32768, 131072, 262144)
OR  	AppFlags & 2048 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	--For VSA and Exchange treat CWE jobs as successful jobs
	--if incremental jobs backed up the failed data and the job linking chain is marked closed
	--So that they get picked for extended retention as successful jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
	SET 	JobStatus = 1
	FROM	#DA_JobCopyList a, #DA_AppCopyList b, JMJobDataLink JDL WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
AND		b.appType IN (106, 53)
	AND		a.BkpLevel = 1
AND		a.JobFlags & 33554432 = 0
	AND		a.JobStatus = 3
	AND		a.JobId = JDL.parentJobId
	AND 	a.CommCellId = JDL.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- Mark the parent Job as BAD if the linked job is BAD on all copies
	-- The Parent job is not restorable if linked job is BAD and not restorable
	-- from any copy
	-----------------------------------------------------------------------------
	-- Get all Child Jobs
	INSERT	INTO @tblChildJobs
	SELECT	DISTINCT JDL.parentJobId, JDL.childJobId, JDL.commCellId, isChildJobBad = 0
	FROM	#DA_JobCopyList JCL, JMJobDataLink JDL WITH (NOLOCK)
	WHERE	JCL.JobId = JDL.parentJobId
	AND 	JCL.CommCellId = JDL.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblChildJobs
SET isChildJobBad = 64
FROM	@tblChildJobs TT, (SELECT JDS.JobId, JDS.CommCellId, MIN(JDS.Disabled & 64) AS isChildJobBad
													FROM 	JMJobDataStats JDS WITH (NOLOCK), @tblChildJobs T
													WHERE	T.childJobId = JDS.jobId
													AND 	T.CommCellId = JDS.CommCellId
													AND		JDS.status = 100
AND		JDS.Disabled & 256 = 0
													GROUP	BY JDS.JobId, JDS.CommCellId) TMP
	WHERE	TT.childJobId = TMP.jobId
	AND 	TT.CommCellId = TMP.CommCellId
AND		TMP.isChildJobBad = 64
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #DA_JobCopyList
SET JobFlags = (JobFlags | 1)
	FROM #DA_JobCopyList JCL, @tblChildJobs T
	WHERE	JCL.jobId = T.parentJobId
	AND 	JCL.CommCellId = T.CommCellId
	AND 	T.isChildJobBad > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- Do not process the Failed/Killed jobs here
	-----------------------------------------------------------------------------
	DELETE	#DA_JobCopyList
	WHERE JobStatus NOT IN (1, 3, 14) -- Success / Completed With Errors / Completed With Warnings
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- In case if no job history is available then do not process such jobs
	-----------------------------------------------------------------------------
	DELETE	#DA_JobCopyList
	WHERE StartTime = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update EndTime if EndTime is 0
	UPDATE	#DA_JobCopyList
	SET 	EndTime = StartTime
	WHERE	EndTime = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
/*
	-- Do not process disabled job without data
	-- Process them as if Index only data is written then the overall job status will be 101 and disabled but jobs will never be pruned.
	DELETE	FROM #DA_JobCopyList
	WHERE	DataStatus = 101
	AND		Disabled > 0
	SET	@errorCode	=	@@ERROR
*/
CX_EXIT:
	IF object_id('tempdb.dbo.#tblAppCopyList') IS NOT null DROP TABLE #tblAppCopyList
	IF @errorCode != 0
	BEGIN
		DELETE	FROM #DA_JobCopyList
		SELECT	@errorCode, -1, -1
	END
	ELSE
	BEGIN
		SELECT	@errorCode, @numAppIdAged, @numJobCopy
	END
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daPopulateTempTbl')
	delete from GxQscripts where name = 'daPopulateTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateTempTbl')
	delete from GXDBVersions where aliasname = 'daPopulateTempTbl'
GO

insert into GXDBVersions values(2, 'daPopulateTempTbl',  'v1.10.208.4.54.1', 'daPopulateTempTbl', 'v1.10.208.4.54.1')
GO

