

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daPopulateLogTempTbl.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daPopulateLogTempTbl.sp,v $ $Id: daPopulateLogTempTbl.sp,v 1.9.2.2.54.1 2021/05/05 22:15:12 hkapadia Exp $";
--  +========================================================================+
--  | Stored Proc:  daPopulateLogTempTbl.sp()
--  |
--  | Description:  Populate log of Subclients.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='daPopulateLogTempTbl')
BEGIN
	print '>>> Drop Stored Procedure: daPopulateLogTempTbl <<<'
	drop procedure daPopulateLogTempTbl
END
IF EXISTS (select * from GxQscripts where name='daPopulateLogTempTbl')
	delete from GxQscripts where name = 'daPopulateLogTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateLogTempTbl')
	delete from GXDBVersions where aliasname = 'daPopulateLogTempTbl'
GO
print '... Creating Procedure: daPopulateLogTempTbl'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure daPopulateLogTempTbl
  @numAppIdToAge INTEGER,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobCopy INTEGER;
	SET NOCOUNT ON
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobCopy		INTEGER
	DECLARE @errorCode		INTEGER
	SET		@numAppIdAged	= 0
	SET		@numJobCopy		= 0
	SET		@errorCode		= 0
	DECLARE @ORACLE_RMAN_CUSTOMSCRIPT_BKP		BIGINT
	SET			@ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
	DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
	SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
	DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
	SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
	IF object_id('tempdb.dbo.#tblAppIdList') IS NOT null DROP TABLE #tblAppIdList
	CREATE TABLE #tblAppIdList (
			rowId int IDENTITY(1,1),
			appType int,
			appId int,
			fileType int,
			Primary Key (appId, fileType)
			)
	-------------------------------------------------------------------------------
	-- Get the @numAppIdToAge rows to be processed from ArchAppCopyToBeAged
	-- appId with logs will not be processed here
	-------------------------------------------------------------------------------
	INSERT	INTO #tblAppIdList
			(appType, appId, fileType)
	SELECT	DISTINCT appType, appId, fileType
FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 4 > 0
AND		AppFlags & (33554432 | 67108864) = 0
	AND		AgeStatus = 0
	AND		DoNotAge = 0
	ORDER	BY AppType, appId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF		@numAppIdToAge > 0
	BEGIN
		DELETE	FROM #tblAppIdList
		WHERE	rowId > @numAppIdToAge
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	-- Aging status is ignored here
	-- Data on copy which do not need to be aged will still be calculated
	-- to see if its retention is the longest for job
	INSERT INTO	#DA_AppCopyList
	SELECT	DISTINCT b.*
FROM	#tblAppIdList a, ArchAppCopyToBeAged b
WHERE	b.AppFlags & 4 > 0
AND		b.AppFlags & (33554432 | 67108864) = 0
	AND 	a.appId = b.appId
	AND 	a.fileType = b.fileType
AND		b.DoNotAge & (33554432 | 262144 | 524288 | 1) = 0
	SELECT 	@errorCode = @@ERROR
	IF		@errorCode != 0 GOTO CX_EXIT
	SELECT @numAppIdAged = count(*) FROM #DA_AppCopyList where AgeStatus = 0
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	-- Get the data from JMJobDataStats table for the appIds to be processed
	-- on all copies
	-------------------------------------------------------------------------------
	INSERT	INTO #DA_JobDataStats
	SELECT	b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId, DataStatus=MAX(b.status),
Disabled=MAX(b.Disabled & 1),
ManualRet=MAX(b.Disabled & 2),
JobFlags = ((MAX(CASE WHEN (b.Disabled & 64) <> 0 THEN 1 ELSE 0 END)) | (MAX(CASE WHEN C.type > 1 THEN 2 ELSE 0 END)))
	FROM	#DA_AppCopyList a, JMJobDataStats b WITH (NOLOCK), APP_CommCell C WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	b.status <> 1000
AND 	b.Disabled & 256 = 0
	AND 	a.FileType = b.dataType
	AND		b.CommCellId = c.id
	GROUP	BY b.AppId, b.archGrpId, b.archGrpCopyId, b.JobId, b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_JobDataStats ON #DA_JobDataStats (JobId, CommCellId, CopyId)
	-------------------------------------------------------------------------------
	-- Remove Foreign backups if there are any
	-------------------------------------------------------------------------------
	DELETE	#DA_JobDataStats
WHERE	(JobFlags & 2) <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Get the data from #DA_JobDataStats table for the appIds to be processed
	-- on all copies.
	-- Later populate only those copies that are selected for pruning
	-- (appIdSelectedForPruning = 1)
	-------------------------------------------------------------------------------
	INSERT	INTO #DA_JobCopyList
	SELECT	DISTINCT a.AppId, a.AppFlags,
					a.CopyId, a.FileType,
					b.JobId, b.CommCellId,
					StartTime = -1, EndTime = -1,
					BkpLevel = -1, JobStatus = -1,
					DataStatus = b.DataStatus, Disabled = b.Disabled,
					ManualRet = b.ManualRet, RetainForAuxCopy = 0,
					ExtendedJob = 0, OnLinkedSP = 0, fullCycleNum = 0,
					CycleId = 0, jobRetainReason = 0,
					a.isCWEjobValid, JobFlags = b.JobFlags
	FROM	#DA_AppCopyList a, #DA_JobDataStats b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	IF		@numJobCopy = 0 GOTO CX_EXIT
	----------------------------------------------------------------------------------------------
	-- Get the Start Time, End Time, Backuplevel, JobStatus and fullCycleNum of the selected jobs
	----------------------------------------------------------------------------------------------
	-- Update job info for regular backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStartDate,
				EndTime = b.ServEndDate,
BkpLevel = CASE WHEN (((b.bkpattributes & 0x4000) <> 0 OR (b.bkpattributes & 0x10000) <> 0)
AND ((b.bkpattributes & 0x1000) = 0 AND (b.bkpattributes & 0x2000) = 0))
											THEN 2 ELSE b.BkpLevel END, -- Config/Control File ONLY Backups should not be FULL backups
				JobStatus = b.Status,
				fullCycleNum = b.fullCycleNum
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update job info for DR backup and ERASE backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStart,
				EndTime = b.ServEnd,
				BkpLevel = b.ER_BkpLevel,
				JobStatus = b.Status,
				fullCycleNum = b.fullCycleNum
	FROM	#DA_JobCopyList a, JMAdminJobStatsTable b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update Snap jobs with BCD Index archive files
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 4
	FROM	#DA_JobCopyList a, #DA_AppCopyList b, JMJobDataStats JDS WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		b.copyIsSnap <> 0
	AND		a.JobId = JDS.JobId
	AND		a.commCellId = JDS.commCellId
	AND		a.CopyId = JDS.archGrpCopyId
AND		JDS.dataType = 6
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for appaware child jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 64
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		b.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for appaware child full jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 128
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		b.bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for custom script jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 16777216
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		(b.bkpattributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP) > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Set flag for open chain jobs
	-------------------------------------------------------------------------------
	UPDATE	#DA_JobCopyList
SET 	JobFlags = JobFlags | 33554432
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		b.openChain <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- Do not process the Failed/Killed jobs here
	-----------------------------------------------------------------------------
	DELETE	#DA_JobCopyList
	WHERE JobStatus NOT IN (1, 3, 14) -- Success / Completed With Errors / Completed With Warnings
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- In case if no job history is available then do not process such jobs
	-----------------------------------------------------------------------------
	DELETE	#DA_JobCopyList
	WHERE StartTime = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update EndTime if EndTime is 0
	UPDATE	#DA_JobCopyList
	SET 	EndTime = StartTime
	WHERE	EndTime = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
/*
	-- Do not process disabled job without data
	-- Process them as if Index only data is written then the overall job status will be 101 and disabled but jobs will never be pruned.
	DELETE	FROM #DA_JobCopyList
	WHERE	DataStatus = 101
	AND		Disabled > 0
	SET	@errorCode	=	@@ERROR
*/
CX_EXIT:
	IF object_id('tempdb.dbo.#tblAppIdList') IS NOT null DROP TABLE #tblAppIdList
	IF @errorCode != 0
	BEGIN
		DELETE	FROM #DA_JobCopyList
		SELECT	@errorCode, -1, -1
	END
	ELSE
	BEGIN
		SELECT	@errorCode, @numAppIdAged, @numJobCopy
	END
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daPopulateLogTempTbl')
	delete from GxQscripts where name = 'daPopulateLogTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateLogTempTbl')
	delete from GXDBVersions where aliasname = 'daPopulateLogTempTbl'
GO

insert into GXDBVersions values(2, 'daPopulateLogTempTbl',  'v1.9.2.2.54.1', 'daPopulateLogTempTbl', 'v1.9.2.2.54.1')
GO

