

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daPopulateAlertInfo.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  daPopulateAlertInfo()
--  | Description:  Populate alert info for DataAging job
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daPopulateAlertInfo.sp,v $ $Id: daPopulateAlertInfo.sp,v 1.4.294.1 2018/03/20 20:03:11 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daPopulateAlertInfo <<<'

IF EXISTS (select * from sysobjects where name='daPopulateAlertInfo')
	drop procedure daPopulateAlertInfo
IF EXISTS (select * from GxQscripts where name='daPopulateAlertInfo')
	delete from GxQscripts where name = 'daPopulateAlertInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateAlertInfo')
	delete from GXDBVersions where aliasname = 'daPopulateAlertInfo'
GO
print '... Creating Procedure: daPopulateAlertInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure daPopulateAlertInfo
  @i_JobId INTEGER,
  @i_CommCellId INTEGER,
  @i_flags INTEGER,	/* 1: Media Recycled Alert Info, 2: Pruned Job Count Alert Info */
  @i_prunedJobsCount INTEGER,
  @i_dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	/* This temp table must be created and populated by caller before calling this stored procedure
		CREATE	TABLE #RecyclableMedia
		(
			MediaId			INTEGER,
			BarCode			NVARCHAR(256)
		)
	*/
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @AlertInfoCursorFlag 	INTEGER
	DECLARE @curMediaId						INTEGER
	DECLARE @curBarCode						NVARCHAR(256)
	DECLARE @errorCode						INTEGER
	SET 	@AlertInfoCursorFlag 		= 0
	SET 	@curMediaId							= 0
	SET 	@curBarCode							= ''
	SET		@errorCode							= 0
	IF NOT EXISTS (SELECT * FROM archDAAlertInfo WHERE jobID = @i_JobId AND commcellId = @i_CommCellId)
	BEGIN
		INSERT INTO archDAAlertInfo
		VALUES (@i_JobId, @i_CommCellId, '<DAAlert></DAAlert>')
	END
	IF @i_flags = 1
	BEGIN
		DECLARE	AlertInfoCursor CURSOR STATIC FOR
		SELECT	DISTINCT MediaId, Barcode
		FROM	#RecyclableMedia
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SET		@AlertInfoCursorFlag = 1
		OPEN	AlertInfoCursor
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM	AlertInfoCursor
		INTO	@curMediaId, @curBarCode
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			UPDATE	archDAAlertInfo
			SET		alertXML.modify('insert <media id="{sql:variable("@curMediaId")}"  barcode="{sql:variable("@curBarCode")}" /> into (/DAAlert)[1]')
			WHERE	jobId = @i_JobId
			AND		commcellId = @i_CommCellId
			AND		alertXML.exist('(/DAAlert/media/@id)[.=sql:variable("@curMediaId")]') <> 1
			FETCH	NEXT
			FROM	AlertInfoCursor
			INTO	@curMediaId, @curBarCode
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
	END
	IF @i_flags = 2
	BEGIN
		UPDATE	archDAAlertInfo
		SET		alertXML.modify('insert <prunedJobs count="{sql:variable("@i_prunedJobsCount")}" /> into (/DAAlert)[1]')
		WHERE	jobId = @i_JobId
		AND		commcellId = @i_CommCellId
		AND		alertXML.exist('(/DAAlert/prunedJobs)') <> 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF @AlertInfoCursorFlag = 1
	BEGIN
		CLOSE				AlertInfoCursor
		DEALLOCATE	AlertInfoCursor
	END
	SELECT	@errorCode
	RETURN	@errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'daPopulateAlertInfo')
	delete from GxQscripts where name = 'daPopulateAlertInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateAlertInfo')
	delete from GXDBVersions where aliasname = 'daPopulateAlertInfo'
GO

insert into GXDBVersions values(2, 'daPopulateAlertInfo',  '00010004029400010000', 'daPopulateAlertInfo', '00010004029400010000')
GO

